#!/bin/sh

SWNAME=zsh-4.2.0
ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc
INFODIR=/usr/share/info

rm -rf $SWNAME
bzcat ${SWNAME}.tar.bz2 | tar xf -
cd $SWNAME
patch -p1 < ../zsh-4.2.0-completion_tar_archive.patch
patch -p1 < ../zsh-4.0.2-sshcomp.patch
./configure --prefix=/usr --mandir=$MANDIR --infodir=$INFODIR --enable-function-subdirs --enable-etcdir=/etc
make
rm -rf `pwd`/../pkg
mkdir -p `pwd`/../pkg
make install DESTDIR=`pwd`/../pkg
make install.info DESTDIR=`pwd`/../pkg
gzip `pwd`/../pkg${MANDIR}/man1/*.1
rm `pwd`/../pkg${INFODIR}/dir
gzip `pwd`/../pkg${INFODIR}/zsh.info*
mkdir -p `pwd`/../pkg${DOCDIR}/$SWNAME
cp -p Ch* `pwd`/../pkg${DOCDIR}/$SWNAME/.
cp -p LI* `pwd`/../pkg${DOCDIR}/$SWNAME/.
cp -p ME* `pwd`/../pkg${DOCDIR}/$SWNAME/.
cp -p RE* `pwd`/../pkg${DOCDIR}/$SWNAME/.
cp -p ../PlamoBuild.sh `pwd`/../pkg${DOCDIR}/${SWNAME}/.
chown -R root:root `pwd`/../pkg${DOCDIR}
mkdir -p `pwd`/../pkg/bin
( cd `pwd`/../pkg/bin ; ln -s ../usr/bin/$SWNAME zsh )
cd `pwd`/../pkg
makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
cat >> install/doinst.sh <<EOF
if fgrep /usr/bin/zsh etc/shells 1> /dev/null 2> /dev/null ; then
 GOOD=y
else
 echo "/usr/bin/zsh" >> etc/shells
fi
#%% begin initialize $SWNAME
if [ -x /usr/bin/install-info ] ; then
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/zsh.info.gz
elif [ -x usr/sbin/install-info ] ; then
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/zsh.info.gz
fi
#%% end
EOF
tar zcf ${SWNAME}-${ARCH}-${PVER}.tgz usr bin install
