#!/bin/sh

check_and_clean () {
    for d in $1; do
	if [ -b $d -o -c $d ]; then
	    return 1
	fi
    done
    /sbin/modprobe -r $2
    return 0
}

main () {
    /usr/bin/sleep 2

    REMAIN=
    check_and_clean '/dev/sd[a-z]*' sd_mod || REMAIN=yes
    check_and_clean '/dev/sr[0-9]*' sr_mod || REMAIN=yes
    check_and_clean '/dev/st[0-9]*' st || REMAIN=yes
    check_and_clean '/dev/osst[0-9]*' osst || REMAIN=yes
    check_and_clean '/dev/sg[0-9]*' sg || REMAIN=yes

    if [ -z "$REMAIN" ]; then
	/sbin/modprobe -r usb-storage scsi_mod
    fi
}

main &
