#!/bin/sh
#
#                            Time-stamp: <2004-03-07 18:47:19 cyamauch>     

DEFAULT_ENV_DIRNAME=Default

if [ "$1" = "" ] ; then
  echo "Specify Source directory."
  exit 0
fi

SOURCE_DIR=$1
DEFAULT_ENV_DIR=$SOURCE_DIR/../$DEFAULT_ENV_DIRNAME
shift

if [ "$1" = "" ] ; then
  FSIZE_UI=12
else
  FSIZE_UI=$1
fi
FSIZE_UI_SMALL=`expr $FSIZE_UI - 2`
FSIZE_UI_LARGE=`expr $FSIZE_UI + 2`
if [ "$2" = "" ] ; then
  FSIZE_TERM=14
else
  FSIZE_TERM=$2
fi
if [ "$3" = "" ] ; then
  FSIZE_EDITOR=16
else
  FSIZE_EDITOR=$3
fi

echo "[User Interface    : $FSIZE_UI pixels]"
echo "[Terminal and Text : $FSIZE_TERM pixels]"
echo "[Editor(emacs)     : $FSIZE_EDITOR pixels]"

rm -rf $DEFAULT_ENV_DIR

cp -dpR $SOURCE_DIR $DEFAULT_ENV_DIR

LST=`grep @FSIZE_ $SOURCE_DIR/.* | awk -F ':' '{print $1}' | sort -u`
for i in $LST ; do
  cat $i | sed -e "s/@FSIZE_UI@/$FSIZE_UI/g" \
		-e "s/@FSIZE_UI_SMALL@/$FSIZE_UI_SMALL/g" \
		-e "s/@FSIZE_UI_LARGE@/$FSIZE_UI_LARGE/g" \
		-e "s/@FSIZE_TERM@/$FSIZE_TERM/g" \
		-e "s/@FSIZE_EDITOR@/$FSIZE_EDITOR/g" \
  > `echo $i|sed -e "s/Source/$DEFAULT_ENV_DIRNAME/"`
done

if (( $FSIZE_TERM < 16 )) ; then
  ( cd $DEFAULT_ENV_DIR ; cat .dir_colors_medium > .dir_colors ; rm .dir_colors_medium )
fi
