/*
 * kernel/power/block_io.h
 *
 * Copyright 2004-2006 Nigel Cunningham <nigel@suspend2.net>
 *
 * Distributed under GPLv2.
 *
 * This file contains declarations for functions exported from
 * block_io.c, which contains low level io functions.
 */

#include <linux/buffer_head.h>
#include "extent.h"

struct suspend_bdev_info {
	struct block_device *bdev;
	dev_t dev_t;
	int bmap_shift;
	int blocks_per_page;
};

/* 
 * Our exported interface so the swapwriter and filewriter don't
 * need these functions duplicated.
 */
struct suspend_bio_ops {
	int (*bdev_page_io) (int rw, struct block_device *bdev, long pos,
			struct page *page);
	void (*check_io_stats) (void);
	void (*reset_io_stats) (void);
	void (*finish_all_io) (void);
	int (*prepare_readahead) (int index);
	void (*cleanup_readahead) (int index);
	struct page ** readahead_pages;
	int (*readahead_ready) (int readahead_index);
	int (*forward_one_page) (void);
	void (*set_extra_page_forward) (void);
	void (*set_devinfo) (struct suspend_bdev_info *info);
	int (*read_chunk) (struct page *buffer_page, int sync);
	int (*write_chunk) (struct page *buffer_page);
	int (*rw_header_chunk) (int rw, struct suspend_module_ops *owner,
			char *buffer, int buffer_size);
	int (*write_header_chunk_finish) (void);
	int (*rw_init) (int rw, int stream_number);
	int (*rw_cleanup) (int rw);
};

extern struct suspend_bio_ops suspend_bio_ops;

extern char *suspend_writer_buffer;
extern int suspend_writer_buffer_posn;
extern int suspend_read_fd;
extern struct extent_iterate_saved_state suspend_writer_posn_save[3];
extern struct extent_iterate_state suspend_writer_posn;
extern int suspend_header_bytes_used;
