#ifndef _LINUX_SUSPEND2_H
#define _LINUX_SUSPEND2_H

#include <linux/dyn_pageflags.h>

/* arch/i386/mm/init.c */
extern char __nosave_begin, __nosave_end;

#define SECTOR_SIZE 512

/* kernel/power/main.c */
extern unsigned long suspend_result;

/* kernel/power/process.c */
extern unsigned long suspend_debug_state;

/* arch/i386/power/suspend2.c */
extern unsigned long suspend_action;
extern int suspend_io_time[2][2];

extern dyn_pageflags_t pageset1_map;
extern dyn_pageflags_t pageset1_copy_map;

#ifdef CONFIG_PM_DEBUG
#define test_debug_state(bit) (test_bit(bit, &suspend_debug_state))
#else
#define test_debug_state(bit) (0)
#endif

#define test_result_state(bit) (test_bit(bit, &suspend_result))

/* Debug sections  - if debugging compiled in */
enum {
	SUSPEND_ANY_SECTION,
	SUSPEND_EAT_MEMORY,
	SUSPEND_IO,
	SUSPEND_HEADER,
	SUSPEND_WRITER,
	SUSPEND_MEMORY,
};

/* debugging levels. */
#define SUSPEND_STATUS		0
#define SUSPEND_ERROR		2
#define SUSPEND_LOW	 	3
#define SUSPEND_MEDIUM	 	4
#define SUSPEND_HIGH	  	5
#define SUSPEND_VERBOSE		6

/* Configuration flags */
enum {
	SUSPEND_REBOOT,
	SUSPEND_PAUSE,
	SUSPEND_SLOW,
	SUSPEND_LOGALL,
	SUSPEND_CAN_CANCEL,
	SUSPEND_KEEP_IMAGE,
	SUSPEND_FREEZER_TEST,
	SUSPEND_SINGLESTEP,
	SUSPEND_PAUSE_NEAR_PAGESET_END,
	SUSPEND_TEST_FILTER_SPEED,
	SUSPEND_TEST_BIO,
	SUSPEND_NO_PAGESET2,
	SUSPEND_PM_PREPARE_CONSOLE,
	SUSPEND_IGNORE_ROOTFS,
	SUSPEND_REPLACE_SWSUSP,
	SUSPEND_RETRY_RESUME,
};

#ifdef CONFIG_SUSPEND2
#define test_action_state(bit) (test_bit(bit, &suspend_action))
#define set_action_state(bit) (test_and_set_bit(bit, &suspend_action))
#define clear_action_state(bit) (test_and_clear_bit(bit, &suspend_action))
#else
#define test_action_state(bit) (0)
#endif

extern void __suspend_message(unsigned long section, unsigned long level, int log_normally,
		const char *fmt, ...);

#ifdef CONFIG_PM_DEBUG
#define suspend_message(sn, lev, log, fmt, a...) \
do { \
	if (!sn || test_debug_state(sn)) \
		__suspend_message(sn, lev, log, fmt, ##a); \
} while(0)
#else /* CONFIG_PM_DEBUG */
#define suspend_message(sn, lev, log, fmt, a...) \
do { \
	if (lev == SUSPEND_STATUS) \
		__suspend_message(sn, lev, log, fmt, ##a); \
} while(0)
#endif /* CONFIG_PM_DEBUG */
  
/* Suspend 2 */

enum {
	SUSPEND_CAN_SUSPEND,
	SUSPEND_CAN_RESUME,
	SUSPEND_RUNNING,
	SUSPEND_RESUME_DEVICE_OK,
	SUSPEND_NORESUME_SPECIFIED,
	SUSPEND_SANITY_CHECK_PROMPT,
	SUSPEND_PAGESET2_NOT_LOADED,
	SUSPEND_CONTINUE_REQ,
	SUSPEND_RESUMED_BEFORE,
	SUSPEND_RESUME_NOT_DONE,
	SUSPEND_BOOT_TIME,
	SUSPEND_NOW_RESUMING,
	SUSPEND_IGNORE_LOGLEVEL,
	SUSPEND_TRYING_TO_RESUME,
	SUSPEND_TRY_RESUME_RD,
};

/* --------------------------------------------------------------------- */
#ifdef CONFIG_SUSPEND2

/* Used in init dir files */
extern unsigned long suspend_state;

extern void suspend2_try_resume(void);
extern int suspend_early_boot_message 
	(int can_erase_image, int default_answer, char *warning_reason, ...);
extern unsigned long suspend_update_status (unsigned long value, unsigned long maximum,
		const char *fmt, ...);
extern void suspend_prepare_status (int clearbar, const char *fmt, ...);

#define test_suspend_state(bit) \
	(test_bit(bit, &suspend_state))

#define clear_suspend_state(bit) \
	(clear_bit(bit, &suspend_state))

#define set_suspend_state(bit) \
	(set_bit(bit, &suspend_state))

extern void suspend2_try_suspend(int have_pmsem);

/* --------------------------------------------------------------------- */
#else
/* --------------------------------------------------------------------- */

#define suspend_state		(0)
#define clear_suspend_state(bit)	do { } while (0)
#define test_suspend_state(bit) 	(0)
#define set_suspend_state(bit)		do { } while(0)

#define suspend2_try_resume()			do { } while(0)
static inline int suspend_early_boot_message(int a, int b, char *c, ...)	{ return 0; }
static inline unsigned long suspend_update_status(unsigned long value, unsigned long maximum,
		const char *fmt, ...)
{
	return maximum;
}
#define suspend_prepare_status(a, ...)  do { } while(0)

#endif /* CONFIG_SUSPEND2 */

#define test_and_set_suspend_state(bit) \
	(test_and_set_bit(bit, &suspend_state))

#define get_suspend_state()  (suspend_state)

#define restore_suspend_state(saved_state) \
	do { suspend_state = saved_state; } while(0)
	
#if defined(CONFIG_SUSPEND2) && defined(CONFIG_ACPI)
#include <acpi/acpi.h>
static inline int may_try_suspend2(u32 state)
{
	if (state == ACPI_STATE_S4) {
		suspend2_try_suspend(0);
		return 1;
	}
	return 0;
}
#else
static inline int may_try_suspend2(u32 state)
{
	return 0;
}
#endif
#endif /* _LINUX_SUSPEND2_H */
