# -*- coding: ascii -*-
#
#  textcopy.py - a TEXTCOPY compatible Saori module for ninix
#  Copyright (C) 2002-2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: textcopy.py,v 1.6 2004/04/13 05:22:00 shy Exp $
#

import os

if os.environ.has_key('DISPLAY'):
    import gtk
else:
    gtk = None

from ninix.dll import SAORI

class Saori(SAORI):
    def __init__(self):
        SAORI.__init__(self)
        self.window = None
        self.entry = None
    def check_import(self):
        if gtk is None:
            return 0
        else:
            return 1
    def setup(self):
        self.window = gtk.Window()
        self.entry = gtk.Entry()
        self.window.add(self.entry)
        self.entry.realize()
        return 1
    def finalize(self):
        self.entry = None
        self.window = None
        return 1
    def execute(self, argument):
        if len(argument) == 0 or self.entry == None:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        text = argument[0].encode('utf-8')
        self.entry.set_text(text)
        self.entry.select_region(0, len(text))
        if len(argument) >= 2 and argument[1] != 0:
            return 'SAORI/1.0 200 OK\r\nResult: %s\r\n\r\n' % argument[0].encode(self.charset, 'replace')
        else:
            return 'SAORI/1.0 204 No Content\r\n\r\n'
