﻿<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
/**
* PHP versions 4 and 5
*
* LICENSE: Copyright 2006 Tatsuya Tsuruoka. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this
*   list of conditions and the following disclaimer.
* o Redistributions in binary form must reproduce the above copyright notice,
*   this list of conditions and the following disclaimer in the documentation
*   and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE FREEBSD PROJECT "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
* EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* The views and conclusions contained in the software and documentation are
* those of the authors and should not be interpreted as representing official
* policies, either expressed or implied, of The PEAR Group.
*
* @category  Web Services
* @package   Services_RakuAPI
* @author    Tatsuya Tsuruoka <ttsuruoka@p4life.jp>
* @license   http://www.freebsd.org/copyright/freebsd-license.html 2 Clause BSD License
* @version   $Id:$
* @filesource
*/

require_once 'PEAR.php';
require_once 'HTTP/Request.php';

if (!defined('SERVICES_RAKUAPI_BASEURL')) {
    define('SERVICES_RAKUAPI_BASEURL',
           'http://rakuapi.ddo.jp/api?');
}

/**
* Class for accessing and retrieving information
* from RakuAPI
*
* @package Services_RakuAPI
* @author  Tatsuya Tsuruoka <ttsuruoka@p4life.jp>
* @access  public
* @version Release: 0.1.0
* @uses    PEAR
* @uses    HTTP_Request
*/
class Services_RakuAPI
{

    var $_baseurl = SERVICES_RAKUAPI_BASEURL;
    var $_lasturl = null;
    var $affiliate_code = '';

    
    function Services_RakuAPI()
    {
    }

    function getApiVersion()
    {
        return '0.1.0';
    }

    function getLastUrl()
    {
        return $this->_lasturl;
    }

    /**
    * Retrieves information
    *
    * Example:
    * <code>
    * <?php
    * $raku = new Services_RakuAPI;
    * $raku->affiliate_code = '...';
    * $result = $raku->search('DS Lite');
    * ?>
    * </code>
    *
    * @access public
    * @param  string $keywords  
    * @param  array $options
    * @return array The array of information returned by the query
    */
    function search($keywords, $options = array())
    {
        $params = array();
        $params['q'] = $keywords;
        $params['output'] = 'php';
        return $this->_sendRequest(array_merge($params, $options));
    }

    function _sendRequest($params)
    {
        $this->_errors = array();

        if (!empty($this->affiliate_code)) {
            $params['affiliate_code'] = $this->affiliate_code;
        }

        $query = array();
        foreach ($params as $k => $v) {
            $query[] = $k . '=' . urlencode($v);
        }
        $url = $this->_baseurl . implode('&', $query);
        $this->_lasturl = $url;

        $http = &new HTTP_Request($url);
        $http->addHeader('User-Agent', 'PEAR::Services_RakuAPI/' . $this->getApiVersion());
        $http->sendRequest();

        if ($http->getResponseCode() != 200){
            return PEAR::raiseError('RakuAPI returned invalid HTTP response code ' . $http->getResponseCode());
        }
        $result = $http->getResponseBody();

        if ($params['output'] === 'php') {
            return unserialize($result);
        }
        return $result;
    }

}

?>
