#!/bin/sh 
#
# This should be done at initial booting after installation.
# requires:
#	httpd-2.0.63
#
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C


VERSION=5.2.5

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

HTTPD_DIR=$ROOT/opt/httpd
PHP5_DIR=$ROOT/usr

#for Plamo-4.2
NNAME=`cat /etc/HOSTNAME`
if [ ".$NNAME" = "." ]; then
  NNAME=`hostname`
  if [ ".$NNAME" = "." ]; then
    NNAME=localhost
  fi
fi

  if [ ! -f $ROOT/etc/php.ini ]; then
        cp $ROOT/etc/php.ini-plamo $ROOT/etc/php.ini
  fi
  if [ -f $PHP5_DIR/lib/php/php_browscap.ini ]; then
    if fgrep ";browscap" $ROOT/etc/php.ini 1> /dev/null 2>&1; then
      mv $ROOT/etc/php.ini $ROOT/etc/php.ini.bak
      sed -e "s%^;browscap =.*%browscap = $PHP5_DIR/lib/php/php_browscap.ini%" \
        $ROOT/etc/php.ini.bak > $ROOT/etc/php.ini
    fi
  fi

# sybolic links
cd $ROOT/

# ( DONOT CHANGE THE NEXT ONE LINE )
# Add PHP5 Entry to Httpd document index.
if [ -f $HTTPD_DIR/htdocs/contents.list ]; then
  if ! fgrep "PHP-$VERSION" $HTTPD_DIR/htdocs/contents.list 1> /dev/null 2>&1; then
    HTTPD_DIR=$ROOT/opt/httpd
    cat >> $HTTPD_DIR/htdocs/contents.list <<EOL

    <P ALIGN="CENTER"> PHP-$VERSION
    ( <A
	HREF="http://jp.php.net/"
      >http://jp.php.net/</A>
      |
      <A
	HREF="http://www.php.gr.jp/"
      >http://www.php.gr.jp/</A>
    )<BR>
     (Server-side Scripting Language)<BR>
     <A
      HREF="php-$VERSION/"
     >documentation</A>,
     <A
      HREF="php-$VERSION/manual-ja/"
     >manual-ja</A>
<BR>
     <!-- A
      HREF="php5test/"
     > Tests and Samples </A -->.
<BR> 

    </P>
EOL
  fi
  ln -sf $ROOT/usr/share/doc/php-$VERSION $HTTPD_DIR/htdocs/php-$VERSION
  cp -f $HTTPD_DIR/conf/httpd.conf $HTTPD_DIR/conf/httpd.conf.old
  if [ -f $HTTPD_DIR/conf/httpd.conf ]; then
    patch $HTTPD_DIR/conf/httpd.conf $HTTPD_DIR/conf/httpd.conf-php5.patch
    $HTTPD_DIR/bin/apxs  -e -a -n php5 $HTTPD_DIR/libexec/libphp5.so
  fi

  if [ "$NNAME" != "" ] ; then
    mv $HTTPD_DIR/conf/httpd.conf $HTTPD_DIR/conf/httpd.conf.bak
    sed -e "s/LOCALHOST/$NNAME/" $HTTPD_DIR/conf/httpd.conf.bak \
	  > $HTTPD_DIR/conf/httpd.conf
  fi

  chown root.apache $HTTPD_DIR/modules/libphp5.so \
	$HTTPD_DIR/conf/httpd.conf \
  	$HTTPD_DIR/htdocs/php*
  chown wadm.apache $HTTPD_DIR/htdocs/index.php.*
  chmod go+r $HTTPD_DIR/htdocs/index.php.*

  chown root.apache $ROOT/etc/php.ini
  chmod go+r $ROOT/etc/php.ini
  chown -R root.apache $ROOT/usr/lib/php
  chmod -R go-w $ROOT/usr/lib/php
  chmod -R go+rX $ROOT/usr/lib/php

  $HTTPD_DIR/bin/apachectl stop
  sleep 1
  $HTTPD_DIR/bin/apachectl startssl

else
  awk '/Add PHP5 Entry/,/#EOS1/' $ROOT/install/doinst.sh >> /tmp/add_httpd_test.sh
fi
#EOS1
