<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: admin_site.php5,v 1.42 2005/03/10 10:00:46 mdruilhe Exp $
 *	Usage:		Administration of a site - Displays frames & menus
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */	

$action = isset($action) ? $action : "main";

# Initialize admin (init DB, authenticate, check rights)
# ------------------------------------------------------
include ("init_admin.inc");

if ($site == "agora") {
	@header("Location: admin.$ext");
	exit;
}

$bn_frames=1;

switch ($action):

#	--------------------------
#	LEFT FRAME - MENU : FORUMS
#	--------------------------
	case "menu":
		display_header("");
		if ($auth->level >= ADMIN ) {
			$forums = $db->getForums ($site, "", "", 0);
		} else {
			$forums = $db->getForums ($site, $auth->userid, "", 0);
		} 
		if (is_array($forums) && count ($forums)>1) {
			$choose_forum_box = getListBox ("bn", $forums, "$bn", 0,  "top.location=('admin_forum.$ext?site=$site&bn='+this.options[this.selectedIndex].value)");
			$choose_forum_form = "<form action=\"admin_forum.$ext\" target=\"_top\"><input type=\"hidden\" name=\"site\" value=\"$site\">".LABEL_JUMP_TO." $choose_forum_box <input type=\"submit\" value=\"".LABEL_GO."\"></form>";
		}

		print '<center><a href="http://www.w-agora.net" target="_top">';
		print '<img src="images/logo1_admin.jpg" border="0" alt="' .LABEL_AGORA_WEBSITE.'"></a></center>';

		left_menu_header (LABEL_SITE . ": $site");
		echo "<div class=\"left_menu\">" . LABEL_LOGGED_AS. " : <b>". $auth->userid . "</b></div>";
		echo "<div class=\"left_menu\">" . LABEL_PRIVILEGE. " : <b>". $user_privs[$auth->type] . "</b></div>";
		echo "<hr class=\"menu_sep\" />";

		left_menu_item ("admin_site.$ext?site=$site&force_login=1", "_top", LABEL_LOGIN, LABEL_RELOGIN);
		left_menu_item ("admin.$ext?site=agora&bn=", "_top", LABEL_SITES, LABEL_ADMINISTRATION_MAIN);
		left_menu_item ("stats/index.$ext?site=$site&bn=", "edit_frame", LABEL_STATS, sprintf (ALT_STATS, $site));
		left_menu_item ("$main_page?site=$site&bn=", "$site", LABEL_ACCESS_THIS_SITE, sprintf (ALT_ACCESS_SITE, $site)); 
		if ($auth->level > ADMIN ) {
			left_menu_item ("delete_site.$ext?site=$site&bn=", '_top', LABEL_DELETE_THIS_SITE, sprintf (ALT_DELETE_SITE, $site)); 
		}
		left_menu_footer();
		
		// USERS

		left_menu_header (LABEL_USERS);
		left_menu_item ("admin_user.$ext?site=$site","edit_frame", COLUMN_ADMIN_USERS, ALT_USER_ADMIN);
		left_menu_item ("create_user.$ext?site=$site","edit_frame", COLUMN_CREATE, ALT_USER_ADD);
		left_menu_item ("mail_users.$ext?site=$site&bn=","edit_frame", COLUMN_MAIL_USERS, ALT_MAIL_USERS);
		left_menu_footer();

		// CATEGORIES
		if ($auth->level >= ADMIN ) {
			left_menu_header (LABEL_CATEGORIES);
			left_menu_item ("admin_categories.$ext?site=$site&action=add", "edit_frame", COLUMN_CREATE, ALT_CATEGORY_CREATE);
			left_menu_item ("admin_categories.$ext?site=$site", "edit_frame", COLUMN_EDIT, ALT_CATEGORY_EDIT);
			
			left_menu_footer();
		}
		// FORUMS
		left_menu_header (LABEL_FORUMS);
		if ($auth->level >= ADMIN) {
			left_menu_item ("create_forum.$ext?site=$site","edit_frame", COLUMN_CREATE, ALT_FORUM_CREATE);
		}
		left_menu_item ("admin_forum.$ext?site=$site&bn=", "edit_frame", COLUMN_MANAGE_FORUM, ALT_FORUM_MANAGE);
		if ($auth->level >= ADMIN) {
			left_menu_item ("reorder_forums.$ext?site=$site","edit_frame", COLUMN_CHANGE_ORDER, ALT_FORUM_ORDER);
		}

		if (is_array($forums) && count ($forums)>1) {
			echo "<div class=\"menu_item\">$choose_forum_form</div>";
		}

		left_menu_footer();
		
		// FORUMS LISTING LAYOUT
		if ($auth->level > ADMIN ) {
			left_menu_header (LABEL_FORUM_LAYOUT);
			left_menu_item ("editconf.$ext?site=$site&editsite=1","edit_frame", LABEL_SITECONF, ALT_SITECONF);
			left_menu_item ("editform.$ext?site=$site&editsite=1&file=style","edit_frame", LABEL_STYLESHEET, ALT_MODIFY_STYLESHEET);
			left_menu_item ("editform.$ext?site=$site&editsite=1&file=header","edit_frame", LABEL_HEADER, ALT_HEADER);
			left_menu_item ("editlist.$ext?site=$site&editsite=1","edit_frame", LABEL_FORUM_LIST, ALT_FORUM_LIST);
			left_menu_item ("editform.$ext?site=$site&editsite=1&file=footer","edit_frame", LABEL_FOOTER, ALT_FOOTER);
			left_menu_item ("editmsg.$ext?site=$site&editsite=1","edit_frame", LABEL_MESSAGES, ALT_MESSAGES);
			left_menu_footer();
		}

		// DEFAULT TEMPLATES
		if ($auth->level > ADMIN) {
			left_menu_header (LABEL_DEFAULT_TEMPLATES);

			left_menu_item ("editform.$ext?site=$site&file=style&editdefault=1","edit_frame", LABEL_STYLESHEET, ALT_MODIFY_STYLESHEET);
			left_menu_item ("editform.$ext?site=$site&file=header&editdefault=1","edit_frame", LABEL_HEADER, ALT_HEADER);
			left_menu_item ("editform.$ext?site=$site&file=footer&editdefault=1","edit_frame", LABEL_FOOTER, ALT_FOOTER);
			left_menu_item ("editlist.$ext?site=$site&bn=$bn&editdefault=1","edit_frame", COLUMN_NOTES_LISTING, ALT_NOTES_LISTING);
			left_menu_item ("editmsg.$ext?site=$site&bn=$bn&editdefault=1","edit_frame", COLUMN_MESSAGES, ALT_AGORA_MESSAGES);
			left_menu_item ("editform.$ext?site=$site&file=form&editdefault=1","edit_frame", COLUMN_FORM, ALT_FORM);
			left_menu_item ("editform.$ext?site=$site&file=search_form&editdefault=1","edit_frame", COLUMN_SEARCH_FORM, ALT_SEARCH_FORM);
			left_menu_item ("editfields.$ext?site=$site&editdefault=1","edit_frame", COLUMN_FIELDS, ALT_FIELDS);
			left_menu_item ("edittemplate.$ext?site=$site&bn=$bn&editdefault=1","edit_frame", COLUMN_TEMPLATE, ALT_TEMPLATE);
			left_menu_item ("editform.$ext?site=$site&file=before_access&editdefault=1","edit_frame", COLUMN_INCLUDED, ALT_INCLUDED);
			left_menu_item ("editmail.$ext?site=$site&file=mail_template&editdefault=1","edit_frame", COLUMN_MAIL, ALT_MAIL_TEMPLATE);
			left_menu_footer();
		}

		// FORUMS LISTING LAYOUT
		if ($auth->level > ADMIN ) {
			left_menu_header (LABEL_USER_TEMPLATES);
			left_menu_item ("edituserfields.$ext?site=$site","edit_frame", COLUMN_USER_FIELDS, ALT_USER_FIELDS);
			left_menu_item ("editform.$ext?site=$site&file=register_form&editdefault=1","edit_frame", COLUMN_REGISTER, ALT_REGISTER_FORM);
			left_menu_item ("editform.$ext?site=$site&file=show_profile&editdefault=1","edit_frame", COLUMN_PROFILE, ALT_PROFILE_FORM);
			left_menu_item ("editform.$ext?site=$site&file=login_form&editdefault=1","edit_frame", COLUMN_LOGIN, ALT_LOGIN_FORM);
			left_menu_item ("editform.$ext?site=$site&file=change_password_form&editdefault=1","edit_frame", COLUMN_CHANGE_PASSWORD, ALT_CHANGE_PASSWORD_FORM);
			left_menu_item ("editform.$ext?site=$site&file=forgot_password_form&editdefault=1","edit_frame", COLUMN_FORGOT_PASSWORD, ALT_FORGOT_PASSWORD_FORM);
			left_menu_item ("editform.$ext?site=$site&file=subscribe_form&editdefault=1","edit_frame", COLUMN_SUBSCRIBE_FORM_TEMPLATE, ALT_SUBSCRIBE_FORM);
			left_menu_footer();
		}

	break; 
#	--------------------------
#	MAIN PAGE - ENTRY POINT
#	display 2 frames
#	--------------------------
	default:
		print '<head><title>'. TITLE_SITE_ADMINISTRATION . " $site</title></head>";
		frameset ("$WA_SELF?action=menu&site=$site&bn=$bn", "admin_forum.$ext?site=$site&bn=");
	break;
endswitch;
display_footer();
?>
