<?php
/* 
 * $Id: page.inc.php,v 1.2 2004/08/11 13:07:32 youka Exp $
 */



/**
 * Wikiのページ１つを表すクラス。
 * 
 * ページごとにシングルトン（のように振る舞う）。
 * 存在しないページの場合は本文が空文字列のPageになる。
 */
class Page
{
	protected $pagename;	//ページ名(string)
	protected $wikiid;	//WikiFarmのID
	
	
	function getwikiid(){ return $this->wikiid; }
	
	
	/**
	 * インスタンスを取得する。
	 * 
	 * @param	$id	WikiFarmのID。指定しない場合は現在のWikiFarmのIDが使われる。
	 */
	static function getinstance($pagename, $id = WIKIID)
	{
		return new BackupedPage($pagename, $id);
	}
	
	
	/**
	 * コンストラクタ。
	 */
	protected function __construct($pagename, $id)
	{
		$this->pagename = resolvepath(trim($pagename));
		$this->wikiid = $id;
	}
	
	
	/**
	 * ページ名を取得する。
	 */
	function getpagename()
	{
		return $this->pagename;
	}
	
	
	/**
	 * タイムスタンプを取得する。
	 * 
	 * @return	int	ページが存在しない場合は現在の時間を返す。
	 */
	function gettimestamp()
	{
		$db = DataBase::getinstance($this->wikiid);
		$query  = "SELECT timestamp FROM page";
		$query .= " WHERE (pagename = '" . $db->escape($this->pagename) . "'";
		$query .= "  AND source != '')";
		$ret = $db->fetch($db->query($query));
		return $ret == false ? TIME : $ret['timestamp'];
	}
	
	
	/**
	 * 本文を取得する。
	 * 
	 * @return	string	存在しないページの場合は空文字列。
	 */
	function getsource()
	{
		$db = DataBase::getinstance($this->wikiid);
		$query  = "SELECT source FROM page";
		$query .= " WHERE pagename = '" . $db->escape($this->pagename) . "'";
		$ret = $db->fetch($db->query($query));
		return $ret == false ? '' : $ret['source'];
	}
	
	
	/**
	 * 本文を保存する。
	 * 
	 * @param	string	$source	空白文字のみを渡した場合は削除になる。
	 * @param	bool	$notimestamp	trueの時、タイムスタンプを更新しない。
	 */
	function write($source, $notimestamp = false)
	{
		$db = DataBase::getinstance($this->wikiid);
		$db->begin();
		
		$pagename = $db->escape($this->pagename);
		$_source = $db->escape(linetrim($source));
		if($_source == ''){
			$str = "-[[{$this->pagename}]] " . date('Y-m-d (D) H:i:s', TIME);
			$rdpage = Page::getinstance(RECENTDELETED, $this->wikiid);
			$rdpage->write($str . "\n" . $rdpage->getsource());
			$query  = "DELETE FROM page";
			$query .= " WHERE pagename = '$pagename'";
		}
		else{
			$time = $notimestamp ? $this->gettimestamp() : TIME;
			$query  = "INSERT OR REPLACE INTO page";
			$query .= " (pagename, source, timestamp)";
			$query .= " VALUES('$pagename', '$_source', '$time')";
		}
		$db->query($query);
		
		$this->notify();
		$db->commit();
	}
	
	
	
	/**
	 * Pageの更新を他のクラスに知らせる。
	 */
	protected function notify()
	{
		AutoLink::update($this);
		BackLink::update($this);
		Mail::update($this);
	}
}



interface PageObserver
{
	static function update($page);
}

?>