<?php
/**
 * 例外用クラス。
 */
class MyException extends exception
{
	protected $mes;
	
	
	public function __construct($mes = '')
	{
		$this->mes = $mes;
	}
	
	
	public function message()
	{
		return $this->mes;
	}
}


/**
 * SQLite関連の例外クラス。
 */
class DBException extends MyException
{
	public function __construct($mes = '', $dblink)
	{
		parent::__construct($mes . "\n" . sqlite_error_string(sqlite_last_error($dblink)));
	}
}


/**
 * プラグインの例外クラス。
 */
class PluginException extends MyException
{
	public function __construct($mes = '', $pluginname)
	{
		parent::__construct($mes . "($pluginname)");
	}
}


?>