lag.plot                package:stats                R Documentation

_T_i_m_e _S_e_r_i_e_s _L_a_g _P_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plot time series against lagged versions of themselves. Helps
     visualizing "auto-dependence" even when auto-correlations vanish.

_U_s_a_g_e:

     lag.plot(x, lags = 1, layout = NULL, set.lags = 1:lags,
              main = NULL, asp = 1,
              font.main=par("font.main"), cex.main=par("cex.main"),
              diag = TRUE, diag.col = "gray", type = "p", oma = NULL,
              ask = NULL, do.lines = (n <= 150), labels = do.lines, ...)

_A_r_g_u_m_e_n_t_s:

       x: time-series (univariate or multivariate)

    lags: number of lag plots desired, see arg 'set.lags'.

  layout: the layout of multiple plots, basically the 'mfrow' 'par()'
          argument.  The default uses about a square layout (see
          'n2mfrow' such that all plots are on one page.

set.lags: positive integer vector allowing to specify the set of lags
          used; defaults to '1:lags'.

    main: character with a main header title to be done on the top of
          each page.

     asp: Aspect ratio to be fixed, see 'plot.default'.

font.main, cex.main: attributes for the title, see 'par()'.

    diag: logical indicating if the x=y diagonal should be drawn.

diag.col: color to be used for the diagonal 'if(diag)'.

    type: plot type to be used, but see 'plot.ts' about its restricted
          meaning.

     oma: outer margins, see 'par'.

     ask: logical; if true, the user is asked before a new page is
          started.

do.lines: logical indicating if lines should be drawn.

  labels: logical indicating if labels should be used.

     ...: Further arguments to 'plot.ts'.

_N_o_t_e:

     It is more flexible and has different default behaviour than the S
     version.  We use 'main =' instead of 'head = ' for internal
     consistency.

_A_u_t_h_o_r(_s):

     Martin Maechler

_S_e_e _A_l_s_o:

     'plot.ts' which is the basic work horse.

_E_x_a_m_p_l_e_s:

     lag.plot(nhtemp, 8, diag.col = "forest green")
     lag.plot(nhtemp, 5, main="Average Temperatures in New Haven")
     ## ask defaults to TRUE when we have more than one page:
     lag.plot(nhtemp, 6, layout = c(2,1), asp = NA,
              main = "New Haven Temperatures", col.main = "blue")

     ## Multivariate (but non-stationary! ...)
     lag.plot(freeny.x, lag = 3)
     ## Not run: 
     no lines for long series :
     lag.plot(sqrt(sunspots), set = c(1:4, 9:12), pch = ".", col = "gold")
     ## End(Not run)

