#!/bin/sh

SWNAME=mpeg_play-2.4
ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc

rm -rf mpeg_play
tar zxf mpeg_play-2.4-patched-src.tar.gz
cd mpeg_play
patch < ../mpeg_play-2.4_default_fullcolor.patch
patch <<EOF
--- Makefile.proto~	2004-05-25 20:24:17.000000000 +0900
+++ Makefile.proto	2004-05-25 20:25:31.000000000 +0900
@@ -194,7 +194,7 @@
 		@echo Installing \$(PROGRAM) in \$(DEST)
 		@-strip \$(PROGRAM)
 		@if [ \$(DEST) != . ]; then \\
-		(rm -f \$(DEST)/\$(PROGRAM); \$(INSTALL) -f \$(DEST) \$(PROGRAM)); fi
+		(rm -f \$(DEST)/\$(PROGRAM); \$(INSTALL) \$(PROGRAM) \$(DEST)); fi
 
 print:;		@\$(PRINT) \$(HDRS) \$(SRCS)
 
EOF

ln -s Makefile.proto Makefile

make

rm -rf ../pkg
mkdir -p ../pkg/usr/X11R6/bin
mkdir -p ../pkg/${MANDIR}/man1
mkdir -p ../pkg/${DOCDIR}/${SWNAME}

make install DEST=`pwd`/../pkg/usr/X11R6/bin INSTALL=/bin/install
cp -p mpeg_play.1 ../pkg/${MANDIR}/man1/.
gzip ../pkg/${MANDIR}/man1/mpeg_play.1
cp -p ../*.patch ../PlamoBuild.sh A* B* C* P* R* T* V* ../pkg/${DOCDIR}/${SWNAME}/.
gzip ../pkg/${DOCDIR}/${SWNAME}/*.patch
chown -R root:root ../pkg/${DOCDIR}/${SWNAME}

cd ../pkg
/sbin/makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
