#!/bin/sh

PKGVER=5.3.2
ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc

PKGDIR=`pwd`/pkg

rm -rf ImageMagick-${PKGVER}
tar zxf ImageMagick-${PKGVER}.tar.gz
cd ImageMagick-${PKGVER}
patch -p1 <../ImageMagick-5.2.9-DESTDIR.patch
patch -p1 <../ImageMagick-5.2.9-RLE.patch
CFLAGS=-O2 ./configure --prefix=/usr --mandir=$MANDIR --enable-shared --enable-lzw --without-perl
make

rm -rf $PKGDIR
make install DESTDIR=$PKGDIR
gzip ${PKGDIR}${MANDIR}/man1/*.1
gzip ${PKGDIR}${MANDIR}/man4/*.4
gzip ${PKGDIR}${MANDIR}/man5/*.5
mkdir -p ${PKGDIR}${DOCDIR}/ImageMagick-${PKGVER}
cp -p README.txt Manifest.ps ${PKGDIR}${DOCDIR}/ImageMagick-${PKGVER}/.
cp -p ../ImageMagick-5.2.9-DESTDIR.patch ../ImageMagick-5.2.9-RLE.patch ../PlamoBuild.sh ${PKGDIR}${DOCDIR}/ImageMagick-${PKGVER}/.
( cd ${PKGDIR}${DOCDIR}/ImageMagick-${PKGVER}
  ln -s ../../../share/ImageMagick/Copyright.txt .
  ln -s ../../../share/ImageMagick/QuickStart.txt .
  ln -s ../../../share/ImageMagick/ImageMagick.html .
  ln -s ../../../share/ImageMagick/www .
  ln -s ../../../share/ImageMagick/images .
)
chown -R root:root ${PKGDIR}${DOCDIR}/ImageMagick-${PKGVER}
cd $PKGDIR
/sbin/makepkg ImageMagick-${PKGVER}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
