#!/bin/bash -f

ACTIVE=`grep Active: /proc/meminfo | /usr/bin/awk '{print $2}'`
TOTAL=`grep MemTotal: /proc/meminfo | /usr/bin/awk '{print $2}'`
FREE=$(( $TOTAL - $ACTIVE ))
ALLOC=$(( $FREE * 2 / 3 ))

#echo "$TOTAL - $ACTIVE"
#echo $FREE
#echo "$FREE * 2 / 3"
#echo $ALLOC

/usr/bin/sed -e "s/_MEM_ALLOC_/$ALLOC/" /usr/share/memcached/memcached.run \
	> /etc/rc.d/init.d/memcached
/usr/bin/chmod +x /etc/rc.d/init.d/memcached

if [ -f /etc/php.ini ]; then
  /usr/bin/pecl install memcache
  /usr/bin/pecl upgrade memcache

  if ! `/usr/bin/fgrep memcache.so /etc/php.ini 1>/dev/null 2>&1` ; then
      /usr/bin/cat /usr/share/memcached/php.ini-add.memcache >> /etc/php.ini
  fi

fi

