#!/bin/sh
# This should be done at initial booting after installation.
#
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

cd $ROOT/

if [ -d $ROOT/opt/pgsql ] ; then
  mv $ROOT/opt/pgsql $ROOT/opt/pgsql.bak
fi
rm -f $ROOT/opt/pgsql
ln -sf $ROOT/opt/postgresql-8.2.5 $ROOT/opt/pgsql

(cd $ROOT/opt/postgresql-8.2.5/bin; ln -sf postgres postmaster)

(cd $ROOT/usr/doc/postgresql-8.2.5 && \
 rm -f doc && \
 ln -s $ROOT/opt/postgresql-8.2.5/doc doc )

#
# Create Environment
#
PG_ROOT=$ROOT/opt/postgresql-8.2.5; export PG_ROOT

(cd $PG_ROOT/lib && \
	ln -sf libecpg.so.5.2 libecpg.so.5
	ln -sf libecpg.so.5.2 libecpg.so
	ln -sf libecpg_compat.so.2.2 libecpg_compat.so
	ln -sf libecpg_compat.so.2.2 libecpg_compat.so.2
	ln -sf libpgtypes.so.2.2 libpgtypes.so
	ln -sf libpgtypes.so.2.2 libpgtypes.so.2
	ln -sf libpq.so.5.0 libpq.so
	ln -sf libpq.so.5.0 libpq.so.5
)


# Add user and group
groupadd pgsql
useradd -g pgsql -d $ROOT/opt/pgsql -c "Postgres Admin." -s /bin/tcsh postgres
chown -R postgres.pgsql $ROOT/opt/postgresql-8.2.5

# This is required for Kerberos authentication
if ! fgrep "postgres" /etc/services 1> /dev/null 2>&1; then
    echo 'postgres	5432/tcp			# Reserve for PostgreSQL' >> /etc/services
else
	echo "Entry postgres is already in /etc/services."
fi

if [ ! -f /etc/rc.d/init.d/postgresql ]; then
  cp /opt/pgsql/etc/init.d/postgresql /etc/rc.d/init.d/
  chmod +x /etc/rc.d/init.d/postgresql
fi

if ! fgrep "/opt/pgsql/lib" $ROOT/etc/ld.so.conf 1> /dev/null 2>&1; then
  echo "/opt/pgsql/lib" >> $ROOT/etc/ld.so.conf
else
  echo "Entry /opt/pgsql/lib is already in $ROOT/etc/ld.so.conf."
fi
if [ "$ROOT" != "" ] ; then
  /sbin/ldconfig
fi

# fix startup shell
sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/utils/pgsqld \
	> $ROOT/opt/postgresql-8.2.5/bin/pgsqld
chmod +x $ROOT/opt/postgresql-8.2.5/bin/pgsqld
chown postgres.pgsql $ROOT/opt/postgresql-8.2.5/bin/pgsqld

# add LOG_LOCAL0 for syslogd report
if ! fgrep "/var/log/pgsqlog" $ROOT/etc/syslog.conf 1> /dev/null 2>&1; then
    echo "local1.*		/var/log/pgsqlog" >> $ROOT/etc/syslog.conf
    if [ ! -f $ROOT/var/log/pgsqlog ]; then
	touch $ROOT/var/log/pgsqlog
    fi
    kill -HUP `pidof syslogd`
else
	echo "Entry pgsqlog is already in /etc/syslog.conf."
fi
if [ ! -d $ROOT/etc/logrotate.d ]; then
  if [ -f $ROOT/etc/logrotate.conf ]; then
    if ! fgrep "/var/log/pgsqlog" $ROOT/etc/logrotate.conf 1> /dev/null 2>&1; then
        cat $ROOT/opt/postgresql-8.2.5/etc/logrotate.pgsql >> $ROOT/etc/logrotate.conf
    fi
  fi
else
  if [ ! -f $ROOT/etc/logrotate.d/postgresql ]; then
    cp $ROOT/opt/postgresql-8.2.5/etc/logrotate.pgsql $ROOT/etc/logrotate.d/postgresql
  fi
    #if ! fgrep "/var/log/pgsqlog" $ROOT/etc/logrotate.d/syslog 1> /dev/null 2>&1; then
    #  cp -p $ROOT/etc/logrotate.d/syslog $ROOT/tmp/syslog.old
    #  sed -e 's% {% /var/log/pgsqlog {%' $ROOT/tmp/syslog.old > $ROOT/etc/logrotate.d/syslog
    #fi
fi
if ! fgrep "Add by Plamo Linux 4" $ROOT/opt/postgresql-8.2.5/share/postgresql.conf.sample 1> /dev/null 2>&1; then
  cat >> $ROOT/opt/postgresql-8.2.5/share/postgresql.conf.sample <<ENF

#
# Add by Plamo Linux 4.x installer for Postgres8
listen_addresses = '*'
ssl = true

log_destination = 'syslog'
syslog_facility = 'LOCAL1'
syslog_ident = 'postgres'

ENF
#  $ROOT/opt/postgresql-8.2.5/apps/utils/get_memory_parameters -n 64 \
#	>>$ROOT/opt/postgresql-8.2.5/share/postgresql.conf.sample
fi

# set environment variables when non default installation 
if [ "$ROOT" != "" ] ; then
  (cd $ROOT/opt/postgresql-8.2.5/apps/utils;
   mv pgsqld pgsqld.org;
   sed -e "s%PGROOT=%PGROOT=$ROOT%" pgsqld.org > pgsqld;
   chown postgres.pgsql pgsqld;
   chmod +x pgsqld)

  if [ ! -f $ROOT/opt/postgresql-8.2.5/.cshrc.mine ]; then
  sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/_cshrc.pgsqlj > $ROOT/opt/postgresql-8.2.5/.cshrc.mine
  fi
  (cd $ROOT/opt/postgresql-8.2.5/;
   mv .cshrc.mine .cshrc.mine.org;
   echo "setenv TCL_LIBRARY $ROOT/usr/lib/tcl8.0jp" >> .cshrc.mine;
   echo "setenv TK_LIBRARY $ROOT/usr/lib/tk8.0jp" >> .cshrc.mine;
   echo "setenv LD_LIBRARY_PATH \"$ROOT/lib:$ROOT/usr/lib:$ROOT/opt/lib:\$LD_LIBRARY_PATH\"" >> .cshrc.mine
   sed -e "s%PG_DIR	%PG_DIR	$ROOT%" .cshrc.mine.org >> .cshrc.mine;
   chown postgres.pgsql .cshrc.mine;
   )
	mv $ROOT/etc/rc.d/rc.pgsqld $ROOT/etc/rc.d/rc.pgsqld.org
	(echo "LD_LIBRARY_PATH=\"$ROOT/lib:$ROOT/usr/lib:$ROOT/opt/lib\"" \
	 echo "export LD_LIBRARY_PATH") \
	 > $ROOT/etc/rc.d/rc.pgsqld
	sed -e "s%/opt/pgsql%$ROOT/opt/postgresql-8.2.5%" \
	  $ROOT/etc/rc.d/rc.pgsqld.org >> $ROOT/etc/rc.d/rc.pgsqld
	chmod +x $ROOT/etc/rc.d/rc.pgsqld
fi


#
# Initializing DATABASE
#

# Initialize database
sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/utils/initialize_default_database \
	> $ROOT/opt/postgresql-8.2.5/apps/utils/initialize_default_database.sh
/bin/su - postgres -c "sh $ROOT/opt/postgresql-8.2.5/apps/utils/initialize_default_database.sh"

# Start backend
$ROOT/opt/postgresql-8.2.5/bin/pgsqld start
sleep 1

# Create database users
sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/utils/create_default_users-8.x \
	> $ROOT/opt/postgresql-8.2.5/apps/utils/create_default_users.sh
/bin/su - postgres -c "sh $ROOT/opt/postgresql-8.2.5/apps/utils/create_default_users.sh"

# set access control file(open for your network)
#HNAME=`hostname`
#HADDR=`fgrep ${HNAME}\. /etc/hosts | cut -f1`
#NADDR=`fgrep localnet /etc/networks | cut -f2`
#NMASK=`ifconfig | fgrep $HADDR | cut -f4 -d:`
NADDR=`ifconfig eth0 | fgrep inet | sed -e 's/.*addr:\(.*\) .*Bcast:\(.*\) .*Mask:\(.*\)/\1/'`
NMASK=`ifconfig eth0 | fgrep inet | sed -e 's/.*addr:\(.*\) .*Bcast:\(.*\) .*Mask:\(.*\)/\3/'`
if [ "$NADDR" != "" ] ; then
	sed -e "s/192.168.2.0/$NADDR/" -e "s/255.255.255.128/$NMASK/" \
 $ROOT/opt/postgresql-8.2.5/share/pg_hba.conf.template > $ROOT/opt/postgresql-8.2.5/share/pg_hba.conf.sample
fi

if [ ! -f $ROOT/opt/postgresql-8.2.5/.cshrc ]; then
  sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/_cshrc.pgsql > $ROOT/opt/postgresql-8.2.5/.cshrc
fi
if [ ! -f $ROOT/opt/postgresql-8.2.5/.bashrc ]; then
  sed -e "s%/opt/pgsql%/opt/postgresql-8.2.5%" -e "s%5432%5432%" \
	$ROOT/opt/postgresql-8.2.5/apps/_bashrc.pgsql > $ROOT/opt/postgresql-8.2.5/.bashrc
fi


#
# ( DONOT CHANGE THE NEXT ONE LINE )
# Add PostgreSQL Entry to Apache document index.
#
if [ -f $ROOT/opt/httpd/htdocs/contents.list ]; then
  if ! fgrep "postgresql-8.2.5" $ROOT/opt/httpd/htdocs/contents.list 1> /dev/null 2>&1; then
    cat >> $ROOT/opt/httpd/htdocs/contents.list <<EOL

    <P ALIGN="CENTER">
    postgresql-8.2.5
    (
      <A
	HREF="http://www.jp.postgresql.org/"
      > http://www.postgresql.org/ </A>
	|
      <A
	HREF="http://www.postgresql.jp/"
      > http://www.postgresql.jp/ </A>
    )<BR>
     (Object Relational Database Management System)<BR>
    <A
     HREF="postgresql-8.2.5/"
    >documentation</A>
    </P>
EOL
  fi
  if [ ! -f $ROOT/opt/httpd/htdocs/postgresql-8.2.5 ]; then 
    ln -sf $ROOT/usr/doc/postgresql-8.2.5 $ROOT/opt/httpd/htdocs/postgresql-8.2.5
  fi
else
  awk '/Add PostgreSQL Entry/,EOF' $ROOT/install/doinst.sh >> /tmp/add_apache_test.sh
fi
#
cd $ROOT/
