BEGIN;
-- Drop index bindings from system tables
DROP OPERATOR CLASS gist_geometry_ops USING gist CASCADE;
-- Drop all aggregates.
DROP AGGREGATE memcollect ( geometry );
DROP AGGREGATE ST_memcollect ( geometry );
DROP AGGREGATE accum ( geometry );
DROP AGGREGATE ST_accum ( geometry );
DROP AGGREGATE collect ( geometry );
DROP AGGREGATE ST_collect ( geometry );
DROP AGGREGATE makeline ( geometry );
DROP AGGREGATE ST_MakeLine ( geometry );
DROP AGGREGATE Polygonize ( geometry );
DROP AGGREGATE ST_Polygonize ( geometry );
DROP AGGREGATE Extent ( geometry );
DROP AGGREGATE ST_Extent ( geometry );
DROP AGGREGATE Extent3d ( geometry );
DROP AGGREGATE ST_Extent3d ( geometry );
DROP AGGREGATE MemGeomUnion ( geometry );
DROP AGGREGATE ST_MemGeomUnion ( geometry );
DROP AGGREGATE GeomUnion ( geometry );
DROP AGGREGATE ST_Union ( geometry );
-- Drop all operators.
DROP OPERATOR <  (geometry,geometry) CASCADE;
DROP OPERATOR <=  (geometry,geometry) CASCADE;
DROP OPERATOR =  (geometry,geometry) CASCADE;
DROP OPERATOR >=  (geometry,geometry) CASCADE;
DROP OPERATOR >  (geometry,geometry) CASCADE;
DROP OPERATOR <<  (geometry,geometry) CASCADE;
DROP OPERATOR &<  (geometry,geometry) CASCADE;
DROP OPERATOR <<|  (geometry,geometry) CASCADE;
DROP OPERATOR &<|  (geometry,geometry) CASCADE;
DROP OPERATOR &&  (geometry,geometry) CASCADE;
DROP OPERATOR &>  (geometry,geometry) CASCADE;
DROP OPERATOR >>  (geometry,geometry) CASCADE;
DROP OPERATOR |&>  (geometry,geometry) CASCADE;
DROP OPERATOR |>>  (geometry,geometry) CASCADE;
DROP OPERATOR ~=  (geometry,geometry) CASCADE;
DROP OPERATOR @  (geometry,geometry) CASCADE;
DROP OPERATOR ~  (geometry,geometry) CASCADE;
-- Drop all casts.
DROP CAST (geometry AS box2d);
DROP CAST (geometry AS box3d);
DROP CAST (geometry AS box);
DROP CAST (box3d AS box2d);
DROP CAST (box2d AS box3d);
DROP CAST (box2d AS geometry);
DROP CAST (box3d AS box);
DROP CAST (box3d AS geometry);
DROP CAST (text AS geometry);
DROP CAST (geometry AS text);
DROP CAST (chip AS geometry);
DROP CAST (bytea AS geometry);
DROP CAST (geometry AS bytea);
-- Drop all functions.
DROP FUNCTION Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) CASCADE;
DROP FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) CASCADE;
DROP FUNCTION Affine (geometry,float8,float8,float8,float8,float8,float8) CASCADE;
DROP FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8) CASCADE;
DROP FUNCTION RotateZ (geometry,float8) CASCADE;
DROP FUNCTION ST_RotateZ (geometry,float8) CASCADE;
DROP FUNCTION Rotate (geometry,float8) CASCADE;
DROP FUNCTION ST_Rotate (geometry,float8) CASCADE;
DROP FUNCTION RotateX (geometry,float8) CASCADE;
DROP FUNCTION ST_RotateX (geometry,float8) CASCADE;
DROP FUNCTION RotateY (geometry,float8) CASCADE;
DROP FUNCTION ST_RotateY (geometry,float8) CASCADE;
DROP FUNCTION Translate (geometry,float8,float8,float8) CASCADE;
DROP FUNCTION ST_Translate (geometry,float8,float8,float8) CASCADE;
DROP FUNCTION Translate (geometry,float8,float8) CASCADE;
DROP FUNCTION ST_Translate (geometry,float8,float8) CASCADE;
DROP FUNCTION Scale (geometry,float8,float8,float8) CASCADE;
DROP FUNCTION ST_Scale (geometry,float8,float8,float8) CASCADE;
DROP FUNCTION Scale (geometry,float8,float8) CASCADE;
DROP FUNCTION ST_Scale (geometry,float8,float8) CASCADE;
DROP FUNCTION transscale (geometry,float8,float8,float8,float8) CASCADE;
DROP FUNCTION ST_transscale (geometry,float8,float8,float8,float8) CASCADE;
DROP FUNCTION shift_longitude (geometry) CASCADE;
DROP FUNCTION ST_shift_longitude (geometry) CASCADE;
DROP FUNCTION xmin (box3d) CASCADE;
DROP FUNCTION ST_xmin (box3d) CASCADE;
DROP FUNCTION ymin (box3d) CASCADE;
DROP FUNCTION ST_ymin (box3d) CASCADE;
DROP FUNCTION zmin (box3d) CASCADE;
DROP FUNCTION ST_zmin (box3d) CASCADE;
DROP FUNCTION xmax (box3d) CASCADE;
DROP FUNCTION ST_xmax (box3d) CASCADE;
DROP FUNCTION ymax (box3d) CASCADE;
DROP FUNCTION ST_ymax (box3d) CASCADE;
DROP FUNCTION zmax (box3d) CASCADE;
DROP FUNCTION ST_zmax (box3d) CASCADE;
DROP FUNCTION box2d_overleft (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_overleft (box2d, box2d) CASCADE;
DROP FUNCTION box2d_overright (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_overright (box2d, box2d) CASCADE;
DROP FUNCTION box2d_left (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_left (box2d, box2d) CASCADE;
DROP FUNCTION box2d_right (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_right (box2d, box2d) CASCADE;
DROP FUNCTION box2d_contain (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_contain (box2d, box2d) CASCADE;
DROP FUNCTION box2d_contained (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_contained (box2d, box2d) CASCADE;
DROP FUNCTION box2d_overlap (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_overlap (box2d, box2d) CASCADE;
DROP FUNCTION box2d_same (box2d, box2d) CASCADE;
DROP FUNCTION ST_box2d_same (box2d, box2d) CASCADE;
DROP FUNCTION geometry_lt (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_lt (geometry, geometry) CASCADE;
DROP FUNCTION geometry_le (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_le (geometry, geometry) CASCADE;
DROP FUNCTION geometry_gt (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_gt (geometry, geometry) CASCADE;
DROP FUNCTION geometry_ge (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_ge (geometry, geometry) CASCADE;
DROP FUNCTION geometry_eq (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_eq (geometry, geometry) CASCADE;
DROP FUNCTION geometry_cmp (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_cmp (geometry, geometry) CASCADE;
DROP FUNCTION postgis_gist_sel  (internal, oid, internal, int4) CASCADE;
DROP FUNCTION ST_postgis_gist_sel  (internal, oid, internal, int4) CASCADE;
DROP FUNCTION postgis_gist_joinsel (internal, oid, internal, smallint) CASCADE;
DROP FUNCTION ST_postgis_gist_joinsel (internal, oid, internal, smallint) CASCADE;
DROP FUNCTION geometry_overleft (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_overleft (geometry, geometry) CASCADE;
DROP FUNCTION geometry_overright (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_overright (geometry, geometry) CASCADE;
DROP FUNCTION geometry_overabove (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_overabove (geometry, geometry) CASCADE;
DROP FUNCTION geometry_overbelow (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_overbelow (geometry, geometry) CASCADE;
DROP FUNCTION geometry_left (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_left (geometry, geometry) CASCADE;
DROP FUNCTION geometry_right (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_right (geometry, geometry) CASCADE;
DROP FUNCTION geometry_above (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_above (geometry, geometry) CASCADE;
DROP FUNCTION geometry_below (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_below (geometry, geometry) CASCADE;
DROP FUNCTION geometry_contain (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_contain (geometry, geometry) CASCADE;
DROP FUNCTION geometry_contained (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_contained (geometry, geometry) CASCADE;
DROP FUNCTION geometry_overlap (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_overlap (geometry, geometry) CASCADE;
DROP FUNCTION geometry_same (geometry, geometry) CASCADE;
DROP FUNCTION ST_geometry_same (geometry, geometry) CASCADE;
DROP FUNCTION LWGEOM_gist_consistent (internal,geometry,int4) CASCADE;
DROP FUNCTION LWGEOM_gist_compress (internal) CASCADE;
DROP FUNCTION LWGEOM_gist_penalty (internal,internal,internal) CASCADE;
DROP FUNCTION LWGEOM_gist_picksplit (internal, internal) CASCADE;
DROP FUNCTION LWGEOM_gist_union (bytea, internal) CASCADE;
DROP FUNCTION LWGEOM_gist_same (box2d, box2d, internal) CASCADE;
DROP FUNCTION LWGEOM_gist_decompress (internal) CASCADE;
DROP FUNCTION addBBOX (geometry) CASCADE;
DROP FUNCTION ST_addBBOX (geometry) CASCADE;
DROP FUNCTION dropBBOX (geometry) CASCADE;
DROP FUNCTION ST_dropBBOX (geometry) CASCADE;
DROP FUNCTION getSRID (geometry) CASCADE;
DROP FUNCTION getSRID (geometry) CASCADE;
DROP FUNCTION getBBOX (geometry) CASCADE;
DROP FUNCTION getBBOX (geometry) CASCADE;
DROP FUNCTION srid (chip) CASCADE;
DROP FUNCTION ST_srid (chip) CASCADE;
DROP FUNCTION height (chip) CASCADE;
DROP FUNCTION ST_height (chip) CASCADE;
DROP FUNCTION factor (chip) CASCADE;
DROP FUNCTION ST_factor (chip) CASCADE;
DROP FUNCTION width (chip) CASCADE;
DROP FUNCTION ST_width (chip) CASCADE;
DROP FUNCTION datatype (chip) CASCADE;
DROP FUNCTION ST_datatype (chip) CASCADE;
DROP FUNCTION compression (chip) CASCADE;
DROP FUNCTION ST_compression (chip) CASCADE;
DROP FUNCTION setSRID (chip,int4) CASCADE;
DROP FUNCTION setFactor (chip,float4) CASCADE;
DROP FUNCTION ST_setFactor (chip,float4) CASCADE;
DROP FUNCTION mem_size (geometry) CASCADE;
DROP FUNCTION ST_mem_size (geometry) CASCADE;
DROP FUNCTION summary (geometry) CASCADE;
DROP FUNCTION ST_summary (geometry) CASCADE;
DROP FUNCTION npoints (geometry) CASCADE;
DROP FUNCTION ST_npoints (geometry) CASCADE;
DROP FUNCTION nrings (geometry) CASCADE;
DROP FUNCTION ST_nrings (geometry) CASCADE;
DROP FUNCTION length3d (geometry) CASCADE;
DROP FUNCTION ST_length3d (geometry) CASCADE;
DROP FUNCTION length2d (geometry) CASCADE;
DROP FUNCTION ST_length2d (geometry) CASCADE;
DROP FUNCTION length (geometry) CASCADE;
DROP FUNCTION ST_Length (geometry) CASCADE;
DROP FUNCTION length3d_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION ST_length3d_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION length_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION ST_length_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION length2d_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION ST_length2d_spheroid (geometry, spheroid) CASCADE;
DROP FUNCTION perimeter3d (geometry) CASCADE;
DROP FUNCTION ST_perimeter3d (geometry) CASCADE;
DROP FUNCTION perimeter2d (geometry) CASCADE;
DROP FUNCTION ST_perimeter2d (geometry) CASCADE;
DROP FUNCTION perimeter (geometry) CASCADE;
DROP FUNCTION ST_Perimeter (geometry) CASCADE;
DROP FUNCTION area2d (geometry) CASCADE;
DROP FUNCTION ST_area2d (geometry) CASCADE;
DROP FUNCTION area (geometry) CASCADE;
DROP FUNCTION ST_Area (geometry) CASCADE;
DROP FUNCTION distance_spheroid (geometry,geometry,spheroid) CASCADE;
DROP FUNCTION ST_distance_spheroid (geometry,geometry,spheroid) CASCADE;
DROP FUNCTION distance_sphere (geometry,geometry) CASCADE;
DROP FUNCTION ST_distance_sphere (geometry,geometry) CASCADE;
DROP FUNCTION distance (geometry,geometry) CASCADE;
DROP FUNCTION ST_Distance (geometry,geometry) CASCADE;
DROP FUNCTION max_distance (geometry,geometry) CASCADE;
DROP FUNCTION ST_max_distance (geometry,geometry) CASCADE;
DROP FUNCTION azimuth (geometry,geometry) CASCADE;
DROP FUNCTION ST_azimuth (geometry,geometry) CASCADE;
DROP FUNCTION force_2d (geometry) CASCADE;
DROP FUNCTION ST_force_2d (geometry) CASCADE;
DROP FUNCTION force_3dz (geometry) CASCADE;
DROP FUNCTION ST_force_3dz (geometry) CASCADE;
DROP FUNCTION force_3d (geometry) CASCADE;
DROP FUNCTION ST_force_3d (geometry) CASCADE;
DROP FUNCTION force_3dm (geometry) CASCADE;
DROP FUNCTION ST_force_3dm (geometry) CASCADE;
DROP FUNCTION force_4d (geometry) CASCADE;
DROP FUNCTION ST_force_4d (geometry) CASCADE;
DROP FUNCTION force_collection (geometry) CASCADE;
DROP FUNCTION ST_force_collection (geometry) CASCADE;
DROP FUNCTION multi (geometry) CASCADE;
DROP FUNCTION ST_multi (geometry) CASCADE;
DROP FUNCTION collector (geometry, geometry) CASCADE;
DROP FUNCTION ST_collector (geometry, geometry) CASCADE;
DROP FUNCTION collect (geometry, geometry) CASCADE;
DROP FUNCTION ST_collect (geometry, geometry) CASCADE;
DROP FUNCTION geom_accum  (geometry[],geometry) CASCADE;
DROP FUNCTION ST_geom_accum  (geometry[],geometry) CASCADE;
DROP FUNCTION collect_garray  (geometry[]) CASCADE;
DROP FUNCTION ST_collect_garray  (geometry[]) CASCADE;
DROP FUNCTION expand (box3d,float8) CASCADE;
DROP FUNCTION ST_Expand (box3d,float8) CASCADE;
DROP FUNCTION expand (box2d,float8) CASCADE;
DROP FUNCTION ST_expand (box2d,float8) CASCADE;
DROP FUNCTION expand (geometry,float8) CASCADE;
DROP FUNCTION ST_expand (geometry,float8) CASCADE;
DROP FUNCTION envelope (geometry) CASCADE;
DROP FUNCTION ST_Envelope (geometry) CASCADE;
DROP FUNCTION reverse (geometry) CASCADE;
DROP FUNCTION ST_Reverse (geometry) CASCADE;
DROP FUNCTION ForceRHR (geometry) CASCADE;
DROP FUNCTION ST_ForceRHR (geometry) CASCADE;
DROP FUNCTION noop (geometry) CASCADE;
DROP FUNCTION ST_noop (geometry) CASCADE;
DROP FUNCTION zmflag (geometry) CASCADE;
DROP FUNCTION ST_zmflag (geometry) CASCADE;
DROP FUNCTION hasBBOX (geometry) CASCADE;
DROP FUNCTION ST_HasBBOX (geometry) CASCADE;
DROP FUNCTION ndims (geometry) CASCADE;
DROP FUNCTION ST_NDims (geometry) CASCADE;
DROP FUNCTION AsEWKT (geometry) CASCADE;
DROP FUNCTION ST_AsEWKT (geometry) CASCADE;
DROP FUNCTION AsEWKB (geometry) CASCADE;
DROP FUNCTION ST_AsEWKB (geometry) CASCADE;
DROP FUNCTION AsHEXEWKB (geometry) CASCADE;
DROP FUNCTION ST_AsHEXEWKB (geometry) CASCADE;
DROP FUNCTION AsHEXEWKB (geometry, text) CASCADE;
DROP FUNCTION ST_AsHEXEWKB (geometry, text) CASCADE;
DROP FUNCTION AsEWKB (geometry,text) CASCADE;
DROP FUNCTION ST_AsEWKB (geometry,text) CASCADE;
DROP FUNCTION GeomFromEWKB (bytea) CASCADE;
DROP FUNCTION ST_GeomFromEWKB (bytea) CASCADE;
DROP FUNCTION GeomFromEWKT (text) CASCADE;
DROP FUNCTION ST_GeomFromEWKT (text) CASCADE;
DROP FUNCTION cache_bbox () CASCADE;
DROP FUNCTION ST_Cache_BBox () CASCADE;
DROP FUNCTION MakePoint (float8, float8) CASCADE;
DROP FUNCTION ST_MakePoint (float8, float8) CASCADE;
DROP FUNCTION MakePoint (float8, float8, float8) CASCADE;
DROP FUNCTION ST_MakePoint (float8, float8, float8) CASCADE;
DROP FUNCTION MakePoint (float8, float8, float8, float8) CASCADE;
DROP FUNCTION ST_MakePoint (float8, float8, float8, float8) CASCADE;
DROP FUNCTION MakePointM (float8, float8, float8) CASCADE;
DROP FUNCTION MakePointM (float8, float8, float8) CASCADE;
DROP FUNCTION MakeBox2d (geometry, geometry) CASCADE;
DROP FUNCTION ST_MakeBox2d (geometry, geometry) CASCADE;
DROP FUNCTION MakeBox3d (geometry, geometry) CASCADE;
DROP FUNCTION ST_MakeBox3d (geometry, geometry) CASCADE;
DROP FUNCTION makeline_garray  (geometry[]) CASCADE;
DROP FUNCTION ST_MakeLine_GArray  (geometry[]) CASCADE;
DROP FUNCTION LineFromMultiPoint (geometry) CASCADE;
DROP FUNCTION ST_LineFromMultiPoint (geometry) CASCADE;
DROP FUNCTION MakeLine (geometry, geometry) CASCADE;
DROP FUNCTION ST_MakeLine (geometry, geometry) CASCADE;
DROP FUNCTION AddPoint (geometry, geometry) CASCADE;
DROP FUNCTION ST_AddPoint (geometry, geometry) CASCADE;
DROP FUNCTION AddPoint (geometry, geometry, integer) CASCADE;
DROP FUNCTION ST_AddPoint (geometry, geometry, integer) CASCADE;
DROP FUNCTION RemovePoint (geometry, integer) CASCADE;
DROP FUNCTION ST_RemovePoint (geometry, integer) CASCADE;
DROP FUNCTION SetPoint (geometry, integer, geometry) CASCADE;
DROP FUNCTION ST_SetPoint (geometry, integer, geometry) CASCADE;
DROP FUNCTION MakePolygon (geometry, geometry[]) CASCADE;
DROP FUNCTION ST_MakePolygon (geometry, geometry[]) CASCADE;
DROP FUNCTION MakePolygon (geometry) CASCADE;
DROP FUNCTION ST_MakePolygon (geometry) CASCADE;
DROP FUNCTION BuildArea (geometry) CASCADE;
DROP FUNCTION ST_BuildArea (geometry) CASCADE;
DROP FUNCTION Polygonize_GArray  (geometry[]) CASCADE;
DROP FUNCTION ST_Polygonize_GArray  (geometry[]) CASCADE;
DROP FUNCTION LineMerge (geometry) CASCADE;
DROP FUNCTION ST_LineMerge (geometry) CASCADE;
DROP FUNCTION Dump (geometry) CASCADE;
DROP FUNCTION ST_Dump (geometry) CASCADE;
DROP FUNCTION DumpRings (geometry) CASCADE;
DROP FUNCTION ST_DumpRings (geometry) CASCADE;
DROP FUNCTION combine_bbox (box2d,geometry) CASCADE;
DROP FUNCTION ST_Combine_BBox (box2d,geometry) CASCADE;
DROP FUNCTION combine_bbox (box3d,geometry) CASCADE;
DROP FUNCTION ST_Combine_BBox (box3d,geometry) CASCADE;
DROP FUNCTION create_histogram2d (box2d,int) CASCADE;
DROP FUNCTION ST_create_histogram2d (box2d,int) CASCADE;
DROP FUNCTION build_histogram2d  (histogram2d,text,text) CASCADE;
DROP FUNCTION ST_build_histogram2d  (histogram2d,text,text) CASCADE;
DROP FUNCTION build_histogram2d  (histogram2d,text,text,text) CASCADE;
DROP FUNCTION ST_build_histogram2d  (histogram2d,text,text,text) CASCADE;
DROP FUNCTION explode_histogram2d  (histogram2d,text) CASCADE;
DROP FUNCTION ST_explode_histogram2d  (histogram2d,text) CASCADE;
DROP FUNCTION estimate_histogram2d (histogram2d,box2d) CASCADE;
DROP FUNCTION ST_estimate_histogram2d (histogram2d,box2d) CASCADE;
DROP FUNCTION estimated_extent (text,text,text) CASCADE;
DROP FUNCTION ST_estimated_extent (text,text,text) CASCADE;
DROP FUNCTION estimated_extent (text,text) CASCADE;
DROP FUNCTION ST_estimated_extent (text,text) CASCADE;
DROP FUNCTION find_extent (text,text,text) CASCADE;
DROP FUNCTION ST_find_extent (text,text,text) CASCADE;
DROP FUNCTION find_extent (text,text) CASCADE;
DROP FUNCTION ST_find_extent (text,text) CASCADE;
DROP FUNCTION rename_geometry_table_constraints () CASCADE;
DROP FUNCTION fix_geometry_columns () CASCADE;
DROP FUNCTION probe_geometry_columns () CASCADE;
DROP FUNCTION AddGeometryColumn (varchar,varchar,varchar,varchar,integer,varchar,integer) CASCADE;
DROP FUNCTION AddGeometryColumn (varchar,varchar,varchar,integer,varchar,integer) CASCADE;
DROP FUNCTION AddGeometryColumn (varchar,varchar,integer,varchar,integer) CASCADE;
DROP FUNCTION DropGeometryColumn (varchar, varchar,varchar,varchar) CASCADE;
DROP FUNCTION DropGeometryColumn (varchar,varchar,varchar) CASCADE;
DROP FUNCTION DropGeometryColumn (varchar,varchar) CASCADE;
DROP FUNCTION DropGeometryTable (varchar, varchar,varchar) CASCADE;
DROP FUNCTION DropGeometryTable (varchar,varchar) CASCADE;
DROP FUNCTION DropGeometryTable (varchar) CASCADE;
DROP FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,varchar,integer) CASCADE;
DROP FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer) CASCADE;
DROP FUNCTION UpdateGeometrySRID (varchar,varchar,integer) CASCADE;
DROP FUNCTION update_geometry_stats () CASCADE;
DROP FUNCTION update_geometry_stats (varchar,varchar) CASCADE;
DROP FUNCTION find_srid (varchar,varchar,varchar) CASCADE;
DROP FUNCTION get_proj4_from_srid (integer) CASCADE;
DROP FUNCTION transform_geometry (geometry,text,text,int) CASCADE;
DROP FUNCTION transform (geometry,integer) CASCADE;
DROP FUNCTION ST_Transform (geometry,integer) CASCADE;
DROP FUNCTION postgis_version () CASCADE;
DROP FUNCTION postgis_proj_version () CASCADE;
DROP FUNCTION postgis_lib_version () CASCADE;
DROP FUNCTION postgis_scripts_released () CASCADE;
DROP FUNCTION postgis_uses_stats () CASCADE;
DROP FUNCTION postgis_geos_version () CASCADE;
DROP FUNCTION postgis_jts_version () CASCADE;
DROP FUNCTION postgis_scripts_build_date () CASCADE;
DROP FUNCTION postgis_lib_build_date () CASCADE;
DROP FUNCTION postgis_full_version () CASCADE;
DROP FUNCTION box2d (geometry) CASCADE;
DROP FUNCTION ST_box2d (geometry) CASCADE;
DROP FUNCTION box3d (geometry) CASCADE;
DROP FUNCTION ST_box3d (geometry) CASCADE;
DROP FUNCTION box (geometry) CASCADE;
DROP FUNCTION ST_box (geometry) CASCADE;
DROP FUNCTION box2d (box3d) CASCADE;
DROP FUNCTION ST_box2d (box3d) CASCADE;
DROP FUNCTION box3d (box2d) CASCADE;
DROP FUNCTION ST_box3d (box2d) CASCADE;
DROP FUNCTION box (box3d) CASCADE;
DROP FUNCTION ST_box (box3d) CASCADE;
DROP FUNCTION text (geometry) CASCADE;
DROP FUNCTION ST_text (geometry) CASCADE;
DROP FUNCTION box3dtobox (box3d) CASCADE;
DROP FUNCTION geometry (box2d) CASCADE;
DROP FUNCTION ST_geometry (box2d) CASCADE;
DROP FUNCTION geometry (box3d) CASCADE;
DROP FUNCTION ST_geometry (box3d) CASCADE;
DROP FUNCTION geometry (text) CASCADE;
DROP FUNCTION ST_geometry (text) CASCADE;
DROP FUNCTION geometry (chip) CASCADE;
DROP FUNCTION ST_geometry (chip) CASCADE;
DROP FUNCTION geometry (bytea) CASCADE;
DROP FUNCTION ST_geometry (bytea) CASCADE;
DROP FUNCTION bytea (geometry) CASCADE;
DROP FUNCTION ST_bytea (geometry) CASCADE;
DROP FUNCTION text (bool) CASCADE;
DROP FUNCTION ST_text (bool) CASCADE;
DROP FUNCTION simplify (geometry, float8) CASCADE;
DROP FUNCTION ST_simplify (geometry, float8) CASCADE;
DROP FUNCTION SnapToGrid (geometry, float8, float8, float8, float8) CASCADE;
DROP FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8) CASCADE;
DROP FUNCTION SnapToGrid (geometry, float8, float8) CASCADE;
DROP FUNCTION ST_SnapToGrid (geometry, float8, float8) CASCADE;
DROP FUNCTION SnapToGrid (geometry, float8) CASCADE;
DROP FUNCTION ST_SnapToGrid (geometry, float8) CASCADE;
DROP FUNCTION SnapToGrid (geometry, geometry, float8, float8, float8, float8) CASCADE;
DROP FUNCTION ST_SnapToGrid (geometry, geometry, float8, float8, float8, float8) CASCADE;
DROP FUNCTION segmentize (geometry, float8) CASCADE;
DROP FUNCTION ST_segmentize (geometry, float8) CASCADE;
DROP FUNCTION line_substring (geometry, float8, float8) CASCADE;
DROP FUNCTION ST_line_substring (geometry, float8, float8) CASCADE;
DROP FUNCTION line_locate_point (geometry, geometry) CASCADE;
DROP FUNCTION ST_line_locate_point (geometry, geometry) CASCADE;
DROP FUNCTION locate_between_measures (geometry, float8, float8) CASCADE;
DROP FUNCTION ST_locate_between_measures (geometry, float8, float8) CASCADE;
DROP FUNCTION locate_along_measure (geometry, float8) CASCADE;
DROP FUNCTION ST_locate_along_measure (geometry, float8) CASCADE;
DROP FUNCTION intersection (geometry,geometry) CASCADE;
DROP FUNCTION buffer (geometry,float8) CASCADE;
DROP FUNCTION ST_Buffer (geometry,float8) CASCADE;
DROP FUNCTION buffer (geometry,float8,integer) CASCADE;
DROP FUNCTION ST_buffer (geometry,float8,integer) CASCADE;
DROP FUNCTION convexhull (geometry) CASCADE;
DROP FUNCTION ST_ConvexHull (geometry) CASCADE;
DROP FUNCTION difference (geometry,geometry) CASCADE;
DROP FUNCTION ST_Difference (geometry,geometry) CASCADE;
DROP FUNCTION boundary (geometry) CASCADE;
DROP FUNCTION ST_Boundary (geometry) CASCADE;
DROP FUNCTION symdifference (geometry,geometry) CASCADE;
DROP FUNCTION ST_SymDifference (geometry,geometry) CASCADE;
DROP FUNCTION symmetricdifference (geometry,geometry) CASCADE;
DROP FUNCTION ST_symmetricdifference (geometry,geometry) CASCADE;
DROP FUNCTION GeomUnion (geometry,geometry) CASCADE;
DROP FUNCTION ST_Union (geometry,geometry) CASCADE;
DROP FUNCTION unite_garray  (geometry[]) CASCADE;
DROP FUNCTION ST_unite_garray  (geometry[]) CASCADE;
DROP FUNCTION relate (geometry,geometry) CASCADE;
DROP FUNCTION ST_relate (geometry,geometry) CASCADE;
DROP FUNCTION relate (geometry,geometry,text) CASCADE;
DROP FUNCTION ST_Relate (geometry,geometry,text) CASCADE;
DROP FUNCTION disjoint (geometry,geometry) CASCADE;
DROP FUNCTION ST_Disjoint (geometry,geometry) CASCADE;
DROP FUNCTION touches (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Touches (geometry,geometry) CASCADE;
DROP FUNCTION ST_Touches (geometry,geometry) CASCADE;
DROP FUNCTION ST_DWithin (geometry, geometry, float8) CASCADE;
DROP FUNCTION intersects (geometry,geometry) CASCADE;
DROP FUNCTION crosses (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Crosses (geometry,geometry) CASCADE;
DROP FUNCTION ST_Crosses (geometry,geometry) CASCADE;
DROP FUNCTION within (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Within (geometry,geometry) CASCADE;
DROP FUNCTION ST_Within (geometry,geometry) CASCADE;
DROP FUNCTION contains (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Contains (geometry,geometry) CASCADE;
DROP FUNCTION ST_Contains (geometry,geometry) CASCADE;
DROP FUNCTION _ST_CoveredBy (geometry,geometry) CASCADE;
DROP FUNCTION ST_CoveredBy (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Covers (geometry,geometry) CASCADE;
DROP FUNCTION ST_Covers (geometry,geometry) CASCADE;
DROP FUNCTION overlaps (geometry,geometry) CASCADE;
DROP FUNCTION _ST_Overlaps (geometry,geometry) CASCADE;
DROP FUNCTION ST_Overlaps (geometry,geometry) CASCADE;
DROP FUNCTION IsValid (geometry) CASCADE;
DROP FUNCTION ST_IsValid (geometry) CASCADE;
DROP FUNCTION GEOSnoop (geometry) CASCADE;
DROP FUNCTION JTSnoop (geometry) CASCADE;
DROP FUNCTION Centroid (geometry) CASCADE;
DROP FUNCTION ST_Centroid (geometry) CASCADE;
DROP FUNCTION IsRing (geometry) CASCADE;
DROP FUNCTION ST_IsRing (geometry) CASCADE;
DROP FUNCTION PointOnSurface (geometry) CASCADE;
DROP FUNCTION ST_PointOnSurface (geometry) CASCADE;
DROP FUNCTION IsSimple (geometry) CASCADE;
DROP FUNCTION ST_IsSimple (geometry) CASCADE;
DROP FUNCTION Equals (geometry,geometry) CASCADE;
DROP FUNCTION ST_Equals (geometry,geometry) CASCADE;
DROP FUNCTION AsSVG (geometry,int4,int4) CASCADE;
DROP FUNCTION ST_AsSVG (geometry,int4,int4) CASCADE;
DROP FUNCTION AsSVG (geometry,int4) CASCADE;
DROP FUNCTION ST_AsSVG (geometry,int4) CASCADE;
DROP FUNCTION AsSVG (geometry) CASCADE;
DROP FUNCTION ST_AsSVG (geometry) CASCADE;
DROP FUNCTION AsGML (geometry, int4, int4) CASCADE;
DROP FUNCTION ST_AsGML (geometry, int4, int4) CASCADE;
DROP FUNCTION AsGML (geometry, int4) CASCADE;
DROP FUNCTION ST_AsGML (geometry, int4) CASCADE;
DROP FUNCTION AsGML (geometry) CASCADE;
DROP FUNCTION ST_AsGML (geometry) CASCADE;
DROP FUNCTION AsUKML (geometry, int4, int4) CASCADE;
DROP FUNCTION ST_AsUKML (geometry, int4, int4) CASCADE;
DROP FUNCTION AsUKML (geometry, int4) CASCADE;
DROP FUNCTION ST_AsUKML (geometry, int4) CASCADE;
DROP FUNCTION AsUKML (geometry) CASCADE;
DROP FUNCTION ST_AsUKML (geometry) CASCADE;
DROP FUNCTION AsKML (geometry, int4, int4) CASCADE;
DROP FUNCTION ST_AsKML (geometry, int4, int4) CASCADE;
DROP FUNCTION AsKML (geometry, int4) CASCADE;
DROP FUNCTION ST_AsKML (geometry, int4) CASCADE;
DROP FUNCTION AsKML (geometry) CASCADE;
DROP FUNCTION ST_AsKML (geometry) CASCADE;
DROP FUNCTION NumPoints (geometry) CASCADE;
DROP FUNCTION ST_NumPoints (geometry) CASCADE;
DROP FUNCTION NumGeometries (geometry) CASCADE;
DROP FUNCTION ST_NumGeometries (geometry) CASCADE;
DROP FUNCTION GeometryN (geometry,integer) CASCADE;
DROP FUNCTION ST_GeometryN (geometry,integer) CASCADE;
DROP FUNCTION Dimension (geometry) CASCADE;
DROP FUNCTION ST_Dimension (geometry) CASCADE;
DROP FUNCTION ExteriorRing (geometry) CASCADE;
DROP FUNCTION ST_ExteriorRing (geometry) CASCADE;
DROP FUNCTION NumInteriorRings (geometry) CASCADE;
DROP FUNCTION ST_NumInteriorRings (geometry) CASCADE;
DROP FUNCTION NumInteriorRing (geometry) CASCADE;
DROP FUNCTION ST_NumInteriorRing (geometry) CASCADE;
DROP FUNCTION InteriorRingN (geometry,integer) CASCADE;
DROP FUNCTION GeometryType (geometry) CASCADE;
DROP FUNCTION ST_GeometryType (geometry) CASCADE;
DROP FUNCTION PointN (geometry,integer) CASCADE;
DROP FUNCTION ST_PointN (geometry,integer) CASCADE;
DROP FUNCTION X (geometry) CASCADE;
DROP FUNCTION ST_X (geometry) CASCADE;
DROP FUNCTION Y (geometry) CASCADE;
DROP FUNCTION ST_Y (geometry) CASCADE;
DROP FUNCTION Z (geometry) CASCADE;
DROP FUNCTION SE_Z (geometry) CASCADE;
DROP FUNCTION ST_Z (geometry) CASCADE;
DROP FUNCTION M (geometry) CASCADE;
DROP FUNCTION ST_M (geometry) CASCADE;
DROP FUNCTION StartPoint (geometry) CASCADE;
DROP FUNCTION ST_StartPoint (geometry) CASCADE;
DROP FUNCTION EndPoint (geometry) CASCADE;
DROP FUNCTION ST_EndPoint (geometry) CASCADE;
DROP FUNCTION IsClosed (geometry) CASCADE;
DROP FUNCTION ST_IsClosed (geometry) CASCADE;
DROP FUNCTION IsEmpty (geometry) CASCADE;
DROP FUNCTION ST_IsEmpty (geometry) CASCADE;
DROP FUNCTION SRID (geometry) CASCADE;
DROP FUNCTION ST_SRID (geometry) CASCADE;
DROP FUNCTION SetSRID (geometry,int4) CASCADE;
DROP FUNCTION ST_SetSRID (geometry,int4) CASCADE;
DROP FUNCTION AsBinary (geometry) CASCADE;
DROP FUNCTION ST_AsBinary (geometry) CASCADE;
DROP FUNCTION AsBinary (geometry,text) CASCADE;
DROP FUNCTION ST_AsBinary (geometry,text) CASCADE;
DROP FUNCTION AsText (geometry) CASCADE;
DROP FUNCTION ST_AsText (geometry) CASCADE;
DROP FUNCTION GeometryFromText (text) CASCADE;
DROP FUNCTION ST_GeometryFromText (text) CASCADE;
DROP FUNCTION GeometryFromText (text, int4) CASCADE;
DROP FUNCTION ST_GeometryFromText (text, int4) CASCADE;
DROP FUNCTION GeomFromText (text) CASCADE;
DROP FUNCTION ST_GeomFromText (text) CASCADE;
DROP FUNCTION GeomFromText (text, int4) CASCADE;
DROP FUNCTION ST_GeomFromText (text, int4) CASCADE;
DROP FUNCTION PointFromText (text) CASCADE;
DROP FUNCTION ST_PointFromText (text) CASCADE;
DROP FUNCTION PointFromText (text, int4) CASCADE;
DROP FUNCTION ST_PointFromText (text, int4) CASCADE;
DROP FUNCTION LineFromText (text) CASCADE;
DROP FUNCTION ST_LineFromText (text) CASCADE;
DROP FUNCTION LineFromText (text, int4) CASCADE;
DROP FUNCTION ST_LineFromText (text, int4) CASCADE;
DROP FUNCTION LineStringFromText (text) CASCADE;
DROP FUNCTION LineStringFromText (text, int4) CASCADE;
DROP FUNCTION PolyFromText (text) CASCADE;
DROP FUNCTION ST_PolyFromText (text) CASCADE;
DROP FUNCTION PolyFromText (text, int4) CASCADE;
DROP FUNCTION ST_PolyFromText (text, int4) CASCADE;
DROP FUNCTION PolygonFromText (text, int4) CASCADE;
DROP FUNCTION ST_PolygonFromText (text, int4) CASCADE;
DROP FUNCTION PolygonFromText (text) CASCADE;
DROP FUNCTION ST_PolygonFromText (text) CASCADE;
DROP FUNCTION MLineFromText (text, int4) CASCADE;
DROP FUNCTION ST_MLineFromText (text, int4) CASCADE;
DROP FUNCTION MLineFromText (text) CASCADE;
DROP FUNCTION ST_MLineFromText (text) CASCADE;
DROP FUNCTION MultiLineStringFromText (text) CASCADE;
DROP FUNCTION ST_MultiLineStringFromText (text) CASCADE;
DROP FUNCTION MultiLineStringFromText (text, int4) CASCADE;
DROP FUNCTION ST_MultiLineStringFromText (text, int4) CASCADE;
DROP FUNCTION MPointFromText (text, int4) CASCADE;
DROP FUNCTION ST_MPointFromText (text, int4) CASCADE;
DROP FUNCTION MPointFromText (text) CASCADE;
DROP FUNCTION ST_MPointFromText (text) CASCADE;
DROP FUNCTION MultiPointFromText (text, int4) CASCADE;
DROP FUNCTION MultiPointFromText (text) CASCADE;
DROP FUNCTION ST_MultiPointFromText (text) CASCADE;
DROP FUNCTION MultiPointFromText (text) CASCADE;
DROP FUNCTION ST_MultiPointFromText (text) CASCADE;
DROP FUNCTION MPolyFromText (text, int4) CASCADE;
DROP FUNCTION ST_MPolyFromText (text, int4) CASCADE;
DROP FUNCTION MPolyFromText (text) CASCADE;
DROP FUNCTION ST_MPolyFromText (text) CASCADE;
DROP FUNCTION MultiPolygonFromText (text, int4) CASCADE;
DROP FUNCTION ST_MultiPolygonFromText (text, int4) CASCADE;
DROP FUNCTION MultiPolygonFromText (text) CASCADE;
DROP FUNCTION ST_MultiPolygonFromText (text) CASCADE;
DROP FUNCTION GeomCollFromText (text, int4) CASCADE;
DROP FUNCTION ST_GeomCollFromText (text, int4) CASCADE;
DROP FUNCTION GeomCollFromText (text) CASCADE;
DROP FUNCTION ST_GeomCollFromText (text) CASCADE;
DROP FUNCTION GeomFromWKB (bytea) CASCADE;
DROP FUNCTION ST_GeomFromWKB (bytea) CASCADE;
DROP FUNCTION GeomFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_GeomFromWKB (bytea, int) CASCADE;
DROP FUNCTION PointFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_PointFromWKB (bytea, int) CASCADE;
DROP FUNCTION PointFromWKB (bytea) CASCADE;
DROP FUNCTION ST_PointFromWKB (bytea) CASCADE;
DROP FUNCTION LineFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_LineFromWKB (bytea, int) CASCADE;
DROP FUNCTION LineFromWKB (bytea) CASCADE;
DROP FUNCTION ST_LineFromWKB (bytea) CASCADE;
DROP FUNCTION LinestringFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_LinestringFromWKB (bytea, int) CASCADE;
DROP FUNCTION LinestringFromWKB (bytea) CASCADE;
DROP FUNCTION ST_LinestringFromWKB (bytea) CASCADE;
DROP FUNCTION PolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_PolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION PolyFromWKB (bytea) CASCADE;
DROP FUNCTION ST_PolyFromWKB (bytea) CASCADE;
DROP FUNCTION PolygonFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_PolygonFromWKB (bytea, int) CASCADE;
DROP FUNCTION PolygonFromWKB (bytea) CASCADE;
DROP FUNCTION ST_PolygonFromWKB (bytea) CASCADE;
DROP FUNCTION MPointFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_MPointFromWKB (bytea, int) CASCADE;
DROP FUNCTION MPointFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MPointFromWKB (bytea) CASCADE;
DROP FUNCTION MultiPointFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_MultiPointFromWKB (bytea, int) CASCADE;
DROP FUNCTION MultiPointFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MultiPointFromWKB (bytea) CASCADE;
DROP FUNCTION MultiLineFromWKB (bytea, int) CASCADE;
DROP FUNCTION MultiLineFromWKB (bytea, int) CASCADE;
DROP FUNCTION MultiLineFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MultiLineFromWKB (bytea) CASCADE;
DROP FUNCTION MLineFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_MLineFromWKB (bytea, int) CASCADE;
DROP FUNCTION MLineFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MLineFromWKB (bytea) CASCADE;
DROP FUNCTION MPolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_MPolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION MPolyFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MPolyFromWKB (bytea) CASCADE;
DROP FUNCTION MultiPolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_MultiPolyFromWKB (bytea, int) CASCADE;
DROP FUNCTION MultiPolyFromWKB (bytea) CASCADE;
DROP FUNCTION ST_MultiPolyFromWKB (bytea) CASCADE;
DROP FUNCTION GeomCollFromWKB (bytea, int) CASCADE;
DROP FUNCTION ST_GeomCollFromWKB (bytea, int) CASCADE;
DROP FUNCTION GeomCollFromWKB (bytea) CASCADE;
DROP FUNCTION ST_GeomCollFromWKB (bytea) CASCADE;
DROP FUNCTION BdPolyFromText (text, integer) CASCADE;
DROP FUNCTION ST_BdPolyFromText (text, integer) CASCADE;
DROP FUNCTION BdMPolyFromText (text, integer) CASCADE;
DROP FUNCTION ST_BdMPolyFromText (text, integer) CASCADE;
DROP FUNCTION UnlockRows (text) CASCADE;
DROP FUNCTION LockRow (text, text, text, text, timestamp) CASCADE;
DROP FUNCTION LockRow (text, text, text, text) CASCADE;
DROP FUNCTION LockRow (text, text, text) CASCADE;
DROP FUNCTION LockRow (text, text, text, timestamp) CASCADE;
DROP FUNCTION AddAuth (text) CASCADE;
DROP FUNCTION CheckAuth (text, text, text) CASCADE;
DROP FUNCTION CheckAuth (text, text) CASCADE;
DROP FUNCTION CheckAuthTrigger () CASCADE;
DROP FUNCTION GetTransactionID () CASCADE;
DROP FUNCTION EnableLongTransactions () CASCADE;
DROP FUNCTION LongTransactionsEnabled () CASCADE;
DROP FUNCTION DisableLongTransactions () CASCADE;
DROP FUNCTION ST_WKTToSQL (text) CASCADE;
DROP FUNCTION ST_WKBToSQL (bytea) CASCADE;
DROP FUNCTION ST_CoordDim (geometry) CASCADE;
DROP FUNCTION ST_OrderingEquals (geometry, geometry) CASCADE;
DROP FUNCTION SE_Is3D (geometry) CASCADE;
DROP FUNCTION SE_IsMeasured (geometry) CASCADE;
DROP FUNCTION ST_Point (float8, float8) CASCADE;
DROP FUNCTION SE_Z (geometry) CASCADE;
DROP FUNCTION SE_M (geometry) CASCADE;
DROP FUNCTION ST_Polygon (geometry, int) CASCADE;
DROP FUNCTION SE_EnvelopesIntersect (geometry,geometry) CASCADE;
DROP FUNCTION SE_LocateAlong (geometry, float8) CASCADE;
DROP FUNCTION SE_LocateBetween (geometry, float8, float8) CASCADE;
DROP FUNCTION ST_CurveToLine (geometry, integer) CASCADE;
DROP FUNCTION ST_CurveToLine (geometry) CASCADE;
DROP FUNCTION ST_HasArc (geometry) CASCADE;
DROP FUNCTION ST_LineToCurve (geometry) CASCADE;
-- Drop all types.
DROP TYPE histogram2d CASCADE;
DROP TYPE spheroid CASCADE;
DROP TYPE geometry CASCADE;
DROP TYPE box3d CASCADE;
DROP TYPE chip CASCADE;
DROP TYPE box2d CASCADE;
DROP TYPE geometry_dump CASCADE;
-- Drop all tables.
DROP TABLE spatial_ref_sys;
DROP TABLE geometry_columns;

COMMIT;
