/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAccessible.idl
 */

#ifndef __gen_nsIAccessible_h__
#define __gen_nsIAccessible_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIDOMNode_h__
#include "nsIDOMNode.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIAccessible */
#define NS_IACCESSIBLE_IID_STR "b26fbe47-9a5f-42a1-822b-082461ae4d6d"

#define NS_IACCESSIBLE_IID \
  {0xb26fbe47, 0x9a5f, 0x42a1, \
    { 0x82, 0x2b, 0x08, 0x24, 0x61, 0xae, 0x4d, 0x6d }}

/**
 * A cross-platform interface that supports platform-specific 
 * accessibility APIs like MSAA and ATK. Contains the sum of what's needed
 * to support IAccessible as well as ATK's generic accessibility objects.
 * Can also be used by in-process accessibility clients to get information
 * about objects in the accessible tree. The accessible tree is a subset of 
 * nodes in the DOM tree -- such as documents, focusable elements and text.
 * Mozilla creates the implementations of nsIAccessible on demand.
 * See http://www.mozilla.org/projects/ui/accessibility for more information.
 *
 * @status UNDER_REVIEW
 */
class nsIAccessible : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IACCESSIBLE_IID)

  /**
   * Parent node in accessible tree.
   */
  /* readonly attribute nsIAccessible parent; */
  NS_IMETHOD GetParent(nsIAccessible * *aParent) = 0;

  /**
   * Next sibling in accessible tree
   */
  /* readonly attribute nsIAccessible nextSibling; */
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) = 0;

  /**
   * Previous sibling in accessible tree
   */
  /* readonly attribute nsIAccessible previousSibling; */
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) = 0;

  /**
   * First child in accessible tree
   */
  /* readonly attribute nsIAccessible firstChild; */
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) = 0;

  /**
   * Last child in accessible tree
   */
  /* readonly attribute nsIAccessible lastChild; */
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) = 0;

  /**
   * Number of accessible children
   */
  /* readonly attribute long childCount; */
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) = 0;

  /**
   * Accessible name -- the main text equivalent for this node
   */
  /* attribute AString name; */
  NS_IMETHOD GetName(nsAString & aName) = 0;
  NS_IMETHOD SetName(const nsAString & aName) = 0;

  /**
   * Accessible value -- a number or a secondary text equivalent for this node
   */
  /* readonly attribute AString value; */
  NS_IMETHOD GetValue(nsAString & aValue) = 0;

  /**
   * Accessible description -- long text associated with this node
   */
  /* readonly attribute AString description; */
  NS_IMETHOD GetDescription(nsAString & aDescription) = 0;

  /**
   * Provides localized string of accesskey name, such as Alt+D.
   * The modifier may be affected by user and platform preferences.
   * Usually alt+letter, or just the letter alone for menu items. 
   */
  /* readonly attribute AString keyboardShortcut; */
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) = 0;

  /**
   * Provides localized string of global keyboard accelerator, such
   * as Ctrl+O for Open file
   */
  /* readonly attribute AString keyBinding; */
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) = 0;

  /**
   * Enumerated accessible role. The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   */
  /* readonly attribute unsigned long role; */
  NS_IMETHOD GetRole(PRUint32 *aRole) = 0;

  /**
   * Accessible states -- bit field which describes boolean properties of node. 
   * See the STATE_* constants defined later in this file.
   */
  /* readonly attribute unsigned long state; */
  NS_IMETHOD GetState(PRUint32 *aState) = 0;

  /**
   * Extended accessible states -- second bit field describing node
   */
  /* readonly attribute unsigned long extState; */
  NS_IMETHOD GetExtState(PRUint32 *aExtState) = 0;

  /**
   * Help text associated with node
   */
  /* readonly attribute AString help; */
  NS_IMETHOD GetHelp(nsAString & aHelp) = 0;

  /**
   * Focused accessible child of node
   */
  /* readonly attribute nsIAccessible focusedChild; */
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) = 0;

  /**
   * Accessible child which contains the coordinate at x,y
   */
  /* nsIAccessible getChildAtPoint (in long x, in long y); */
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) = 0;

  /**
   * Nth accessible child using zero-based index
   */
  /* nsIAccessible getChildAt (in long aChildIndex); */
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically to the right of this one
   */
  /* nsIAccessible getAccessibleToRight (); */
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically to the left of this one
   */
  /* nsIAccessible getAccessibleToLeft (); */
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically above this one
   */
  /* nsIAccessible getAccessibleAbove (); */
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically below this one
   */
  /* nsIAccessible getAccessibleBelow (); */
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) = 0;

  /* void getBounds (out long x, out long y, out long width, out long height); */
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) = 0;

  /**
   * Add this accessible to the current selection
   */
  /* void addSelection (); */
  NS_IMETHOD AddSelection(void) = 0;

  /**
   * Remove this accessible from the current selection
   */
  /* void removeSelection (); */
  NS_IMETHOD RemoveSelection(void) = 0;

  /**
   * Extend the current selection from its current accessible anchor node
   * to this accessible
   */
  /* void extendSelection (); */
  NS_IMETHOD ExtendSelection(void) = 0;

  /**
   * Select this accessible node only
   */
  /* void takeSelection (); */
  NS_IMETHOD TakeSelection(void) = 0;

  /**
   * Focus this accessible node,
   * The state STATE_FOCUSABLE indicates whether this node is normally focusable.
   * It is the callers responsibility to determine whether this node is focusable.
   * accTakeFocus on a node that is not normally focusable (such as a table),
   * will still set focus on that node, although normally that will not be visually 
   * indicated in most style sheets.
   */
  /* void takeFocus (); */
  NS_IMETHOD TakeFocus(void) = 0;

  /**
   * The number of accessible actions associated with this accessible
   */
  /* readonly attribute PRUint8 numActions; */
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) = 0;

  /**
   * The name of the accessible action at the given zero-based index
   */
  /* AString getActionName (in PRUint8 index); */
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) = 0;

  /**
   * Perform the accessible action at the given zero-based index
   * Action number 0 is the default action
   */
  /* void doAction (in PRUint8 index); */
  NS_IMETHOD DoAction(PRUint8 index) = 0;

  /**
   * Get the DOM node described by this accessible node
   */
  /* nsIDOMNode getDOMNode (); */
  NS_IMETHOD GetDOMNode(nsIDOMNode **_retval) = 0;

  /**
   * Get a pointer to accessibility interface for this node, which is specific 
   * to the OS/accessibility toolkit we're running on.
   */
  /* [noscript] void getNativeInterface (out voidPtr aOutAccessible); */
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) = 0;

  /**
   * MSAA State flags - used for bitfield. More than 1 allowed.
   */
  enum { STATE_UNAVAILABLE = 1U };

  enum { STATE_SELECTED = 2U };

  enum { STATE_FOCUSED = 4U };

  enum { STATE_PRESSED = 8U };

  enum { STATE_CHECKED = 16U };

  enum { STATE_MIXED = 32U };

  enum { STATE_READONLY = 64U };

  enum { STATE_HOTTRACKED = 128U };

  enum { STATE_DEFAULT = 256U };

  enum { STATE_EXPANDED = 512U };

  enum { STATE_COLLAPSED = 1024U };

  enum { STATE_BUSY = 2048U };

  enum { STATE_FLOATING = 4096U };

  enum { STATE_MARQUEED = 8192U };

  enum { STATE_ANIMATED = 16384U };

  enum { STATE_INVISIBLE = 32768U };

  enum { STATE_OFFSCREEN = 65536U };

  enum { STATE_SIZEABLE = 131072U };

  enum { STATE_MOVEABLE = 262144U };

  enum { STATE_SELFVOICING = 524288U };

  enum { STATE_FOCUSABLE = 1048576U };

  enum { STATE_SELECTABLE = 2097152U };

  enum { STATE_LINKED = 4194304U };

  enum { STATE_TRAVERSED = 8388608U };

  enum { STATE_MULTISELECTABLE = 16777216U };

  enum { STATE_EXTSELECTABLE = 33554432U };

  enum { STATE_ALERT_LOW = 67108864U };

  enum { STATE_ALERT_MEDIUM = 134217728U };

  enum { STATE_ALERT_HIGH = 268435456U };

  enum { STATE_PROTECTED = 536870912U };

  enum { STATE_HASPOPUP = 1073741824U };

  /**
 * Extended state flags (for now non-MSAA, for Java and Gnome/ATK support)
 * This is only the states that there isn't already a mapping for in MSAA
 * See www.accessmozilla.org/article.php?sid=11 for information on the mappings between accessibility API states
 */
  enum { STATE_INVALID = 2097152U };

  enum { STATE_ACTIVE = 4194304U };

  enum { STATE_EXPANDABLE = 8388608U };

  enum { STATE_MODAL = 16777216U };

  enum { STATE_MULTI_LINE = 33554432U };

  enum { STATE_SENSITIVE = 67108864U };

  enum { STATE_RESIZABLE = 134217728U };

  enum { STATE_SHOWING = 268435456U };

  enum { STATE_SINGLE_LINE = 536870912U };

  enum { STATE_TRANSIENT = 1073741824U };

  enum { STATE_VERTICAL = 2147483648U };

#ifdef MOZ_ACCESSIBILITY_ATK
/**
 * The following nsIAccessible roles are translated to ATK_ROLE_UNKNOWN
 * 
 *  ROLE_TITLEBAR, ROLE_SOUND, ROLE_CURSOR, ROLE_CARET, ROLE_BORDER,
 *  ROLE_GROUPING, ROLE_EQUATION, ROLE_COLUMN, ROLE_ROW, ROLE_LINK,
 *  ROLE_WHITESPACE, ROLE_CLOCK,
 *  ROLE_IPADDRESS
 *
 *  ROLE_GRIP
 *    The object represents a special mouse pointer, which allows a user to
 *    manipulate user interface elements such as windows.
 *
 *  ROLE_HELPBALLOON
 *    The object displays a Help topic in the form of a ToolTip or Help balloon.
 *
 *  ROLE_PROPERTYPAGE
 *    The object represents a property sheet.
 *
 *  ROLE_INDICATOR
 *    The object represents an indicator, such as a pointer graphic pointing to
 *    the current item.
 *
 *  ROLE_HOTKEYFIELD
 *    The object represents a hot-key field that allow the user to enter a
 *    sequence of keystroke.
 *
 * The following ATK roles have no corresponding nsIAccessible roles. Perhaps
 * there are not these types of widget/control in Mozilla, so don't need these
 * ATK roles? Or need add some of them?
 *
 *   ATK_ROLE_ARROW
 *     An arrow in one of the four cardinal directions.
 *
 *   ATK_ROLE_INTERNAL_FRAME
 *     A frame-like object that is clipped by a desktop pane.
 * 
 *  ATK_ROLE_ACCEL_LABEL, ATK_ROLE_CANVAS, ATK_ROLE_CHECK_MENU_ITEM,
 *   ATK_ROLE_COLOR_CHOOSER, ATK_ROLE_DATE_EDITOR, ATK_ROLE_DESKTOP_ICON,
 *   ATK_ROLE_DESKTOP_FRAME, ATK_ROLE_DIRECTORY_PANE, ATK_ROLE_FILE_CHOOSER,
 *   ATK_ROLE_FILLER, ATK_ROLE_FONT_CHOOSER, ATK_ROLE_GLASS_PANE,
 *  ATK_ROLE_HTML_CONTAINER, ATK_ROLE_ICON, ATK_ROLE_LAYERED_PANE,
 *   ATK_ROLE_POPUP_MENU, ATK_ROLE_OPTION_PANE, ATK_ROLE_PASSWORD_TEXT,
 *  ATK_ROLE_RADIO_MENU_ITEM, ATK_ROLE_ROOT_PANE, ATK_ROLE_SCROLL_PANE,
 *  ATK_ROLE_SPLIT_PANE, ATK_ROLE_TEAR_OFF_MENU_ITEM, ATK_ROLE_TERMINAL,
 *  ATK_ROLE_TOGGLE_BUTTON, ATK_ROLE_TREE_TABLE, ATK_ROLE_VIEWPORT, ATK_ROLE_LABEL
 *
 * Important:
 * Following value should keep synchronization with the definitions in atk.h
 */
  enum { ROLE_TITLEBAR = 66U };    // ATK_ROLE_UNKNOWN
  enum { ROLE_MENUBAR = 33U };     // ATK_ROLE_MENU_BAR
  enum { ROLE_SCROLLBAR = 47U };   // ATK_ROLE_SCROLL_BAR
  enum { ROLE_GRIP = 66U };        // ATK_ROLE_UNKNOWN
  enum { ROLE_SOUND = 66U };       // ATK_ROLE_UNKNOWN
  enum { ROLE_CURSOR = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_CARET = 66U };       // ATK_ROLE_UNKNOWN
  enum { ROLE_ALERT = 2U };        // ATK_ROLE_ALERT
  enum { ROLE_WINDOW = 68U };      // ATK_ROLE_WINDOW
  // An object used for drawing custom user interface elements
  enum { ROLE_CLIENT = 18U };      // ATK_ROLE_DRAWING_AREA
  enum { ROLE_MENUPOPUP = 32U };   // ATK_ROLE_MENU
  enum { ROLE_MENUITEM = 34U };    // ATK_ROLE_MENU_ITEM
  enum { ROLE_TOOLTIP = 63U };     // ATK_ROLE_TOOL_TIP
  // The object represents a main window for a application
  enum { ROLE_APPLICATION = 73U }; // ATK_ROLE_APPLICATION
  // The object represents a document window, only for MDI windows
  enum { ROLE_DOCUMENT = 68U };    // ATK_ROLE_WINDOW
  enum { ROLE_PANE = 38U };        // ATK_ROLE_PANEL
  enum { ROLE_CHART = 26U };       // ATK_ROLE_IMAGE
  enum { ROLE_DIALOG = 16U };      // ATK_ROLE_DIALOG
  enum { ROLE_BORDER = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_GROUPING = 66U };    // ATK_ROLE_UNKNOWN
  enum { ROLE_SEPARATOR = 49U };   // ATK_ROLE_SEPARATOR
  enum { ROLE_TOOLBAR = 62U };     // ATK_ROLE_TOOL_BAR
  enum { ROLE_STATUSBAR = 53U };   // ATK_ROLE_STATUSBAR
  enum { ROLE_TABLE = 54U };       // ATK_ROLE_TABLE
  // Or ATK_ROLE_TABLE_COLUMN_HEADER?
  enum { ROLE_COLUMNHEADER = 10U };// ATK_ROLE_COLUMN_HEADER
  // Or ATK_ROLE_TABLE_ROW_HEADER ?
  enum { ROLE_ROWHEADER = 46U };   // ATK_ROLE_ROW_HEADER
  enum { ROLE_COLUMN = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_ROW = 66U };         // ATK_ROLE_UNKNOWN
  enum { ROLE_CELL = 55U };        // ATK_ROLE_TABLE_CELL
  enum { ROLE_LINK = 101U };        // ATK doesn't have such role now
  enum { ROLE_HELPBALLOON = 66U }; // ATK_ROLE_UNKNOWN
  // The object represents a cartoon-like graphic object
  enum { ROLE_CHARACTER = 26U };   // ATK_ROLE_IMAGE
  enum { ROLE_LIST = 30U };        // ATK_ROLE_LIST
  enum { ROLE_LISTITEM = 31U };    // ATK_ROLE_LIST_ITEM
  // The object represents an outline or tree structure
  enum { ROLE_OUTLINE = 64U };     // ATK_ROLE_TREE
  // The object represents an item in an outline or tree structure
  enum { ROLE_OUTLINEITEM = 31U }; // ATK_ROLE_LIST_ITEM
  enum { ROLE_PAGETAB = 36U };     // ATK_ROLE_PAGE_TAB
  enum { ROLE_PROPERTYPAGE = 66U };// ATK_ROLE_UNKNOWN
  enum { ROLE_INDICATOR = 66U };   // ATK_ROLE_UNKNOWN
  enum { ROLE_GRAPHIC = 26U };     // ATK_ROLE_IMAGE
  // Read-only text, can't be modified or selected
  enum { ROLE_STATICTEXT = 60U };  // ATK_ROLE_TEXT
  enum { ROLE_TEXT = 60U };        // ATK_ROLE_TEXT
  enum { ROLE_PUSHBUTTON = 42U };  // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_CHECKBUTTON = 7U };  // ATK_ROLE_CHECK_BOX
  enum { ROLE_RADIOBUTTON = 43U }; // ATK_ROLE_RADIO_BUTTON
  enum { ROLE_COMBOBOX = 11U };    // ATK_ROLE_COMBO_BOX
  // Just represents the calender control
  enum { ROLE_DROPLIST = 5U };     // ATK_ROLE_CALENDAR
  enum { ROLE_PROGRESSBAR = 41U }; // ATK_ROLE_PROGRESS_BAR
  enum { ROLE_DIAL = 15U };        // ATK_ROLE_DIAL
  enum { ROLE_HOTKEYFIELD = 66U }; // ATK_ROLE_UNKNOWN
  enum { ROLE_SLIDER = 50U };      // ATK_ROLE_SLIDER
  enum { ROLE_SPINBUTTON = 52U };  // ATK_ROLE_SPIN_BUTTON
  enum { ROLE_DIAGRAM = 26U };     // ATK_ROLE_IMAGE
  enum { ROLE_ANIMATION = 3U };    // ATK_ROLE_ANIMATION
  enum { ROLE_EQUATION = 66U };    // ATK_ROLE_UNKNOWN
  enum { ROLE_BUTTONDROPDOWN = 42U }; // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_BUTTONMENU = 42U };  // ATK_ROLE_PUSH_BUTTON
  // Represents a button that drops down a grid
  enum { ROLE_BUTTONDROPDOWNGRID = 66U }; // ATK_ROLE_UNKNOWN
  enum { ROLE_WHITESPACE = 66U };  // ATK_ROLE_UNKNOWN
  enum { ROLE_PAGETABLIST = 37U }; // ATK_ROLE_PAGE_TAB_LIST
  enum { ROLE_CLOCK = 66U };       // ATK_ROLE_UNKNOWN
  // Represents a button on the toolbar that has a drop-down list icon
  // directly adjacent to the button
  enum { ROLE_SPLITBUTTON = 42U }; // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_IPADDRESS = 66U };   // ATK_ROLE_UNKNOWN
  enum { ROLE_NOTHING = 0U };      // ATK_ROLE_INVALID
  // Represent top level window
  enum { ROLE_FRAME = 22U };               // ATK_ROLE_FRAME
#else
// MSAA Roles - only one per nsIAccessible or IAccessible
  enum { ROLE_TITLEBAR = 1U };
  enum { ROLE_MENUBAR = 2U };
  enum { ROLE_SCROLLBAR = 3U };
  enum { ROLE_GRIP = 4U };
  enum { ROLE_SOUND = 5U };
  enum { ROLE_CURSOR = 6U };
  enum { ROLE_CARET = 7U };
  enum { ROLE_ALERT = 8U };
  enum { ROLE_WINDOW = 9U };
  enum { ROLE_CLIENT = 10U };
  enum { ROLE_MENUPOPUP = 11U };
  enum { ROLE_MENUITEM = 12U };
  enum { ROLE_TOOLTIP = 13U };
  enum { ROLE_APPLICATION = 14U };
  enum { ROLE_DOCUMENT = 15U };
  enum { ROLE_PANE = 16U };
  enum { ROLE_CHART = 17U };
  enum { ROLE_DIALOG = 18U };
  enum { ROLE_BORDER = 19U };
  enum { ROLE_GROUPING = 20U };
  enum { ROLE_SEPARATOR = 21U };
  enum { ROLE_TOOLBAR = 22U };
  enum { ROLE_STATUSBAR = 23U };
  enum { ROLE_TABLE = 24U };
  enum { ROLE_COLUMNHEADER = 25U };
  enum { ROLE_ROWHEADER = 26U };
  enum { ROLE_COLUMN = 27U };
  enum { ROLE_ROW = 28U };
  enum { ROLE_CELL = 29U };
  enum { ROLE_LINK = 30U };
  enum { ROLE_HELPBALLOON = 31U };
  enum { ROLE_CHARACTER = 32U };
  enum { ROLE_LIST = 33U };
  enum { ROLE_LISTITEM = 34U };
  enum { ROLE_OUTLINE = 35U };
  enum { ROLE_OUTLINEITEM = 36U };
  enum { ROLE_PAGETAB = 37U };
  enum { ROLE_PROPERTYPAGE = 38U };
  enum { ROLE_INDICATOR = 39U };
  enum { ROLE_GRAPHIC = 40U };
  enum { ROLE_STATICTEXT = 41U };
  enum { ROLE_TEXT = 42U };
  enum { ROLE_PUSHBUTTON = 43U };
  enum { ROLE_CHECKBUTTON = 44U };
  enum { ROLE_RADIOBUTTON = 45U };
  enum { ROLE_COMBOBOX = 46U };
  enum { ROLE_DROPLIST = 47U };
  enum { ROLE_PROGRESSBAR = 48U };
  enum { ROLE_DIAL = 49U };
  enum { ROLE_HOTKEYFIELD = 50U };
  enum { ROLE_SLIDER = 51U };
  enum { ROLE_SPINBUTTON = 52U };
  enum { ROLE_DIAGRAM = 53U };
  enum { ROLE_ANIMATION = 54U };
  enum { ROLE_EQUATION = 55U };
  enum { ROLE_BUTTONDROPDOWN = 56U };
  enum { ROLE_BUTTONMENU = 57U };
  enum { ROLE_BUTTONDROPDOWNGRID = 58U };
  enum { ROLE_WHITESPACE = 59U };
  enum { ROLE_PAGETABLIST = 60U };
  enum { ROLE_CLOCK = 61U };
  enum { ROLE_SPLITBUTTON = 62U };
  enum { ROLE_IPADDRESS = 63U };
  enum { ROLE_NOTHING = 4294967295U };
#endif
};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIACCESSIBLE \
  NS_IMETHOD GetParent(nsIAccessible * *aParent); \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling); \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling); \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild); \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild); \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount); \
  NS_IMETHOD GetName(nsAString & aName); \
  NS_IMETHOD SetName(const nsAString & aName); \
  NS_IMETHOD GetValue(nsAString & aValue); \
  NS_IMETHOD GetDescription(nsAString & aDescription); \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut); \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding); \
  NS_IMETHOD GetRole(PRUint32 *aRole); \
  NS_IMETHOD GetState(PRUint32 *aState); \
  NS_IMETHOD GetExtState(PRUint32 *aExtState); \
  NS_IMETHOD GetHelp(nsAString & aHelp); \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild); \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval); \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval); \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height); \
  NS_IMETHOD AddSelection(void); \
  NS_IMETHOD RemoveSelection(void); \
  NS_IMETHOD ExtendSelection(void); \
  NS_IMETHOD TakeSelection(void); \
  NS_IMETHOD TakeFocus(void); \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions); \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval); \
  NS_IMETHOD DoAction(PRUint8 index); \
  NS_IMETHOD GetDOMNode(nsIDOMNode **_retval); \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIACCESSIBLE(_to) \
  NS_IMETHOD GetParent(nsIAccessible * *aParent) { return _to GetParent(aParent); } \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) { return _to GetNextSibling(aNextSibling); } \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) { return _to GetPreviousSibling(aPreviousSibling); } \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) { return _to GetFirstChild(aFirstChild); } \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) { return _to GetLastChild(aLastChild); } \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) { return _to GetChildCount(aChildCount); } \
  NS_IMETHOD GetName(nsAString & aName) { return _to GetName(aName); } \
  NS_IMETHOD SetName(const nsAString & aName) { return _to SetName(aName); } \
  NS_IMETHOD GetValue(nsAString & aValue) { return _to GetValue(aValue); } \
  NS_IMETHOD GetDescription(nsAString & aDescription) { return _to GetDescription(aDescription); } \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) { return _to GetKeyboardShortcut(aKeyboardShortcut); } \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) { return _to GetKeyBinding(aKeyBinding); } \
  NS_IMETHOD GetRole(PRUint32 *aRole) { return _to GetRole(aRole); } \
  NS_IMETHOD GetState(PRUint32 *aState) { return _to GetState(aState); } \
  NS_IMETHOD GetExtState(PRUint32 *aExtState) { return _to GetExtState(aExtState); } \
  NS_IMETHOD GetHelp(nsAString & aHelp) { return _to GetHelp(aHelp); } \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) { return _to GetFocusedChild(aFocusedChild); } \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) { return _to GetChildAtPoint(x, y, _retval); } \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) { return _to GetChildAt(aChildIndex, _retval); } \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) { return _to GetAccessibleToRight(_retval); } \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) { return _to GetAccessibleToLeft(_retval); } \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) { return _to GetAccessibleAbove(_retval); } \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) { return _to GetAccessibleBelow(_retval); } \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return _to GetBounds(x, y, width, height); } \
  NS_IMETHOD AddSelection(void) { return _to AddSelection(); } \
  NS_IMETHOD RemoveSelection(void) { return _to RemoveSelection(); } \
  NS_IMETHOD ExtendSelection(void) { return _to ExtendSelection(); } \
  NS_IMETHOD TakeSelection(void) { return _to TakeSelection(); } \
  NS_IMETHOD TakeFocus(void) { return _to TakeFocus(); } \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) { return _to GetNumActions(aNumActions); } \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) { return _to GetActionName(index, _retval); } \
  NS_IMETHOD DoAction(PRUint8 index) { return _to DoAction(index); } \
  NS_IMETHOD GetDOMNode(nsIDOMNode **_retval) { return _to GetDOMNode(_retval); } \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) { return _to GetNativeInterface(aOutAccessible); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIACCESSIBLE(_to) \
  NS_IMETHOD GetParent(nsIAccessible * *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNextSibling(aNextSibling); } \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPreviousSibling(aPreviousSibling); } \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstChild(aFirstChild); } \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastChild(aLastChild); } \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildCount(aChildCount); } \
  NS_IMETHOD GetName(nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD SetName(const nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(aName); } \
  NS_IMETHOD GetValue(nsAString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValue(aValue); } \
  NS_IMETHOD GetDescription(nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyboardShortcut(aKeyboardShortcut); } \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyBinding(aKeyBinding); } \
  NS_IMETHOD GetRole(PRUint32 *aRole) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRole(aRole); } \
  NS_IMETHOD GetState(PRUint32 *aState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetState(aState); } \
  NS_IMETHOD GetExtState(PRUint32 *aExtState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExtState(aExtState); } \
  NS_IMETHOD GetHelp(nsAString & aHelp) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHelp(aHelp); } \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFocusedChild(aFocusedChild); } \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildAtPoint(x, y, _retval); } \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildAt(aChildIndex, _retval); } \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleToRight(_retval); } \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleToLeft(_retval); } \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleAbove(_retval); } \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleBelow(_retval); } \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBounds(x, y, width, height); } \
  NS_IMETHOD AddSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSelection(); } \
  NS_IMETHOD RemoveSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveSelection(); } \
  NS_IMETHOD ExtendSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtendSelection(); } \
  NS_IMETHOD TakeSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->TakeSelection(); } \
  NS_IMETHOD TakeFocus(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->TakeFocus(); } \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumActions(aNumActions); } \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActionName(index, _retval); } \
  NS_IMETHOD DoAction(PRUint8 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoAction(index); } \
  NS_IMETHOD GetDOMNode(nsIDOMNode **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDOMNode(_retval); } \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNativeInterface(aOutAccessible); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAccessible : public nsIAccessible
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIACCESSIBLE

  nsAccessible();

private:
  ~nsAccessible();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAccessible, nsIAccessible)

nsAccessible::nsAccessible()
{
  /* member initializers and constructor code */
}

nsAccessible::~nsAccessible()
{
  /* destructor code */
}

/* readonly attribute nsIAccessible parent; */
NS_IMETHODIMP nsAccessible::GetParent(nsIAccessible * *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible nextSibling; */
NS_IMETHODIMP nsAccessible::GetNextSibling(nsIAccessible * *aNextSibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible previousSibling; */
NS_IMETHODIMP nsAccessible::GetPreviousSibling(nsIAccessible * *aPreviousSibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible firstChild; */
NS_IMETHODIMP nsAccessible::GetFirstChild(nsIAccessible * *aFirstChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible lastChild; */
NS_IMETHODIMP nsAccessible::GetLastChild(nsIAccessible * *aLastChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long childCount; */
NS_IMETHODIMP nsAccessible::GetChildCount(PRInt32 *aChildCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString name; */
NS_IMETHODIMP nsAccessible::GetName(nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAccessible::SetName(const nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString value; */
NS_IMETHODIMP nsAccessible::GetValue(nsAString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString description; */
NS_IMETHODIMP nsAccessible::GetDescription(nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString keyboardShortcut; */
NS_IMETHODIMP nsAccessible::GetKeyboardShortcut(nsAString & aKeyboardShortcut)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString keyBinding; */
NS_IMETHODIMP nsAccessible::GetKeyBinding(nsAString & aKeyBinding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long role; */
NS_IMETHODIMP nsAccessible::GetRole(PRUint32 *aRole)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long state; */
NS_IMETHODIMP nsAccessible::GetState(PRUint32 *aState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long extState; */
NS_IMETHODIMP nsAccessible::GetExtState(PRUint32 *aExtState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString help; */
NS_IMETHODIMP nsAccessible::GetHelp(nsAString & aHelp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible focusedChild; */
NS_IMETHODIMP nsAccessible::GetFocusedChild(nsIAccessible * *aFocusedChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getChildAtPoint (in long x, in long y); */
NS_IMETHODIMP nsAccessible::GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getChildAt (in long aChildIndex); */
NS_IMETHODIMP nsAccessible::GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleToRight (); */
NS_IMETHODIMP nsAccessible::GetAccessibleToRight(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleToLeft (); */
NS_IMETHODIMP nsAccessible::GetAccessibleToLeft(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleAbove (); */
NS_IMETHODIMP nsAccessible::GetAccessibleAbove(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleBelow (); */
NS_IMETHODIMP nsAccessible::GetAccessibleBelow(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getBounds (out long x, out long y, out long width, out long height); */
NS_IMETHODIMP nsAccessible::GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addSelection (); */
NS_IMETHODIMP nsAccessible::AddSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeSelection (); */
NS_IMETHODIMP nsAccessible::RemoveSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void extendSelection (); */
NS_IMETHODIMP nsAccessible::ExtendSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void takeSelection (); */
NS_IMETHODIMP nsAccessible::TakeSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void takeFocus (); */
NS_IMETHODIMP nsAccessible::TakeFocus()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRUint8 numActions; */
NS_IMETHODIMP nsAccessible::GetNumActions(PRUint8 *aNumActions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getActionName (in PRUint8 index); */
NS_IMETHODIMP nsAccessible::GetActionName(PRUint8 index, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doAction (in PRUint8 index); */
NS_IMETHODIMP nsAccessible::DoAction(PRUint8 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode getDOMNode (); */
NS_IMETHODIMP nsAccessible::GetDOMNode(nsIDOMNode **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void getNativeInterface (out voidPtr aOutAccessible); */
NS_IMETHODIMP nsAccessible::GetNativeInterface(void * *aOutAccessible)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAccessible_h__ */
