# image1.tcl --
#
# This demonstration script displays two image widgets.
#
# RCS: @(#) $Id: image1.tcl,v 1.1 1999/03/31 15:08:33 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .image1
catch {destroy $w}
toplevel $w
wm title $w "Image Demonstration #1"
wm iconname $w "Image1"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"This demonstration displays two images, each in a separate label widget." \
"$B$3$N%G%b$G$O(B 2 $B$D$N%i%Y%k>e$K2hA|$r$=$l$>$lI=<($7$F$$$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

catch {image delete image1a}
image create photo image1a -file [file join $tk_library demos.jp images earth.gif]
label $w.l1 -image image1a -bd 1 -relief sunken

catch {image delete image1b}
image create photo image1b \
  -file [file join $tk_library demos.jp images earthris.gif]
label $w.l2 -image image1b -bd 1 -relief sunken

pack $w.l1 $w.l2 -side top -padx .5m -pady .5m
