(defvar title "̾Ƚ    for NEmacs/Mule. (C) yoshinov@etl.go.jp")
(defvar version "ver 2.0 (1995.3)")
(defvar patches1 "add seimei-region by akiba@aa.cs.keio.ac.jp")
(defvar patches2 "for mule version by yoichi@esasd.ksp.fujixerox.co.jp")
(defvar patches3 "for ne/mu version by ksakai@mtl.t.u-tokyo.ac.jp")
(defvar original "̾Ƚ version 1.02 Copyright(C) 1991 S.Ameno, Ϲ")
;;
;; ̾Ƚ for NEmacs/Mule version. by yoshinov@etl.go.jp
;;
;; 1. How to setup....(ˡ)
;;     ʤ.emacs˰ʲΰԤƤ
;; (autoload 'seimei "seimei" "seimei" t)
;; load-pathǸǤǥ쥯ȥseimei.elƤ
;;
;; 2. How to use......(ˡ) λ̤Ǥ
;; a)
;;    M-x seimei
;; b)
;;    ̾δ֤˶򤢤ƽ񤭡regionꤷƤ
;;    M-x seimei-region
;;
;;    seimei.elɤ߹Ǥ.emacs
;;    (autoload 'seimei-region "seimei" "seimei" t)
;;    Ƚ񤭹ǤɬפޤϷ̿ʤ:-)
;; c)
;;    ̾δ֤˶򤢤ưԤ˰ͤŤĽ񤭤ޤ쥷ϥ
;;    M-x seimei-buffer
;;
;;    seimei.elɤ߹Ǥ.emacs
;;    (autoload 'seimei-buffer "seimei" "seimei" t)
;;    Ƚ񤭹ǤɬפޤƤӡϷ̿ʤ:-)
;;
;; 3. Bugs and other info.
;;   seimei.c Ȥϡη׻٤ۤʤޤelưϡ(;_;)
;;   ʸ80ʾ̾1ޤ
;;   bufferϡλˤkill-bufferޤ(for )
;;   byte-compileseimei.elcmuleꤢ뤤nemacsˤʤޤΤǡ
;;   mulenemacs¸Ƥϸαղ(by yoichi)
;;
;; 3.1 ̾ȽǤˤήɤ뤱ɡġ
;;
;;   βοΤήɤˤäưۤʤ褦Ǥޤήɤε
;;   ̤ήɤ綧ˤʤäꤹ褦ǤŷƱؤդ⡢ۥ
;;   󥹤⡢޹Ԥ⡢ʤȤȤǡ˵ˤƤͤܤ
;;   ɤߤˤʤ뤫˸ĺȤ򤪴ᤷޤܥץ
;;   ϾβˤΤǤ
;;
;;   ̾͡Ƚ硡ʥĥҡߡΣߡ
;;
;;   ---- ʲϹκ줿seimei.docžܤǤ ---
;;   ʤɽåԤǤ뾮Ϣ
;;   ΤȤǤ(ܿͤδ˾ˤƤޤ)
;;   ջĮ1950-10  240-01    0468-75-2933
;;   -------------------------------------------------------------
;;
;;   ʤβ˴ؤƤϸ漫ȤǼľ뤳Ȥޤseimei.el
;;   θȾʬϲˤʤäƤޤѲ뤴Ȥ\n
;;   ˤʤäƤޤǤ顢㤨defaultǣΡָޡפ򣵲ѹ
;;   ȤȤǤС\nҤȤıۤȤ˰ưФ褤櫓
;;   Ǥ
;;
;; 3.2 ʸŷȳġ
;;   ver 1.03em ꡢ˼٤εפޤΤŷȳϲޤ̡
;;
;;   顼ФˤϤΤ餻

(defvar Seimei-Buffer "*̾Ƚ*" "Buffer name for ̾Ƚ")
(defvar Seimei-Kanji-Kakusuu-Dic-Buffer " **"
  "Buffer name for *")
(defvar Float-Buffer " *ư黻*"
  "Buffer name for ư黻*")
(defvar Seimei-TMPBUFFER " *SEIMEI-tmpbuf*"
  "Buffer name for ʸĹ׻*")
(defvar seimei-char-width (length "") "ܸʸ礭")
(defconst seimei-erase-buffer t "̾ȽǤη̤õˤt")

;;;###autoload
(defun seimei-buffer ()
  (interactive)
  (save-excursion
    (let ((cbuf (current-buffer))
	  (seimei-erase-buffer nil))
      (set-buffer (get-buffer-create Seimei-Buffer))
      (erase-buffer)
      (insert (format "%s\n\t\t\t\t\t%s\n" title version))
      (set-buffer cbuf)
      (goto-char (point-min))
      (while (re-search-forward "^[^ ]* [^ \n]*$" nil t)
	(seimei-region (match-beginning 0) (match-end 0))))))

;;;###autoload
(defun seimei-region (start end)
  (interactive "r")
  (save-excursion
    (goto-char start)
    (if (search-forward " " end t)
	(seimei (buffer-substring start (match-beginning 0))
		(buffer-substring (match-end 0) end))
      (error "Please Set Region on @<SPC>̾@"))))

;;;###autoload
(defun seimei (sei mei)
  "̾ȽǤԤޤ"
  (interactive "S̾Ƚ:פɤ>\nSˡ̾פɤ>")
  (setup-dic) ;Хåե
;  (my-debugger-setup)
  (catch 'globaltag nil
	 (let ((res (get-buffer-create Seimei-Buffer))
	       (dic (get-buffer Seimei-Kanji-Kakusuu-Dic-Buffer))
	       (seimeilist nil)(seimeilen nil)(seimeikaku nil)(tmpkaku nil)
	       (tmp 0)(point0 0)(point1 0)(point2 0)(point3 0)(point4 0)
	       (orgtmp 0)(smsum 0)(slc 0)(lc 0))
	   (setq seimeilist (list (format "%s" sei) (format "%s" mei)))
	   (setq seimeilen (list (strlen sei) (strlen mei)))
	   (set-buffer dic)
	   (while (< slc 2) ;̾2롼פ롣
	     (while (not (eq (car seimeilen) lc))
	       (goto-char (point-min))
	       (if (search-forward
		    (substring (car seimeilist) lc
			       (+ lc seimei-char-width)) (point-max) t)
		   (setq tmpkaku (append tmpkaku
					 (list (count-lines (point-min)
							    (point)))))
		 (progn
		   (seimei-sorry-poor-dic sei mei
		    (substring (car seimeilist) lc (+ lc seimei-char-width)))
		   (throw 'globaltag nil)))
	       (setq lc (+ lc seimei-char-width)))
	     (setq seimeilist (cdr seimeilist));̾򥻥åȡ
	     (setq seimeilen (cdr seimeilen)) ;̾(Ĺ)򥻥åȡ
	     (setq seimeikaku (append seimeikaku (list tmpkaku)))
	     (setq tmpkaku nil)
	     (setq lc 0)
	     (setq slc (1+ slc)))
	   (setq smsum ;פ̾פꥹȤ˳Ǽ
		 (list (addcell (car seimeikaku))
		       (addcell (car (cdr seimeikaku)))))
	   
	   (setup-float-buffer)
	   
	   (set-buffer res)
	   (if seimei-erase-buffer
	       (progn
		 (erase-buffer)
		 (insert (format "%s\n\t\t\t\t\t%s\n" title version)))
	     (insert "\n"))
	   (insert (format "***** %s %s *****\n" sei mei))
	   (setq tmp (+ (car smsum)(car (cdr smsum))))
	   (setq orgtmp tmp)
	   (while (< 80 tmp) (setq tmp (- tmp 80)))
	   (setq point0 (car (cdr (nth tmp unsei))))
	   (insert (format " %2d   \t %s\n" orgtmp (car (nth tmp unsei))))
	   (setq tmp (car smsum))
	   (setq orgtmp tmp)
	   (while (< 80 tmp) (setq tmp (- tmp 80)))
	   (setq point1 (car (cdr (nth tmp unsei))))
	   (insert (format "ŷ %2d ı\t %s\n" orgtmp (car (nth tmp unsei))))
	   (setq tmp (car (cdr smsum)))
	   (setq orgtmp tmp)
	   (while (< 80 tmp) (setq tmp (- tmp 80)))
	   (setq point2 (car (cdr (nth tmp unsei))))
	   (insert (format "ϱ %2d   \t %s\n" orgtmp (car (nth tmp unsei))))
	   (setq tmp (+ (car (reverse (car seimeikaku)))(car (car (cdr seimeikaku)))))
	   (setq orgtmp tmp)
	   (while (< 80 tmp) (setq tmp (- tmp 80)))
	   (setq point3 (car (cdr (nth tmp unsei))))
	   (insert (format "ͱ %2d Ҳ\t %s\n" orgtmp (car (nth tmp unsei))))
	   (setq tmp (+ (if (null (cdr (reverse (car seimeikaku))))
			    (car (car seimeikaku))
			  (addcell (cdr (reverse (car seimeikaku)))))
			(if (null (cdr (car (cdr seimeikaku))))
			    (car (car (cdr seimeikaku)))
			  (addcell (cdr (car (cdr seimeikaku)))))))
	   (setq orgtmp tmp)
	   (while (< 80 tmp) (setq tmp (- tmp 80)))
	   (setq point4 (car (cdr (nth tmp unsei))))
	   (insert (format " %2d Ķ\t %s\n" orgtmp (car (nth tmp unsei))))
	   (insert (format "+ͱ "))
	   (insert-power (* point0 point3) Pow1/2-7)
	   (insert (format "  ŷ+ϱ+ "))
					;    (debugger-insert (format "1 %s 2 %s 4 %s = %s" point1 point2 point4 (* (* point1 point2) point4) ))
	   (insert-power (* (* point1 point2) point4) Pow1/3-3)
	   (insert (format "   " ))
	   (insert-float-add)
	   (display-buffer res)
;	   (delete-other-windows (selected-window))
;	   (set-window-buffer (split-window (selected-window)) res)
	   (seimei-fin))))

(defun insert-float-add ()
  (let ((afbuf (get-buffer Float-Buffer))
	(cbuf (current-buffer))(tmp 0)(upper 0)(lower 0))
    (set-buffer afbuf)
    (goto-char (point-min))
    (if (> (string-to-int emacs-version) 18)
	(progn
	  (set-buffer cbuf)
	  (setq tmp (number-to-string (+ (read afbuf) (read afbuf))))
	  (string-match "[^\\.]*\\.." tmp)
	  (insert (substring tmp (match-beginning 0) (match-end 0))))
      (setq tmp (read afbuf))
      (forward-line 1)
      (setq upper (+ tmp (read afbuf)))
      (goto-char (point-min))
      (read afbuf)
      (setq tmp (read afbuf))
      (read afbuf)
      (setq lower (+ tmp (read afbuf)))
      (if (< 9 lower)
	  (progn
	    (setq upper (1+ upper))
	    (setq lower (- lower 10))))
      (set-buffer cbuf)
      (insert (format "%s.%s\n" upper lower)))))

(defun setup-float-buffer ()
  (save-excursion
    (let ((tmp (get-buffer-create Float-Buffer)))
      (set-buffer tmp)
      (erase-buffer))))

(defun insert-power (num var)
  "var = Pow1/2-7 : sqrt(num) * 0.7Ȥ黻η̤CХåե˽ϡ
   var = Pow1/3-3 : pow(num, 1/3) * 0.3Ȥ黻η̤CХåե˽ϡ
   ˡûХåեˤϤ롣"
  (interactive "P")
  (let ((afbuf (get-buffer-create Float-Buffer))
	(flag t))
    (while flag
      (if (eq (car var) nil)
	  (setq flag nil)
	(if (eq (car (car var)) num)
	    (progn
	      (insert (format "%s" (car (cdr (car var)))))
	      (insert-string-to-buffer afbuf
				       (format "%s\n" (car (cdr (car var)))))
	      (setq flag nil))
	  (setq var (cdr var)))))))

(defun insert-string-to-buffer (buf str)
  (interactive "P")
  (save-excursion
    (set-buffer buf)
    (insert str)))

(defun addcell (lst)
  "lstͿ줿ꥹȤǤƹפޤ"
  (let ((tmp 0))
    (mapcar (function (lambda (n) (setq tmp (+ tmp n)))) lst)
    tmp))

(defun seimei-sorry-poor-dic (sei mei notfound)
  (let ((res (get-buffer Seimei-Buffer)))
    (set-buffer res)
    (erase-buffer)
    (insert (format "%s\n\t\t\t\t\t%s\n" title version))
    (insert (format "***** %s %s *****\n\n" sei mei))
    (insert (format "۹ʸ%sפޤ̾ȽǤͤޤġ餺\n" notfound))
    (delete-other-windows (selected-window))
    (set-window-buffer (split-window (selected-window)) res)))

(defun seimei-fin ()
  (let ((tmp (get-buffer Seimei-TMPBUFFER))
	(afc (get-buffer Float-Buffer)))
    (kill-buffer tmp)
    (kill-buffer afc)))

(defun seimei-quit ()
  (let ((res (get-buffer Seimei-Buffer))
	(dic (get-buffer Seimei-Kanji-Kakusuu-Dic-Buffer))
	(dbg))
    (seimei-fin)
    (kill-buffer res)
    (kill-buffer dic)
    (if (get-buffer "*debugger*")
	(kill-buffer (get-buffer "*debugger*")))))

(defun no-error-forward-char (num)
  (if (not (= (point) (point-max)))
      (forward-char num)))

(defun setup-dic ()
  "ꤷޤƱ̾ΥХåեˤϺѤޤ"
  (if (not (get-buffer Seimei-Kanji-Kakusuu-Dic-Buffer))
      (let ((dic (get-buffer-create Seimei-Kanji-Kakusuu-Dic-Buffer))
	    (sklist Seimei-Kaku-list))
	(set-buffer dic)
	(while sklist
	  (insert (format "%s" (car sklist)))
	  (setq sklist (cdr sklist)))
	(setq buffer-read-only t))))

(defun strlen (str)
  "ʸĹޤ"
  (interactive "P")
  (save-excursion
    (let ((tmpbuf (get-buffer-create Seimei-TMPBUFFER)))
      (set-buffer tmpbuf)
      (erase-buffer)
      (insert (format "%s" str))
      (1- (point-max)))))

;(defun new-get-buffer-create (buf)
;  "Ʊ̾ΥХåեȤˤϡäƤľޤ"
;  (interactive "P")
;  (if (not (eq (get-buffer buf) nil))
;      (kill-buffer buf))
;  (get-buffer-create buf))

(defun my-debugger-setup ()
  "ʬǤĤʡȤϡġ"
  (save-excursion
    (let ((tmp (get-buffer-create "*debugger*")))
      (set-buffer tmp)
      (erase-buffer))))

(defun debugger-insert (str)
  "ʸˤȤäơ*debugger* buffer˽񤭽Ф"
  (interactive "P")
  (save-excursion
    (let ((debugger (get-buffer "*debugger*")))
      (set-buffer debugger)
      (insert str))))

(defvar Pow1/2-7 '( (25 "3.5") (50 "5.0") (100 "7.0")
		   (200 "9.9") (400 "14.0") (500 "15.7")
		   (800 "19.8") (1000 "22.1") (1600 "28.0")
		   (3200 "39.6") (4000 "44.3") (6400 "56.0")
		   (8000 "62.6") (10000 "70.0")))

(defvar Pow1/3-3 '( (125 "1.5") (250 "1.9") (500 "2.4")
		  (1000 "3.0") (2000 "3.8") (2500 "4.1")
		  (4000 "4.8") (5000 "5.1") (8000 "6.0")
		  (10000 "6.5") (16000 "7.6") (20000 "8.1")
		  (32000 "9.5") (40000 "10.3") (50000 "11.1")
		  (64000 "12.0") (80000 "12.9") (100000 "13.9")
		  (128000 "15.1") (160000 "16.3") (256000 "19.0")
		  (320000 "20.5") (400000 "22.1") (512000 "24.0")
		  (640000 "25.9") (800000 "27.8") (1000000 "30.0")))

(defvar unsei '(
	("" 100)
	("Τȿ" 80)
	("Υ򤷤붧" 10)
	("Ĵ¤Ȱεȿ" 80)
	("Ǥο򾷤" 10)
	("ѹդȿ" 80)
	("äߤȿ" 80)
	("ͦԤεȿ" 80)
	("ǦѤȯŸȿ" 80)
	("ԶȸȤż붧" 10)
	("٤Ƥ˵綧" 5)
	("ޤĹ뤲ȿ" 80)
	("ջǺޤ붧" 10)
	("ǽ˷äޤ줿ȿ" 80)
	("ϫ¿󱿤ζ" 10)
	("塹ȯŸȿ" 80)
	("äޤ줿ȿ" 80)
	("䵣ǵΤȿ" 80)
	("ΤȹưϤ٤ȿ" 80)
	("̤˽Ⱦȿ" 40)
	("þȸɽζ" 10)
	("Ωȸ̾εȿ" 80)
	("̵ϴǺޤ붧" 10)
	("īεȿ" 80)
	("ͤʪ˷äޤȿ" 100)
	("˲᤮»Ⱦȿ" 40)
	("ȰѤζ" 10)
	("Ա򾷤Ⱦȿ" 40)
	("ѿʹ񱿤綧" 5)
	("ɤҤȾȿ" 40)
	("Ⱦȿ" 40)
	("¤Ĥȿ" 100)
	("ճʹ˷äޤȿ" 80)
	("Ԥʤդȿ" 100)
	("Ǻˤ綧" 5)
	("٤ȿ" 80)
	("̵ŤҤ򾷤" 10)
	("١ľʵȿ" 80)
	("ݤ˽Ǥȿ" 80)
	("ɲڤ򤭤ȿ" 100)
	("ŨĤȾȿ" 40)
	("бȿ" 80)
	("ǽʤȾȿ" 40)
	("Ɀ˸ΥȾȿ" 40)
	("դǤΤᤵ붧" 10)
	("Ǥȿ" 80)
	("ŤȾȿ" 40)
	("ǰ꤬ȿ" 80)
	("Τȿ" 80)
	("η㤷Ⱦȿ" 40)
	("Ĺ³ʤȾȿ" 40)
	("ȶȴ֤⤫Ⱦȿ" 40)
	("ɸŪͻߤȿ" 100)
	("ɤ˶줷Ⱦȿ" 40)
	("³Ỵ綧" 5)
	("üˤϤ䤹Ⱦȿ" 40)
	("դ̵Ϥζ" 5)
	("˾θȿ" 80)
	("Ǻθ˹ʡԤĵȿ" 80)
	("Ϥμ夵̤붧" 10)
	("ŰǤ԰¤勞" 10)
	("򼫲ȯŸȿ" 80)
	("ײݤˤʤ꤬Ⱦȿ" 40)
	("ĴȯŸȿ" 100)
	("򤿤ɤ붧" 10)
	("Фεȿ" 100)
	("˾Ĥ붧" 10)
	("᤹ȿ" 80)
	("Ϥɬȿ" 80)
	("˳ڤζ" 10)
	("Ǥ˸綧" 5)
	("ʿޤǦȾȿ" 40)
	("μ¤˷礱Ⱦȿ" 40)
	("ǯ˱ɤȿ" 80)
	("Ĥʿ붧" 10)
	("ʿ̵ʵȿ" 80)
	("θжʶ" 10)
	("ŤȾȿ" 40)
	("ĶήȾȿ" 40)
	("ޤΤʤ" 10)
	("̵١ζ" 10)
	("Ƕˡȿ" 100)))

(defvar Seimei-Kaku-list '(
	"ĤΤإΥեإá첵ЦШЭ\n"
	"ƤȤҤ󥢥ȥʥ˥̥ϥҥޥ"
	"ڥץڤ塷強ǵȬλЩеѹ"
	"ұҸҹҾ\n"
	"ˤ̤ߤ復ĥƥ"
	"򤰤Ť٤ԥ֥٥ѥԤä硹ݵ׵ڵݶҸ"
	"ͻλҼ۽Ƿ˴̦ͼͿФвѺ"
	"֥׮װ׵\n"
	"ͤϤդޤͥۤǤɤӥɥХӤ߲"
	"в𴢵صԶ͸޸߸ٻ߻ܼ꽺"
	"οѿðĤŷȿɤʩʬʸ˳"
	"ͧͽϻСТжклмно֦׷٩ڽھ۩"
	"\n"
	"ʤۤ¤Ѥץ¥ťǥݥʱʱòĲӳ"
	"𴤴ŵ̶ֵ緻긼øŸùŻƻʻ˻"
	"Լ̼н辤¾áöģ"
	"Ⱦɥɬɹʦʧʺʿ̷̤̱"
	"ͳΩУХЧбпҲԩ"
	"֧۲\n"
	"Ф֤ݥܰ°˰аȱ󳥳ƴ̴"
	"ȵɵٵ۵ⶤĶʷ͹Թ纡"
	"ƺ߻ݻǼ뽣Ƚܽ侢翧Կ"
	"¸¿éƱ"
	"ǡǤǯȩȲɴ˻̶̾ͭξϷϾ"
	"ҳԪԫաբ֨٪٫٬٭ٮڿ۳۴۵"
	"۶۷\n"
	"ܰɰ̰ϰֲѴδ޴"
	"ɶѶܶϷݷ޷踫㹣"
	"ҺǻֻڻҼּݼ޼Ӿ"
	"ÿĿȿɿ޿¨«­¼âäëĮ"
	"ƦǢǥǦȴȼȽɪ"
	"ʭʱʼ˧ˮ˷˸˺̯ͤ͸;Τ"
	"ϤϫϮϴЯѼҢңҴҺ"
	"ԬԭԮԯգդզի֪֩֫֬ױح"
	"ٯٰٱٲٳٴٵٷٸ۪۸۹ۺۻۼ۽"
	"ޢ\n"
	"ͰѰװ鱫˱ѱ²̲ϲײز"
	"ȳسٳߴ񵧵ϵƶն"
	"·ԷƸǸȸѸԸ׸ιϹ"
	"ʺӺȻɻϻл޻¼˼Լټǽҽ"
	"¿´¶óô"
	"ġĹľšťŪųŵŹǰ"
	"ȡɽʨʪʻ"
	"ˡˢ˼̨̣̿"
	"ϧЪгдѻѽҤҥ"
	"԰ԲԳԴԵեէըְֱֲֳ֭֮֯ׯ"
	"׸׹ٶٹٺٻپڭ"
	"۾ۿޡޣޤޥ"
	""
	"\n"
	"İҰٰڰ߰Ǳɱ̱αֱ岰ʲͲѲ"
	"׳货ǴȵҵԵյ޵궮ζ"
	"շ׷¸ɸ̸θϸոĹȹӹٹ麨"
	"Ⱥպѻӻ׻ػܻ󽦽Ž˽ӽսʾ"
	"ӿ¥§¯"
	"ñúĩļƨƶƽ"
	"ǪǶȪȯɢɧ"
	"˦˿ͦͨͩͮʹΧημϺз"
	"ҦҵӡӢӣ"
	"ӤӥӦӾԶԷԸԹԺԻթժլխִֵ֢׿"
	"٨ټۦ۫۬"
	"ަާިީުޫެޭޮޯް"
	""
	""
	"\n"
	"ưױٱ㲧ƲȲٲڲ峢ʳ˳"
	"ٴ˵εܵ󶪶Ͷ÷˷"
	"ĸ˸ɹ̹ҹ׹ܹ߹ºú˺Ϻֺ޺"
	"ĻջƼͼӼڼ򽤽Խڽ޽"
	"þɾ;ξп˿ֿؿ"
	"¤©ª®µ¹ìÿĿ"
	"ţůŸƤƩƹƿǺǼǽ"
	"ȫȻɰɱɳɶɿʴʶ"
	"ˤ˶̮̰̲̼̽ͰήαειοϢ"
	"ϯϲϵЫиҧ"
	"ӧӨөӪӫӬӭӮӯӺԱԼԽԾԿծկհձղճֶ֡"
	"ַָֹֻּײءآأإئاٽ"
	"ޱ޲޳޴޵޶޷޸޺"
	""
	""
	""
	""
	"\n"
	"ðӰ԰۰ܰձ벫۲߳³̳Գݳ޳"
	"Ӵ󵬵ŵƵӵߵݶǷ"
	"ͷзַ򸣸Ӹ蹯̺κѺ׺غٺں"
	"»뼦żμϼмؼ½ɽʽͽѽ߽"
	"ľϾҾԾپ¿ʿڿ"
	"¦²æõøĢĥ"
	"ĦįĺĻĽūźżžƫưƲƺ"
	"ǭǱǴǸǾɩɭɷɼ"
	"ˣ˨ˬ˾̩̳ͣͪ͹ΦΨΫάΰ"
	"γδϬҨҶҷҿӰӱ"
	"ӳӴӵӶӷӸӹӻԡԢմյնշոչպֽ־"
	"׺ؤةثجخدذر"
	"ۭ"
	"ݷݸ޻޼޽޾޿"
	""
	""
	""
	"\n"
	"ΰذıͱӱ۱쳨ó"
	"ִ״ʵеǶ˶϶ж"
	"׶ڶɷʷڷиָ۸湢Źʹй຾"
	"ԺۺۻȼѼ潢׽۽뾡žƾǾ˾Ѿھ"
	"ݾǿҿٿܿݿ߿¬"
	"°·º½ãçêùûīıĶ"
	"ŽơƸƻǣǬȣȦȮȵȺ"
	"ɫɮɯɲɾʥʲʷʽ"
	"˵˹̵̫̺̻ͬͯͱ͵ͷͺΡΣΪβ"
	"ϭϽаҩӲӼӽӿ"
	"ԣջֿ֣׶"
	"بتسصطظعغػؼؽؿ١ۮ"
	"ܡܢܣܥܦܧܨܩܪܫܬܭܮܯܱܰܲݹݺ"
	""
	""
	""
	""
	"\n"
	"Űհǲ˲Ҳ޲ӳֳڳ"
	"Ͷȶضٶ󷢷ȷѷӷطظٸ"
	"ݸ¹۹ĺźɺк̻ܺ𽥽"
	"ؽݽȾվܾտ"
	"±³»òĭĲķ"
	"ŤŮŴŶƯȭȷȹ"
	"ʡʢ˩˪˭˰̴̬̭Ͳ΢"
	"ίκϡϨϩϰϱЬйѡѣѤҪҫҬҭһ"
	"Ԥԧռսվտ׻"
	"زشضؾ٢ܤܴܳܵܶ"
	"ܷܸܹܻܼܾܺܽܿݻݼݽ"
	""
	""
	""
	""
	""
	"\n"
	"ݰ±رݱޱŲɲβճĳǳҳճ󴷴ôɴش"
	"۸˹ѹڹ޹ݻＤü"
	"ƽνﾨؾ㿪п"
	"åè÷üþħĪĸŦũŬƼǧǫ"
	"Ȥȥȱȳȶɡɣɺʣʹ˱̡̢̧"
	"̪ͶνϳϹѢѥѦѧѨѩѪѾҼ"
	"ԥԦֺ"
	"ס٣ۡ"
	"ݾ"
	"ߡߢߣ"
	""
	""
	""
	"\n"
	"Ȱְ䱽ƱԱڱܱﲣԲܲݲɳγ´ƴ˴Ҵ򵣵"
	"õ綾۶𷮷ķŷη鸢ҹƹûɼϽ"
	"־׾޾̿¢ïýĬĳ"
	"ĴŢŨŰűƢƧƳƴƵƾǮǲȢȨ"
	"ɦɨɸɻʮʯʰʾ˫˯˽̥"
	"ͫέθϥѫѬѭѮѯѳҽ"
	"עףפץצק׼"
	"٤ݿ"
	"ߤߥߦߧߩߪ߬߭߮߯߰߱߳߹"
	""
	""
	""
	""
	"\n"
	"ްⱮñϱбұͳ߳ʹԴ۴̵ܵ"
	"ŶӷƷչݹ𼲼ʼýĽ"
	"ſƿîĵƬǳǻ"
	"Ȱȸʫʳ˥͢͡ͻζϣ϶Ͽ"
	"ЮѱѲҡҮүԨרש״"
	"٥ٿڡڢڣڤڥڧۢ"
	"߲ߴߵ߶߷߸ߺ"
	""
	""
	""
	""
	"\n"
	"ǰŲųĴڴ⵼ǶҸǹֹع꺩"
	"ļռ߽̽ٽ̾߾ῤİ"
	"ŧƥƷǨǿʵͥѰѴ"
	"׽٦ڦڨکڪګڬڮگۣۤۯ"
	"ݡݨݬ޹ߨ߻߼߽߾߿"
	""
	""
	""
	""
	"\n"
	"ϳ۳ܳʴѴ鵳߸ֽ£"
	"ĨƣƮǩǹɵʤ׳٧ڱ"
	"ڲڳڴڶڹݤݥݦݧ"
	""
	""
	""
	"\n"
	"𳪴¶ٷܷ߸¡ŭŲſ"
	"˲̸̹ΥϦϼҰתڵۥݣݩݪݫݭ"
	"߫"
	""
	""
	"\n"
	"Ķ·ƪƭȧ׭"
	"ڷۧ۰ݢݮݱ"
	""
	"\n"
	"ϸܹŻϪѵѶ֤׫ڸۨ۱"
	"ݯݰݲ"
	""
	"\n"
	"÷íϸѷѸѿ׾ں"
	""
	"\n"
	"սڻڼݳ"
	"\n"
	""
	"\n"
	"׬ڰ\n"
	"ݴ\n"
	"\n"
	"\n"
	"ݵݶ\n"
	"\n" )
  "SEIMEI-KANJI-KAKUSUU-LIST*" )
