#!/bin/sh
cd lib/incoming
for lib in * ; do # if this file is already in /lib, we won't replace it
                  # since it might be in use.
if [ ! -r ../$lib ]; then
  mv $lib ..
fi
done
cd ..
if [ -x /sbin/ldconfig ]; then # update library links
  /sbin/ldconfig .
else # no ldconfig, we must be running safely from the bootdisk.
  rm -f libc.so.5
  ln -sf libc.so.5.4.46 libc.so.5
  rm -f libm.so.5
  ln -sf libm.so.5.0.9 libm.so.5
#  rm -f libcurses.so.1
#  ln -sf libcurses.so.1.0.0 libcurses.so.1
#  rm -f libtermcap.so.2
#  ln -sf libtermcap.so.2.0.8 libtermcap.so.2
#  rm -f libgdbm.so.1
#  ln -sf libgdbm.so.1.7.3 libgdbm.so.1
fi
# Get rid of the /lib/incoming directory:
rm -rf incoming
cd ..
#( cd lib ; rm -rf libncurses.so.3.0 )
#( cd lib ; ln -sf libncurses.so.3.4 libncurses.so.3.0 )
#( cd lib ; rm -rf libncurses.so.3.4 )
#( cd lib ; ln -sf libncurses.so.1.9.9g libncurses.so.3.4 )
