import os
import md5
import string

if os.environ.has_key('DISPLAY'):
    import gtk

def create_pixbuf_from_DGP_file(path):
    head, tail = os.path.split(path)
    filename = tail
    m_half = md5.new(filename[:len(filename)/2]).hexdigest()
    m_full = md5.new(filename).hexdigest()
    tmp = m_full + filename
    key = ''
    j = 0
    for i in range(len(tmp)):
        value = ord(tmp[i]) ^ ord(m_half[j])
        if not value:
            break
        key = key + chr(value)
        j = j + 1
        if j >= len(m_half):
            j = 0
    key_length = len(key)
    if key_length == 0:
        print filename + ' generates a null key.'
	# !!! WARNING !!!
	# The gtk.gdk.pixbuf_new_from_file() seems to leak memory.
        # Use gtk.gdk.PixbufLoader instead.
	file = open(path).read()
	loader = gtk.gdk.PixbufLoader('png')
	loader.write(file, len(file))
	pixbuf = loader.get_pixbuf()
	loader.close()
	del(loader)
        return pixbuf # not encrypted
    key = key[1:] + key[0]
    key_pos = 0
    file = open(path, 'r')
    loader = gtk.gdk.PixbufLoader("png")
    while 1:
        c = file.read(1)
        if c == '':
            break
        loader.write(chr(ord(c) ^ ord(key[key_pos])), 1)
        key_pos = key_pos + 1
        if key_pos >= key_length:
            key_pos = 0
    file.close()
    pixbuf = loader.get_pixbuf()
    loader.close()
    return pixbuf

def create_pixbuf_from_file(path, type='pnr'):
    head, tail = os.path.split(path)
    basename, suffix = os.path.splitext(tail)
    if suffix == '.dgp':
        pixbuf = create_pixbuf_from_DGP_file(path)
    else:
	# !!! WARNING !!!
	# The gtk.gdk.pixbuf_new_from_file() seems to leak memory.
        # Use gtk.gdk.PixbufLoader instead.
	file = open(path).read()
        if type == 'pnr':
            loader = gtk.gdk.PixbufLoader('png')
        else:
            loader = gtk.gdk.PixbufLoader(type)
	loader.write(file, len(file))
	pixbuf = loader.get_pixbuf()
	loader.close()
	del(loader)
    if type == 'pnr':
        pixels = pixbuf.get_pixels()
        size = pixbuf.get_bits_per_sample()/8
        if not pixbuf.get_has_alpha():
            r = pixels[0:size]
            g = pixels[size:size*2]
            b = pixels[size*2:size*3]
            pixbuf = pixbuf.add_alpha(gtk.TRUE, r, g, b)
        else:
            blank_pixbuf = gtk.gdk.Pixbuf(
                pixbuf.get_colorspace(), gtk.FALSE,
                pixbuf.get_bits_per_sample(), 1, 1)
            blank_pixbuf.fill(0)
            blank_pixbuf = blank_pixbuf.add_alpha(
                gtk.TRUE, chr(0), chr(0), chr(0))
            rgba = pixels[0:size*4]
            for i in range(len(pixels)/(4*size)):
                if pixels[i*size*4:(i+1)*size*4] == rgba:
                    x = i % pixbuf.get_width()
                    y = i / pixbuf.get_width()
                    blank_pixbuf.copy_area(0, 0, 1, 1, pixbuf, x, y)
    return pixbuf

def create_pixmap_from_file(path):
    pixbuf = create_pixbuf_from_file(path)
    pixmap, mask = pixbuf.render_pixmap_and_mask(255)
    return pixmap, mask

def reduce_pixbuf(target_pixbuf, pixbuf, dest_x, dest_y):
    if pixbuf.get_has_alpha():
        blank_pixbuf = gtk.gdk.Pixbuf(
            pixbuf.get_colorspace(), gtk.FALSE,
            pixbuf.get_bits_per_sample(), 1, 1)
        blank_pixbuf.fill(0)
        blank_pixbuf = blank_pixbuf.add_alpha(
            gtk.TRUE, chr(0), chr(0), chr(0))
        dest_w = target_pixbuf.get_width()
        dest_h = target_pixbuf.get_height()
        pixels = pixbuf.get_pixels()
        size = pixbuf.get_bits_per_sample()/8
        for i in range(len(pixels)/(4*size)):
            alpha = 0
            for j in range(size):
                alpha = alpha + ord(pixels[i*size*4+size*3:(i+1)*size*4][j]) * pow(8, j)
            if alpha == 0: # alpha
                x = i % pixbuf.get_width()
                y = i / pixbuf.get_width()
                if dest_x + x >= 0 and dest_x + x < dest_w and\
                   dest_y + y >= 0 and dest_y + y < dest_h:
                    blank_pixbuf.copy_area(0, 0, 1, 1, target_pixbuf, dest_x + x, dest_y + y)
    return target_pixbuf
