# Tamito KAJIYAMA <18 October 2001>
# $Id: netlib.py,v 1.1.1.1 2003/04/11 05:54:31 shy Exp $

import os
import select
import string

class Resolver:
    def __init__(self):
        self.command = "ninix-lookup" # may be rewritten
        path = os.environ.get("NINIX") or \
               os.environ.get("NINIX_UPDATE")
        if path is not None:
            path = os.path.join(os.path.dirname(path), self.command)
            if os.path.exists(path):
                self.command = path
        self.pipe = None
    def lookup(self, hostname):
        if self.pipe is None:
            self.pipe = os.popen("%s %s" % (self.command, hostname))
        r, w, e = select.select([self.pipe], [], [], 0)
        if not r:
            return None
        data = self.pipe.read()
        self.pipe.close()
        self.pipe = None
        if data[:2] != "OK":
            return -1
        return string.strip(data[3:])
