# -*- coding: UTF-8 -*-
#
#  ssu.py - a ssu compatible Saori module for ninix
#  Copyright (C) 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

# TODO:
# - if, switch等の引数計算(calcを使用)

import os
import string
import StringIO
import codecs
import whrandom
import re

class Saori:
    def __init__(self):
	self.loaded = 0
        self.function = {'is_empty':      [self.ssu_is_empty,      [0, 1]],
                         'is_digit':      [self.ssu_is_digit,      [1]],
                         'is_alpha':      [self.ssu_is_alpha,      [1]],
                         'iflist':        [self.ssu_iflist,        [None]],
                         'length':        [self.ssu_length,        [1]],
                         'zen2han':       [self.ssu_zen2han,       [1]],
                         'han2zen':       [self.ssu_han2zen,       [1]],
                         'kata2hira,':    [self.ssu_kata2hira,     [1]],
                         'hira2kata':     [self.ssu_hira2kata,     [1]],
                         'sprintf':       [self.ssu_sprintf,       [None]],
                         'calc':          [self.ssu_calc,          [1]],
                         'compare_tail':  [self.ssu_compare_tail,  [2]],
                         'compare_head':  [self.ssu_compare_head,  [2]],
                         'compare':       [self.ssu_compare,       [2]],
                         'count':         [self.ssu_count,         [2]],
                         'erase_first':   [self.ssu_erase_first,   [2]],
                         'erase':         [self.ssu_erase,         [2]],
                         'replace':       [self.ssu_replace,       [3]],
                         'replace_first': [self.ssu_replace_first, [3]],
                         'split':         [self.ssu_split,         [1, 2, 3]],
                         'substr':        [self.ssu_substr,        [3]],
                         'nswitch':       [self.ssu_nswitch,       [None]],
                         'switch':        [self.ssu_switch,        [None]],
                         'if':            [self.ssu_if,            [2, 3]],
                         'unless':        [self.ssu_unless,        [2, 3]],}
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        else:
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        self.loaded = 0
        return 1
    def request(self, req):
        type, argument, charset = self.evaluate_request(req)
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            print 'SSU(0):', argument
            if not self.function.has_key(argument[0]):
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            name = argument[0]
            argument = argument[1:]
            print 'SSU(1):', name, argument
            print 'SSU(2):', self.function[name][1]
            if self.function[name][1] == [None]:
                pass
            elif len(argument) not in self.function[name][1]:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            self.value = []
            result = self.function[name][0](argument, charset)
            print 'SSU(3):', result, self.value
            if result is not None and result is not "":
                s = 'SAORI/1.0 200 OK\r\nResult: %s\r\n' % result
                if self.value is not None and self.value is not []:
                    for i in range(len(self.value)):
                        s = s + 'Value%d: %s\r\n' % (i, self.value[i])
                s = s + 'Charset: %s\r\n' % charset
                s = s + '\r\n'
                return s
            else:
                return 'SAORI/1.0 204 No Content\r\n\r\n'
    def ssu_is_empty(self, args, charset):
        if len(args) == 0:
            return 1
        else:
            return 0
    def ssu_is_digit(self, args, charset):
        s = unicode(args[0], charset, 'ignore')
        if s.isdigit():
            return 1
        else:
            return 0
    def ssu_is_alpha(self, args, charset):
        s = unicode(args[0], charset, 'ignore')
        if s.isalpha():
            return 1
        else:
            return 0
    def ssu_length(self, args, charset):
        s = unicode(args[0], charset, 'ignore')
        return len(s)
    def ssu_substr(self, args, charset):
        s = unicode(args[0], charset, 'ignore')
        if self.ssu_is_digit([args[1]], charset):
            start = int(self.ssu_zen2han([args[1]], charset))
            if start > len(s):
                return ""
        else:
            return ""
        if len(args) == 2:
            end = len(s)
        elif len(args) == 3 and self.ssu_is_digit([args[2]], charset):
            end = start + int(self.ssu_zen2han([args[2]], charset))
        else:
            return ""
        return s[start:end].encode(charset, 'ignore')
    def ssu_sprintf(self, args, charset): ## FIXME
        for i in range(1, len(args)):
            if self.ssu_is_digit([args[i]], charset):
                args[i] = int(self.ssu_zen2han([args[i]], charset)[0])
        try:
            return args[0] % tuple(args[1:])
        except:
            return ""
    ZEN = {'０': '0', '１': '1', '２': '2', '３': '3', '４': '4',
           '５': '5', '６': '6', '７': '7', '８': '8', '９': '9',
           '．': '.', '＋': '+', '−': '-',}
    HAN = {'0': '０', '1': '１', '2': '２', '3': '３', '4': '４',
           '5': '５', '6': '６', '7': '７', '8': '８', '9': '９',
           '.': '．', '+': '＋', '-': '−',}
    def ssu_zen2han(self, args, charset): ## FIXME
        s = unicode(args[0], charset, 'ignore')
        buffer = ""
        for i in range(len(s)):
            c = s[i].encode('utf-8', 'ignore')
            if self.ZEN.has_key(c):
                buffer = buffer + unicode(self.ZEN[c], 'utf-8', 'ignore')
            else:
                buffer = buffer + s[i]
        return buffer.encode(charset, 'ignore')
    def ssu_han2zen(self, args, charset): ## FIXME
        s = unicode(args[0], charset, 'ignore')
        buffer = ""
        for i in range(len(s)):
            c = s[i].encode('utf-8', 'ignore')
            if self.HAN.has_key(c):
                buffer = buffer + unicode(self.HAN[c], 'utf-8', 'ignore')
            else:
                buffer = buffer + s[i]
        return buffer.encode(charset, 'ignore')
    re_condition = re.compile(r"(>|<|==|>=|<=|!=|＞|＜|＞＝|＜＝|！＝|＝＝)")
    def eval_condition(self, left, ope, right):
        if self.ssu_is_digit([left], 'utf-8') and \
           self.ssu_is_digit([right], 'utf-8'):
            left = float(self.ssu_zen2han([left], 'utf-8'))
            right = float(self.ssu_zen2han([right], 'utf-8'))
        elif ope in ['>', '＞', '>=', '＞＝', '<', '＜', '<=', '＜＝']:
            left = len(left)
            right = len(right)
        result = False
        if ope in ['>', '＞']:
            result = left > right
        elif ope in ['>=', '＞＝']:
            result = left >= right
        elif ope in ['<', '＜']:
            result = left < right
        elif ope in ['<=', '＜＝']:
            result = left <= right
        elif ope in ['==', '＝＝']:
            result = left == right
        elif ope in ['!=', '！＝']:
            result = left != right
        else:
            pass # "should not reach here"   
        return result
    def ssu_if(self, args, charset):
        condition = unicode(args[0], charset, 'ignore').encode('utf-8', 'ignore')
        match = self.re_condition.search(condition)
        if match is not None:
            left = condition[:match.start()]
            ope = match.group(1)
            right = condition[match.end():]
            result = self.eval_condition(left, ope, right)
            if result:
                return args[1]
        if len(args) == 3:
            return args[2]
        else:
            return ""
    def ssu_unless(self, args, charset):
        condition = unicode(args[0], charset, 'ignore').encode('utf-8', 'ignore')
        match = self.re_condition.search(condition)
        if match is not None:
            left = condition[:match.start()]
            ope = match.group(1)
            right = condition[match.end():]
            result = self.eval_condition(left, ope, right)
            if not result:
                return args[1]
        if len(args) == 3:
            return args[2]
        else:
            return ""
    def ssu_iflist(self, args, charset):
        left = unicode(args[0], charset, 'ignore').encode('utf-8', 'ignore')
        i = 1
        while 1:
            if len(args[i:]) < 2:
                break
            ope_right = unicode(args[i], charset, 'ignore').encode('utf-8', 'ignore')
            match = self.re_condition.search(ope_right)
            if match is not None:
                ope = match.group(1)
                right = ope_right[match.end():]
                result = self.eval_condition(left, ope, right)
                if result:
                    return args[i + 1]
            i = i + 2
        return ""
    def ssu_nswitch(self, args, charset):
        num = unicode(args[0], charset, 'ignore').encode('utf-8', 'ignore')
        if self.ssu_is_digit([num], 'utf-8'):
            num = int(self.ssu_zen2han([num], 'utf-8'))
            if num > 0 and num < len(args):
                return args[num]
        return ""
    def ssu_count(self, args, charset):
        return string.count(args[0], args[1])
    def ssu_compare(self, args, charset):
        if args[0] == args[1]:
            return 1
        else:
            return 0
    def ssu_compare_head(self, args, charset):
        s0 = args[0]
        s1 = args[1]
        l0 = len(s0)
        l1 = len(s1)
        if l0 <= l1 and s1[:l0] == s0:
            return 1
        else:
            return 0
    def ssu_compare_tail(self, args, charset):
        s0 = args[0]
        s1 = args[1]
        l0 = len(s0)
        l1 = len(s1)
        if l0 <= l1 and s1[-l0:] == s0:
            return 1
        else:
            return 0
    def ssu_erase(self, args, charset):
        return string.replace(args[0], args[1], '')
    def ssu_erase_first(self, args, charset):
        return string.replace(args[0], args[1], '', 1)
    def ssu_replace(self, args, charset):
        return string.replace(args[0], args[1], args[2])
    def ssu_replace_first(self, args, charset):
        return string.replace(args[0], args[1], args[2], 1)
    def ssu_split(self, args, charset):
        s0 = args[0]
        if len(args) >= 2:
            s1 = args[1]
        else:
            s1 = ' ' ## FIXME
        if len(args) == 3:
            num = unicode(args[0], charset, 'ignore').encode('utf-8', 'ignore')
            if self.ssu_is_digit([num], 'utf-8'):
                num = int(self.ssu_zen2han([num], 'utf-8'))
            list = string.split(s0, s1, num)
        else:
            list = string.split(s0, s1)
        self.value = list
        return len(list)
    def ssu_switch(self, args, charset):
        left = args[0]
        i = 1
        while 1:
            if len(args[i:]) < 2:
                break
            right = args[i]
            if left == right:
                return args[i + 1]
            i = i + 2
        return ""
    def ssu_kata2hira(self, args, charset): ## FIXME
        return ""
    def ssu_hira2kata(self, args, charset): ## FIXME
        return ""
    def ssu_calc(self, args, charset): ## FIXME
        return 0
    def evaluate_request(self, req):
        type = None
        argument = []
        charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key == 'Charset':
                    charset = value
                    try:
                        codecs.lookup(charset)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                if key[:8] == 'Argument': ## FIXME
                    argument.append(value)
                else:
                    continue
        return type, argument, charset
