# -*- coding: EUC-JP -*-
#
#  mciaudior.py - a MCIAUDIOR compatible Saori module for ninix
#  Copyright (C) 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#  Copyright (C) 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: mciaudior.py,v 1.2 2003/07/19 04:23:13 shy Exp $

# TODO:
# - loop .

import os
import signal
import string
import StringIO
import re

class Saori:
    def __init__(self):
        self.pid = 0
	self.loaded = 0
        self.filepath = None
        self.sakura = None
        self.pause = 0
    def use_sakura(self, sakura):
        self.sakura = sakura
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        elif self.sakura != None:
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        if self.pid != 0:
            try:
                os.kill(-self.pid, 9)
                os.waitpid(self.pid, 0)
            except:
                pass
	    self.pid = 0
        self.filepath = None
        self.loaded = 0
        return 1
    def request(self, req):
        argv = self.evaluate_request(req)
        argc = len(argv)
        if argc == 1:
            if argv[0] == 'stop':
                ##self.filepath = None
                if self.pid != 0:
                    try:
                        os.kill(-self.pid, 9)
                        os.waitpid(self.pid, 0)
                    except:
                        pass
                    self.pid = 0
            elif argv[0] == 'play':
                if self.pid != 0:
                    status = os.waitpid(-self.pid, os.WNOHANG)
                    if os.WIFEXITED(status) or os.WIFSIGNALED(status):
                        self.pid = 0
                    elif self.pause:
                        os.kill(-self.pid, signal.SIGCONT)
                        self.pause = 0
                        return 'SAORI/1.0 204 No Content\r\n\r\n'
                    else:
                        os.kill(-self.pid, signal.SIGSTOP)
                        self.pause = 1
                        return 'SAORI/1.0 204 No Content\r\n\r\n'
                if os.path.isfile(self.filepath):
                    self.pid = os.fork()
                    if self.pid == 0:
                        os.setsid()
                        for regex, command in self.sakura.helpers:
                            if regex.search(self.filepath):
                                self.execute_command(command, self.filepath)
                        os._exit(0)
        elif argc == 2:
            if argv[0] == 'load':
                if self.pid != 0:
                    try:
                        os.kill(-self.pid, 9)
                        os.waitpid(self.pid, 0)
                    except:
                        pass
                    self.pid = 0
                filename = string.replace(argv[1], '\\', '/')
                filename = string.lower(filename)
                self.filepath = os.path.join(self.dir, filename)
        return 'SAORI/1.0 204 No Content\r\n\r\n'
    def execute_command(self, command, arg):
        pos = string.find(command, "%s")
        if pos < 0:
            sys.stderr.write("cannot execute command (%s missing)\n")
            return
        os.system(command[:pos] + arg + command[pos+2:])
    def evaluate_request(self, req):
        result = []
        header = StringIO.StringIO(req)
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key[:8] == 'Argument':
                    result.append(value)
                else:
                    continue
        return result
