# Tamito KAJIYAMA <14 June 2001>
# $Id: config.py,v 1.7 2003/07/19 04:23:12 shy Exp $

import string
import UserDict
import codecs

builtin_open = open

class Config(UserDict.UserDict):
    def __init__(self):
        UserDict.UserDict.__init__(self)
        self.itemlist = []
    def __setitem__(self, key, value):
        UserDict.UserDict.__setitem__(self, key, value)
        self.itemlist.append((key, value))
    def get(self, name, default=None):
        if type(name) == type([]):
            keylist = name
        else:
            keylist = [name]
        for key in keylist:
            if self.data.has_key(key):
                return self.data[key]
        return default
    def getint(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return int(value)
            except ValueError:
                pass
        return default
    def getfloat(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return float(value)
            except ValueError:
                pass
        return default
    def adjust(self, name, base, default=None):
        value = self.get(name)
        if value:
            try:
                if value[:2] == "--":
                    return int(value[1:])
                value = int(value)
            except (TypeError, ValueError):
                value = default
        if value is not None and value < 0:
            value = base + value
        return value
    def __str__(self):
        buffer = []
        for item in self.data.items():
            buffer.append('%s,%s\n' % item)
        return string.join(buffer, '')

def open(path):
    file = builtin_open(path)
    buffer = []
    while 1:
        line = file.readline()
        if not line:
            break
        if not string.strip(line):
            continue
        buffer.append(line)
    return new_config(buffer)

def new_config(buffer):
    dict = Config()
    charset = 'Shift_JIS' # default
    for line in buffer:
        try:
            key, value = string.split(line, ',', 1)
        except ValueError:
            continue
        if string.strip(key) == 'charset':
            try:
                codecs.lookup(charset)
            except:
                print "Unsupported charset %s" % string.strip(value)
            else:
                charset = string.strip(value)
        elif string.strip(key) in ['refreshundeletemask', 'icon', 'cursor',
                                   'shiori', 'makoto']:
            dict[string.strip(key)] = string.strip(value)
        else:
            dict[string.strip(key)] = string.strip(unicode(value, charset, 'replace'))
    return dict

def null_config():
    return Config()
