#!/usr/bin/env python
# Tamito KAJIYAMA <18 October 2001>

import os
import sys
import socket

PROGRAM_NAME = os.environ.get("NINIX_LOOKUP", sys.argv[0])

USAGE = """\
Usage: %s [-t] hostname
"""

def main():
    if len(sys.argv) == 3 and sys.argv[1] == "-t":
        test(sys.argv[2])
    elif len(sys.argv) == 2:
        lookup(sys.argv[1])
    else:
        sys.stderr.write(USAGE % os.path.basename(PROGRAM_NAME))
        sys.exit(1)

def lookup(hostname):
    try:
        address = socket.gethostbyname(hostname)
    except socket.error, e:
        print "ERROR", str(e)
    else:
        print "OK", address

def test(hostname):
    import select
    import string
    import time

    print "command =", PROGRAM_NAME
    pipe = os.popen(PROGRAM_NAME + " " + hostname)
    while 1:
        r, w, e = select.select([pipe], [], [], 0)
        if r:
            print
            break
        time.sleep(0.1)
        sys.stdout.write(".")
        sys.stdout.flush()
    data = pipe.read()
    if data[:2] == "OK":
        print string.strip(data[3:])
    else:
        print data
    pipe.close()

if __name__ == "__main__":
    main()
