#
#
#
#

set ipent_proc(get)		ipent:get
set ipent_proc(delete)		ipent:delete

Widget:DefineClass IpEntry {} ipent:create ipent:config ipent_proc

option add *IpEntry.borderWidth 2
option add *IpEntry.relief sunken
option add *IpEntry.highlightThickness 1

proc ipent:create {w a} {
    global ipent_conf
    set ipent_conf($w,entries) [list \
	[list $w.addr1 3 $w.dot1 .] \
	[list $w.addr2 3 $w.dot2 .] \
	[list $w.addr3 3 $w.dot3 .] \
	[list $w.addr4 3 $w.dot4 /] \
	[list $w.mask  2 ""    ""]]
    set ipent_conf($w,write_id) ""
    set ipent_conf($w,read_id) ""

    foreach e $ipent_conf($w,entries) {
	set ent [lindex $e 0]
	set wth [lindex $e 1]
	set sep [lindex $e 2]
	set txt [lindex $e 3]

	entry $ent -borderwidth 0 -relief flat -justify right \
	    -highlightthickness 0 -width $wth
	Widget:SetEntryState $ent normal
	bindtags $ent [list $ent IpEntryEntry . all]
	pack $ent -side left -padx 0 -pady 0 -ipadx 0 -ipady 0

	if {$sep != ""} {
	    label $sep -borderwidth 0 -relief flat -width 1 -text $txt
	    Widget:SetLabelState $sep normal
	    pack $sep -side left -padx 0 -pady 0 -ipadx 0 -ipady 0
	}
    }
    bind $w <FocusIn> [list focus $w.addr1]
    bind $w <Destroy> [list ipent:delete_trace $w]

    return $w
}

proc ipent:get {w a} {
    global ipent_conf

    set val {}
    set blank 0
    foreach i $ipent_conf($w,entries) {
	set v [[lindex $i 0] get]
	set d [lindex $i 3]
	if {$v == ""} {
	    incr blank
	}
	set val "$val$v$d"
    }
    if {$blank >= 4} {
	set val {}
    }
    regsub {/$} $val {} val
    return $val
}

proc ipent:delete {w a} {
    global ipent_conf

    foreach i $ipent_conf($w,entries) {
	set e [lindex $i 0]
	$e delete 0 end
    }
}

proc ipent:config {w o v} {
    switch -- $o {
	-state     {ipent:set_state $w $v}
	-variable  {ipent:set_variable $w $v}
	-netmaskon {ipent:set_netmask $w $v}
	default    {return 1}
    }
    return 0
}

proc ipent:set_state {w state} {
    global ipent_conf

    foreach e $ipent_conf($w,entries) {
	set ent [lindex $e 0]
	set sep [lindex $e 2]
	if {$ent != ""} {
	    Widget:SetEntryState $ent $state
	}
	if {$sep != ""} {
	    Widget:SetLabelState $sep $state
	}
    }
}

proc ipent:set_netmask {w on} {
    global ipent_conf

    set ent [lindex [lindex $ipent_conf($w,entries) 4] 0]
    set sep [lindex [lindex $ipent_conf($w,entries) 3] 2]
    if {$on} {
	pack $sep $ent -side left
    } else {
	$ent delete 0 end
	pack forget $ent
	pack forget $sep
    }
}

proc ipent:delete_trace {w} {
    global ipent_conf

    if {$ipent_conf($w,write_id) != ""} {
	del_trace $ipent_conf($w,write_id)
    }
    if {$ipent_conf($w,read_id) != ""} {
	del_trace $ipent_conf($w,read_id)
    }
}

proc ipent:set_variable {w varname} {
    ipent:delete_trace $w

    catch {
	ipent:write_handler $w $varname
    }
    set ipent_conf($w,write_id) \
	[set_trace $varname w [list ipent:write_handler $w $varname]]
    set ipent_conf($w,read_id) \
	[set_trace $varname r [list ipent:read_handler $w $varname]]
}

set ipent_mask_table {
    0xff 0xfe 0xfc 0xf8 0xf0 0xe0 0xc0 0x80 0x00
}

proc ipent:write_handler {win varname} {
    global ipent_conf
    upvar \#0 $varname var

    set l [split $var "/"]
    set addr [lindex $l 0]
    set mask [lindex $l 1]
    set octs [split $addr "."]

    set entries $ipent_conf($win,entries)
    for {set i 0} {$i < 4} {incr i} {
	set ent [lindex [lindex $entries $i] 0]
	set state [$ent cget -state]
	$ent configure -state normal
	$ent delete 0 end
	$ent insert 0 [lindex $octs $i]
	$ent configure -state $state
    }
    set octs [split $mask "."]
    if {[llength $octs] == 0} {
	set mask_num ""
    } elseif {[llength $octs] == 1} {
	set mask_num $octs
    } else {
	set mask_num 0
	foreach o $octs {
	    global ipent_mask_table
	    set n 8
	    foreach t $ipent_mask_table {
		if {$t == $o} {
		    break
		}
		incr n -1
	    }
	    incr mask_num $n
	}
    }
    set ent [lindex [lindex $entries 4] 0]
    set state [$ent cget -state]
    $ent configure -state normal
    $ent delete 0 end
    $ent insert 0 $mask_num
    $ent configure -state $state
}

proc ipent:read_handler {win varname} {
    upvar \#0 $varname var

    global ipent_conf
    set entries $ipent_conf($win,entries)

    set octs {}
    for {set i 0} {$i < 4} {incr i} {
	set ent [lindex [lindex $entries $i] 0]
	set octs [concat $octs [$ent get]]
    }
    set addr [join $octs "."]

    set ent [lindex [lindex $entries 4] 0]
    set mask [$ent get]
    if {$mask != "" && $mask != 0} {
	set var [join [list $addr $mask] "/"]
    } else {
	set var $addr
    }
}

foreach e [bind Entry] {
    bind IpEntryEntry $e [bind Entry $e]
}

bind IpEntryEntry <Key> {}
foreach n {0 1 2 3 4 5 6 7 8 9 period slash} {
    bind IpEntryEntry <Key-$n> {ipent:insert %W %A}
}
bind IpEntryEntry <Left>  {ipent:move_cursor %W -1}
bind IpEntryEntry <Right> {ipent:move_cursor %W  1}

proc ipent:insert {w a} {
    global ipent_conf

    if {$a == ""} {
	return
    }
    set p [winfo parent $w]
    set entries $ipent_conf($p,entries)

    set n [lsearch $entries "$w *"]
    set e [lindex $entries $n]

    set sep [lindex $e 2]
    set txt [lindex $e 3]
    set next [lindex [lindex $entries [expr $n+1]] 0]

    if ![regexp {^[0-9]} $a] {
	if {$sep != "" && $a == $txt} {
	    focus $next
	    $next selection range 0 end
	}
	return
    }
    catch {
	set insert [$w index insert]
	if {[$w index sel.first] <= $insert && 
	[$w index sel.last] >= $insert} {
	    $w delete sel.first sel.last
	}
    }
    $w insert insert $a
    while {[$w get] > 255} {
	$w delete 0 1
    }
    return
}

proc ipent:move_cursor {w step} {
    global ipent_conf

    set p [winfo parent $w]
    set entries $ipent_conf($p,entries)

    set c [expr [$w index insert] + $step]
    set n [lsearch $entries "$w *"]

    if {$c >= 0 && $c <= [string length [$w get]]} {
	tkEntrySetCursor $w $c
    } elseif {$c < 0 && $n > 0} {
	set next [lindex [lindex $entries [expr $n-1]] 0]
	focus $next
	tkEntrySetCursor $next end
    } elseif {
	$c > [string length [$w get]] &&
	$n < [expr [llength $entries] - 1]
    } {
	set next [lindex [lindex $entries [expr $n+1]] 0]
	focus $next
	tkEntrySetCursor $next 0
    }
}

proc ipent:test {} {
    global a1 a2
    set a1 ""
    set a2 ""
    IpEntry .e1 -variable a1
    IpEntry .e2 -variable a2 -netmaskon 0
    button .b -text "print" -command {
	puts "1:$a1"
	puts "2:$a2"
    }
    pack .e1 .e2 .b
}
