#
#
#
#

proc Modem:List {} {
    global PPxP_SysPath PPxP_UsrPath

    set flist [glob -nocomplain [file join $PPxP_SysPath modem *]]
    if [info exists PPxP_UsrPath] {
	lappend flist [glob -nocomplain [file join $PPxP_UsrPath modem *]]
    }
    set mlist {}

    foreach fname $flist {
	if {$fname == "" || [file isdirectory $fname]} {
	    continue
	}
	set f [open $fname]
	set name [file tail $fname]
	set desc ""

	while {[gets $f l] >= 0} {
	    if [regexp -nocase {name} [lindex $l 0]] {
		set desc [lindex $l 1]
		break
	    }
	}
	close $f
	set m [format "%-12s (%s)" $name $desc]
	set mlist [lappend mlist $m]
    }
    lsort $mlist
}

proc Modem:SetVar {val} {
    global PPxPVar
    set PPxPVar(SERIAL.MODEM) [lindex [split $val] 0]
}
