
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::ImageND;

@EXPORT_OK  = qw(  ninterpol PDL::PP convolve PDL::PP rebin  circ_mean circ_mean_p );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   @ISA    = ( 'PDL::Exporter','DynaLoader' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::ImageND ;





=head1 NAME

PDL::ImageND - useful image processing routines which work in N-dimensions

=head1 DESCRIPTION

In some cases (though not as many as one would like) it
is possible to write general routines that operate on
N-dimensional objects.

An example in this module is a N-Dim convolution algorithm
I made up one day - it works but the boundary condtions
are a bit funny.

=head1 SYNOPSIS

 use PDL::ImageND;

=cut







=head1 FUNCTIONS



=cut





use Carp;





=head2 convolve

=for sig

  Signature: (a(m); b(n); int adims(p); int bdims(q); [o]c(m))

=for ref

N-dimensional convolution algorithm.

=for usage

$new = convolve $a, $kernel

Convolve an array with a kernel, both of
which are N-dimensional.

Note because of the algorithm used (writing N-dim routines is not easy on the
brain!) the boundary conditions are a bit strange. They wrap, but up to the
I<NEXT> row/column/cube-slice/etc. If this is a problem consider using
zero-padding or something.





=cut






# Custom Perl wrapper

sub PDL::convolve{
    my($a,$b,$c) = @_;
    barf("Usage: convolve(a(*), b(*), [o]c(*)") if $#_<1 || $#_>2;
    $c = PDL->null if $#_<2;
    &PDL::_convolve_int( $a->clump(-1), $b->clump(-1),
       long([$a->dims]), long([$b->dims]),
       ($c->getndims>1? $c->clump(-1) : $c)
     );
     $c->setdims([$a->dims]);
     return $c;
}



*convolve = \&PDL::convolve;



=head2 ninterpol()

=for ref

N-dimensional interpolation routine

=for sig

 Signature: ninterpol(point(),data(n),[o]value())

=for usage

      $value = ninterpol($point, $data);

C<ninterpol> uses C<interpol> to find a linearly interpolated value in
N dimensions, assuming the data is spread on a uniform grid.  To use
an arbitrary grid distribution, need to find the grid-space point from
the indexing scheme, then call C<ninterpol> -- this is far from
trivial (and ill-defined in general).

=cut

*ninterpol = \&PDL::ninterpol;

sub PDL::ninterpol {
    use PDL::Math 'floor';
    use PDL::Primitive 'interpol';
    print 'Usage: $a = ninterpolate($point(s), $data);' if $#_ != 1;
    my ($p, $y) = @_;
    my ($ip) = floor($p);
    # isolate relevant N-cube
    $y = $y->slice(join (',',map($_.':'.($_+1),list $ip)));
    for (list ($p-$ip)) { $y = interpol($_,$y->xvals,$y); }
    $y;
}





=head2 rebin

=for sig

  Signature: (a(m); [o]b(n); int ns => n)

=for ref

N-dimensional rebinning algorithm

=for usage

$new = rebin $a, $dim1, $dim2,..;.
$new = rebin $a, $template;
$new = rebin $a, $template, {Norm => 1};

Rebin an N-dimensional array to newly specified dimensions.
Specifying `Norm' keeps the sum constant, otherwise the intensities
are kept constant.  If more template dimensions are given than for the
input pdl, these dimensions are created; if less, the final dimensions
are maintained as they were.

So if C<$a> is a 10 x 10 pdl, then C<rebin($a,15)> is a 15 x 10 pdl,
while C<rebin($a,15,16,17)> is a 15 x 16 x 17 pdl (where the values
along the final dimension are all identical).





=cut






# Custom Perl wrapper

sub PDL::rebin {
    my($a) = shift;
    my($opts) = ref $_[-1] eq "HASH" ? pop : {};
    my(@idims) = $a->dims;
    my(@odims) = ref $_[0] ? $_[0]->dims : @_;
    my($i,$b);
    foreach $i (0..$#odims) {
      if ($i > $#idims) {  # Just dummy extra dimensions
          $a = $a->dummy($i,$odims[$i]);
          next;
      # rebin_int can cope with all cases, but code
      # 1->n and n->1 separately for speed
      } elsif ($odims[$i] != $idims[$i]) {       # If something changes
         if (!($odims[$i] % $idims[$i])) {      # Cells map 1 -> n
               my ($r) = $odims[$i]/$idims[$i];
               $b = $a->mv($i,0)->dummy(0,$r)->clump(2);
         } elsif (!($idims[$i] % $odims[$i])) { # Cells map n -> 1
               my ($r) = $idims[$i]/$odims[$i];
               $a = $a->mv($i,0);
               # -> copy so won't corrupt input PDL
               $b = $a->slice("0:-1:$r")->copy;
               foreach (1..$r-1) {
                  $b += $a->slice("$_:-1:$r");
               }
               $b /= $r;
         } else {                               # Cells map n -> m
             &PDL::_rebin_int($a->mv($i,0), $b = null, $odims[$i]);
         }
         $a = $b->mv(0,$i);
      }
    }
    if (exists $opts->{Norm} and $opts->{Norm}) {
      my ($norm) = 1;
      for $i (0..$#odims) {
         if ($i > $#idims) {
              $norm /= $odims[$i];
         } else {
              $norm *= $idims[$i]/$odims[$i];
         }
      }
      return $a * $norm;
    } else {
      # Explicit copy so i) can't corrupt input PDL through this link
      #                 ii) don't waste space on invisible elements
      return $a -> copy;
    }
}


*rebin = \&PDL::rebin;



=head2 circ_mean_p

=for ref

Calculates the circular mean of an n-dim image and returns
the projection. Optionally takes the center to be used.

=for usage

   $cmean=circ_mean_p($im);
   $cmean=circ_mean_p($im,{Center => [10,10]});

=cut


sub circ_mean_p {
 my ($a,$opt) = @_;
 my ($rad,$sum,$norm);

 if (defined $opt) {
   $rad = long PDL::rvals($a,$opt);
 }
 else {
   $rad = long rvals $a;
 }
 $sum = zeroes($rad->max+1);
 PDL::indadd $a->clump(-1), $rad->clump(-1), $sum; # this does the real work
 $norm = zeroes($rad->max+1);
 PDL::indadd pdl(1), $rad->clump(-1), $norm;       # equivalent to get norm
 $sum /= $norm;
 return $sum;
}

=head2 circ_mean

=for ref

Smooths an image by applying circular mean.
Optionally takes the center to be used.

=for usage

   circ_mean($im);
   circ_mean($im,{Center => [10,10]});

=cut

sub circ_mean {
 my ($a,$opt) = @_;
 my ($rad,$sum,$norm,$a1);

 if (defined $opt) {
   $rad = long PDL::rvals($a,$opt);
 }
 else {
   $rad = long rvals $a;
 }
 $sum = zeroes($rad->max+1);
 PDL::indadd $a->clump(-1), $rad->clump(-1), $sum; # this does the real work
 $norm = zeroes($rad->max+1);
 PDL::indadd pdl(1), $rad->clump(-1), $norm;       # equivalent to get norm
 $sum /= $norm;
 $a1 = $a->clump(-1);
 $a1 .= $sum->index($rad->clump(-1));

 return $a;
}



;


=head1 AUTHORS

Copyright (C) Karl Glazebrook 1997.
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL
distribution. If this file is separated from the PDL distribution,
the copyright notice should be included in the file.

=cut





# Exit with OK status

1;

		   