
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Math;

@EXPORT_OK  = qw( PDL::PP acos PDL::PP asin PDL::PP atan PDL::PP cosh PDL::PP sinh PDL::PP tan PDL::PP tanh PDL::PP ceil PDL::PP floor PDL::PP rint PDL::PP pow PDL::PP acosh PDL::PP asinh PDL::PP atanh PDL::PP erf PDL::PP erfc PDL::PP bessj0 PDL::PP bessj1 PDL::PP bessy0 PDL::PP bessy1 PDL::PP bessjn PDL::PP bessyn PDL::PP lgamma PDL::PP badmask PDL::PP isfinite PDL::PP erfi PDL::PP ndtri PDL::PP svd PDL::PP polyroots PDL::PP eigens PDL::PP simq PDL::PP squaretotri );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   @ISA    = ( 'PDL::Exporter','DynaLoader' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Math ;




=head1 NAME

PDL::Math - extended mathematical operations and special functions

=head1 SYNOPSIS

 use PDL::Math;

 use PDL::Graphics::TriD;
 imag3d [SURF2D,bessj0(rvals(zeroes(50,50))/2)];

=head1 DESCRIPTION

This module extends PDL with more advanced mathematical
functions than provided by standard Perl.

All the functions have one input pdl, and one output, unless otherwise
stated.

The functions are usually available from the system
maths library, however if they are not (determined
when PDL is compiled) a version from the Cephes math
library is used.

=cut






=head1 FUNCTIONS



=cut






=head2 acos

=for sig

  Signature: (a(); [o]b())

=for ref

The usual trigonometric function. Works inplace.



=cut






*acos = \&PDL::acos;




=head2 asin

=for sig

  Signature: (a(); [o]b())

=for ref

The usual trigonometric function. Works inplace.



=cut






*asin = \&PDL::asin;




=head2 atan

=for sig

  Signature: (a(); [o]b())

=for ref

The usual trigonometric function. Works inplace.



=cut






*atan = \&PDL::atan;




=head2 cosh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*cosh = \&PDL::cosh;




=head2 sinh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*sinh = \&PDL::sinh;




=head2 tan

=for sig

  Signature: (a(); [o]b())

=for ref

The usual trigonometric function. Works inplace.



=cut






*tan = \&PDL::tan;




=head2 tanh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*tanh = \&PDL::tanh;




=head2 ceil

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format. Works inplace.



=cut






*ceil = \&PDL::ceil;




=head2 floor

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format. Works inplace.



=cut






*floor = \&PDL::floor;




=head2 rint

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format. Works inplace.



=cut






*rint = \&PDL::rint;




=head2 pow

=for sig

  Signature: (a(); b(); [o]c())

=for ref

Synonym for `**'. Works inplace.



=cut






*pow = \&PDL::pow;




=head2 acosh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*acosh = \&PDL::acosh;




=head2 asinh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*asinh = \&PDL::asinh;




=head2 atanh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic function. Works inplace.



=cut






*atanh = \&PDL::atanh;




=head2 erf

=for sig

  Signature: (a(); [o]b())

=for ref

The error function. Works inplace.



=cut






*erf = \&PDL::erf;




=head2 erfc

=for sig

  Signature: (a(); [o]b())

=for ref

The complement of the error function. Works inplace.



=cut






*erfc = \&PDL::erfc;




=head2 bessj0

=for sig

  Signature: (a(); [o]b())

=for ref

The standard Bessel function. Works inplace.



=cut






*bessj0 = \&PDL::bessj0;




=head2 bessj1

=for sig

  Signature: (a(); [o]b())

=for ref

The standard Bessel function. Works inplace.



=cut






*bessj1 = \&PDL::bessj1;




=head2 bessy0

=for sig

  Signature: (a(); [o]b())

=for ref

The standard Bessel function. Works inplace.



=cut






*bessy0 = \&PDL::bessy0;




=head2 bessy1

=for sig

  Signature: (a(); [o]b())

=for ref

The standard Bessel function. Works inplace.



=cut






*bessy1 = \&PDL::bessy1;




=head2 bessjn

=for sig

  Signature: (a(); int n(); [o]b())

=for ref

The standard Bessel function.
This has a second integer
argument which gives the order of the function required.
 Works inplace.



=cut






*bessjn = \&PDL::bessjn;




=head2 bessyn

=for sig

  Signature: (a(); int n(); [o]b())

=for ref

The standard Bessel function.
This has a second integer
argument which gives the order of the function required.
 Works inplace.



=cut






*bessyn = \&PDL::bessyn;




=head2 lgamma

=for sig

  Signature: (a(); [o]b(); int[o]s())

=for ref

log gamma function

This returns 2 piddles -- the first set gives the log(gamma) values,
while the second set, of integer values, gives the sign of the gamma
function.  This is useful for determining factorials, amongst other
things.





=cut






*lgamma = \&PDL::lgamma;




=head2 badmask

=for sig

  Signature: (a(); b(); [o]c())

=for ref

Clears all C<infs> and C<nans> in C<$a> to the corresponding value in C<$b>.

badmask can be run with C<$a> inplace:

  badmask($a->inplace,0);
  $a->inplace->badmask(0);





=cut






*badmask = \&PDL::badmask;




=head2 isfinite

=for sig

  Signature: (a(); int [o]mask())

=for ref

Sets C<$mask> true if C<$a> is not a C<NaN> or C<inf> (either positive or negative). Works inplace.



=cut






*isfinite = \&PDL::isfinite;




=head2 erfi

=for sig

  Signature: (a(); [o]b())

=for ref

The inverse of the error function. Works inplace.



=cut






*erfi = \&PDL::erfi;




=head2 ndtri

=for sig

  Signature: (a(); [o]b())

=for ref

The value for which the area under the
Gaussian probability density function (integrated from
minus infinity) is equal to the argument (cf L<erfi|/erfi>). Works inplace.



=cut






*ndtri = \&PDL::ndtri;




=head2 svd

=for sig

  Signature: (a(n,m); [o]u(n,m); [o,phys]z(n); [o]v(n,n))


=for ref

Singular value decomposition of array.

=for usage

 ($u, $s, $v) = svd($a);





=cut






*svd = \&PDL::svd;




=head2 polyroots

=for sig

  Signature: (cr(n); ci(n); [o]rr(m); [o]ri(m))



=for ref

Complex roots of a complex polynomial, given coefficients in order
of decreasing powers.

=for usage

 ($rr, $ri) = polyroots($cr, $ci);





=cut






*polyroots = \&PDL::polyroots;




=head2 eigens

=for sig

  Signature: ([phys]a(m); [o,phys]ev(n,n); [o,phys]e(n))


=for ref

Eigenvalues and -vectors of a symmetric square matrix.  If passed
an asymmetric matrix, the routine will warn and symmetrize it.

=for usage

 ($e, $ev) = eigens($a);





=cut





sub PDL::eigens {
      my ($a) = @_;
      my (@d) = $a->dims;
      barf "Need real square matrix for eigens" 
            if $#d != 1 or $d[0] != $d[1];
      my ($n) = $d[0];
      my ($sym) = 0.5*($a + $a->mv(0,1));
      my ($err) = PDL::max(abs($sym));
      barf "Need symmetric component non-zero for eigens"
          if $err == 0;
      $err = PDL::max(abs($a-$sym))/$err;
      warn "Using symmetrized version of the matrix in eigens"
          if $err > 1e-5;
      # Get lower triangular form -- 
      my ($lt) = PDL::where($sym,$sym->xvals <= $sym->yvals)->copy;
      my ($ev) = PDL->zeroes($n,$n);
      my ($e)  = PDL->zeroes($n);
      &PDL::_eigens_int($lt, $ev, $e);
      return $ev, $e;
}


*eigens = \&PDL::eigens;




=head2 simq

=for sig

  Signature: ([phys]a(n,n); [phys]b(n); [o,phys]x(n); int [o,phys]ips(n); int flag)


=for ref

Solution of simultaneous linear equations, C<a x = b>.

C<$a> is an C<n x n> matrix (i.e., a vector of length C<n*n>), stored row-wise:
that is, C<a(i,j) = a[ij]>, where C<ij = i*n + j>.  
While this is the
transpose of the normal column-wise storage, this corresponds to
normal PDL usage.  The contents of matrix a may be altered (but may be
required for subsequent calls with flag = -1).

C<$b>, C<$x>, C<$ips> are vectors of length C<n>.

Set C<flag=0> to solve.  
Set C<flag=-1> to do a new back substitution for
different C<$b> vector using the same a matrix previously reduced when
C<flag=0> (the C<$ips> vector generated in the previous solution is also
required).





=cut






*simq = \&PDL::simq;




=head2 squaretotri

=for sig

  Signature: (a(n,n); b(m))


=for ref

Convert a symmetric square matrix to triangular vector storage





=cut






*squaretotri = \&PDL::squaretotri;


;


sub eigen_c {
	my($mat) = @_;
	my $s = $mat->getdim(0);
	my $z = zeroes($s * ($s+1) / 2);
	my $ev = zeroes($s);
	squaretotri($mat,$z);
	my $k = 0 * $mat;
	PDL::eigens($z, $k, $ev);
	return ($ev, $k);
}


=head1 BUGS

Hasn't been tested on all platforms to ensure Cephes
versions are picked up automatically and used correctly.

=head1 AUTHOR

Copyright (C) R.J.R. Williams 1997 (rjrw@ast.leeds.ac.uk), Karl Glazebrook
(kgb@aaoepp.aao.gov.au) and Tuomas J. Lukka (Tuomas.Lukka@helsinki.fi).

All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL
distribution. If this file is separated from the PDL distribution,
the copyright notice should be included in the file.

=cut




# Exit with OK status

1;

		   