#!/bin/sh

SW=openmotif-2.2.2

PKG=`pwd`/pkg
rm -rf $PKG
mkdir -p $PKG
cd $SW
make install DESTDIR=$PKG
mkdir -p $PKG/usr/doc/$SW
cp -p ACKNOWLEDGEMENTS BUGREPORT CLOSEDBUGS COPYRIGHT.MOTIF LICENSE OPENBUGS README RELEASE RELNOTES $PKG/usr/doc/$SW/.
cp -p ../*.patch $PKG/usr/doc/$SW/.
gzip $PKG/usr/doc/$SW/*.patch
cp -p ../*build.sh $PKG/usr/doc/$SW/.
chown -R root:root $PKG/usr/doc
gzip $PKG/usr/X11R6/man/man1/*.1* 
gzip $PKG/usr/X11R6/man/man3/*.3*
gzip $PKG/usr/X11R6/man/man4/*.4*
gzip $PKG/usr/X11R6/man/man5/*.5*
cd $PKG
mkdir -p usr/X11R6/lib/X11/app-defaults
( cd usr/X11R6/lib/X11/app-defaults 
  ln -s ../../../share/Xm/*/*.ad . 
  for i in *.ad ; do mv $i ${i%%.ad} ; done
  cp -p ../../../../../../$SW/demos/lib/Xmd/XmdHelp.ad XmdHelp
  chown root:root XmdHelp
)
mkdir -p usr/X11R6/lib/X11/uid
( cd usr/X11R6/share/Xm/helloint
  LST="../../../../../../$SW/demos/programs/hellomotifi18n/*/uid"
  cp -pR ${LST%%uid} .
  LST="*/uid"
  chown -R root:root ${LST%%uid}
)
( cd usr/X11R6/lib/X11/uid
  cp -p ../../../../../../$SW/demos/programs/periodic/periodic.uid ../../../share/Xm/periodic/.
  cp -p ../../../../../../$SW/demos/programs/periodic/periodic.uil ../../../share/Xm/periodic/.
  chown root:root ../../../share/Xm/periodic/periodic.uid
  chown root:root ../../../share/Xm/periodic/periodic.uil
  ln -s ../../../share/Xm/*/*.uid .
  LST="../../../share/Xm/*/*/uid"
  ln -s ${LST%%uid} .
  rm pixmaps
)
mkdir -p usr/X11R6/lib/X11/help
( cd usr/X11R6/lib/X11/help
  ln -s ../../../share/Xm/*/*.help .
)

cp -p ../$SW/demos/lib/Xmd/.libs/onHelp usr/X11R6/bin/.
chown root:root usr/X11R6/bin/onHelp
mkdir -p usr/X11R6/include/Xmd
( cd usr/X11R6/include/Xmd
  cp -p ../../../../../$SW/demos/lib/Xmd/*.h .
  cp -p ../../../../../$SW/demos/lib/Xmd/README .
)
( cd usr/X11R6/lib
  cp -p ../../../../$SW/demos/lib/Xmd/lib*.* .
)
chown -R root:root usr/X11R6/include/Xmd
chown -R root:root usr/X11R6/lib/*Xmd*

mkdir -p usr/X11R6/include/Exm
( cd usr/X11R6/include/Exm
  cp -p ../../../../../$SW/demos/lib/Exm/*.h .
  cp -p ../../../../../$SW/demos/lib/Exm/README .
)
( cd usr/X11R6/lib
  cp -p ../../../../$SW/demos/lib/Exm/lib*.* .
)
chown -R root:root usr/X11R6/include/Exm
chown -R root:root usr/X11R6/lib/*Exm*

mkdir -p usr/X11R6/include/Wsm
( cd usr/X11R6/include/Wsm
  cp -p ../../../../../$SW/demos/lib/Wsm/*.h .
)
( cd usr/X11R6/lib
  cp -p ../../../../$SW/demos/lib/Wsm/lib*.* .
)
chown -R root:root usr/X11R6/include/Wsm
chown -R root:root usr/X11R6/lib/*Wsm*

makepkg $SW.tgz <<EOF
y
y
EOF

if [ -f /var/log/packages/$SW.tgz ] ; then
   removepkg $SW
fi
installpkg $SW.tgz
ldconfig

sh install/doinst.sh
rm install/doinst.sh
rmdir install

( cd ../$SW/lib/Mrm
  make clean ; make install DESTDIR=$PKG
)

rm $SW.tgz
makepkg $SW.tgz <<EOF
y
y
EOF

if [ -f /var/log/packages/$SW.tgz ] ; then
   removepkg $SW
fi
installpkg $SW.tgz
ldconfig

sh install/doinst.sh
rm install/doinst.sh
rmdir install

( cd ../$SW/clients/uil
  make clean ; make install DESTDIR=$PKG
)

rm $SW.tgz
makepkg $SW.tgz <<EOF
y
y
EOF
