/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSMODULES_H
#define ARTSMODULES_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"
#include "artsmidi.h"
#include "artsgui.h"

namespace Arts {
namespace Environment {
class Context;
class Container;
class Item;
class InstrumentItem;
class InstrumentItemGuiFactory;
class StereoEffectItem;
class MixerChannel;
class MixerItem;
};
class SimpleMixerChannel;
class MonoSimpleMixerChannel;
class Synth_AUX_BUS;
class MonoComplexMixerChannel;
class MixerGuiFactory;
class MonoSimpleMixerChannelGuiFactory;
class SimpleMixerChannelGuiFactory;
class MixerItemGui;
class ObjectCache;
class MidiReleaseHelper;
class Synth_CAPTURE_WAV;
class Synth_COMPRESSOR;
class Synth_NIL;
class Synth_DEBUG;
class Synth_DATA;
class Synth_ATAN_SATURATE;
class Synth_BRICKWALL_LIMITER;
class Synth_AUTOPANNER;
class Synth_DELAY;
class Synth_CDELAY;
class Synth_FM_SOURCE;
class Synth_TREMOLO;
class Synth_FX_CFLANGER;
class Synth_NOISE;
class Synth_WAVE_TRI;
class Synth_WAVE_SQUARE;
class Synth_WAVE_PULSE;
class Synth_WAVE_SOFTSAW;
class Synth_ENVELOPE_ADSR;
class Synth_SHELVE_CUTOFF;
class Synth_XFADE;
class Synth_MIDI_TEST;
class Synth_MIDI_DEBUG;
class Synth_FREEVERB;
class FreeverbGuiFactory;
class Synth_STD_EQUALIZER;
class Synth_RC;
class Synth_MOOG_VCF;
class Synth_PSCALE;
class Synth_SEQUENCE;
class Synth_PITCH_SHIFT;
class Synth_STEREO_PITCH_SHIFT;
class Effect_WAVECAPTURE;
class Synth_STEREO_FIR_EQUALIZER;
class StereoFirEqualizerGuiFactory;
class Synth_PLAY_PAT;
class Interface_MIDI_NOTE;
class Synth_STRUCT_KILL;

namespace Environment {
class Context_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Context_base *_create(const std::string& subClass = "Arts::Environment::Context");
	static Context_base *_fromString(const std::string& objectref);
	static Context_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Context_base *_fromDynamicCast(const Arts::Object& object);
	inline Context_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void addEntry(const std::string& name, Arts::Object obj) = 0;
	virtual std::string lookupEntry(Arts::Object obj) = 0;
	virtual void removeEntry(Arts::Object obj) = 0;
};

class Context_stub : virtual public Context_base, virtual public Arts::Object_stub {
protected:
	Context_stub();

public:
	Context_stub(Arts::Connection *connection, long objectID);

	void addEntry(const std::string& name, Arts::Object obj);
	std::string lookupEntry(Arts::Object obj);
	void removeEntry(Arts::Object obj);
};

class Context_skel : virtual public Context_base, virtual public Arts::Object_skel {
public:
	Context_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class Context : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Context_base *_cache;
	inline Context_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Context_base *)_pool->base->_cast(Context_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Context(Context_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Context_base _base_class;

	inline Context() : Arts::Object(_Creator), _cache(0) {}
	inline Context(const Arts::SubClass& s) :
		Arts::Object(Context_base::_create(s.string())), _cache(0) {}
	inline Context(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Context_base::_fromString(r.string())):(Context_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Context(const Arts::DynamicCast& c) : Arts::Object(Context_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Context(const Context& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Context(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Context null() {return Context((Context_base*)0);}
	inline static Context _from_base(Context_base* b) {return Context(b);}
	inline Context& operator=(const Context& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Context_base* _base() {return _cache?_cache:_method_call();}

	inline void addEntry(const std::string& name, Arts::Object obj);
	inline std::string lookupEntry(Arts::Object obj);
	inline void removeEntry(Arts::Object obj);
};

class Container_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Container_base *_create(const std::string& subClass = "Arts::Environment::Container");
	static Container_base *_fromString(const std::string& objectref);
	static Container_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Container_base *_fromDynamicCast(const Arts::Object& object);
	inline Container_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string dataDirectory() = 0;
	virtual void dataDirectory(const std::string& newValue) = 0;
	virtual Arts::Environment::Context context() = 0;
	virtual void context(Arts::Environment::Context newValue) = 0;
	virtual std::vector<Arts::Environment::Item> * items() = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& strlist) = 0;
	virtual void addItem(Arts::Environment::Item item) = 0;
	virtual Arts::Environment::Item createItem(const std::string& name) = 0;
	virtual void removeItem(Arts::Environment::Item item) = 0;
};

class Container_stub : virtual public Container_base, virtual public Arts::Object_stub {
protected:
	Container_stub();

public:
	Container_stub(Arts::Connection *connection, long objectID);

	std::string dataDirectory();
	void dataDirectory(const std::string& newValue);
	Arts::Environment::Context context();
	void context(Arts::Environment::Context newValue);
	std::vector<Arts::Environment::Item> * items();
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& strlist);
	void addItem(Arts::Environment::Item item);
	Arts::Environment::Item createItem(const std::string& name);
	void removeItem(Arts::Environment::Item item);
};

class Container_skel : virtual public Container_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void dataDirectory_changed(const std::string& newValue) {
		_emit_changed("dataDirectory_changed",newValue);
	}

public:
	Container_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class Container : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Container_base *_cache;
	inline Container_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Container_base *)_pool->base->_cast(Container_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Container(Container_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Container_base _base_class;

	inline Container() : Arts::Object(_Creator), _cache(0) {}
	inline Container(const Arts::SubClass& s) :
		Arts::Object(Container_base::_create(s.string())), _cache(0) {}
	inline Container(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Container_base::_fromString(r.string())):(Container_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Container(const Arts::DynamicCast& c) : Arts::Object(Container_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Container(const Container& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Container(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Container null() {return Container((Container_base*)0);}
	inline static Container _from_base(Container_base* b) {return Container(b);}
	inline Container& operator=(const Container& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Container_base* _base() {return _cache?_cache:_method_call();}

	inline std::string dataDirectory();
	inline void dataDirectory(const std::string& _newValue);
	inline Arts::Environment::Context context();
	inline void context(Arts::Environment::Context _newValue);
	inline std::vector<Arts::Environment::Item> * items();
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline void addItem(Arts::Environment::Item item);
	inline Arts::Environment::Item createItem(const std::string& name);
	inline void removeItem(Arts::Environment::Item item);
};

class Item_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Item_base *_create(const std::string& subClass = "Arts::Environment::Item");
	static Item_base *_fromString(const std::string& objectref);
	static Item_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Item_base *_fromDynamicCast(const Arts::Object& object);
	inline Item_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool active() = 0;
	virtual Arts::Environment::Container parent() = 0;
	virtual void setContainer(Arts::Environment::Container container) = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& strlist) = 0;
};

class Item_stub : virtual public Item_base, virtual public Arts::Object_stub {
protected:
	Item_stub();

public:
	Item_stub(Arts::Connection *connection, long objectID);

	bool active();
	Arts::Environment::Container parent();
	void setContainer(Arts::Environment::Container container);
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& strlist);
};

class Item_skel : virtual public Item_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}

public:
	Item_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class Item : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Item_base *_cache;
	inline Item_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Item_base *)_pool->base->_cast(Item_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Item(Item_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Item_base _base_class;

	inline Item() : Arts::Object(_Creator), _cache(0) {}
	inline Item(const Arts::SubClass& s) :
		Arts::Object(Item_base::_create(s.string())), _cache(0) {}
	inline Item(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Item_base::_fromString(r.string())):(Item_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Item(const Arts::DynamicCast& c) : Arts::Object(Item_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Item(const Item& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Item(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Item null() {return Item((Item_base*)0);}
	inline static Item _from_base(Item_base* b) {return Item(b);}
	inline Item& operator=(const Item& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Item_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
};

class InstrumentItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static InstrumentItem_base *_create(const std::string& subClass = "Arts::Environment::InstrumentItem");
	static InstrumentItem_base *_fromString(const std::string& objectref);
	static InstrumentItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static InstrumentItem_base *_fromDynamicCast(const Arts::Object& object);
	inline InstrumentItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::MidiPort port() = 0;
	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual std::string busname() = 0;
	virtual void busname(const std::string& newValue) = 0;
};

class InstrumentItem_stub : virtual public InstrumentItem_base, virtual public Arts::Environment::Item_stub {
protected:
	InstrumentItem_stub();

public:
	InstrumentItem_stub(Arts::Connection *connection, long objectID);

	Arts::MidiPort port();
	std::string filename();
	void filename(const std::string& newValue);
	std::string busname();
	void busname(const std::string& newValue);
};

class InstrumentItem_skel : virtual public InstrumentItem_base, virtual public Arts::Environment::Item_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}
	inline void busname_changed(const std::string& newValue) {
		_emit_changed("busname_changed",newValue);
	}

public:
	InstrumentItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class InstrumentItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InstrumentItem_base *_cache;
	inline InstrumentItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InstrumentItem_base *)_pool->base->_cast(InstrumentItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InstrumentItem(InstrumentItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef InstrumentItem_base _base_class;

	inline InstrumentItem() : Arts::Object(_Creator), _cache(0) {}
	inline InstrumentItem(const Arts::SubClass& s) :
		Arts::Object(InstrumentItem_base::_create(s.string())), _cache(0) {}
	inline InstrumentItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InstrumentItem_base::_fromString(r.string())):(InstrumentItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InstrumentItem(const Arts::DynamicCast& c) : Arts::Object(InstrumentItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline InstrumentItem(const InstrumentItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InstrumentItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InstrumentItem null() {return InstrumentItem((InstrumentItem_base*)0);}
	inline static InstrumentItem _from_base(InstrumentItem_base* b) {return InstrumentItem(b);}
	inline InstrumentItem& operator=(const InstrumentItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline InstrumentItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline Arts::MidiPort port();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline std::string busname();
	inline void busname(const std::string& _newValue);
};

class InstrumentItemGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static InstrumentItemGuiFactory_base *_create(const std::string& subClass = "Arts::Environment::InstrumentItemGuiFactory");
	static InstrumentItemGuiFactory_base *_fromString(const std::string& objectref);
	static InstrumentItemGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static InstrumentItemGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline InstrumentItemGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class InstrumentItemGuiFactory_stub : virtual public InstrumentItemGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	InstrumentItemGuiFactory_stub();

public:
	InstrumentItemGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class InstrumentItemGuiFactory_skel : virtual public InstrumentItemGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	InstrumentItemGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class InstrumentItemGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InstrumentItemGuiFactory_base *_cache;
	inline InstrumentItemGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InstrumentItemGuiFactory_base *)_pool->base->_cast(InstrumentItemGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InstrumentItemGuiFactory(InstrumentItemGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef InstrumentItemGuiFactory_base _base_class;

	inline InstrumentItemGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::SubClass& s) :
		Arts::Object(InstrumentItemGuiFactory_base::_create(s.string())), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InstrumentItemGuiFactory_base::_fromString(r.string())):(InstrumentItemGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::DynamicCast& c) : Arts::Object(InstrumentItemGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline InstrumentItemGuiFactory(const InstrumentItemGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InstrumentItemGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InstrumentItemGuiFactory null() {return InstrumentItemGuiFactory((InstrumentItemGuiFactory_base*)0);}
	inline static InstrumentItemGuiFactory _from_base(InstrumentItemGuiFactory_base* b) {return InstrumentItemGuiFactory(b);}
	inline InstrumentItemGuiFactory& operator=(const InstrumentItemGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline InstrumentItemGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class StereoEffectItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffectItem_base *_create(const std::string& subClass = "Arts::Environment::StereoEffectItem");
	static StereoEffectItem_base *_fromString(const std::string& objectref);
	static StereoEffectItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoEffectItem_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoEffectItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::SynthModule effect() = 0;
	virtual void effect(Arts::SynthModule newValue) = 0;
	virtual Arts::StereoEffectStack stack() = 0;
	virtual void stack(Arts::StereoEffectStack newValue) = 0;
};

class StereoEffectItem_stub : virtual public StereoEffectItem_base, virtual public Arts::Environment::Item_stub {
protected:
	StereoEffectItem_stub();

public:
	StereoEffectItem_stub(Arts::Connection *connection, long objectID);

	Arts::SynthModule effect();
	void effect(Arts::SynthModule newValue);
	Arts::StereoEffectStack stack();
	void stack(Arts::StereoEffectStack newValue);
};

class StereoEffectItem_skel : virtual public StereoEffectItem_base, virtual public Arts::Environment::Item_skel {
public:
	StereoEffectItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class StereoEffectItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffectItem_base *_cache;
	inline StereoEffectItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffectItem_base *)_pool->base->_cast(StereoEffectItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffectItem(StereoEffectItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoEffectItem_base _base_class;

	inline StereoEffectItem() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffectItem(const Arts::SubClass& s) :
		Arts::Object(StereoEffectItem_base::_create(s.string())), _cache(0) {}
	inline StereoEffectItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffectItem_base::_fromString(r.string())):(StereoEffectItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffectItem(const Arts::DynamicCast& c) : Arts::Object(StereoEffectItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoEffectItem(const StereoEffectItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffectItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffectItem null() {return StereoEffectItem((StereoEffectItem_base*)0);}
	inline static StereoEffectItem _from_base(StereoEffectItem_base* b) {return StereoEffectItem(b);}
	inline StereoEffectItem& operator=(const StereoEffectItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline StereoEffectItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline Arts::SynthModule effect();
	inline void effect(Arts::SynthModule _newValue);
	inline Arts::StereoEffectStack stack();
	inline void stack(Arts::StereoEffectStack _newValue);
};

class MixerChannel_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static MixerChannel_base *_create(const std::string& subClass = "Arts::Environment::MixerChannel");
	static MixerChannel_base *_fromString(const std::string& objectref);
	static MixerChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerChannel_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
};

class MixerChannel_stub : virtual public MixerChannel_base, virtual public Arts::StereoEffect_stub {
protected:
	MixerChannel_stub();

public:
	MixerChannel_stub(Arts::Connection *connection, long objectID);

	std::string name();
	void name(const std::string& newValue);
};

class MixerChannel_skel : virtual public MixerChannel_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	MixerChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class MixerChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerChannel_base *_cache;
	inline MixerChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerChannel_base *)_pool->base->_cast(MixerChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerChannel(MixerChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerChannel_base _base_class;

	inline MixerChannel() : Arts::Object(_Creator), _cache(0) {}
	inline MixerChannel(const Arts::SubClass& s) :
		Arts::Object(MixerChannel_base::_create(s.string())), _cache(0) {}
	inline MixerChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerChannel_base::_fromString(r.string())):(MixerChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerChannel(const Arts::DynamicCast& c) : Arts::Object(MixerChannel_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerChannel(const MixerChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerChannel null() {return MixerChannel((MixerChannel_base*)0);}
	inline static MixerChannel _from_base(MixerChannel_base* b) {return MixerChannel(b);}
	inline MixerChannel& operator=(const MixerChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MixerChannel_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string name();
	inline void name(const std::string& _newValue);
};

class MixerItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static MixerItem_base *_create(const std::string& subClass = "Arts::Environment::MixerItem");
	static MixerItem_base *_fromString(const std::string& objectref);
	static MixerItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerItem_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::Environment::MixerChannel> * channels() = 0;
	virtual long channelCount() = 0;
	virtual void channelCount(long newValue) = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual std::string type() = 0;
	virtual void type(const std::string& newValue) = 0;
};

class MixerItem_stub : virtual public MixerItem_base, virtual public Arts::Environment::Item_stub {
protected:
	MixerItem_stub();

public:
	MixerItem_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::Environment::MixerChannel> * channels();
	long channelCount();
	void channelCount(long newValue);
	std::string name();
	void name(const std::string& newValue);
	std::string type();
	void type(const std::string& newValue);
};

class MixerItem_skel : virtual public MixerItem_base, virtual public Arts::Environment::Item_skel {
protected:
	// emitters for change notifications
	inline void channelCount_changed(long newValue) {
		_emit_changed("channelCount_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void type_changed(const std::string& newValue) {
		_emit_changed("type_changed",newValue);
	}

public:
	MixerItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
};
#include "reference.h"
namespace Arts {
namespace Environment {
class MixerItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerItem_base *_cache;
	inline MixerItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerItem_base *)_pool->base->_cast(MixerItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerItem(MixerItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerItem_base _base_class;

	inline MixerItem() : Arts::Object(_Creator), _cache(0) {}
	inline MixerItem(const Arts::SubClass& s) :
		Arts::Object(MixerItem_base::_create(s.string())), _cache(0) {}
	inline MixerItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerItem_base::_fromString(r.string())):(MixerItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerItem(const Arts::DynamicCast& c) : Arts::Object(MixerItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerItem(const MixerItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerItem null() {return MixerItem((MixerItem_base*)0);}
	inline static MixerItem _from_base(MixerItem_base* b) {return MixerItem(b);}
	inline MixerItem& operator=(const MixerItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline MixerItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline std::vector<Arts::Environment::MixerChannel> * channels();
	inline long channelCount();
	inline void channelCount(long _newValue);
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline std::string type();
	inline void type(const std::string& _newValue);
};

};
class SimpleMixerChannel_base : virtual public Arts::Environment::MixerChannel_base {
public:
	static unsigned long _IID; // interface ID

	static SimpleMixerChannel_base *_create(const std::string& subClass = "Arts::SimpleMixerChannel");
	static SimpleMixerChannel_base *_fromString(const std::string& objectref);
	static SimpleMixerChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SimpleMixerChannel_base *_fromDynamicCast(const Arts::Object& object);
	inline SimpleMixerChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Synth_STD_EQUALIZER equalizerLeft() = 0;
	virtual Arts::Synth_STD_EQUALIZER equalizerRight() = 0;
	virtual Arts::StereoEffectStack insertEffects() = 0;
	virtual float gainLeft() = 0;
	virtual void gainLeft(float newValue) = 0;
	virtual float gainRight() = 0;
	virtual void gainRight(float newValue) = 0;
	virtual float pan() = 0;
	virtual void pan(float newValue) = 0;
	virtual float volumeLeft() = 0;
	virtual void volumeLeft(float newValue) = 0;
	virtual float volumeRight() = 0;
	virtual void volumeRight(float newValue) = 0;
};

class SimpleMixerChannel_stub : virtual public SimpleMixerChannel_base, virtual public Arts::Environment::MixerChannel_stub {
protected:
	SimpleMixerChannel_stub();

public:
	SimpleMixerChannel_stub(Arts::Connection *connection, long objectID);

	Arts::Synth_STD_EQUALIZER equalizerLeft();
	Arts::Synth_STD_EQUALIZER equalizerRight();
	Arts::StereoEffectStack insertEffects();
	float gainLeft();
	void gainLeft(float newValue);
	float gainRight();
	void gainRight(float newValue);
	float pan();
	void pan(float newValue);
	float volumeLeft();
	void volumeLeft(float newValue);
	float volumeRight();
	void volumeRight(float newValue);
};

class SimpleMixerChannel_skel : virtual public SimpleMixerChannel_base, virtual public Arts::Environment::MixerChannel_skel {
protected:
	// emitters for change notifications
	inline void gainLeft_changed(float newValue) {
		_emit_changed("gainLeft_changed",newValue);
	}
	inline void gainRight_changed(float newValue) {
		_emit_changed("gainRight_changed",newValue);
	}
	inline void pan_changed(float newValue) {
		_emit_changed("pan_changed",newValue);
	}
	inline void volumeLeft_changed(float newValue) {
		_emit_changed("volumeLeft_changed",newValue);
	}
	inline void volumeRight_changed(float newValue) {
		_emit_changed("volumeRight_changed",newValue);
	}

public:
	SimpleMixerChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SimpleMixerChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SimpleMixerChannel_base *_cache;
	inline SimpleMixerChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SimpleMixerChannel_base *)_pool->base->_cast(SimpleMixerChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SimpleMixerChannel(SimpleMixerChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SimpleMixerChannel_base _base_class;

	inline SimpleMixerChannel() : Arts::Object(_Creator), _cache(0) {}
	inline SimpleMixerChannel(const Arts::SubClass& s) :
		Arts::Object(SimpleMixerChannel_base::_create(s.string())), _cache(0) {}
	inline SimpleMixerChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SimpleMixerChannel_base::_fromString(r.string())):(SimpleMixerChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SimpleMixerChannel(const Arts::DynamicCast& c) : Arts::Object(SimpleMixerChannel_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SimpleMixerChannel(const SimpleMixerChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SimpleMixerChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SimpleMixerChannel null() {return SimpleMixerChannel((SimpleMixerChannel_base*)0);}
	inline static SimpleMixerChannel _from_base(SimpleMixerChannel_base* b) {return SimpleMixerChannel(b);}
	inline SimpleMixerChannel& operator=(const SimpleMixerChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::MixerChannel() const { return Arts::Environment::MixerChannel(*_pool); }
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline SimpleMixerChannel_base* _base() {return _cache?_cache:_method_call();}

	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::Synth_STD_EQUALIZER equalizerLeft();
	inline Arts::Synth_STD_EQUALIZER equalizerRight();
	inline Arts::StereoEffectStack insertEffects();
	inline float gainLeft();
	inline void gainLeft(float _newValue);
	inline float gainRight();
	inline void gainRight(float _newValue);
	inline float pan();
	inline void pan(float _newValue);
	inline float volumeLeft();
	inline void volumeLeft(float _newValue);
	inline float volumeRight();
	inline void volumeRight(float _newValue);
};

class MonoSimpleMixerChannel_base : virtual public Arts::Environment::MixerChannel_base {
public:
	static unsigned long _IID; // interface ID

	static MonoSimpleMixerChannel_base *_create(const std::string& subClass = "Arts::MonoSimpleMixerChannel");
	static MonoSimpleMixerChannel_base *_fromString(const std::string& objectref);
	static MonoSimpleMixerChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MonoSimpleMixerChannel_base *_fromDynamicCast(const Arts::Object& object);
	inline MonoSimpleMixerChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Synth_STD_EQUALIZER equalizer() = 0;
	virtual Arts::StereoEffectStack insertEffects() = 0;
	virtual float gain() = 0;
	virtual void gain(float newValue) = 0;
	virtual float pan() = 0;
	virtual void pan(float newValue) = 0;
	virtual float volume() = 0;
	virtual void volume(float newValue) = 0;
};

class MonoSimpleMixerChannel_stub : virtual public MonoSimpleMixerChannel_base, virtual public Arts::Environment::MixerChannel_stub {
protected:
	MonoSimpleMixerChannel_stub();

public:
	MonoSimpleMixerChannel_stub(Arts::Connection *connection, long objectID);

	Arts::Synth_STD_EQUALIZER equalizer();
	Arts::StereoEffectStack insertEffects();
	float gain();
	void gain(float newValue);
	float pan();
	void pan(float newValue);
	float volume();
	void volume(float newValue);
};

class MonoSimpleMixerChannel_skel : virtual public MonoSimpleMixerChannel_base, virtual public Arts::Environment::MixerChannel_skel {
protected:
	// emitters for change notifications
	inline void gain_changed(float newValue) {
		_emit_changed("gain_changed",newValue);
	}
	inline void pan_changed(float newValue) {
		_emit_changed("pan_changed",newValue);
	}
	inline void volume_changed(float newValue) {
		_emit_changed("volume_changed",newValue);
	}

public:
	MonoSimpleMixerChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MonoSimpleMixerChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MonoSimpleMixerChannel_base *_cache;
	inline MonoSimpleMixerChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MonoSimpleMixerChannel_base *)_pool->base->_cast(MonoSimpleMixerChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MonoSimpleMixerChannel(MonoSimpleMixerChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MonoSimpleMixerChannel_base _base_class;

	inline MonoSimpleMixerChannel() : Arts::Object(_Creator), _cache(0) {}
	inline MonoSimpleMixerChannel(const Arts::SubClass& s) :
		Arts::Object(MonoSimpleMixerChannel_base::_create(s.string())), _cache(0) {}
	inline MonoSimpleMixerChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MonoSimpleMixerChannel_base::_fromString(r.string())):(MonoSimpleMixerChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MonoSimpleMixerChannel(const Arts::DynamicCast& c) : Arts::Object(MonoSimpleMixerChannel_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MonoSimpleMixerChannel(const MonoSimpleMixerChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MonoSimpleMixerChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MonoSimpleMixerChannel null() {return MonoSimpleMixerChannel((MonoSimpleMixerChannel_base*)0);}
	inline static MonoSimpleMixerChannel _from_base(MonoSimpleMixerChannel_base* b) {return MonoSimpleMixerChannel(b);}
	inline MonoSimpleMixerChannel& operator=(const MonoSimpleMixerChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::MixerChannel() const { return Arts::Environment::MixerChannel(*_pool); }
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MonoSimpleMixerChannel_base* _base() {return _cache?_cache:_method_call();}

	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::Synth_STD_EQUALIZER equalizer();
	inline Arts::StereoEffectStack insertEffects();
	inline float gain();
	inline void gain(float _newValue);
	inline float pan();
	inline void pan(float _newValue);
	inline float volume();
	inline void volume(float _newValue);
};

class Synth_AUX_BUS_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_AUX_BUS_base *_create(const std::string& subClass = "Arts::Synth_AUX_BUS");
	static Synth_AUX_BUS_base *_fromString(const std::string& objectref);
	static Synth_AUX_BUS_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_AUX_BUS_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_AUX_BUS_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float level() = 0;
	virtual void level(float newValue) = 0;
	virtual long channel() = 0;
	virtual void channel(long newValue) = 0;
};

class Synth_AUX_BUS_stub : virtual public Synth_AUX_BUS_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_AUX_BUS_stub();

public:
	Synth_AUX_BUS_stub(Arts::Connection *connection, long objectID);

	float level();
	void level(float newValue);
	long channel();
	void channel(long newValue);
};

class Synth_AUX_BUS_skel : virtual public Synth_AUX_BUS_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream

protected:
	// emitters for change notifications
	inline void level_changed(float newValue) {
		_emit_changed("level_changed",newValue);
	}
	inline void channel_changed(long newValue) {
		_emit_changed("channel_changed",newValue);
	}

public:
	Synth_AUX_BUS_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_AUX_BUS : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_AUX_BUS_base *_cache;
	inline Synth_AUX_BUS_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_AUX_BUS_base *)_pool->base->_cast(Synth_AUX_BUS_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_AUX_BUS(Synth_AUX_BUS_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_AUX_BUS_base _base_class;

	inline Synth_AUX_BUS() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_AUX_BUS(const Arts::SubClass& s) :
		Arts::Object(Synth_AUX_BUS_base::_create(s.string())), _cache(0) {}
	inline Synth_AUX_BUS(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_AUX_BUS_base::_fromString(r.string())):(Synth_AUX_BUS_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_AUX_BUS(const Arts::DynamicCast& c) : Arts::Object(Synth_AUX_BUS_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_AUX_BUS(const Synth_AUX_BUS& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_AUX_BUS(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_AUX_BUS null() {return Synth_AUX_BUS((Synth_AUX_BUS_base*)0);}
	inline static Synth_AUX_BUS _from_base(Synth_AUX_BUS_base* b) {return Synth_AUX_BUS(b);}
	inline Synth_AUX_BUS& operator=(const Synth_AUX_BUS& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_AUX_BUS_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float level();
	inline void level(float _newValue);
	inline long channel();
	inline void channel(long _newValue);
};

class MonoComplexMixerChannel_base : virtual public Arts::Environment::MixerChannel_base {
public:
	static unsigned long _IID; // interface ID

	static MonoComplexMixerChannel_base *_create(const std::string& subClass = "Arts::MonoComplexMixerChannel");
	static MonoComplexMixerChannel_base *_fromString(const std::string& objectref);
	static MonoComplexMixerChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MonoComplexMixerChannel_base *_fromDynamicCast(const Arts::Object& object);
	inline MonoComplexMixerChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Synth_STD_EQUALIZER equalizer() = 0;
	virtual Arts::StereoEffectStack insertEffects() = 0;
	virtual std::vector<Arts::Synth_AUX_BUS> * aux() = 0;
	virtual float gain() = 0;
	virtual void gain(float newValue) = 0;
	virtual float volume() = 0;
	virtual void volume(float newValue) = 0;
	virtual float pan() = 0;
	virtual void pan(float newValue) = 0;
	virtual bool mute() = 0;
	virtual void mute(bool newValue) = 0;
	virtual bool pfl() = 0;
	virtual void pfl(bool newValue) = 0;
};

class MonoComplexMixerChannel_stub : virtual public MonoComplexMixerChannel_base, virtual public Arts::Environment::MixerChannel_stub {
protected:
	MonoComplexMixerChannel_stub();

public:
	MonoComplexMixerChannel_stub(Arts::Connection *connection, long objectID);

	Arts::Synth_STD_EQUALIZER equalizer();
	Arts::StereoEffectStack insertEffects();
	std::vector<Arts::Synth_AUX_BUS> * aux();
	float gain();
	void gain(float newValue);
	float volume();
	void volume(float newValue);
	float pan();
	void pan(float newValue);
	bool mute();
	void mute(bool newValue);
	bool pfl();
	void pfl(bool newValue);
};

class MonoComplexMixerChannel_skel : virtual public MonoComplexMixerChannel_base, virtual public Arts::Environment::MixerChannel_skel {
protected:
	// emitters for change notifications
	inline void gain_changed(float newValue) {
		_emit_changed("gain_changed",newValue);
	}
	inline void volume_changed(float newValue) {
		_emit_changed("volume_changed",newValue);
	}
	inline void pan_changed(float newValue) {
		_emit_changed("pan_changed",newValue);
	}
	inline void mute_changed(bool newValue) {
		_emit_changed("mute_changed",newValue);
	}
	inline void pfl_changed(bool newValue) {
		_emit_changed("pfl_changed",newValue);
	}

public:
	MonoComplexMixerChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MonoComplexMixerChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MonoComplexMixerChannel_base *_cache;
	inline MonoComplexMixerChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MonoComplexMixerChannel_base *)_pool->base->_cast(MonoComplexMixerChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MonoComplexMixerChannel(MonoComplexMixerChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MonoComplexMixerChannel_base _base_class;

	inline MonoComplexMixerChannel() : Arts::Object(_Creator), _cache(0) {}
	inline MonoComplexMixerChannel(const Arts::SubClass& s) :
		Arts::Object(MonoComplexMixerChannel_base::_create(s.string())), _cache(0) {}
	inline MonoComplexMixerChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MonoComplexMixerChannel_base::_fromString(r.string())):(MonoComplexMixerChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MonoComplexMixerChannel(const Arts::DynamicCast& c) : Arts::Object(MonoComplexMixerChannel_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MonoComplexMixerChannel(const MonoComplexMixerChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MonoComplexMixerChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MonoComplexMixerChannel null() {return MonoComplexMixerChannel((MonoComplexMixerChannel_base*)0);}
	inline static MonoComplexMixerChannel _from_base(MonoComplexMixerChannel_base* b) {return MonoComplexMixerChannel(b);}
	inline MonoComplexMixerChannel& operator=(const MonoComplexMixerChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::MixerChannel() const { return Arts::Environment::MixerChannel(*_pool); }
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MonoComplexMixerChannel_base* _base() {return _cache?_cache:_method_call();}

	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::Synth_STD_EQUALIZER equalizer();
	inline Arts::StereoEffectStack insertEffects();
	inline std::vector<Arts::Synth_AUX_BUS> * aux();
	inline float gain();
	inline void gain(float _newValue);
	inline float volume();
	inline void volume(float _newValue);
	inline float pan();
	inline void pan(float _newValue);
	inline bool mute();
	inline void mute(bool _newValue);
	inline bool pfl();
	inline void pfl(bool _newValue);
};

class MixerGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static MixerGuiFactory_base *_create(const std::string& subClass = "Arts::MixerGuiFactory");
	static MixerGuiFactory_base *_fromString(const std::string& objectref);
	static MixerGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class MixerGuiFactory_stub : virtual public MixerGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	MixerGuiFactory_stub();

public:
	MixerGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class MixerGuiFactory_skel : virtual public MixerGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	MixerGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MixerGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerGuiFactory_base *_cache;
	inline MixerGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerGuiFactory_base *)_pool->base->_cast(MixerGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerGuiFactory(MixerGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerGuiFactory_base _base_class;

	inline MixerGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline MixerGuiFactory(const Arts::SubClass& s) :
		Arts::Object(MixerGuiFactory_base::_create(s.string())), _cache(0) {}
	inline MixerGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerGuiFactory_base::_fromString(r.string())):(MixerGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerGuiFactory(const Arts::DynamicCast& c) : Arts::Object(MixerGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerGuiFactory(const MixerGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerGuiFactory null() {return MixerGuiFactory((MixerGuiFactory_base*)0);}
	inline static MixerGuiFactory _from_base(MixerGuiFactory_base* b) {return MixerGuiFactory(b);}
	inline MixerGuiFactory& operator=(const MixerGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline MixerGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class MonoSimpleMixerChannelGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static MonoSimpleMixerChannelGuiFactory_base *_create(const std::string& subClass = "Arts::MonoSimpleMixerChannelGuiFactory");
	static MonoSimpleMixerChannelGuiFactory_base *_fromString(const std::string& objectref);
	static MonoSimpleMixerChannelGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MonoSimpleMixerChannelGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline MonoSimpleMixerChannelGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class MonoSimpleMixerChannelGuiFactory_stub : virtual public MonoSimpleMixerChannelGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	MonoSimpleMixerChannelGuiFactory_stub();

public:
	MonoSimpleMixerChannelGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class MonoSimpleMixerChannelGuiFactory_skel : virtual public MonoSimpleMixerChannelGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	MonoSimpleMixerChannelGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MonoSimpleMixerChannelGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MonoSimpleMixerChannelGuiFactory_base *_cache;
	inline MonoSimpleMixerChannelGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MonoSimpleMixerChannelGuiFactory_base *)_pool->base->_cast(MonoSimpleMixerChannelGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MonoSimpleMixerChannelGuiFactory(MonoSimpleMixerChannelGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MonoSimpleMixerChannelGuiFactory_base _base_class;

	inline MonoSimpleMixerChannelGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline MonoSimpleMixerChannelGuiFactory(const Arts::SubClass& s) :
		Arts::Object(MonoSimpleMixerChannelGuiFactory_base::_create(s.string())), _cache(0) {}
	inline MonoSimpleMixerChannelGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MonoSimpleMixerChannelGuiFactory_base::_fromString(r.string())):(MonoSimpleMixerChannelGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MonoSimpleMixerChannelGuiFactory(const Arts::DynamicCast& c) : Arts::Object(MonoSimpleMixerChannelGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MonoSimpleMixerChannelGuiFactory(const MonoSimpleMixerChannelGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MonoSimpleMixerChannelGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MonoSimpleMixerChannelGuiFactory null() {return MonoSimpleMixerChannelGuiFactory((MonoSimpleMixerChannelGuiFactory_base*)0);}
	inline static MonoSimpleMixerChannelGuiFactory _from_base(MonoSimpleMixerChannelGuiFactory_base* b) {return MonoSimpleMixerChannelGuiFactory(b);}
	inline MonoSimpleMixerChannelGuiFactory& operator=(const MonoSimpleMixerChannelGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline MonoSimpleMixerChannelGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class SimpleMixerChannelGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static SimpleMixerChannelGuiFactory_base *_create(const std::string& subClass = "Arts::SimpleMixerChannelGuiFactory");
	static SimpleMixerChannelGuiFactory_base *_fromString(const std::string& objectref);
	static SimpleMixerChannelGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SimpleMixerChannelGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline SimpleMixerChannelGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class SimpleMixerChannelGuiFactory_stub : virtual public SimpleMixerChannelGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	SimpleMixerChannelGuiFactory_stub();

public:
	SimpleMixerChannelGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class SimpleMixerChannelGuiFactory_skel : virtual public SimpleMixerChannelGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	SimpleMixerChannelGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SimpleMixerChannelGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SimpleMixerChannelGuiFactory_base *_cache;
	inline SimpleMixerChannelGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SimpleMixerChannelGuiFactory_base *)_pool->base->_cast(SimpleMixerChannelGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SimpleMixerChannelGuiFactory(SimpleMixerChannelGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SimpleMixerChannelGuiFactory_base _base_class;

	inline SimpleMixerChannelGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline SimpleMixerChannelGuiFactory(const Arts::SubClass& s) :
		Arts::Object(SimpleMixerChannelGuiFactory_base::_create(s.string())), _cache(0) {}
	inline SimpleMixerChannelGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SimpleMixerChannelGuiFactory_base::_fromString(r.string())):(SimpleMixerChannelGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SimpleMixerChannelGuiFactory(const Arts::DynamicCast& c) : Arts::Object(SimpleMixerChannelGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SimpleMixerChannelGuiFactory(const SimpleMixerChannelGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SimpleMixerChannelGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SimpleMixerChannelGuiFactory null() {return SimpleMixerChannelGuiFactory((SimpleMixerChannelGuiFactory_base*)0);}
	inline static SimpleMixerChannelGuiFactory _from_base(SimpleMixerChannelGuiFactory_base* b) {return SimpleMixerChannelGuiFactory(b);}
	inline SimpleMixerChannelGuiFactory& operator=(const SimpleMixerChannelGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline SimpleMixerChannelGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class MixerItemGui_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MixerItemGui_base *_create(const std::string& subClass = "Arts::MixerItemGui");
	static MixerItemGui_base *_fromString(const std::string& objectref);
	static MixerItemGui_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerItemGui_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerItemGui_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool active() = 0;
	virtual void active(bool newValue) = 0;
	virtual long channelCount() = 0;
	virtual void channelCount(long newValue) = 0;
	virtual std::string type() = 0;
	virtual void type(const std::string& newValue) = 0;
	virtual Arts::Widget initialize(Arts::Environment::MixerItem item) = 0;
};

class MixerItemGui_stub : virtual public MixerItemGui_base, virtual public Arts::Object_stub {
protected:
	MixerItemGui_stub();

public:
	MixerItemGui_stub(Arts::Connection *connection, long objectID);

	bool active();
	void active(bool newValue);
	long channelCount();
	void channelCount(long newValue);
	std::string type();
	void type(const std::string& newValue);
	Arts::Widget initialize(Arts::Environment::MixerItem item);
};

class MixerItemGui_skel : virtual public MixerItemGui_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}
	inline void channelCount_changed(long newValue) {
		_emit_changed("channelCount_changed",newValue);
	}
	inline void type_changed(const std::string& newValue) {
		_emit_changed("type_changed",newValue);
	}

public:
	MixerItemGui_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MixerItemGui : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerItemGui_base *_cache;
	inline MixerItemGui_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerItemGui_base *)_pool->base->_cast(MixerItemGui_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerItemGui(MixerItemGui_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerItemGui_base _base_class;

	inline MixerItemGui() : Arts::Object(_Creator), _cache(0) {}
	inline MixerItemGui(const Arts::SubClass& s) :
		Arts::Object(MixerItemGui_base::_create(s.string())), _cache(0) {}
	inline MixerItemGui(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerItemGui_base::_fromString(r.string())):(MixerItemGui_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerItemGui(const Arts::DynamicCast& c) : Arts::Object(MixerItemGui_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerItemGui(const MixerItemGui& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerItemGui(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerItemGui null() {return MixerItemGui((MixerItemGui_base*)0);}
	inline static MixerItemGui _from_base(MixerItemGui_base* b) {return MixerItemGui(b);}
	inline MixerItemGui& operator=(const MixerItemGui& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MixerItemGui_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline void active(bool _newValue);
	inline long channelCount();
	inline void channelCount(long _newValue);
	inline std::string type();
	inline void type(const std::string& _newValue);
	inline Arts::Widget initialize(Arts::Environment::MixerItem item);
};

class ObjectCache_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static ObjectCache_base *_create(const std::string& subClass = "Arts::ObjectCache");
	static ObjectCache_base *_fromString(const std::string& objectref);
	static ObjectCache_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ObjectCache_base *_fromDynamicCast(const Arts::Object& object);
	inline ObjectCache_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void put(Arts::Object obj, const std::string& name) = 0;
	virtual Arts::Object get(const std::string& name) = 0;
};

class ObjectCache_stub : virtual public ObjectCache_base, virtual public Arts::Object_stub {
protected:
	ObjectCache_stub();

public:
	ObjectCache_stub(Arts::Connection *connection, long objectID);

	void put(Arts::Object obj, const std::string& name);
	Arts::Object get(const std::string& name);
};

class ObjectCache_skel : virtual public ObjectCache_base, virtual public Arts::Object_skel {
public:
	ObjectCache_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class ObjectCache : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ObjectCache_base *_cache;
	inline ObjectCache_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ObjectCache_base *)_pool->base->_cast(ObjectCache_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ObjectCache(ObjectCache_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ObjectCache_base _base_class;

	inline ObjectCache() : Arts::Object(_Creator), _cache(0) {}
	inline ObjectCache(const Arts::SubClass& s) :
		Arts::Object(ObjectCache_base::_create(s.string())), _cache(0) {}
	inline ObjectCache(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ObjectCache_base::_fromString(r.string())):(ObjectCache_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ObjectCache(const Arts::DynamicCast& c) : Arts::Object(ObjectCache_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ObjectCache(const ObjectCache& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ObjectCache(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ObjectCache null() {return ObjectCache((ObjectCache_base*)0);}
	inline static ObjectCache _from_base(ObjectCache_base* b) {return ObjectCache(b);}
	inline ObjectCache& operator=(const ObjectCache& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline ObjectCache_base* _base() {return _cache?_cache:_method_call();}

	inline void put(Arts::Object obj, const std::string& name);
	inline Arts::Object get(const std::string& name);
};

class MidiReleaseHelper_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static MidiReleaseHelper_base *_create(const std::string& subClass = "Arts::MidiReleaseHelper");
	static MidiReleaseHelper_base *_fromString(const std::string& objectref);
	static MidiReleaseHelper_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiReleaseHelper_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiReleaseHelper_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::SynthModule voice() = 0;
	virtual void voice(Arts::SynthModule newValue) = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual Arts::ObjectCache cache() = 0;
	virtual void cache(Arts::ObjectCache newValue) = 0;
	virtual bool terminate() = 0;
};

class MidiReleaseHelper_stub : virtual public MidiReleaseHelper_base, virtual public Arts::SynthModule_stub {
protected:
	MidiReleaseHelper_stub();

public:
	MidiReleaseHelper_stub(Arts::Connection *connection, long objectID);

	Arts::SynthModule voice();
	void voice(Arts::SynthModule newValue);
	std::string name();
	void name(const std::string& newValue);
	Arts::ObjectCache cache();
	void cache(Arts::ObjectCache newValue);
	bool terminate();
};

class MidiReleaseHelper_skel : virtual public MidiReleaseHelper_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *done;                              // incoming stream

protected:
	// emitters for change notifications
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	MidiReleaseHelper_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiReleaseHelper : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiReleaseHelper_base *_cache;
	inline MidiReleaseHelper_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiReleaseHelper_base *)_pool->base->_cast(MidiReleaseHelper_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiReleaseHelper(MidiReleaseHelper_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiReleaseHelper_base _base_class;

	inline MidiReleaseHelper() : Arts::Object(_Creator), _cache(0) {}
	inline MidiReleaseHelper(const Arts::SubClass& s) :
		Arts::Object(MidiReleaseHelper_base::_create(s.string())), _cache(0) {}
	inline MidiReleaseHelper(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiReleaseHelper_base::_fromString(r.string())):(MidiReleaseHelper_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiReleaseHelper(const Arts::DynamicCast& c) : Arts::Object(MidiReleaseHelper_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiReleaseHelper(const MidiReleaseHelper& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiReleaseHelper(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiReleaseHelper null() {return MidiReleaseHelper((MidiReleaseHelper_base*)0);}
	inline static MidiReleaseHelper _from_base(MidiReleaseHelper_base* b) {return MidiReleaseHelper(b);}
	inline MidiReleaseHelper& operator=(const MidiReleaseHelper& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MidiReleaseHelper_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::SynthModule voice();
	inline void voice(Arts::SynthModule _newValue);
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::ObjectCache cache();
	inline void cache(Arts::ObjectCache _newValue);
	inline bool terminate();
};

class Synth_CAPTURE_WAV_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_CAPTURE_WAV_base *_create(const std::string& subClass = "Arts::Synth_CAPTURE_WAV");
	static Synth_CAPTURE_WAV_base *_fromString(const std::string& objectref);
	static Synth_CAPTURE_WAV_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_CAPTURE_WAV_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_CAPTURE_WAV_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
};

class Synth_CAPTURE_WAV_stub : virtual public Synth_CAPTURE_WAV_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_CAPTURE_WAV_stub();

public:
	Synth_CAPTURE_WAV_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
};

class Synth_CAPTURE_WAV_skel : virtual public Synth_CAPTURE_WAV_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // incoming stream
	float *right;                             // incoming stream

protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}

public:
	Synth_CAPTURE_WAV_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_CAPTURE_WAV : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_CAPTURE_WAV_base *_cache;
	inline Synth_CAPTURE_WAV_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_CAPTURE_WAV_base *)_pool->base->_cast(Synth_CAPTURE_WAV_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_CAPTURE_WAV(Synth_CAPTURE_WAV_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_CAPTURE_WAV_base _base_class;

	inline Synth_CAPTURE_WAV() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::SubClass& s) :
		Arts::Object(Synth_CAPTURE_WAV_base::_create(s.string())), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_CAPTURE_WAV_base::_fromString(r.string())):(Synth_CAPTURE_WAV_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::DynamicCast& c) : Arts::Object(Synth_CAPTURE_WAV_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Synth_CAPTURE_WAV& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_CAPTURE_WAV(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_CAPTURE_WAV null() {return Synth_CAPTURE_WAV((Synth_CAPTURE_WAV_base*)0);}
	inline static Synth_CAPTURE_WAV _from_base(Synth_CAPTURE_WAV_base* b) {return Synth_CAPTURE_WAV(b);}
	inline Synth_CAPTURE_WAV& operator=(const Synth_CAPTURE_WAV& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_CAPTURE_WAV_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
};

class Synth_COMPRESSOR_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_COMPRESSOR_base *_create(const std::string& subClass = "Arts::Synth_COMPRESSOR");
	static Synth_COMPRESSOR_base *_fromString(const std::string& objectref);
	static Synth_COMPRESSOR_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_COMPRESSOR_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_COMPRESSOR_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float attack() = 0;
	virtual void attack(float newValue) = 0;
	virtual float release() = 0;
	virtual void release(float newValue) = 0;
	virtual float threshold() = 0;
	virtual void threshold(float newValue) = 0;
	virtual float ratio() = 0;
	virtual void ratio(float newValue) = 0;
	virtual float output() = 0;
	virtual void output(float newValue) = 0;
};

class Synth_COMPRESSOR_stub : virtual public Synth_COMPRESSOR_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_COMPRESSOR_stub();

public:
	Synth_COMPRESSOR_stub(Arts::Connection *connection, long objectID);

	float attack();
	void attack(float newValue);
	float release();
	void release(float newValue);
	float threshold();
	void threshold(float newValue);
	float ratio();
	void ratio(float newValue);
	float output();
	void output(float newValue);
};

class Synth_COMPRESSOR_skel : virtual public Synth_COMPRESSOR_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void attack_changed(float newValue) {
		_emit_changed("attack_changed",newValue);
	}
	inline void release_changed(float newValue) {
		_emit_changed("release_changed",newValue);
	}
	inline void threshold_changed(float newValue) {
		_emit_changed("threshold_changed",newValue);
	}
	inline void ratio_changed(float newValue) {
		_emit_changed("ratio_changed",newValue);
	}
	inline void output_changed(float newValue) {
		_emit_changed("output_changed",newValue);
	}

public:
	Synth_COMPRESSOR_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_COMPRESSOR : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_COMPRESSOR_base *_cache;
	inline Synth_COMPRESSOR_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_COMPRESSOR_base *)_pool->base->_cast(Synth_COMPRESSOR_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_COMPRESSOR(Synth_COMPRESSOR_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_COMPRESSOR_base _base_class;

	inline Synth_COMPRESSOR() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_COMPRESSOR(const Arts::SubClass& s) :
		Arts::Object(Synth_COMPRESSOR_base::_create(s.string())), _cache(0) {}
	inline Synth_COMPRESSOR(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_COMPRESSOR_base::_fromString(r.string())):(Synth_COMPRESSOR_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_COMPRESSOR(const Arts::DynamicCast& c) : Arts::Object(Synth_COMPRESSOR_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_COMPRESSOR(const Synth_COMPRESSOR& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_COMPRESSOR(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_COMPRESSOR null() {return Synth_COMPRESSOR((Synth_COMPRESSOR_base*)0);}
	inline static Synth_COMPRESSOR _from_base(Synth_COMPRESSOR_base* b) {return Synth_COMPRESSOR(b);}
	inline Synth_COMPRESSOR& operator=(const Synth_COMPRESSOR& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_COMPRESSOR_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float attack();
	inline void attack(float _newValue);
	inline float release();
	inline void release(float _newValue);
	inline float threshold();
	inline void threshold(float _newValue);
	inline float ratio();
	inline void ratio(float _newValue);
	inline float output();
	inline void output(float _newValue);
};

class Synth_NIL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_NIL_base *_create(const std::string& subClass = "Arts::Synth_NIL");
	static Synth_NIL_base *_fromString(const std::string& objectref);
	static Synth_NIL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_NIL_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_NIL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_NIL_stub : virtual public Synth_NIL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_NIL_stub();

public:
	Synth_NIL_stub(Arts::Connection *connection, long objectID);

};

class Synth_NIL_skel : virtual public Synth_NIL_base, virtual public Arts::SynthModule_skel {
public:
	Synth_NIL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_NIL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_NIL_base *_cache;
	inline Synth_NIL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_NIL_base *)_pool->base->_cast(Synth_NIL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_NIL(Synth_NIL_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_NIL_base _base_class;

	inline Synth_NIL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_NIL(const Arts::SubClass& s) :
		Arts::Object(Synth_NIL_base::_create(s.string())), _cache(0) {}
	inline Synth_NIL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_NIL_base::_fromString(r.string())):(Synth_NIL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_NIL(const Arts::DynamicCast& c) : Arts::Object(Synth_NIL_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_NIL(const Synth_NIL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_NIL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_NIL null() {return Synth_NIL((Synth_NIL_base*)0);}
	inline static Synth_NIL _from_base(Synth_NIL_base* b) {return Synth_NIL(b);}
	inline Synth_NIL& operator=(const Synth_NIL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_NIL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_DEBUG_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DEBUG_base *_create(const std::string& subClass = "Arts::Synth_DEBUG");
	static Synth_DEBUG_base *_fromString(const std::string& objectref);
	static Synth_DEBUG_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_DEBUG_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_DEBUG_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string comment() = 0;
	virtual void comment(const std::string& newValue) = 0;
};

class Synth_DEBUG_stub : virtual public Synth_DEBUG_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DEBUG_stub();

public:
	Synth_DEBUG_stub(Arts::Connection *connection, long objectID);

	std::string comment();
	void comment(const std::string& newValue);
};

class Synth_DEBUG_skel : virtual public Synth_DEBUG_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream

protected:
	// emitters for change notifications
	inline void comment_changed(const std::string& newValue) {
		_emit_changed("comment_changed",newValue);
	}

public:
	Synth_DEBUG_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DEBUG : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DEBUG_base *_cache;
	inline Synth_DEBUG_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DEBUG_base *)_pool->base->_cast(Synth_DEBUG_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DEBUG(Synth_DEBUG_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DEBUG_base _base_class;

	inline Synth_DEBUG() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DEBUG(const Arts::SubClass& s) :
		Arts::Object(Synth_DEBUG_base::_create(s.string())), _cache(0) {}
	inline Synth_DEBUG(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DEBUG_base::_fromString(r.string())):(Synth_DEBUG_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DEBUG(const Arts::DynamicCast& c) : Arts::Object(Synth_DEBUG_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_DEBUG(const Synth_DEBUG& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DEBUG(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DEBUG null() {return Synth_DEBUG((Synth_DEBUG_base*)0);}
	inline static Synth_DEBUG _from_base(Synth_DEBUG_base* b) {return Synth_DEBUG(b);}
	inline Synth_DEBUG& operator=(const Synth_DEBUG& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DEBUG_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string comment();
	inline void comment(const std::string& _newValue);
};

class Synth_DATA_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DATA_base *_create(const std::string& subClass = "Arts::Synth_DATA");
	static Synth_DATA_base *_fromString(const std::string& objectref);
	static Synth_DATA_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_DATA_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_DATA_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float value() = 0;
	virtual void value(float newValue) = 0;
};

class Synth_DATA_stub : virtual public Synth_DATA_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DATA_stub();

public:
	Synth_DATA_stub(Arts::Connection *connection, long objectID);

	float value();
	void value(float newValue);
};

class Synth_DATA_skel : virtual public Synth_DATA_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void value_changed(float newValue) {
		_emit_changed("value_changed",newValue);
	}

public:
	Synth_DATA_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DATA : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DATA_base *_cache;
	inline Synth_DATA_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DATA_base *)_pool->base->_cast(Synth_DATA_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DATA(Synth_DATA_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DATA_base _base_class;

	inline Synth_DATA() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DATA(const Arts::SubClass& s) :
		Arts::Object(Synth_DATA_base::_create(s.string())), _cache(0) {}
	inline Synth_DATA(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DATA_base::_fromString(r.string())):(Synth_DATA_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DATA(const Arts::DynamicCast& c) : Arts::Object(Synth_DATA_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_DATA(const Synth_DATA& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DATA(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DATA null() {return Synth_DATA((Synth_DATA_base*)0);}
	inline static Synth_DATA _from_base(Synth_DATA_base* b) {return Synth_DATA(b);}
	inline Synth_DATA& operator=(const Synth_DATA& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DATA_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float value();
	inline void value(float _newValue);
};

class Synth_ATAN_SATURATE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ATAN_SATURATE_base *_create(const std::string& subClass = "Arts::Synth_ATAN_SATURATE");
	static Synth_ATAN_SATURATE_base *_fromString(const std::string& objectref);
	static Synth_ATAN_SATURATE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_ATAN_SATURATE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_ATAN_SATURATE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float inscale() = 0;
	virtual void inscale(float newValue) = 0;
};

class Synth_ATAN_SATURATE_stub : virtual public Synth_ATAN_SATURATE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ATAN_SATURATE_stub();

public:
	Synth_ATAN_SATURATE_stub(Arts::Connection *connection, long objectID);

	float inscale();
	void inscale(float newValue);
};

class Synth_ATAN_SATURATE_skel : virtual public Synth_ATAN_SATURATE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void inscale_changed(float newValue) {
		_emit_changed("inscale_changed",newValue);
	}

public:
	Synth_ATAN_SATURATE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_ATAN_SATURATE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ATAN_SATURATE_base *_cache;
	inline Synth_ATAN_SATURATE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ATAN_SATURATE_base *)_pool->base->_cast(Synth_ATAN_SATURATE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ATAN_SATURATE(Synth_ATAN_SATURATE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_ATAN_SATURATE_base _base_class;

	inline Synth_ATAN_SATURATE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::SubClass& s) :
		Arts::Object(Synth_ATAN_SATURATE_base::_create(s.string())), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ATAN_SATURATE_base::_fromString(r.string())):(Synth_ATAN_SATURATE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::DynamicCast& c) : Arts::Object(Synth_ATAN_SATURATE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Synth_ATAN_SATURATE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ATAN_SATURATE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ATAN_SATURATE null() {return Synth_ATAN_SATURATE((Synth_ATAN_SATURATE_base*)0);}
	inline static Synth_ATAN_SATURATE _from_base(Synth_ATAN_SATURATE_base* b) {return Synth_ATAN_SATURATE(b);}
	inline Synth_ATAN_SATURATE& operator=(const Synth_ATAN_SATURATE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ATAN_SATURATE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float inscale();
	inline void inscale(float _newValue);
};

class Synth_BRICKWALL_LIMITER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_BRICKWALL_LIMITER_base *_create(const std::string& subClass = "Arts::Synth_BRICKWALL_LIMITER");
	static Synth_BRICKWALL_LIMITER_base *_fromString(const std::string& objectref);
	static Synth_BRICKWALL_LIMITER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_BRICKWALL_LIMITER_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_BRICKWALL_LIMITER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_BRICKWALL_LIMITER_stub : virtual public Synth_BRICKWALL_LIMITER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_BRICKWALL_LIMITER_stub();

public:
	Synth_BRICKWALL_LIMITER_stub(Arts::Connection *connection, long objectID);

};

class Synth_BRICKWALL_LIMITER_skel : virtual public Synth_BRICKWALL_LIMITER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_BRICKWALL_LIMITER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_BRICKWALL_LIMITER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_BRICKWALL_LIMITER_base *_cache;
	inline Synth_BRICKWALL_LIMITER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_BRICKWALL_LIMITER_base *)_pool->base->_cast(Synth_BRICKWALL_LIMITER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_BRICKWALL_LIMITER(Synth_BRICKWALL_LIMITER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_BRICKWALL_LIMITER_base _base_class;

	inline Synth_BRICKWALL_LIMITER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::SubClass& s) :
		Arts::Object(Synth_BRICKWALL_LIMITER_base::_create(s.string())), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_BRICKWALL_LIMITER_base::_fromString(r.string())):(Synth_BRICKWALL_LIMITER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::DynamicCast& c) : Arts::Object(Synth_BRICKWALL_LIMITER_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Synth_BRICKWALL_LIMITER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_BRICKWALL_LIMITER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_BRICKWALL_LIMITER null() {return Synth_BRICKWALL_LIMITER((Synth_BRICKWALL_LIMITER_base*)0);}
	inline static Synth_BRICKWALL_LIMITER _from_base(Synth_BRICKWALL_LIMITER_base* b) {return Synth_BRICKWALL_LIMITER(b);}
	inline Synth_BRICKWALL_LIMITER& operator=(const Synth_BRICKWALL_LIMITER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_BRICKWALL_LIMITER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_AUTOPANNER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_AUTOPANNER_base *_create(const std::string& subClass = "Arts::Synth_AUTOPANNER");
	static Synth_AUTOPANNER_base *_fromString(const std::string& objectref);
	static Synth_AUTOPANNER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_AUTOPANNER_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_AUTOPANNER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_AUTOPANNER_stub : virtual public Synth_AUTOPANNER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_AUTOPANNER_stub();

public:
	Synth_AUTOPANNER_stub(Arts::Connection *connection, long objectID);

};

class Synth_AUTOPANNER_skel : virtual public Synth_AUTOPANNER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *inlfo;                             // incoming stream
	float *outvalue1;                         // outgoing stream
	float *outvalue2;                         // outgoing stream

public:
	Synth_AUTOPANNER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_AUTOPANNER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_AUTOPANNER_base *_cache;
	inline Synth_AUTOPANNER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_AUTOPANNER_base *)_pool->base->_cast(Synth_AUTOPANNER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_AUTOPANNER(Synth_AUTOPANNER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_AUTOPANNER_base _base_class;

	inline Synth_AUTOPANNER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::SubClass& s) :
		Arts::Object(Synth_AUTOPANNER_base::_create(s.string())), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_AUTOPANNER_base::_fromString(r.string())):(Synth_AUTOPANNER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::DynamicCast& c) : Arts::Object(Synth_AUTOPANNER_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_AUTOPANNER(const Synth_AUTOPANNER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_AUTOPANNER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_AUTOPANNER null() {return Synth_AUTOPANNER((Synth_AUTOPANNER_base*)0);}
	inline static Synth_AUTOPANNER _from_base(Synth_AUTOPANNER_base* b) {return Synth_AUTOPANNER(b);}
	inline Synth_AUTOPANNER& operator=(const Synth_AUTOPANNER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_AUTOPANNER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_DELAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DELAY_base *_create(const std::string& subClass = "Arts::Synth_DELAY");
	static Synth_DELAY_base *_fromString(const std::string& objectref);
	static Synth_DELAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_DELAY_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_DELAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float maxdelay() = 0;
	virtual void maxdelay(float newValue) = 0;
};

class Synth_DELAY_stub : virtual public Synth_DELAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DELAY_stub();

public:
	Synth_DELAY_stub(Arts::Connection *connection, long objectID);

	float maxdelay();
	void maxdelay(float newValue);
};

class Synth_DELAY_skel : virtual public Synth_DELAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *time;                              // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void maxdelay_changed(float newValue) {
		_emit_changed("maxdelay_changed",newValue);
	}

public:
	Synth_DELAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DELAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DELAY_base *_cache;
	inline Synth_DELAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DELAY_base *)_pool->base->_cast(Synth_DELAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DELAY(Synth_DELAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DELAY_base _base_class;

	inline Synth_DELAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DELAY(const Arts::SubClass& s) :
		Arts::Object(Synth_DELAY_base::_create(s.string())), _cache(0) {}
	inline Synth_DELAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DELAY_base::_fromString(r.string())):(Synth_DELAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DELAY(const Arts::DynamicCast& c) : Arts::Object(Synth_DELAY_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_DELAY(const Synth_DELAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DELAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DELAY null() {return Synth_DELAY((Synth_DELAY_base*)0);}
	inline static Synth_DELAY _from_base(Synth_DELAY_base* b) {return Synth_DELAY(b);}
	inline Synth_DELAY& operator=(const Synth_DELAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DELAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float maxdelay();
	inline void maxdelay(float _newValue);
};

class Synth_CDELAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_CDELAY_base *_create(const std::string& subClass = "Arts::Synth_CDELAY");
	static Synth_CDELAY_base *_fromString(const std::string& objectref);
	static Synth_CDELAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_CDELAY_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_CDELAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float time() = 0;
	virtual void time(float newValue) = 0;
};

class Synth_CDELAY_stub : virtual public Synth_CDELAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_CDELAY_stub();

public:
	Synth_CDELAY_stub(Arts::Connection *connection, long objectID);

	float time();
	void time(float newValue);
};

class Synth_CDELAY_skel : virtual public Synth_CDELAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void time_changed(float newValue) {
		_emit_changed("time_changed",newValue);
	}

public:
	Synth_CDELAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_CDELAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_CDELAY_base *_cache;
	inline Synth_CDELAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_CDELAY_base *)_pool->base->_cast(Synth_CDELAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_CDELAY(Synth_CDELAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_CDELAY_base _base_class;

	inline Synth_CDELAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_CDELAY(const Arts::SubClass& s) :
		Arts::Object(Synth_CDELAY_base::_create(s.string())), _cache(0) {}
	inline Synth_CDELAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_CDELAY_base::_fromString(r.string())):(Synth_CDELAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_CDELAY(const Arts::DynamicCast& c) : Arts::Object(Synth_CDELAY_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_CDELAY(const Synth_CDELAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_CDELAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_CDELAY null() {return Synth_CDELAY((Synth_CDELAY_base*)0);}
	inline static Synth_CDELAY _from_base(Synth_CDELAY_base* b) {return Synth_CDELAY(b);}
	inline Synth_CDELAY& operator=(const Synth_CDELAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_CDELAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float time();
	inline void time(float _newValue);
};

class Synth_FM_SOURCE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FM_SOURCE_base *_create(const std::string& subClass = "Arts::Synth_FM_SOURCE");
	static Synth_FM_SOURCE_base *_fromString(const std::string& objectref);
	static Synth_FM_SOURCE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_FM_SOURCE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_FM_SOURCE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_FM_SOURCE_stub : virtual public Synth_FM_SOURCE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FM_SOURCE_stub();

public:
	Synth_FM_SOURCE_stub(Arts::Connection *connection, long objectID);

};

class Synth_FM_SOURCE_skel : virtual public Synth_FM_SOURCE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *modulator;                         // incoming stream
	float *modlevel;                          // incoming stream
	float *pos;                               // outgoing stream

public:
	Synth_FM_SOURCE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FM_SOURCE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FM_SOURCE_base *_cache;
	inline Synth_FM_SOURCE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FM_SOURCE_base *)_pool->base->_cast(Synth_FM_SOURCE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FM_SOURCE(Synth_FM_SOURCE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FM_SOURCE_base _base_class;

	inline Synth_FM_SOURCE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::SubClass& s) :
		Arts::Object(Synth_FM_SOURCE_base::_create(s.string())), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FM_SOURCE_base::_fromString(r.string())):(Synth_FM_SOURCE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::DynamicCast& c) : Arts::Object(Synth_FM_SOURCE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_FM_SOURCE(const Synth_FM_SOURCE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FM_SOURCE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FM_SOURCE null() {return Synth_FM_SOURCE((Synth_FM_SOURCE_base*)0);}
	inline static Synth_FM_SOURCE _from_base(Synth_FM_SOURCE_base* b) {return Synth_FM_SOURCE(b);}
	inline Synth_FM_SOURCE& operator=(const Synth_FM_SOURCE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FM_SOURCE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_TREMOLO_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_TREMOLO_base *_create(const std::string& subClass = "Arts::Synth_TREMOLO");
	static Synth_TREMOLO_base *_fromString(const std::string& objectref);
	static Synth_TREMOLO_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_TREMOLO_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_TREMOLO_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_TREMOLO_stub : virtual public Synth_TREMOLO_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_TREMOLO_stub();

public:
	Synth_TREMOLO_stub(Arts::Connection *connection, long objectID);

};

class Synth_TREMOLO_skel : virtual public Synth_TREMOLO_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *inlfo;                             // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_TREMOLO_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_TREMOLO : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_TREMOLO_base *_cache;
	inline Synth_TREMOLO_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_TREMOLO_base *)_pool->base->_cast(Synth_TREMOLO_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_TREMOLO(Synth_TREMOLO_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_TREMOLO_base _base_class;

	inline Synth_TREMOLO() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_TREMOLO(const Arts::SubClass& s) :
		Arts::Object(Synth_TREMOLO_base::_create(s.string())), _cache(0) {}
	inline Synth_TREMOLO(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_TREMOLO_base::_fromString(r.string())):(Synth_TREMOLO_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_TREMOLO(const Arts::DynamicCast& c) : Arts::Object(Synth_TREMOLO_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_TREMOLO(const Synth_TREMOLO& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_TREMOLO(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_TREMOLO null() {return Synth_TREMOLO((Synth_TREMOLO_base*)0);}
	inline static Synth_TREMOLO _from_base(Synth_TREMOLO_base* b) {return Synth_TREMOLO(b);}
	inline Synth_TREMOLO& operator=(const Synth_TREMOLO& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_TREMOLO_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_FX_CFLANGER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FX_CFLANGER_base *_create(const std::string& subClass = "Arts::Synth_FX_CFLANGER");
	static Synth_FX_CFLANGER_base *_fromString(const std::string& objectref);
	static Synth_FX_CFLANGER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_FX_CFLANGER_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_FX_CFLANGER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float mintime() = 0;
	virtual void mintime(float newValue) = 0;
	virtual float maxtime() = 0;
	virtual void maxtime(float newValue) = 0;
};

class Synth_FX_CFLANGER_stub : virtual public Synth_FX_CFLANGER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FX_CFLANGER_stub();

public:
	Synth_FX_CFLANGER_stub(Arts::Connection *connection, long objectID);

	float mintime();
	void mintime(float newValue);
	float maxtime();
	void maxtime(float newValue);
};

class Synth_FX_CFLANGER_skel : virtual public Synth_FX_CFLANGER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *lfo;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void mintime_changed(float newValue) {
		_emit_changed("mintime_changed",newValue);
	}
	inline void maxtime_changed(float newValue) {
		_emit_changed("maxtime_changed",newValue);
	}

public:
	Synth_FX_CFLANGER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FX_CFLANGER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FX_CFLANGER_base *_cache;
	inline Synth_FX_CFLANGER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FX_CFLANGER_base *)_pool->base->_cast(Synth_FX_CFLANGER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FX_CFLANGER(Synth_FX_CFLANGER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FX_CFLANGER_base _base_class;

	inline Synth_FX_CFLANGER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::SubClass& s) :
		Arts::Object(Synth_FX_CFLANGER_base::_create(s.string())), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FX_CFLANGER_base::_fromString(r.string())):(Synth_FX_CFLANGER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::DynamicCast& c) : Arts::Object(Synth_FX_CFLANGER_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_FX_CFLANGER(const Synth_FX_CFLANGER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FX_CFLANGER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FX_CFLANGER null() {return Synth_FX_CFLANGER((Synth_FX_CFLANGER_base*)0);}
	inline static Synth_FX_CFLANGER _from_base(Synth_FX_CFLANGER_base* b) {return Synth_FX_CFLANGER(b);}
	inline Synth_FX_CFLANGER& operator=(const Synth_FX_CFLANGER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FX_CFLANGER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float mintime();
	inline void mintime(float _newValue);
	inline float maxtime();
	inline void maxtime(float _newValue);
};

class Synth_NOISE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_NOISE_base *_create(const std::string& subClass = "Arts::Synth_NOISE");
	static Synth_NOISE_base *_fromString(const std::string& objectref);
	static Synth_NOISE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_NOISE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_NOISE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_NOISE_stub : virtual public Synth_NOISE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_NOISE_stub();

public:
	Synth_NOISE_stub(Arts::Connection *connection, long objectID);

};

class Synth_NOISE_skel : virtual public Synth_NOISE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *outvalue;                          // outgoing stream

public:
	Synth_NOISE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_NOISE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_NOISE_base *_cache;
	inline Synth_NOISE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_NOISE_base *)_pool->base->_cast(Synth_NOISE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_NOISE(Synth_NOISE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_NOISE_base _base_class;

	inline Synth_NOISE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_NOISE(const Arts::SubClass& s) :
		Arts::Object(Synth_NOISE_base::_create(s.string())), _cache(0) {}
	inline Synth_NOISE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_NOISE_base::_fromString(r.string())):(Synth_NOISE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_NOISE(const Arts::DynamicCast& c) : Arts::Object(Synth_NOISE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_NOISE(const Synth_NOISE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_NOISE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_NOISE null() {return Synth_NOISE((Synth_NOISE_base*)0);}
	inline static Synth_NOISE _from_base(Synth_NOISE_base* b) {return Synth_NOISE(b);}
	inline Synth_NOISE& operator=(const Synth_NOISE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_NOISE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_TRI_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_TRI_base *_create(const std::string& subClass = "Arts::Synth_WAVE_TRI");
	static Synth_WAVE_TRI_base *_fromString(const std::string& objectref);
	static Synth_WAVE_TRI_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_WAVE_TRI_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_WAVE_TRI_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_TRI_stub : virtual public Synth_WAVE_TRI_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_TRI_stub();

public:
	Synth_WAVE_TRI_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_TRI_skel : virtual public Synth_WAVE_TRI_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_TRI_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_TRI : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_TRI_base *_cache;
	inline Synth_WAVE_TRI_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_TRI_base *)_pool->base->_cast(Synth_WAVE_TRI_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_TRI(Synth_WAVE_TRI_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_TRI_base _base_class;

	inline Synth_WAVE_TRI() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_TRI_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_TRI_base::_fromString(r.string())):(Synth_WAVE_TRI_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_TRI_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_WAVE_TRI(const Synth_WAVE_TRI& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_TRI(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_TRI null() {return Synth_WAVE_TRI((Synth_WAVE_TRI_base*)0);}
	inline static Synth_WAVE_TRI _from_base(Synth_WAVE_TRI_base* b) {return Synth_WAVE_TRI(b);}
	inline Synth_WAVE_TRI& operator=(const Synth_WAVE_TRI& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_TRI_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_SQUARE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SQUARE_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SQUARE");
	static Synth_WAVE_SQUARE_base *_fromString(const std::string& objectref);
	static Synth_WAVE_SQUARE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_WAVE_SQUARE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_WAVE_SQUARE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SQUARE_stub : virtual public Synth_WAVE_SQUARE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SQUARE_stub();

public:
	Synth_WAVE_SQUARE_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SQUARE_skel : virtual public Synth_WAVE_SQUARE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SQUARE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_SQUARE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SQUARE_base *_cache;
	inline Synth_WAVE_SQUARE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SQUARE_base *)_pool->base->_cast(Synth_WAVE_SQUARE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SQUARE(Synth_WAVE_SQUARE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SQUARE_base _base_class;

	inline Synth_WAVE_SQUARE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SQUARE_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SQUARE_base::_fromString(r.string())):(Synth_WAVE_SQUARE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SQUARE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Synth_WAVE_SQUARE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SQUARE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SQUARE null() {return Synth_WAVE_SQUARE((Synth_WAVE_SQUARE_base*)0);}
	inline static Synth_WAVE_SQUARE _from_base(Synth_WAVE_SQUARE_base* b) {return Synth_WAVE_SQUARE(b);}
	inline Synth_WAVE_SQUARE& operator=(const Synth_WAVE_SQUARE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SQUARE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_PULSE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_PULSE_base *_create(const std::string& subClass = "Arts::Synth_WAVE_PULSE");
	static Synth_WAVE_PULSE_base *_fromString(const std::string& objectref);
	static Synth_WAVE_PULSE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_WAVE_PULSE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_WAVE_PULSE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float dutycycle() = 0;
	virtual void dutycycle(float newValue) = 0;
};

class Synth_WAVE_PULSE_stub : virtual public Synth_WAVE_PULSE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_PULSE_stub();

public:
	Synth_WAVE_PULSE_stub(Arts::Connection *connection, long objectID);

	float dutycycle();
	void dutycycle(float newValue);
};

class Synth_WAVE_PULSE_skel : virtual public Synth_WAVE_PULSE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void dutycycle_changed(float newValue) {
		_emit_changed("dutycycle_changed",newValue);
	}

public:
	Synth_WAVE_PULSE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_PULSE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_PULSE_base *_cache;
	inline Synth_WAVE_PULSE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_PULSE_base *)_pool->base->_cast(Synth_WAVE_PULSE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_PULSE(Synth_WAVE_PULSE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_PULSE_base _base_class;

	inline Synth_WAVE_PULSE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_PULSE_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_PULSE_base::_fromString(r.string())):(Synth_WAVE_PULSE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_PULSE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_WAVE_PULSE(const Synth_WAVE_PULSE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_PULSE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_PULSE null() {return Synth_WAVE_PULSE((Synth_WAVE_PULSE_base*)0);}
	inline static Synth_WAVE_PULSE _from_base(Synth_WAVE_PULSE_base* b) {return Synth_WAVE_PULSE(b);}
	inline Synth_WAVE_PULSE& operator=(const Synth_WAVE_PULSE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_PULSE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float dutycycle();
	inline void dutycycle(float _newValue);
};

class Synth_WAVE_SOFTSAW_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SOFTSAW_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SOFTSAW");
	static Synth_WAVE_SOFTSAW_base *_fromString(const std::string& objectref);
	static Synth_WAVE_SOFTSAW_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_WAVE_SOFTSAW_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_WAVE_SOFTSAW_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SOFTSAW_stub : virtual public Synth_WAVE_SOFTSAW_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SOFTSAW_stub();

public:
	Synth_WAVE_SOFTSAW_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SOFTSAW_skel : virtual public Synth_WAVE_SOFTSAW_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SOFTSAW_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_SOFTSAW : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SOFTSAW_base *_cache;
	inline Synth_WAVE_SOFTSAW_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SOFTSAW_base *)_pool->base->_cast(Synth_WAVE_SOFTSAW_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SOFTSAW(Synth_WAVE_SOFTSAW_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SOFTSAW_base _base_class;

	inline Synth_WAVE_SOFTSAW() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SOFTSAW_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SOFTSAW_base::_fromString(r.string())):(Synth_WAVE_SOFTSAW_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SOFTSAW_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Synth_WAVE_SOFTSAW& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SOFTSAW(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SOFTSAW null() {return Synth_WAVE_SOFTSAW((Synth_WAVE_SOFTSAW_base*)0);}
	inline static Synth_WAVE_SOFTSAW _from_base(Synth_WAVE_SOFTSAW_base* b) {return Synth_WAVE_SOFTSAW(b);}
	inline Synth_WAVE_SOFTSAW& operator=(const Synth_WAVE_SOFTSAW& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SOFTSAW_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_ENVELOPE_ADSR_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ENVELOPE_ADSR_base *_create(const std::string& subClass = "Arts::Synth_ENVELOPE_ADSR");
	static Synth_ENVELOPE_ADSR_base *_fromString(const std::string& objectref);
	static Synth_ENVELOPE_ADSR_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_ENVELOPE_ADSR_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_ENVELOPE_ADSR_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_ENVELOPE_ADSR_stub : virtual public Synth_ENVELOPE_ADSR_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ENVELOPE_ADSR_stub();

public:
	Synth_ENVELOPE_ADSR_stub(Arts::Connection *connection, long objectID);

};

class Synth_ENVELOPE_ADSR_skel : virtual public Synth_ENVELOPE_ADSR_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *active;                            // incoming stream
	float *invalue;                           // incoming stream
	float *attack;                            // incoming stream
	float *decay;                             // incoming stream
	float *sustain;                           // incoming stream
	float *release;                           // incoming stream
	float *outvalue;                          // outgoing stream
	float *done;                              // outgoing stream

public:
	Synth_ENVELOPE_ADSR_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_ENVELOPE_ADSR : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ENVELOPE_ADSR_base *_cache;
	inline Synth_ENVELOPE_ADSR_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ENVELOPE_ADSR_base *)_pool->base->_cast(Synth_ENVELOPE_ADSR_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ENVELOPE_ADSR(Synth_ENVELOPE_ADSR_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_ENVELOPE_ADSR_base _base_class;

	inline Synth_ENVELOPE_ADSR() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::SubClass& s) :
		Arts::Object(Synth_ENVELOPE_ADSR_base::_create(s.string())), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ENVELOPE_ADSR_base::_fromString(r.string())):(Synth_ENVELOPE_ADSR_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::DynamicCast& c) : Arts::Object(Synth_ENVELOPE_ADSR_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Synth_ENVELOPE_ADSR& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ENVELOPE_ADSR(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ENVELOPE_ADSR null() {return Synth_ENVELOPE_ADSR((Synth_ENVELOPE_ADSR_base*)0);}
	inline static Synth_ENVELOPE_ADSR _from_base(Synth_ENVELOPE_ADSR_base* b) {return Synth_ENVELOPE_ADSR(b);}
	inline Synth_ENVELOPE_ADSR& operator=(const Synth_ENVELOPE_ADSR& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ENVELOPE_ADSR_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_SHELVE_CUTOFF_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_SHELVE_CUTOFF_base *_create(const std::string& subClass = "Arts::Synth_SHELVE_CUTOFF");
	static Synth_SHELVE_CUTOFF_base *_fromString(const std::string& objectref);
	static Synth_SHELVE_CUTOFF_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_SHELVE_CUTOFF_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_SHELVE_CUTOFF_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_SHELVE_CUTOFF_stub : virtual public Synth_SHELVE_CUTOFF_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_SHELVE_CUTOFF_stub();

public:
	Synth_SHELVE_CUTOFF_stub(Arts::Connection *connection, long objectID);

};

class Synth_SHELVE_CUTOFF_skel : virtual public Synth_SHELVE_CUTOFF_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *frequency;                         // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_SHELVE_CUTOFF_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_SHELVE_CUTOFF : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_SHELVE_CUTOFF_base *_cache;
	inline Synth_SHELVE_CUTOFF_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_SHELVE_CUTOFF_base *)_pool->base->_cast(Synth_SHELVE_CUTOFF_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_SHELVE_CUTOFF(Synth_SHELVE_CUTOFF_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_SHELVE_CUTOFF_base _base_class;

	inline Synth_SHELVE_CUTOFF() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::SubClass& s) :
		Arts::Object(Synth_SHELVE_CUTOFF_base::_create(s.string())), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_SHELVE_CUTOFF_base::_fromString(r.string())):(Synth_SHELVE_CUTOFF_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::DynamicCast& c) : Arts::Object(Synth_SHELVE_CUTOFF_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Synth_SHELVE_CUTOFF& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_SHELVE_CUTOFF(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_SHELVE_CUTOFF null() {return Synth_SHELVE_CUTOFF((Synth_SHELVE_CUTOFF_base*)0);}
	inline static Synth_SHELVE_CUTOFF _from_base(Synth_SHELVE_CUTOFF_base* b) {return Synth_SHELVE_CUTOFF(b);}
	inline Synth_SHELVE_CUTOFF& operator=(const Synth_SHELVE_CUTOFF& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_SHELVE_CUTOFF_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_XFADE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_XFADE_base *_create(const std::string& subClass = "Arts::Synth_XFADE");
	static Synth_XFADE_base *_fromString(const std::string& objectref);
	static Synth_XFADE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_XFADE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_XFADE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_XFADE_stub : virtual public Synth_XFADE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_XFADE_stub();

public:
	Synth_XFADE_stub(Arts::Connection *connection, long objectID);

};

class Synth_XFADE_skel : virtual public Synth_XFADE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *percentage;                        // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_XFADE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_XFADE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_XFADE_base *_cache;
	inline Synth_XFADE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_XFADE_base *)_pool->base->_cast(Synth_XFADE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_XFADE(Synth_XFADE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_XFADE_base _base_class;

	inline Synth_XFADE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_XFADE(const Arts::SubClass& s) :
		Arts::Object(Synth_XFADE_base::_create(s.string())), _cache(0) {}
	inline Synth_XFADE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_XFADE_base::_fromString(r.string())):(Synth_XFADE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_XFADE(const Arts::DynamicCast& c) : Arts::Object(Synth_XFADE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_XFADE(const Synth_XFADE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_XFADE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_XFADE null() {return Synth_XFADE((Synth_XFADE_base*)0);}
	inline static Synth_XFADE _from_base(Synth_XFADE_base* b) {return Synth_XFADE(b);}
	inline Synth_XFADE& operator=(const Synth_XFADE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_XFADE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MIDI_TEST_base : virtual public Arts::SynthModule_base,
	virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MIDI_TEST_base *_create(const std::string& subClass = "Arts::Synth_MIDI_TEST");
	static Synth_MIDI_TEST_base *_fromString(const std::string& objectref);
	static Synth_MIDI_TEST_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_MIDI_TEST_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_MIDI_TEST_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual std::string busname() = 0;
	virtual void busname(const std::string& newValue) = 0;
};

class Synth_MIDI_TEST_stub : virtual public Synth_MIDI_TEST_base, virtual public Arts::SynthModule_stub,
	virtual public Arts::MidiPort_stub {
protected:
	Synth_MIDI_TEST_stub();

public:
	Synth_MIDI_TEST_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
	std::string busname();
	void busname(const std::string& newValue);
};

class Synth_MIDI_TEST_skel : virtual public Synth_MIDI_TEST_base, virtual public Arts::SynthModule_skel,
	virtual public Arts::MidiPort_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}
	inline void busname_changed(const std::string& newValue) {
		_emit_changed("busname_changed",newValue);
	}

public:
	Synth_MIDI_TEST_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MIDI_TEST : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MIDI_TEST_base *_cache;
	inline Synth_MIDI_TEST_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MIDI_TEST_base *)_pool->base->_cast(Synth_MIDI_TEST_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MIDI_TEST(Synth_MIDI_TEST_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MIDI_TEST_base _base_class;

	inline Synth_MIDI_TEST() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::SubClass& s) :
		Arts::Object(Synth_MIDI_TEST_base::_create(s.string())), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MIDI_TEST_base::_fromString(r.string())):(Synth_MIDI_TEST_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::DynamicCast& c) : Arts::Object(Synth_MIDI_TEST_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_MIDI_TEST(const Synth_MIDI_TEST& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MIDI_TEST(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MIDI_TEST null() {return Synth_MIDI_TEST((Synth_MIDI_TEST_base*)0);}
	inline static Synth_MIDI_TEST _from_base(Synth_MIDI_TEST_base* b) {return Synth_MIDI_TEST(b);}
	inline Synth_MIDI_TEST& operator=(const Synth_MIDI_TEST& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline Synth_MIDI_TEST_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline std::string busname();
	inline void busname(const std::string& _newValue);
};

class Synth_MIDI_DEBUG_base : virtual public Arts::SynthModule_base,
	virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MIDI_DEBUG_base *_create(const std::string& subClass = "Arts::Synth_MIDI_DEBUG");
	static Synth_MIDI_DEBUG_base *_fromString(const std::string& objectref);
	static Synth_MIDI_DEBUG_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_MIDI_DEBUG_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_MIDI_DEBUG_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MIDI_DEBUG_stub : virtual public Synth_MIDI_DEBUG_base, virtual public Arts::SynthModule_stub,
	virtual public Arts::MidiPort_stub {
protected:
	Synth_MIDI_DEBUG_stub();

public:
	Synth_MIDI_DEBUG_stub(Arts::Connection *connection, long objectID);

};

class Synth_MIDI_DEBUG_skel : virtual public Synth_MIDI_DEBUG_base, virtual public Arts::SynthModule_skel,
	virtual public Arts::MidiPort_skel {
public:
	Synth_MIDI_DEBUG_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MIDI_DEBUG : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MIDI_DEBUG_base *_cache;
	inline Synth_MIDI_DEBUG_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MIDI_DEBUG_base *)_pool->base->_cast(Synth_MIDI_DEBUG_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MIDI_DEBUG(Synth_MIDI_DEBUG_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MIDI_DEBUG_base _base_class;

	inline Synth_MIDI_DEBUG() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::SubClass& s) :
		Arts::Object(Synth_MIDI_DEBUG_base::_create(s.string())), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MIDI_DEBUG_base::_fromString(r.string())):(Synth_MIDI_DEBUG_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::DynamicCast& c) : Arts::Object(Synth_MIDI_DEBUG_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Synth_MIDI_DEBUG& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MIDI_DEBUG(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MIDI_DEBUG null() {return Synth_MIDI_DEBUG((Synth_MIDI_DEBUG_base*)0);}
	inline static Synth_MIDI_DEBUG _from_base(Synth_MIDI_DEBUG_base* b) {return Synth_MIDI_DEBUG(b);}
	inline Synth_MIDI_DEBUG& operator=(const Synth_MIDI_DEBUG& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline Synth_MIDI_DEBUG_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
};

class Synth_FREEVERB_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FREEVERB_base *_create(const std::string& subClass = "Arts::Synth_FREEVERB");
	static Synth_FREEVERB_base *_fromString(const std::string& objectref);
	static Synth_FREEVERB_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_FREEVERB_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_FREEVERB_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float roomsize() = 0;
	virtual void roomsize(float newValue) = 0;
	virtual float damp() = 0;
	virtual void damp(float newValue) = 0;
	virtual float wet() = 0;
	virtual void wet(float newValue) = 0;
	virtual float dry() = 0;
	virtual void dry(float newValue) = 0;
	virtual float width() = 0;
	virtual void width(float newValue) = 0;
	virtual float mode() = 0;
	virtual void mode(float newValue) = 0;
};

class Synth_FREEVERB_stub : virtual public Synth_FREEVERB_base, virtual public Arts::StereoEffect_stub {
protected:
	Synth_FREEVERB_stub();

public:
	Synth_FREEVERB_stub(Arts::Connection *connection, long objectID);

	float roomsize();
	void roomsize(float newValue);
	float damp();
	void damp(float newValue);
	float wet();
	void wet(float newValue);
	float dry();
	void dry(float newValue);
	float width();
	void width(float newValue);
	float mode();
	void mode(float newValue);
};

class Synth_FREEVERB_skel : virtual public Synth_FREEVERB_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void roomsize_changed(float newValue) {
		_emit_changed("roomsize_changed",newValue);
	}
	inline void damp_changed(float newValue) {
		_emit_changed("damp_changed",newValue);
	}
	inline void wet_changed(float newValue) {
		_emit_changed("wet_changed",newValue);
	}
	inline void dry_changed(float newValue) {
		_emit_changed("dry_changed",newValue);
	}
	inline void width_changed(float newValue) {
		_emit_changed("width_changed",newValue);
	}
	inline void mode_changed(float newValue) {
		_emit_changed("mode_changed",newValue);
	}

public:
	Synth_FREEVERB_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FREEVERB : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FREEVERB_base *_cache;
	inline Synth_FREEVERB_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FREEVERB_base *)_pool->base->_cast(Synth_FREEVERB_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FREEVERB(Synth_FREEVERB_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FREEVERB_base _base_class;

	inline Synth_FREEVERB() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FREEVERB(const Arts::SubClass& s) :
		Arts::Object(Synth_FREEVERB_base::_create(s.string())), _cache(0) {}
	inline Synth_FREEVERB(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FREEVERB_base::_fromString(r.string())):(Synth_FREEVERB_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FREEVERB(const Arts::DynamicCast& c) : Arts::Object(Synth_FREEVERB_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_FREEVERB(const Synth_FREEVERB& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FREEVERB(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FREEVERB null() {return Synth_FREEVERB((Synth_FREEVERB_base*)0);}
	inline static Synth_FREEVERB _from_base(Synth_FREEVERB_base* b) {return Synth_FREEVERB(b);}
	inline Synth_FREEVERB& operator=(const Synth_FREEVERB& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FREEVERB_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float roomsize();
	inline void roomsize(float _newValue);
	inline float damp();
	inline void damp(float _newValue);
	inline float wet();
	inline void wet(float _newValue);
	inline float dry();
	inline void dry(float _newValue);
	inline float width();
	inline void width(float _newValue);
	inline float mode();
	inline void mode(float _newValue);
};

class FreeverbGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static FreeverbGuiFactory_base *_create(const std::string& subClass = "Arts::FreeverbGuiFactory");
	static FreeverbGuiFactory_base *_fromString(const std::string& objectref);
	static FreeverbGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static FreeverbGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline FreeverbGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class FreeverbGuiFactory_stub : virtual public FreeverbGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	FreeverbGuiFactory_stub();

public:
	FreeverbGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class FreeverbGuiFactory_skel : virtual public FreeverbGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	FreeverbGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class FreeverbGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	FreeverbGuiFactory_base *_cache;
	inline FreeverbGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FreeverbGuiFactory_base *)_pool->base->_cast(FreeverbGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline FreeverbGuiFactory(FreeverbGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef FreeverbGuiFactory_base _base_class;

	inline FreeverbGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline FreeverbGuiFactory(const Arts::SubClass& s) :
		Arts::Object(FreeverbGuiFactory_base::_create(s.string())), _cache(0) {}
	inline FreeverbGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(FreeverbGuiFactory_base::_fromString(r.string())):(FreeverbGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FreeverbGuiFactory(const Arts::DynamicCast& c) : Arts::Object(FreeverbGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline FreeverbGuiFactory(const FreeverbGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline FreeverbGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static FreeverbGuiFactory null() {return FreeverbGuiFactory((FreeverbGuiFactory_base*)0);}
	inline static FreeverbGuiFactory _from_base(FreeverbGuiFactory_base* b) {return FreeverbGuiFactory(b);}
	inline FreeverbGuiFactory& operator=(const FreeverbGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline FreeverbGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class Synth_STD_EQUALIZER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STD_EQUALIZER_base *_create(const std::string& subClass = "Arts::Synth_STD_EQUALIZER");
	static Synth_STD_EQUALIZER_base *_fromString(const std::string& objectref);
	static Synth_STD_EQUALIZER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_STD_EQUALIZER_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_STD_EQUALIZER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float low() = 0;
	virtual void low(float newValue) = 0;
	virtual float mid() = 0;
	virtual void mid(float newValue) = 0;
	virtual float high() = 0;
	virtual void high(float newValue) = 0;
	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
	virtual float q() = 0;
	virtual void q(float newValue) = 0;
};

class Synth_STD_EQUALIZER_stub : virtual public Synth_STD_EQUALIZER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_STD_EQUALIZER_stub();

public:
	Synth_STD_EQUALIZER_stub(Arts::Connection *connection, long objectID);

	float low();
	void low(float newValue);
	float mid();
	void mid(float newValue);
	float high();
	void high(float newValue);
	float frequency();
	void frequency(float newValue);
	float q();
	void q(float newValue);
};

class Synth_STD_EQUALIZER_skel : virtual public Synth_STD_EQUALIZER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void low_changed(float newValue) {
		_emit_changed("low_changed",newValue);
	}
	inline void mid_changed(float newValue) {
		_emit_changed("mid_changed",newValue);
	}
	inline void high_changed(float newValue) {
		_emit_changed("high_changed",newValue);
	}
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}
	inline void q_changed(float newValue) {
		_emit_changed("q_changed",newValue);
	}

public:
	Synth_STD_EQUALIZER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STD_EQUALIZER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STD_EQUALIZER_base *_cache;
	inline Synth_STD_EQUALIZER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STD_EQUALIZER_base *)_pool->base->_cast(Synth_STD_EQUALIZER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STD_EQUALIZER(Synth_STD_EQUALIZER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STD_EQUALIZER_base _base_class;

	inline Synth_STD_EQUALIZER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::SubClass& s) :
		Arts::Object(Synth_STD_EQUALIZER_base::_create(s.string())), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STD_EQUALIZER_base::_fromString(r.string())):(Synth_STD_EQUALIZER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::DynamicCast& c) : Arts::Object(Synth_STD_EQUALIZER_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Synth_STD_EQUALIZER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STD_EQUALIZER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STD_EQUALIZER null() {return Synth_STD_EQUALIZER((Synth_STD_EQUALIZER_base*)0);}
	inline static Synth_STD_EQUALIZER _from_base(Synth_STD_EQUALIZER_base* b) {return Synth_STD_EQUALIZER(b);}
	inline Synth_STD_EQUALIZER& operator=(const Synth_STD_EQUALIZER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STD_EQUALIZER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float low();
	inline void low(float _newValue);
	inline float mid();
	inline void mid(float _newValue);
	inline float high();
	inline void high(float _newValue);
	inline float frequency();
	inline void frequency(float _newValue);
	inline float q();
	inline void q(float _newValue);
};

class Synth_RC_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_RC_base *_create(const std::string& subClass = "Arts::Synth_RC");
	static Synth_RC_base *_fromString(const std::string& objectref);
	static Synth_RC_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_RC_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_RC_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float b() = 0;
	virtual void b(float newValue) = 0;
	virtual float f() = 0;
	virtual void f(float newValue) = 0;
};

class Synth_RC_stub : virtual public Synth_RC_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_RC_stub();

public:
	Synth_RC_stub(Arts::Connection *connection, long objectID);

	float b();
	void b(float newValue);
	float f();
	void f(float newValue);
};

class Synth_RC_skel : virtual public Synth_RC_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void b_changed(float newValue) {
		_emit_changed("b_changed",newValue);
	}
	inline void f_changed(float newValue) {
		_emit_changed("f_changed",newValue);
	}

public:
	Synth_RC_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_RC : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_RC_base *_cache;
	inline Synth_RC_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_RC_base *)_pool->base->_cast(Synth_RC_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_RC(Synth_RC_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_RC_base _base_class;

	inline Synth_RC() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_RC(const Arts::SubClass& s) :
		Arts::Object(Synth_RC_base::_create(s.string())), _cache(0) {}
	inline Synth_RC(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_RC_base::_fromString(r.string())):(Synth_RC_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_RC(const Arts::DynamicCast& c) : Arts::Object(Synth_RC_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_RC(const Synth_RC& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_RC(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_RC null() {return Synth_RC((Synth_RC_base*)0);}
	inline static Synth_RC _from_base(Synth_RC_base* b) {return Synth_RC(b);}
	inline Synth_RC& operator=(const Synth_RC& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_RC_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float b();
	inline void b(float _newValue);
	inline float f();
	inline void f(float _newValue);
};

class Synth_MOOG_VCF_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MOOG_VCF_base *_create(const std::string& subClass = "Arts::Synth_MOOG_VCF");
	static Synth_MOOG_VCF_base *_fromString(const std::string& objectref);
	static Synth_MOOG_VCF_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_MOOG_VCF_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_MOOG_VCF_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
	virtual float resonance() = 0;
	virtual void resonance(float newValue) = 0;
};

class Synth_MOOG_VCF_stub : virtual public Synth_MOOG_VCF_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MOOG_VCF_stub();

public:
	Synth_MOOG_VCF_stub(Arts::Connection *connection, long objectID);

	float frequency();
	void frequency(float newValue);
	float resonance();
	void resonance(float newValue);
};

class Synth_MOOG_VCF_skel : virtual public Synth_MOOG_VCF_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}
	inline void resonance_changed(float newValue) {
		_emit_changed("resonance_changed",newValue);
	}

public:
	Synth_MOOG_VCF_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MOOG_VCF : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MOOG_VCF_base *_cache;
	inline Synth_MOOG_VCF_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MOOG_VCF_base *)_pool->base->_cast(Synth_MOOG_VCF_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MOOG_VCF(Synth_MOOG_VCF_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MOOG_VCF_base _base_class;

	inline Synth_MOOG_VCF() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::SubClass& s) :
		Arts::Object(Synth_MOOG_VCF_base::_create(s.string())), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MOOG_VCF_base::_fromString(r.string())):(Synth_MOOG_VCF_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::DynamicCast& c) : Arts::Object(Synth_MOOG_VCF_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_MOOG_VCF(const Synth_MOOG_VCF& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MOOG_VCF(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MOOG_VCF null() {return Synth_MOOG_VCF((Synth_MOOG_VCF_base*)0);}
	inline static Synth_MOOG_VCF _from_base(Synth_MOOG_VCF_base* b) {return Synth_MOOG_VCF(b);}
	inline Synth_MOOG_VCF& operator=(const Synth_MOOG_VCF& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MOOG_VCF_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float frequency();
	inline void frequency(float _newValue);
	inline float resonance();
	inline void resonance(float _newValue);
};

class Synth_PSCALE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PSCALE_base *_create(const std::string& subClass = "Arts::Synth_PSCALE");
	static Synth_PSCALE_base *_fromString(const std::string& objectref);
	static Synth_PSCALE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_PSCALE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_PSCALE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float top() = 0;
	virtual void top(float newValue) = 0;
};

class Synth_PSCALE_stub : virtual public Synth_PSCALE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PSCALE_stub();

public:
	Synth_PSCALE_stub(Arts::Connection *connection, long objectID);

	float top();
	void top(float newValue);
};

class Synth_PSCALE_skel : virtual public Synth_PSCALE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void top_changed(float newValue) {
		_emit_changed("top_changed",newValue);
	}

public:
	Synth_PSCALE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PSCALE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PSCALE_base *_cache;
	inline Synth_PSCALE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PSCALE_base *)_pool->base->_cast(Synth_PSCALE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PSCALE(Synth_PSCALE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PSCALE_base _base_class;

	inline Synth_PSCALE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PSCALE(const Arts::SubClass& s) :
		Arts::Object(Synth_PSCALE_base::_create(s.string())), _cache(0) {}
	inline Synth_PSCALE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PSCALE_base::_fromString(r.string())):(Synth_PSCALE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PSCALE(const Arts::DynamicCast& c) : Arts::Object(Synth_PSCALE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_PSCALE(const Synth_PSCALE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PSCALE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PSCALE null() {return Synth_PSCALE((Synth_PSCALE_base*)0);}
	inline static Synth_PSCALE _from_base(Synth_PSCALE_base* b) {return Synth_PSCALE(b);}
	inline Synth_PSCALE& operator=(const Synth_PSCALE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PSCALE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float top();
	inline void top(float _newValue);
};

class Synth_SEQUENCE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_SEQUENCE_base *_create(const std::string& subClass = "Arts::Synth_SEQUENCE");
	static Synth_SEQUENCE_base *_fromString(const std::string& objectref);
	static Synth_SEQUENCE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_SEQUENCE_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_SEQUENCE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual std::string seq() = 0;
	virtual void seq(const std::string& newValue) = 0;
};

class Synth_SEQUENCE_stub : virtual public Synth_SEQUENCE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_SEQUENCE_stub();

public:
	Synth_SEQUENCE_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	std::string seq();
	void seq(const std::string& newValue);
};

class Synth_SEQUENCE_skel : virtual public Synth_SEQUENCE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // outgoing stream
	float *pos;                               // outgoing stream

protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void seq_changed(const std::string& newValue) {
		_emit_changed("seq_changed",newValue);
	}

public:
	Synth_SEQUENCE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_SEQUENCE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_SEQUENCE_base *_cache;
	inline Synth_SEQUENCE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_SEQUENCE_base *)_pool->base->_cast(Synth_SEQUENCE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_SEQUENCE(Synth_SEQUENCE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_SEQUENCE_base _base_class;

	inline Synth_SEQUENCE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::SubClass& s) :
		Arts::Object(Synth_SEQUENCE_base::_create(s.string())), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_SEQUENCE_base::_fromString(r.string())):(Synth_SEQUENCE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::DynamicCast& c) : Arts::Object(Synth_SEQUENCE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_SEQUENCE(const Synth_SEQUENCE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_SEQUENCE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_SEQUENCE null() {return Synth_SEQUENCE((Synth_SEQUENCE_base*)0);}
	inline static Synth_SEQUENCE _from_base(Synth_SEQUENCE_base* b) {return Synth_SEQUENCE(b);}
	inline Synth_SEQUENCE& operator=(const Synth_SEQUENCE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_SEQUENCE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline std::string seq();
	inline void seq(const std::string& _newValue);
};

class Synth_PITCH_SHIFT_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PITCH_SHIFT_base *_create(const std::string& subClass = "Arts::Synth_PITCH_SHIFT");
	static Synth_PITCH_SHIFT_base *_fromString(const std::string& objectref);
	static Synth_PITCH_SHIFT_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_PITCH_SHIFT_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_PITCH_SHIFT_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
};

class Synth_PITCH_SHIFT_stub : virtual public Synth_PITCH_SHIFT_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PITCH_SHIFT_stub();

public:
	Synth_PITCH_SHIFT_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	float frequency();
	void frequency(float newValue);
};

class Synth_PITCH_SHIFT_skel : virtual public Synth_PITCH_SHIFT_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}

public:
	Synth_PITCH_SHIFT_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PITCH_SHIFT : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PITCH_SHIFT_base *_cache;
	inline Synth_PITCH_SHIFT_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PITCH_SHIFT_base *)_pool->base->_cast(Synth_PITCH_SHIFT_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PITCH_SHIFT(Synth_PITCH_SHIFT_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PITCH_SHIFT_base _base_class;

	inline Synth_PITCH_SHIFT() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::SubClass& s) :
		Arts::Object(Synth_PITCH_SHIFT_base::_create(s.string())), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PITCH_SHIFT_base::_fromString(r.string())):(Synth_PITCH_SHIFT_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::DynamicCast& c) : Arts::Object(Synth_PITCH_SHIFT_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Synth_PITCH_SHIFT& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PITCH_SHIFT(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PITCH_SHIFT null() {return Synth_PITCH_SHIFT((Synth_PITCH_SHIFT_base*)0);}
	inline static Synth_PITCH_SHIFT _from_base(Synth_PITCH_SHIFT_base* b) {return Synth_PITCH_SHIFT(b);}
	inline Synth_PITCH_SHIFT& operator=(const Synth_PITCH_SHIFT& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PITCH_SHIFT_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline float frequency();
	inline void frequency(float _newValue);
};

class Synth_STEREO_PITCH_SHIFT_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STEREO_PITCH_SHIFT_base *_create(const std::string& subClass = "Arts::Synth_STEREO_PITCH_SHIFT");
	static Synth_STEREO_PITCH_SHIFT_base *_fromString(const std::string& objectref);
	static Synth_STEREO_PITCH_SHIFT_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_STEREO_PITCH_SHIFT_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_STEREO_PITCH_SHIFT_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
};

class Synth_STEREO_PITCH_SHIFT_stub : virtual public Synth_STEREO_PITCH_SHIFT_base, virtual public Arts::StereoEffect_stub {
protected:
	Synth_STEREO_PITCH_SHIFT_stub();

public:
	Synth_STEREO_PITCH_SHIFT_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	float frequency();
	void frequency(float newValue);
};

class Synth_STEREO_PITCH_SHIFT_skel : virtual public Synth_STEREO_PITCH_SHIFT_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}

public:
	Synth_STEREO_PITCH_SHIFT_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STEREO_PITCH_SHIFT : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STEREO_PITCH_SHIFT_base *_cache;
	inline Synth_STEREO_PITCH_SHIFT_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STEREO_PITCH_SHIFT_base *)_pool->base->_cast(Synth_STEREO_PITCH_SHIFT_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STEREO_PITCH_SHIFT(Synth_STEREO_PITCH_SHIFT_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STEREO_PITCH_SHIFT_base _base_class;

	inline Synth_STEREO_PITCH_SHIFT() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STEREO_PITCH_SHIFT(const Arts::SubClass& s) :
		Arts::Object(Synth_STEREO_PITCH_SHIFT_base::_create(s.string())), _cache(0) {}
	inline Synth_STEREO_PITCH_SHIFT(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STEREO_PITCH_SHIFT_base::_fromString(r.string())):(Synth_STEREO_PITCH_SHIFT_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STEREO_PITCH_SHIFT(const Arts::DynamicCast& c) : Arts::Object(Synth_STEREO_PITCH_SHIFT_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_STEREO_PITCH_SHIFT(const Synth_STEREO_PITCH_SHIFT& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STEREO_PITCH_SHIFT(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STEREO_PITCH_SHIFT null() {return Synth_STEREO_PITCH_SHIFT((Synth_STEREO_PITCH_SHIFT_base*)0);}
	inline static Synth_STEREO_PITCH_SHIFT _from_base(Synth_STEREO_PITCH_SHIFT_base* b) {return Synth_STEREO_PITCH_SHIFT(b);}
	inline Synth_STEREO_PITCH_SHIFT& operator=(const Synth_STEREO_PITCH_SHIFT& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STEREO_PITCH_SHIFT_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline float frequency();
	inline void frequency(float _newValue);
};

class Effect_WAVECAPTURE_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static Effect_WAVECAPTURE_base *_create(const std::string& subClass = "Arts::Effect_WAVECAPTURE");
	static Effect_WAVECAPTURE_base *_fromString(const std::string& objectref);
	static Effect_WAVECAPTURE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Effect_WAVECAPTURE_base *_fromDynamicCast(const Arts::Object& object);
	inline Effect_WAVECAPTURE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
};

class Effect_WAVECAPTURE_stub : virtual public Effect_WAVECAPTURE_base, virtual public Arts::StereoEffect_stub {
protected:
	Effect_WAVECAPTURE_stub();

public:
	Effect_WAVECAPTURE_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
};

class Effect_WAVECAPTURE_skel : virtual public Effect_WAVECAPTURE_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}

public:
	Effect_WAVECAPTURE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Effect_WAVECAPTURE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Effect_WAVECAPTURE_base *_cache;
	inline Effect_WAVECAPTURE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Effect_WAVECAPTURE_base *)_pool->base->_cast(Effect_WAVECAPTURE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Effect_WAVECAPTURE(Effect_WAVECAPTURE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Effect_WAVECAPTURE_base _base_class;

	inline Effect_WAVECAPTURE() : Arts::Object(_Creator), _cache(0) {}
	inline Effect_WAVECAPTURE(const Arts::SubClass& s) :
		Arts::Object(Effect_WAVECAPTURE_base::_create(s.string())), _cache(0) {}
	inline Effect_WAVECAPTURE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Effect_WAVECAPTURE_base::_fromString(r.string())):(Effect_WAVECAPTURE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Effect_WAVECAPTURE(const Arts::DynamicCast& c) : Arts::Object(Effect_WAVECAPTURE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Effect_WAVECAPTURE(const Effect_WAVECAPTURE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Effect_WAVECAPTURE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Effect_WAVECAPTURE null() {return Effect_WAVECAPTURE((Effect_WAVECAPTURE_base*)0);}
	inline static Effect_WAVECAPTURE _from_base(Effect_WAVECAPTURE_base* b) {return Effect_WAVECAPTURE(b);}
	inline Effect_WAVECAPTURE& operator=(const Effect_WAVECAPTURE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Effect_WAVECAPTURE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
};

class Synth_STEREO_FIR_EQUALIZER_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STEREO_FIR_EQUALIZER_base *_create(const std::string& subClass = "Arts::Synth_STEREO_FIR_EQUALIZER");
	static Synth_STEREO_FIR_EQUALIZER_base *_fromString(const std::string& objectref);
	static Synth_STEREO_FIR_EQUALIZER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_STEREO_FIR_EQUALIZER_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_STEREO_FIR_EQUALIZER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::GraphPoint> * frequencies() = 0;
	virtual void frequencies(const std::vector<Arts::GraphPoint>& newValue) = 0;
	virtual long taps() = 0;
	virtual void taps(long newValue) = 0;
};

class Synth_STEREO_FIR_EQUALIZER_stub : virtual public Synth_STEREO_FIR_EQUALIZER_base, virtual public Arts::StereoEffect_stub {
protected:
	Synth_STEREO_FIR_EQUALIZER_stub();

public:
	Synth_STEREO_FIR_EQUALIZER_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::GraphPoint> * frequencies();
	void frequencies(const std::vector<Arts::GraphPoint>& newValue);
	long taps();
	void taps(long newValue);
};

class Synth_STEREO_FIR_EQUALIZER_skel : virtual public Synth_STEREO_FIR_EQUALIZER_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void taps_changed(long newValue) {
		_emit_changed("taps_changed",newValue);
	}

public:
	Synth_STEREO_FIR_EQUALIZER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STEREO_FIR_EQUALIZER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STEREO_FIR_EQUALIZER_base *_cache;
	inline Synth_STEREO_FIR_EQUALIZER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STEREO_FIR_EQUALIZER_base *)_pool->base->_cast(Synth_STEREO_FIR_EQUALIZER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STEREO_FIR_EQUALIZER(Synth_STEREO_FIR_EQUALIZER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STEREO_FIR_EQUALIZER_base _base_class;

	inline Synth_STEREO_FIR_EQUALIZER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STEREO_FIR_EQUALIZER(const Arts::SubClass& s) :
		Arts::Object(Synth_STEREO_FIR_EQUALIZER_base::_create(s.string())), _cache(0) {}
	inline Synth_STEREO_FIR_EQUALIZER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STEREO_FIR_EQUALIZER_base::_fromString(r.string())):(Synth_STEREO_FIR_EQUALIZER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STEREO_FIR_EQUALIZER(const Arts::DynamicCast& c) : Arts::Object(Synth_STEREO_FIR_EQUALIZER_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_STEREO_FIR_EQUALIZER(const Synth_STEREO_FIR_EQUALIZER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STEREO_FIR_EQUALIZER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STEREO_FIR_EQUALIZER null() {return Synth_STEREO_FIR_EQUALIZER((Synth_STEREO_FIR_EQUALIZER_base*)0);}
	inline static Synth_STEREO_FIR_EQUALIZER _from_base(Synth_STEREO_FIR_EQUALIZER_base* b) {return Synth_STEREO_FIR_EQUALIZER(b);}
	inline Synth_STEREO_FIR_EQUALIZER& operator=(const Synth_STEREO_FIR_EQUALIZER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STEREO_FIR_EQUALIZER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::vector<Arts::GraphPoint> * frequencies();
	inline void frequencies(const std::vector<Arts::GraphPoint>& _newValue);
	inline long taps();
	inline void taps(long _newValue);
};

class StereoFirEqualizerGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static StereoFirEqualizerGuiFactory_base *_create(const std::string& subClass = "Arts::StereoFirEqualizerGuiFactory");
	static StereoFirEqualizerGuiFactory_base *_fromString(const std::string& objectref);
	static StereoFirEqualizerGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoFirEqualizerGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoFirEqualizerGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class StereoFirEqualizerGuiFactory_stub : virtual public StereoFirEqualizerGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	StereoFirEqualizerGuiFactory_stub();

public:
	StereoFirEqualizerGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class StereoFirEqualizerGuiFactory_skel : virtual public StereoFirEqualizerGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	StereoFirEqualizerGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StereoFirEqualizerGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoFirEqualizerGuiFactory_base *_cache;
	inline StereoFirEqualizerGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoFirEqualizerGuiFactory_base *)_pool->base->_cast(StereoFirEqualizerGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoFirEqualizerGuiFactory(StereoFirEqualizerGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoFirEqualizerGuiFactory_base _base_class;

	inline StereoFirEqualizerGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline StereoFirEqualizerGuiFactory(const Arts::SubClass& s) :
		Arts::Object(StereoFirEqualizerGuiFactory_base::_create(s.string())), _cache(0) {}
	inline StereoFirEqualizerGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoFirEqualizerGuiFactory_base::_fromString(r.string())):(StereoFirEqualizerGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoFirEqualizerGuiFactory(const Arts::DynamicCast& c) : Arts::Object(StereoFirEqualizerGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoFirEqualizerGuiFactory(const StereoFirEqualizerGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoFirEqualizerGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoFirEqualizerGuiFactory null() {return StereoFirEqualizerGuiFactory((StereoFirEqualizerGuiFactory_base*)0);}
	inline static StereoFirEqualizerGuiFactory _from_base(StereoFirEqualizerGuiFactory_base* b) {return StereoFirEqualizerGuiFactory(b);}
	inline StereoFirEqualizerGuiFactory& operator=(const StereoFirEqualizerGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline StereoFirEqualizerGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class Synth_PLAY_PAT_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_PAT_base *_create(const std::string& subClass = "Arts::Synth_PLAY_PAT");
	static Synth_PLAY_PAT_base *_fromString(const std::string& objectref);
	static Synth_PLAY_PAT_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_PLAY_PAT_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_PLAY_PAT_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
};

class Synth_PLAY_PAT_stub : virtual public Synth_PLAY_PAT_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PLAY_PAT_stub();

public:
	Synth_PLAY_PAT_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
};

class Synth_PLAY_PAT_skel : virtual public Synth_PLAY_PAT_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}

public:
	Synth_PLAY_PAT_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PLAY_PAT : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PLAY_PAT_base *_cache;
	inline Synth_PLAY_PAT_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_PAT_base *)_pool->base->_cast(Synth_PLAY_PAT_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PLAY_PAT(Synth_PLAY_PAT_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PLAY_PAT_base _base_class;

	inline Synth_PLAY_PAT() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PLAY_PAT(const Arts::SubClass& s) :
		Arts::Object(Synth_PLAY_PAT_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY_PAT(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PLAY_PAT_base::_fromString(r.string())):(Synth_PLAY_PAT_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY_PAT(const Arts::DynamicCast& c) : Arts::Object(Synth_PLAY_PAT_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_PLAY_PAT(const Synth_PLAY_PAT& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PLAY_PAT(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PLAY_PAT null() {return Synth_PLAY_PAT((Synth_PLAY_PAT_base*)0);}
	inline static Synth_PLAY_PAT _from_base(Synth_PLAY_PAT_base* b) {return Synth_PLAY_PAT(b);}
	inline Synth_PLAY_PAT& operator=(const Synth_PLAY_PAT& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PLAY_PAT_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
};

class Interface_MIDI_NOTE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Interface_MIDI_NOTE_base *_create(const std::string& subClass = "Arts::Interface_MIDI_NOTE");
	static Interface_MIDI_NOTE_base *_fromString(const std::string& objectref);
	static Interface_MIDI_NOTE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Interface_MIDI_NOTE_base *_fromDynamicCast(const Arts::Object& object);
	inline Interface_MIDI_NOTE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Interface_MIDI_NOTE_stub : virtual public Interface_MIDI_NOTE_base, virtual public Arts::SynthModule_stub {
protected:
	Interface_MIDI_NOTE_stub();

public:
	Interface_MIDI_NOTE_stub(Arts::Connection *connection, long objectID);

};

class Interface_MIDI_NOTE_skel : virtual public Interface_MIDI_NOTE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // outgoing stream
	float *velocity;                          // outgoing stream
	float *pressed;                           // outgoing stream

public:
	Interface_MIDI_NOTE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Interface_MIDI_NOTE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Interface_MIDI_NOTE_base *_cache;
	inline Interface_MIDI_NOTE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Interface_MIDI_NOTE_base *)_pool->base->_cast(Interface_MIDI_NOTE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Interface_MIDI_NOTE(Interface_MIDI_NOTE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Interface_MIDI_NOTE_base _base_class;

	inline Interface_MIDI_NOTE() : Arts::Object(_Creator), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::SubClass& s) :
		Arts::Object(Interface_MIDI_NOTE_base::_create(s.string())), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Interface_MIDI_NOTE_base::_fromString(r.string())):(Interface_MIDI_NOTE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::DynamicCast& c) : Arts::Object(Interface_MIDI_NOTE_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Interface_MIDI_NOTE(const Interface_MIDI_NOTE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Interface_MIDI_NOTE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Interface_MIDI_NOTE null() {return Interface_MIDI_NOTE((Interface_MIDI_NOTE_base*)0);}
	inline static Interface_MIDI_NOTE _from_base(Interface_MIDI_NOTE_base* b) {return Interface_MIDI_NOTE(b);}
	inline Interface_MIDI_NOTE& operator=(const Interface_MIDI_NOTE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Interface_MIDI_NOTE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_STRUCT_KILL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STRUCT_KILL_base *_create(const std::string& subClass = "Arts::Synth_STRUCT_KILL");
	static Synth_STRUCT_KILL_base *_fromString(const std::string& objectref);
	static Synth_STRUCT_KILL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_STRUCT_KILL_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_STRUCT_KILL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_STRUCT_KILL_stub : virtual public Synth_STRUCT_KILL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_STRUCT_KILL_stub();

public:
	Synth_STRUCT_KILL_stub(Arts::Connection *connection, long objectID);

};

class Synth_STRUCT_KILL_skel : virtual public Synth_STRUCT_KILL_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *ready;                             // incoming stream

public:
	Synth_STRUCT_KILL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STRUCT_KILL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STRUCT_KILL_base *_cache;
	inline Synth_STRUCT_KILL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STRUCT_KILL_base *)_pool->base->_cast(Synth_STRUCT_KILL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STRUCT_KILL(Synth_STRUCT_KILL_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STRUCT_KILL_base _base_class;

	inline Synth_STRUCT_KILL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::SubClass& s) :
		Arts::Object(Synth_STRUCT_KILL_base::_create(s.string())), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STRUCT_KILL_base::_fromString(r.string())):(Synth_STRUCT_KILL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::DynamicCast& c) : Arts::Object(Synth_STRUCT_KILL_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_STRUCT_KILL(const Synth_STRUCT_KILL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STRUCT_KILL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STRUCT_KILL null() {return Synth_STRUCT_KILL((Synth_STRUCT_KILL_base*)0);}
	inline static Synth_STRUCT_KILL _from_base(Synth_STRUCT_KILL_base* b) {return Synth_STRUCT_KILL(b);}
	inline Synth_STRUCT_KILL& operator=(const Synth_STRUCT_KILL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STRUCT_KILL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

};
// Forward wrapper calls to _base classes:

inline void Arts::Environment::Context::addEntry(const std::string& name, Arts::Object obj)
{
	 _cache?static_cast<Arts::Environment::Context_base*>(_cache)->addEntry(name, obj):static_cast<Arts::Environment::Context_base*>(_method_call())->addEntry(name, obj);
}

inline std::string Arts::Environment::Context::lookupEntry(Arts::Object obj)
{
	return _cache?static_cast<Arts::Environment::Context_base*>(_cache)->lookupEntry(obj):static_cast<Arts::Environment::Context_base*>(_method_call())->lookupEntry(obj);
}

inline void Arts::Environment::Context::removeEntry(Arts::Object obj)
{
	 _cache?static_cast<Arts::Environment::Context_base*>(_cache)->removeEntry(obj):static_cast<Arts::Environment::Context_base*>(_method_call())->removeEntry(obj);
}

inline std::string Arts::Environment::Container::dataDirectory()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->dataDirectory():static_cast<Arts::Environment::Container_base*>(_method_call())->dataDirectory();
}

inline void Arts::Environment::Container::dataDirectory(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->dataDirectory(_newValue):static_cast<Arts::Environment::Container_base*>(_method_call())->dataDirectory(_newValue);
}

inline Arts::Environment::Context Arts::Environment::Container::context()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->context():static_cast<Arts::Environment::Container_base*>(_method_call())->context();
}

inline void Arts::Environment::Container::context(Arts::Environment::Context _newValue)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->context(_newValue):static_cast<Arts::Environment::Container_base*>(_method_call())->context(_newValue);
}

inline std::vector<Arts::Environment::Item> * Arts::Environment::Container::items()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->items():static_cast<Arts::Environment::Container_base*>(_method_call())->items();
}

inline std::vector<std::string> * Arts::Environment::Container::saveToList()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->saveToList():static_cast<Arts::Environment::Container_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::Container::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Container_base*>(_method_call())->loadFromList(strlist);
}

inline void Arts::Environment::Container::addItem(Arts::Environment::Item item)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->addItem(item):static_cast<Arts::Environment::Container_base*>(_method_call())->addItem(item);
}

inline Arts::Environment::Item Arts::Environment::Container::createItem(const std::string& name)
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->createItem(name):static_cast<Arts::Environment::Container_base*>(_method_call())->createItem(name);
}

inline void Arts::Environment::Container::removeItem(Arts::Environment::Item item)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->removeItem(item):static_cast<Arts::Environment::Container_base*>(_method_call())->removeItem(item);
}

inline bool Arts::Environment::Item::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::Item::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::Item::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::Item::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::Item::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline bool Arts::Environment::InstrumentItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::InstrumentItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::InstrumentItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::InstrumentItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::InstrumentItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline Arts::MidiPort Arts::Environment::InstrumentItem::port()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->port():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->port();
}

inline std::string Arts::Environment::InstrumentItem::filename()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->filename():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->filename();
}

inline void Arts::Environment::InstrumentItem::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->filename(_newValue):static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->filename(_newValue);
}

inline std::string Arts::Environment::InstrumentItem::busname()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->busname():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->busname();
}

inline void Arts::Environment::InstrumentItem::busname(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->busname(_newValue):static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->busname(_newValue);
}

inline Arts::Widget Arts::Environment::InstrumentItemGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline bool Arts::Environment::StereoEffectItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::StereoEffectItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::StereoEffectItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::StereoEffectItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::StereoEffectItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline Arts::SynthModule Arts::Environment::StereoEffectItem::effect()
{
	return _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->effect():static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->effect();
}

inline void Arts::Environment::StereoEffectItem::effect(Arts::SynthModule _newValue)
{
	 _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->effect(_newValue):static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->effect(_newValue);
}

inline Arts::StereoEffectStack Arts::Environment::StereoEffectItem::stack()
{
	return _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->stack():static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->stack();
}

inline void Arts::Environment::StereoEffectItem::stack(Arts::StereoEffectStack _newValue)
{
	 _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->stack(_newValue):static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->stack(_newValue);
}

inline Arts::AutoSuspendState Arts::Environment::MixerChannel::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Environment::MixerChannel::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Environment::MixerChannel::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Environment::MixerChannel::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Environment::MixerChannel::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Environment::MixerChannel::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Environment::MixerChannel::name()
{
	return _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name():static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name();
}

inline void Arts::Environment::MixerChannel::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name(_newValue);
}

inline bool Arts::Environment::MixerItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::MixerItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::MixerItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::MixerItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::MixerItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline std::vector<Arts::Environment::MixerChannel> * Arts::Environment::MixerItem::channels()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channels():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channels();
}

inline long Arts::Environment::MixerItem::channelCount()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channelCount():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channelCount();
}

inline void Arts::Environment::MixerItem::channelCount(long _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channelCount(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channelCount(_newValue);
}

inline std::string Arts::Environment::MixerItem::name()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->name():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->name();
}

inline void Arts::Environment::MixerItem::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->name(_newValue);
}

inline std::string Arts::Environment::MixerItem::type()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->type():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->type();
}

inline void Arts::Environment::MixerItem::type(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->type(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->type(_newValue);
}

inline std::string Arts::SimpleMixerChannel::name()
{
	return _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name():static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name();
}

inline void Arts::SimpleMixerChannel::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name(_newValue);
}

inline Arts::AutoSuspendState Arts::SimpleMixerChannel::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::SimpleMixerChannel::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::SimpleMixerChannel::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::SimpleMixerChannel::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::SimpleMixerChannel::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::SimpleMixerChannel::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::Synth_STD_EQUALIZER Arts::SimpleMixerChannel::equalizerLeft()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->equalizerLeft():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->equalizerLeft();
}

inline Arts::Synth_STD_EQUALIZER Arts::SimpleMixerChannel::equalizerRight()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->equalizerRight():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->equalizerRight();
}

inline Arts::StereoEffectStack Arts::SimpleMixerChannel::insertEffects()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->insertEffects():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->insertEffects();
}

inline float Arts::SimpleMixerChannel::gainLeft()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->gainLeft():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->gainLeft();
}

inline void Arts::SimpleMixerChannel::gainLeft(float _newValue)
{
	 _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->gainLeft(_newValue):static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->gainLeft(_newValue);
}

inline float Arts::SimpleMixerChannel::gainRight()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->gainRight():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->gainRight();
}

inline void Arts::SimpleMixerChannel::gainRight(float _newValue)
{
	 _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->gainRight(_newValue):static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->gainRight(_newValue);
}

inline float Arts::SimpleMixerChannel::pan()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->pan():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->pan();
}

inline void Arts::SimpleMixerChannel::pan(float _newValue)
{
	 _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->pan(_newValue):static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->pan(_newValue);
}

inline float Arts::SimpleMixerChannel::volumeLeft()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->volumeLeft():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->volumeLeft();
}

inline void Arts::SimpleMixerChannel::volumeLeft(float _newValue)
{
	 _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->volumeLeft(_newValue):static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->volumeLeft(_newValue);
}

inline float Arts::SimpleMixerChannel::volumeRight()
{
	return _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->volumeRight():static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->volumeRight();
}

inline void Arts::SimpleMixerChannel::volumeRight(float _newValue)
{
	 _cache?static_cast<Arts::SimpleMixerChannel_base*>(_cache)->volumeRight(_newValue):static_cast<Arts::SimpleMixerChannel_base*>(_method_call())->volumeRight(_newValue);
}

inline std::string Arts::MonoSimpleMixerChannel::name()
{
	return _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name():static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name();
}

inline void Arts::MonoSimpleMixerChannel::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name(_newValue);
}

inline Arts::AutoSuspendState Arts::MonoSimpleMixerChannel::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::MonoSimpleMixerChannel::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::MonoSimpleMixerChannel::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::MonoSimpleMixerChannel::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::MonoSimpleMixerChannel::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::MonoSimpleMixerChannel::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::Synth_STD_EQUALIZER Arts::MonoSimpleMixerChannel::equalizer()
{
	return _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->equalizer():static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->equalizer();
}

inline Arts::StereoEffectStack Arts::MonoSimpleMixerChannel::insertEffects()
{
	return _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->insertEffects():static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->insertEffects();
}

inline float Arts::MonoSimpleMixerChannel::gain()
{
	return _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->gain():static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->gain();
}

inline void Arts::MonoSimpleMixerChannel::gain(float _newValue)
{
	 _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->gain(_newValue):static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->gain(_newValue);
}

inline float Arts::MonoSimpleMixerChannel::pan()
{
	return _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->pan():static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->pan();
}

inline void Arts::MonoSimpleMixerChannel::pan(float _newValue)
{
	 _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->pan(_newValue):static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->pan(_newValue);
}

inline float Arts::MonoSimpleMixerChannel::volume()
{
	return _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->volume():static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->volume();
}

inline void Arts::MonoSimpleMixerChannel::volume(float _newValue)
{
	 _cache?static_cast<Arts::MonoSimpleMixerChannel_base*>(_cache)->volume(_newValue):static_cast<Arts::MonoSimpleMixerChannel_base*>(_method_call())->volume(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_AUX_BUS::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_AUX_BUS::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_AUX_BUS::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_AUX_BUS::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_AUX_BUS::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_AUX_BUS::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_AUX_BUS::level()
{
	return _cache?static_cast<Arts::Synth_AUX_BUS_base*>(_cache)->level():static_cast<Arts::Synth_AUX_BUS_base*>(_method_call())->level();
}

inline void Arts::Synth_AUX_BUS::level(float _newValue)
{
	 _cache?static_cast<Arts::Synth_AUX_BUS_base*>(_cache)->level(_newValue):static_cast<Arts::Synth_AUX_BUS_base*>(_method_call())->level(_newValue);
}

inline long Arts::Synth_AUX_BUS::channel()
{
	return _cache?static_cast<Arts::Synth_AUX_BUS_base*>(_cache)->channel():static_cast<Arts::Synth_AUX_BUS_base*>(_method_call())->channel();
}

inline void Arts::Synth_AUX_BUS::channel(long _newValue)
{
	 _cache?static_cast<Arts::Synth_AUX_BUS_base*>(_cache)->channel(_newValue):static_cast<Arts::Synth_AUX_BUS_base*>(_method_call())->channel(_newValue);
}

inline std::string Arts::MonoComplexMixerChannel::name()
{
	return _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name():static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name();
}

inline void Arts::MonoComplexMixerChannel::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name(_newValue);
}

inline Arts::AutoSuspendState Arts::MonoComplexMixerChannel::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::MonoComplexMixerChannel::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::MonoComplexMixerChannel::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::MonoComplexMixerChannel::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::MonoComplexMixerChannel::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::MonoComplexMixerChannel::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::Synth_STD_EQUALIZER Arts::MonoComplexMixerChannel::equalizer()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->equalizer():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->equalizer();
}

inline Arts::StereoEffectStack Arts::MonoComplexMixerChannel::insertEffects()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->insertEffects():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->insertEffects();
}

inline std::vector<Arts::Synth_AUX_BUS> * Arts::MonoComplexMixerChannel::aux()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->aux():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->aux();
}

inline float Arts::MonoComplexMixerChannel::gain()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->gain():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->gain();
}

inline void Arts::MonoComplexMixerChannel::gain(float _newValue)
{
	 _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->gain(_newValue):static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->gain(_newValue);
}

inline float Arts::MonoComplexMixerChannel::volume()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->volume():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->volume();
}

inline void Arts::MonoComplexMixerChannel::volume(float _newValue)
{
	 _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->volume(_newValue):static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->volume(_newValue);
}

inline float Arts::MonoComplexMixerChannel::pan()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->pan():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->pan();
}

inline void Arts::MonoComplexMixerChannel::pan(float _newValue)
{
	 _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->pan(_newValue):static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->pan(_newValue);
}

inline bool Arts::MonoComplexMixerChannel::mute()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->mute():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->mute();
}

inline void Arts::MonoComplexMixerChannel::mute(bool _newValue)
{
	 _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->mute(_newValue):static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->mute(_newValue);
}

inline bool Arts::MonoComplexMixerChannel::pfl()
{
	return _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->pfl():static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->pfl();
}

inline void Arts::MonoComplexMixerChannel::pfl(bool _newValue)
{
	 _cache?static_cast<Arts::MonoComplexMixerChannel_base*>(_cache)->pfl(_newValue):static_cast<Arts::MonoComplexMixerChannel_base*>(_method_call())->pfl(_newValue);
}

inline Arts::Widget Arts::MixerGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::Widget Arts::MonoSimpleMixerChannelGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::Widget Arts::SimpleMixerChannelGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline bool Arts::MixerItemGui::active()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->active():static_cast<Arts::MixerItemGui_base*>(_method_call())->active();
}

inline void Arts::MixerItemGui::active(bool _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->active(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->active(_newValue);
}

inline long Arts::MixerItemGui::channelCount()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->channelCount():static_cast<Arts::MixerItemGui_base*>(_method_call())->channelCount();
}

inline void Arts::MixerItemGui::channelCount(long _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->channelCount(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->channelCount(_newValue);
}

inline std::string Arts::MixerItemGui::type()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->type():static_cast<Arts::MixerItemGui_base*>(_method_call())->type();
}

inline void Arts::MixerItemGui::type(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->type(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->type(_newValue);
}

inline Arts::Widget Arts::MixerItemGui::initialize(Arts::Environment::MixerItem item)
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->initialize(item):static_cast<Arts::MixerItemGui_base*>(_method_call())->initialize(item);
}

inline void Arts::ObjectCache::put(Arts::Object obj, const std::string& name)
{
	 _cache?static_cast<Arts::ObjectCache_base*>(_cache)->put(obj, name):static_cast<Arts::ObjectCache_base*>(_method_call())->put(obj, name);
}

inline Arts::Object Arts::ObjectCache::get(const std::string& name)
{
	return _cache?static_cast<Arts::ObjectCache_base*>(_cache)->get(name):static_cast<Arts::ObjectCache_base*>(_method_call())->get(name);
}

inline Arts::AutoSuspendState Arts::MidiReleaseHelper::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::MidiReleaseHelper::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::MidiReleaseHelper::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::MidiReleaseHelper::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::MidiReleaseHelper::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::MidiReleaseHelper::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::SynthModule Arts::MidiReleaseHelper::voice()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->voice():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->voice();
}

inline void Arts::MidiReleaseHelper::voice(Arts::SynthModule _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->voice(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->voice(_newValue);
}

inline std::string Arts::MidiReleaseHelper::name()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->name():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->name();
}

inline void Arts::MidiReleaseHelper::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->name(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->name(_newValue);
}

inline Arts::ObjectCache Arts::MidiReleaseHelper::cache()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->cache():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->cache();
}

inline void Arts::MidiReleaseHelper::cache(Arts::ObjectCache _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->cache(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->cache(_newValue);
}

inline bool Arts::MidiReleaseHelper::terminate()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->terminate():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->terminate();
}

inline Arts::AutoSuspendState Arts::Synth_CAPTURE_WAV::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_CAPTURE_WAV::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_CAPTURE_WAV::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_CAPTURE_WAV::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_CAPTURE_WAV::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_CAPTURE_WAV::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_CAPTURE_WAV::filename()
{
	return _cache?static_cast<Arts::Synth_CAPTURE_WAV_base*>(_cache)->filename():static_cast<Arts::Synth_CAPTURE_WAV_base*>(_method_call())->filename();
}

inline void Arts::Synth_CAPTURE_WAV::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_CAPTURE_WAV_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_CAPTURE_WAV_base*>(_method_call())->filename(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_COMPRESSOR::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_COMPRESSOR::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_COMPRESSOR::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_COMPRESSOR::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_COMPRESSOR::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_COMPRESSOR::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_COMPRESSOR::attack()
{
	return _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->attack():static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->attack();
}

inline void Arts::Synth_COMPRESSOR::attack(float _newValue)
{
	 _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->attack(_newValue):static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->attack(_newValue);
}

inline float Arts::Synth_COMPRESSOR::release()
{
	return _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->release():static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->release();
}

inline void Arts::Synth_COMPRESSOR::release(float _newValue)
{
	 _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->release(_newValue):static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->release(_newValue);
}

inline float Arts::Synth_COMPRESSOR::threshold()
{
	return _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->threshold():static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->threshold();
}

inline void Arts::Synth_COMPRESSOR::threshold(float _newValue)
{
	 _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->threshold(_newValue):static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->threshold(_newValue);
}

inline float Arts::Synth_COMPRESSOR::ratio()
{
	return _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->ratio():static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->ratio();
}

inline void Arts::Synth_COMPRESSOR::ratio(float _newValue)
{
	 _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->ratio(_newValue):static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->ratio(_newValue);
}

inline float Arts::Synth_COMPRESSOR::output()
{
	return _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->output():static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->output();
}

inline void Arts::Synth_COMPRESSOR::output(float _newValue)
{
	 _cache?static_cast<Arts::Synth_COMPRESSOR_base*>(_cache)->output(_newValue):static_cast<Arts::Synth_COMPRESSOR_base*>(_method_call())->output(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_NIL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_NIL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_NIL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_NIL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_NIL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_NIL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_DEBUG::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DEBUG::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DEBUG::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DEBUG::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DEBUG::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DEBUG::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_DEBUG::comment()
{
	return _cache?static_cast<Arts::Synth_DEBUG_base*>(_cache)->comment():static_cast<Arts::Synth_DEBUG_base*>(_method_call())->comment();
}

inline void Arts::Synth_DEBUG::comment(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_DEBUG_base*>(_cache)->comment(_newValue):static_cast<Arts::Synth_DEBUG_base*>(_method_call())->comment(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_DATA::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DATA::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DATA::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DATA::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DATA::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DATA::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_DATA::value()
{
	return _cache?static_cast<Arts::Synth_DATA_base*>(_cache)->value():static_cast<Arts::Synth_DATA_base*>(_method_call())->value();
}

inline void Arts::Synth_DATA::value(float _newValue)
{
	 _cache?static_cast<Arts::Synth_DATA_base*>(_cache)->value(_newValue):static_cast<Arts::Synth_DATA_base*>(_method_call())->value(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_ATAN_SATURATE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ATAN_SATURATE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ATAN_SATURATE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ATAN_SATURATE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ATAN_SATURATE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ATAN_SATURATE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_ATAN_SATURATE::inscale()
{
	return _cache?static_cast<Arts::Synth_ATAN_SATURATE_base*>(_cache)->inscale():static_cast<Arts::Synth_ATAN_SATURATE_base*>(_method_call())->inscale();
}

inline void Arts::Synth_ATAN_SATURATE::inscale(float _newValue)
{
	 _cache?static_cast<Arts::Synth_ATAN_SATURATE_base*>(_cache)->inscale(_newValue):static_cast<Arts::Synth_ATAN_SATURATE_base*>(_method_call())->inscale(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_BRICKWALL_LIMITER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_BRICKWALL_LIMITER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_BRICKWALL_LIMITER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_AUTOPANNER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_AUTOPANNER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_AUTOPANNER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_AUTOPANNER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_AUTOPANNER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_AUTOPANNER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_DELAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DELAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DELAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DELAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DELAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DELAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_DELAY::maxdelay()
{
	return _cache?static_cast<Arts::Synth_DELAY_base*>(_cache)->maxdelay():static_cast<Arts::Synth_DELAY_base*>(_method_call())->maxdelay();
}

inline void Arts::Synth_DELAY::maxdelay(float _newValue)
{
	 _cache?static_cast<Arts::Synth_DELAY_base*>(_cache)->maxdelay(_newValue):static_cast<Arts::Synth_DELAY_base*>(_method_call())->maxdelay(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_CDELAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_CDELAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_CDELAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_CDELAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_CDELAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_CDELAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_CDELAY::time()
{
	return _cache?static_cast<Arts::Synth_CDELAY_base*>(_cache)->time():static_cast<Arts::Synth_CDELAY_base*>(_method_call())->time();
}

inline void Arts::Synth_CDELAY::time(float _newValue)
{
	 _cache?static_cast<Arts::Synth_CDELAY_base*>(_cache)->time(_newValue):static_cast<Arts::Synth_CDELAY_base*>(_method_call())->time(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_FM_SOURCE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FM_SOURCE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FM_SOURCE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FM_SOURCE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FM_SOURCE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FM_SOURCE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_TREMOLO::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_TREMOLO::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_TREMOLO::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_TREMOLO::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_TREMOLO::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_TREMOLO::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_FX_CFLANGER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FX_CFLANGER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FX_CFLANGER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FX_CFLANGER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FX_CFLANGER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FX_CFLANGER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_FX_CFLANGER::mintime()
{
	return _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->mintime():static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->mintime();
}

inline void Arts::Synth_FX_CFLANGER::mintime(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->mintime(_newValue):static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->mintime(_newValue);
}

inline float Arts::Synth_FX_CFLANGER::maxtime()
{
	return _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->maxtime():static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->maxtime();
}

inline void Arts::Synth_FX_CFLANGER::maxtime(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->maxtime(_newValue):static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->maxtime(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_NOISE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_NOISE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_NOISE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_NOISE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_NOISE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_NOISE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_TRI::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_TRI::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_TRI::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_TRI::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_TRI::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_TRI::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SQUARE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SQUARE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SQUARE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SQUARE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SQUARE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SQUARE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_PULSE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_PULSE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_PULSE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_PULSE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_PULSE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_PULSE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_WAVE_PULSE::dutycycle()
{
	return _cache?static_cast<Arts::Synth_WAVE_PULSE_base*>(_cache)->dutycycle():static_cast<Arts::Synth_WAVE_PULSE_base*>(_method_call())->dutycycle();
}

inline void Arts::Synth_WAVE_PULSE::dutycycle(float _newValue)
{
	 _cache?static_cast<Arts::Synth_WAVE_PULSE_base*>(_cache)->dutycycle(_newValue):static_cast<Arts::Synth_WAVE_PULSE_base*>(_method_call())->dutycycle(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SOFTSAW::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SOFTSAW::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SOFTSAW::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_ENVELOPE_ADSR::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ENVELOPE_ADSR::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ENVELOPE_ADSR::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_SHELVE_CUTOFF::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_SHELVE_CUTOFF::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_SHELVE_CUTOFF::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_XFADE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_XFADE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_XFADE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_XFADE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_XFADE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_XFADE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MIDI_TEST::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MIDI_TEST::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MIDI_TEST::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MIDI_TEST::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MIDI_TEST::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MIDI_TEST::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::TimeStamp Arts::Synth_MIDI_TEST::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::Synth_MIDI_TEST::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::Synth_MIDI_TEST::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::Synth_MIDI_TEST::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline std::string Arts::Synth_MIDI_TEST::filename()
{
	return _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->filename():static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->filename();
}

inline void Arts::Synth_MIDI_TEST::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->filename(_newValue);
}

inline std::string Arts::Synth_MIDI_TEST::busname()
{
	return _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->busname():static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->busname();
}

inline void Arts::Synth_MIDI_TEST::busname(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->busname(_newValue):static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->busname(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_MIDI_DEBUG::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MIDI_DEBUG::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MIDI_DEBUG::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MIDI_DEBUG::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MIDI_DEBUG::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MIDI_DEBUG::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::TimeStamp Arts::Synth_MIDI_DEBUG::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::Synth_MIDI_DEBUG::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::Synth_MIDI_DEBUG::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::Synth_MIDI_DEBUG::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline Arts::AutoSuspendState Arts::Synth_FREEVERB::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FREEVERB::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FREEVERB::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FREEVERB::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FREEVERB::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FREEVERB::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_FREEVERB::roomsize()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->roomsize():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->roomsize();
}

inline void Arts::Synth_FREEVERB::roomsize(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->roomsize(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->roomsize(_newValue);
}

inline float Arts::Synth_FREEVERB::damp()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->damp():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->damp();
}

inline void Arts::Synth_FREEVERB::damp(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->damp(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->damp(_newValue);
}

inline float Arts::Synth_FREEVERB::wet()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->wet():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->wet();
}

inline void Arts::Synth_FREEVERB::wet(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->wet(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->wet(_newValue);
}

inline float Arts::Synth_FREEVERB::dry()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->dry():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->dry();
}

inline void Arts::Synth_FREEVERB::dry(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->dry(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->dry(_newValue);
}

inline float Arts::Synth_FREEVERB::width()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->width():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->width();
}

inline void Arts::Synth_FREEVERB::width(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->width(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->width(_newValue);
}

inline float Arts::Synth_FREEVERB::mode()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->mode():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->mode();
}

inline void Arts::Synth_FREEVERB::mode(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->mode(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->mode(_newValue);
}

inline Arts::Widget Arts::FreeverbGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::AutoSuspendState Arts::Synth_STD_EQUALIZER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STD_EQUALIZER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STD_EQUALIZER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STD_EQUALIZER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STD_EQUALIZER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STD_EQUALIZER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_STD_EQUALIZER::low()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->low():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->low();
}

inline void Arts::Synth_STD_EQUALIZER::low(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->low(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->low(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::mid()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->mid():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->mid();
}

inline void Arts::Synth_STD_EQUALIZER::mid(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->mid(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->mid(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::high()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->high():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->high();
}

inline void Arts::Synth_STD_EQUALIZER::high(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->high(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->high(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::frequency()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->frequency():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->frequency();
}

inline void Arts::Synth_STD_EQUALIZER::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->frequency(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::q()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->q():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->q();
}

inline void Arts::Synth_STD_EQUALIZER::q(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->q(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->q(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_RC::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_RC::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_RC::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_RC::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_RC::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_RC::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_RC::b()
{
	return _cache?static_cast<Arts::Synth_RC_base*>(_cache)->b():static_cast<Arts::Synth_RC_base*>(_method_call())->b();
}

inline void Arts::Synth_RC::b(float _newValue)
{
	 _cache?static_cast<Arts::Synth_RC_base*>(_cache)->b(_newValue):static_cast<Arts::Synth_RC_base*>(_method_call())->b(_newValue);
}

inline float Arts::Synth_RC::f()
{
	return _cache?static_cast<Arts::Synth_RC_base*>(_cache)->f():static_cast<Arts::Synth_RC_base*>(_method_call())->f();
}

inline void Arts::Synth_RC::f(float _newValue)
{
	 _cache?static_cast<Arts::Synth_RC_base*>(_cache)->f(_newValue):static_cast<Arts::Synth_RC_base*>(_method_call())->f(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_MOOG_VCF::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MOOG_VCF::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MOOG_VCF::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MOOG_VCF::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MOOG_VCF::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MOOG_VCF::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_MOOG_VCF::frequency()
{
	return _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->frequency():static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->frequency();
}

inline void Arts::Synth_MOOG_VCF::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->frequency(_newValue);
}

inline float Arts::Synth_MOOG_VCF::resonance()
{
	return _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->resonance():static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->resonance();
}

inline void Arts::Synth_MOOG_VCF::resonance(float _newValue)
{
	 _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->resonance(_newValue):static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->resonance(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_PSCALE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PSCALE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PSCALE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PSCALE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PSCALE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PSCALE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PSCALE::top()
{
	return _cache?static_cast<Arts::Synth_PSCALE_base*>(_cache)->top():static_cast<Arts::Synth_PSCALE_base*>(_method_call())->top();
}

inline void Arts::Synth_PSCALE::top(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PSCALE_base*>(_cache)->top(_newValue):static_cast<Arts::Synth_PSCALE_base*>(_method_call())->top(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_SEQUENCE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_SEQUENCE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_SEQUENCE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_SEQUENCE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_SEQUENCE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_SEQUENCE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_SEQUENCE::speed()
{
	return _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->speed():static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->speed();
}

inline void Arts::Synth_SEQUENCE::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->speed(_newValue);
}

inline std::string Arts::Synth_SEQUENCE::seq()
{
	return _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->seq():static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->seq();
}

inline void Arts::Synth_SEQUENCE::seq(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->seq(_newValue):static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->seq(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_PITCH_SHIFT::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PITCH_SHIFT::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PITCH_SHIFT::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PITCH_SHIFT::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PITCH_SHIFT::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PITCH_SHIFT::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PITCH_SHIFT::speed()
{
	return _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->speed():static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->speed();
}

inline void Arts::Synth_PITCH_SHIFT::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->speed(_newValue);
}

inline float Arts::Synth_PITCH_SHIFT::frequency()
{
	return _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->frequency():static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->frequency();
}

inline void Arts::Synth_PITCH_SHIFT::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->frequency(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_STEREO_PITCH_SHIFT::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_STEREO_PITCH_SHIFT::speed()
{
	return _cache?static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_cache)->speed():static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_method_call())->speed();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_method_call())->speed(_newValue);
}

inline float Arts::Synth_STEREO_PITCH_SHIFT::frequency()
{
	return _cache?static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_cache)->frequency():static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_method_call())->frequency();
}

inline void Arts::Synth_STEREO_PITCH_SHIFT::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_STEREO_PITCH_SHIFT_base*>(_method_call())->frequency(_newValue);
}

inline Arts::AutoSuspendState Arts::Effect_WAVECAPTURE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Effect_WAVECAPTURE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Effect_WAVECAPTURE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Effect_WAVECAPTURE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Effect_WAVECAPTURE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Effect_WAVECAPTURE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Effect_WAVECAPTURE::filename()
{
	return _cache?static_cast<Arts::Effect_WAVECAPTURE_base*>(_cache)->filename():static_cast<Arts::Effect_WAVECAPTURE_base*>(_method_call())->filename();
}

inline void Arts::Effect_WAVECAPTURE::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Effect_WAVECAPTURE_base*>(_cache)->filename(_newValue):static_cast<Arts::Effect_WAVECAPTURE_base*>(_method_call())->filename(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_STEREO_FIR_EQUALIZER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::vector<Arts::GraphPoint> * Arts::Synth_STEREO_FIR_EQUALIZER::frequencies()
{
	return _cache?static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_cache)->frequencies():static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_method_call())->frequencies();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::frequencies(const std::vector<Arts::GraphPoint>& _newValue)
{
	 _cache?static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_cache)->frequencies(_newValue):static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_method_call())->frequencies(_newValue);
}

inline long Arts::Synth_STEREO_FIR_EQUALIZER::taps()
{
	return _cache?static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_cache)->taps():static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_method_call())->taps();
}

inline void Arts::Synth_STEREO_FIR_EQUALIZER::taps(long _newValue)
{
	 _cache?static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_cache)->taps(_newValue):static_cast<Arts::Synth_STEREO_FIR_EQUALIZER_base*>(_method_call())->taps(_newValue);
}

inline Arts::Widget Arts::StereoFirEqualizerGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::AutoSuspendState Arts::Synth_PLAY_PAT::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PLAY_PAT::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PLAY_PAT::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PLAY_PAT::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PLAY_PAT::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PLAY_PAT::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_PLAY_PAT::filename()
{
	return _cache?static_cast<Arts::Synth_PLAY_PAT_base*>(_cache)->filename():static_cast<Arts::Synth_PLAY_PAT_base*>(_method_call())->filename();
}

inline void Arts::Synth_PLAY_PAT::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_PLAY_PAT_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_PLAY_PAT_base*>(_method_call())->filename(_newValue);
}

inline Arts::AutoSuspendState Arts::Interface_MIDI_NOTE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Interface_MIDI_NOTE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Interface_MIDI_NOTE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Interface_MIDI_NOTE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Interface_MIDI_NOTE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Interface_MIDI_NOTE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_STRUCT_KILL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STRUCT_KILL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STRUCT_KILL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STRUCT_KILL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STRUCT_KILL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STRUCT_KILL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

#endif /* ARTSMODULES_H */
