/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef KMEDIA2_H
#define KMEDIA2_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"

namespace Arts {
enum poState {posIdle = 0, posPlaying = 1, posPaused = 2};
enum poCapabilities {capSeek = 1, capPause = 2};
};
namespace Arts {
class poTime : public Arts::Type {
public:
	poTime();
	poTime(long _a_seconds, long _a_ms, float _a_custom, const std::string& _a_customUnit);
	poTime(Arts::Buffer& stream);
	poTime(const poTime& copyType);
	poTime& operator=(const poTime& assignType);
	long seconds;
	long ms;
	float custom;
	std::string customUnit;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

};
namespace Arts {
class PlayObject_private;
class PlayObject;
class PlayObjectFactory;
class InputStream;
class FileInputStream;
class StdoutWriter;
class StreamPlayObject;
class PitchablePlayObject;
class PlayObjectFactoryV2;

class PlayObject_private_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObject_private_base *_create(const std::string& subClass = "Arts::PlayObject_private");
	static PlayObject_private_base *_fromString(const std::string& objectref);
	static PlayObject_private_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlayObject_private_base *_fromDynamicCast(const Arts::Object& object);
	inline PlayObject_private_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool loadMedia(const std::string& filename) = 0;
};

class PlayObject_private_stub : virtual public PlayObject_private_base, virtual public Arts::Object_stub {
protected:
	PlayObject_private_stub();

public:
	PlayObject_private_stub(Arts::Connection *connection, long objectID);

	bool loadMedia(const std::string& filename);
};

class PlayObject_private_skel : virtual public PlayObject_private_base, virtual public Arts::Object_skel {
public:
	PlayObject_private_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObject_private : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObject_private_base *_cache;
	inline PlayObject_private_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObject_private_base *)_pool->base->_cast(PlayObject_private_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObject_private(PlayObject_private_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObject_private_base _base_class;

	inline PlayObject_private() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObject_private(const Arts::SubClass& s) :
		Arts::Object(PlayObject_private_base::_create(s.string())), _cache(0) {}
	inline PlayObject_private(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObject_private_base::_fromString(r.string())):(PlayObject_private_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObject_private(const Arts::DynamicCast& c) : Arts::Object(PlayObject_private_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlayObject_private(const PlayObject_private& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObject_private(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObject_private null() {return PlayObject_private((PlayObject_private_base*)0);}
	inline static PlayObject_private _from_base(PlayObject_private_base* b) {return PlayObject_private(b);}
	inline PlayObject_private& operator=(const PlayObject_private& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PlayObject_private_base* _base() {return _cache?_cache:_method_call();}

	inline bool loadMedia(const std::string& filename);
};

class PlayObject_base : virtual public Arts::PlayObject_private_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObject_base *_create(const std::string& subClass = "Arts::PlayObject");
	static PlayObject_base *_fromString(const std::string& objectref);
	static PlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlayObject_base *_fromDynamicCast(const Arts::Object& object);
	inline PlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string description() = 0;
	virtual Arts::poTime currentTime() = 0;
	virtual Arts::poTime overallTime() = 0;
	virtual Arts::poCapabilities capabilities() = 0;
	virtual std::string mediaName() = 0;
	virtual Arts::poState state() = 0;
	virtual void play() = 0;
	virtual void seek(const Arts::poTime& newTime) = 0;
	virtual void pause() = 0;
	virtual void halt() = 0;
};

class PlayObject_stub : virtual public PlayObject_base, virtual public Arts::PlayObject_private_stub {
protected:
	PlayObject_stub();

public:
	PlayObject_stub(Arts::Connection *connection, long objectID);

	std::string description();
	Arts::poTime currentTime();
	Arts::poTime overallTime();
	Arts::poCapabilities capabilities();
	std::string mediaName();
	Arts::poState state();
	void play();
	void seek(const Arts::poTime& newTime);
	void pause();
	void halt();
};

class PlayObject_skel : virtual public PlayObject_base, virtual public Arts::PlayObject_private_skel {
protected:
	// emitters for change notifications
	inline void description_changed(const std::string& newValue) {
		_emit_changed("description_changed",newValue);
	}
	inline void capabilities_changed(Arts::poCapabilities newValue) {
		_emit_changed("capabilities_changed",newValue);
	}
	inline void mediaName_changed(const std::string& newValue) {
		_emit_changed("mediaName_changed",newValue);
	}
	inline void state_changed(Arts::poState newValue) {
		_emit_changed("state_changed",newValue);
	}

public:
	PlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObject_base *_cache;
	inline PlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObject_base *)_pool->base->_cast(PlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObject(PlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObject_base _base_class;

	inline PlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObject(const Arts::SubClass& s) :
		Arts::Object(PlayObject_base::_create(s.string())), _cache(0) {}
	inline PlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObject_base::_fromString(r.string())):(PlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObject(const Arts::DynamicCast& c) : Arts::Object(PlayObject_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlayObject(const PlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObject null() {return PlayObject((PlayObject_base*)0);}
	inline static PlayObject _from_base(PlayObject_base* b) {return PlayObject(b);}
	inline PlayObject& operator=(const PlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObject_private() const { return Arts::PlayObject_private(*_pool); }
	inline PlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline bool loadMedia(const std::string& filename);
	inline std::string description();
	inline Arts::poTime currentTime();
	inline Arts::poTime overallTime();
	inline Arts::poCapabilities capabilities();
	inline std::string mediaName();
	inline Arts::poState state();
	inline void play();
	inline void seek(const Arts::poTime& newTime);
	inline void pause();
	inline void halt();
};

class PlayObjectFactory_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObjectFactory_base *_create(const std::string& subClass = "Arts::PlayObjectFactory");
	static PlayObjectFactory_base *_fromString(const std::string& objectref);
	static PlayObjectFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlayObjectFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline PlayObjectFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::PlayObject createPlayObject(const std::string& filename) = 0;
};

class PlayObjectFactory_stub : virtual public PlayObjectFactory_base, virtual public Arts::Object_stub {
protected:
	PlayObjectFactory_stub();

public:
	PlayObjectFactory_stub(Arts::Connection *connection, long objectID);

	Arts::PlayObject createPlayObject(const std::string& filename);
};

class PlayObjectFactory_skel : virtual public PlayObjectFactory_base, virtual public Arts::Object_skel {
public:
	PlayObjectFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObjectFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObjectFactory_base *_cache;
	inline PlayObjectFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObjectFactory_base *)_pool->base->_cast(PlayObjectFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObjectFactory(PlayObjectFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObjectFactory_base _base_class;

	inline PlayObjectFactory() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObjectFactory(const Arts::SubClass& s) :
		Arts::Object(PlayObjectFactory_base::_create(s.string())), _cache(0) {}
	inline PlayObjectFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObjectFactory_base::_fromString(r.string())):(PlayObjectFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObjectFactory(const Arts::DynamicCast& c) : Arts::Object(PlayObjectFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlayObjectFactory(const PlayObjectFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObjectFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObjectFactory null() {return PlayObjectFactory((PlayObjectFactory_base*)0);}
	inline static PlayObjectFactory _from_base(PlayObjectFactory_base* b) {return PlayObjectFactory(b);}
	inline PlayObjectFactory& operator=(const PlayObjectFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PlayObjectFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::PlayObject createPlayObject(const std::string& filename);
};

class InputStream_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static InputStream_base *_create(const std::string& subClass = "Arts::InputStream");
	static InputStream_base *_fromString(const std::string& objectref);
	static InputStream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static InputStream_base *_fromDynamicCast(const Arts::Object& object);
	inline InputStream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool eof() = 0;
	virtual long size() = 0;
	virtual bool seekOk() = 0;
	virtual long seek(long position) = 0;
};

class InputStream_stub : virtual public InputStream_base, virtual public Arts::SynthModule_stub {
protected:
	InputStream_stub();

public:
	InputStream_stub(Arts::Connection *connection, long objectID);

	bool eof();
	long size();
	bool seekOk();
	long seek(long position);
};

class InputStream_skel : virtual public InputStream_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream outdata;            // outgoing stream

	// handler for asynchronous streams
	virtual void request_outdata(Arts::DataPacket<Arts::mcopbyte> *);

protected:
	// emitters for change notifications
	inline void eof_changed(bool newValue) {
		_emit_changed("eof_changed",newValue);
	}
	inline void size_changed(long newValue) {
		_emit_changed("size_changed",newValue);
	}
	inline void seekOk_changed(bool newValue) {
		_emit_changed("seekOk_changed",newValue);
	}

public:
	InputStream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class InputStream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InputStream_base *_cache;
	inline InputStream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InputStream_base *)_pool->base->_cast(InputStream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InputStream(InputStream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef InputStream_base _base_class;

	inline InputStream() : Arts::Object(_Creator), _cache(0) {}
	inline InputStream(const Arts::SubClass& s) :
		Arts::Object(InputStream_base::_create(s.string())), _cache(0) {}
	inline InputStream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InputStream_base::_fromString(r.string())):(InputStream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InputStream(const Arts::DynamicCast& c) : Arts::Object(InputStream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline InputStream(const InputStream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InputStream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InputStream null() {return InputStream((InputStream_base*)0);}
	inline static InputStream _from_base(InputStream_base* b) {return InputStream(b);}
	inline InputStream& operator=(const InputStream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline InputStream_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline bool eof();
	inline long size();
	inline bool seekOk();
	inline long seek(long position);
};

class FileInputStream_base : virtual public Arts::InputStream_base {
public:
	static unsigned long _IID; // interface ID

	static FileInputStream_base *_create(const std::string& subClass = "Arts::FileInputStream");
	static FileInputStream_base *_fromString(const std::string& objectref);
	static FileInputStream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static FileInputStream_base *_fromDynamicCast(const Arts::Object& object);
	inline FileInputStream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual bool open(const std::string& filename) = 0;
};

class FileInputStream_stub : virtual public FileInputStream_base, virtual public Arts::InputStream_stub {
protected:
	FileInputStream_stub();

public:
	FileInputStream_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
	bool open(const std::string& filename);
};

class FileInputStream_skel : virtual public FileInputStream_base, virtual public Arts::InputStream_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}

public:
	FileInputStream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class FileInputStream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	FileInputStream_base *_cache;
	inline FileInputStream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FileInputStream_base *)_pool->base->_cast(FileInputStream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline FileInputStream(FileInputStream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef FileInputStream_base _base_class;

	inline FileInputStream() : Arts::Object(_Creator), _cache(0) {}
	inline FileInputStream(const Arts::SubClass& s) :
		Arts::Object(FileInputStream_base::_create(s.string())), _cache(0) {}
	inline FileInputStream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(FileInputStream_base::_fromString(r.string())):(FileInputStream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FileInputStream(const Arts::DynamicCast& c) : Arts::Object(FileInputStream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline FileInputStream(const FileInputStream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline FileInputStream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static FileInputStream null() {return FileInputStream((FileInputStream_base*)0);}
	inline static FileInputStream _from_base(FileInputStream_base* b) {return FileInputStream(b);}
	inline FileInputStream& operator=(const FileInputStream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::InputStream() const { return Arts::InputStream(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline FileInputStream_base* _base() {return _cache?_cache:_method_call();}

	inline bool eof();
	inline long size();
	inline bool seekOk();
	inline long seek(long position);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline bool open(const std::string& filename);
};

class StdoutWriter_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static StdoutWriter_base *_create(const std::string& subClass = "Arts::StdoutWriter");
	static StdoutWriter_base *_fromString(const std::string& objectref);
	static StdoutWriter_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StdoutWriter_base *_fromDynamicCast(const Arts::Object& object);
	inline StdoutWriter_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class StdoutWriter_stub : virtual public StdoutWriter_base, virtual public Arts::SynthModule_stub {
protected:
	StdoutWriter_stub();

public:
	StdoutWriter_stub(Arts::Connection *connection, long objectID);

};

class StdoutWriter_skel : virtual public StdoutWriter_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream indata;             // incoming stream

	// handler for asynchronous streams
	virtual void process_indata(Arts::DataPacket<Arts::mcopbyte> *) = 0;

public:
	StdoutWriter_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class StdoutWriter : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StdoutWriter_base *_cache;
	inline StdoutWriter_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StdoutWriter_base *)_pool->base->_cast(StdoutWriter_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StdoutWriter(StdoutWriter_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StdoutWriter_base _base_class;

	inline StdoutWriter() : Arts::Object(_Creator), _cache(0) {}
	inline StdoutWriter(const Arts::SubClass& s) :
		Arts::Object(StdoutWriter_base::_create(s.string())), _cache(0) {}
	inline StdoutWriter(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StdoutWriter_base::_fromString(r.string())):(StdoutWriter_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StdoutWriter(const Arts::DynamicCast& c) : Arts::Object(StdoutWriter_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StdoutWriter(const StdoutWriter& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StdoutWriter(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StdoutWriter null() {return StdoutWriter((StdoutWriter_base*)0);}
	inline static StdoutWriter _from_base(StdoutWriter_base* b) {return StdoutWriter(b);}
	inline StdoutWriter& operator=(const StdoutWriter& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StdoutWriter_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class StreamPlayObject_base : virtual public Arts::PlayObject_base {
public:
	static unsigned long _IID; // interface ID

	static StreamPlayObject_base *_create(const std::string& subClass = "Arts::StreamPlayObject");
	static StreamPlayObject_base *_fromString(const std::string& objectref);
	static StreamPlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StreamPlayObject_base *_fromDynamicCast(const Arts::Object& object);
	inline StreamPlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool streamMedia(Arts::InputStream instream) = 0;
	virtual Arts::InputStream inputStream() = 0;
};

class StreamPlayObject_stub : virtual public StreamPlayObject_base, virtual public Arts::PlayObject_stub {
protected:
	StreamPlayObject_stub();

public:
	StreamPlayObject_stub(Arts::Connection *connection, long objectID);

	bool streamMedia(Arts::InputStream instream);
	Arts::InputStream inputStream();
};

class StreamPlayObject_skel : virtual public StreamPlayObject_base, virtual public Arts::PlayObject_skel {
public:
	StreamPlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StreamPlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StreamPlayObject_base *_cache;
	inline StreamPlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StreamPlayObject_base *)_pool->base->_cast(StreamPlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StreamPlayObject(StreamPlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StreamPlayObject_base _base_class;

	inline StreamPlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline StreamPlayObject(const Arts::SubClass& s) :
		Arts::Object(StreamPlayObject_base::_create(s.string())), _cache(0) {}
	inline StreamPlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StreamPlayObject_base::_fromString(r.string())):(StreamPlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StreamPlayObject(const Arts::DynamicCast& c) : Arts::Object(StreamPlayObject_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StreamPlayObject(const StreamPlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StreamPlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StreamPlayObject null() {return StreamPlayObject((StreamPlayObject_base*)0);}
	inline static StreamPlayObject _from_base(StreamPlayObject_base* b) {return StreamPlayObject(b);}
	inline StreamPlayObject& operator=(const StreamPlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObject() const { return Arts::PlayObject(*_pool); }
	inline operator Arts::PlayObject_private() const { return Arts::PlayObject_private(*_pool); }
	inline StreamPlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline std::string description();
	inline Arts::poTime currentTime();
	inline Arts::poTime overallTime();
	inline Arts::poCapabilities capabilities();
	inline std::string mediaName();
	inline Arts::poState state();
	inline void play();
	inline void seek(const Arts::poTime& newTime);
	inline void pause();
	inline void halt();
	inline bool loadMedia(const std::string& filename);
	inline bool streamMedia(Arts::InputStream instream);
	inline Arts::InputStream inputStream();
};

class PitchablePlayObject_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PitchablePlayObject_base *_create(const std::string& subClass = "Arts::PitchablePlayObject");
	static PitchablePlayObject_base *_fromString(const std::string& objectref);
	static PitchablePlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PitchablePlayObject_base *_fromDynamicCast(const Arts::Object& object);
	inline PitchablePlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
};

class PitchablePlayObject_stub : virtual public PitchablePlayObject_base, virtual public Arts::Object_stub {
protected:
	PitchablePlayObject_stub();

public:
	PitchablePlayObject_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
};

class PitchablePlayObject_skel : virtual public PitchablePlayObject_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}

public:
	PitchablePlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PitchablePlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PitchablePlayObject_base *_cache;
	inline PitchablePlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PitchablePlayObject_base *)_pool->base->_cast(PitchablePlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PitchablePlayObject(PitchablePlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PitchablePlayObject_base _base_class;

	inline PitchablePlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline PitchablePlayObject(const Arts::SubClass& s) :
		Arts::Object(PitchablePlayObject_base::_create(s.string())), _cache(0) {}
	inline PitchablePlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PitchablePlayObject_base::_fromString(r.string())):(PitchablePlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PitchablePlayObject(const Arts::DynamicCast& c) : Arts::Object(PitchablePlayObject_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PitchablePlayObject(const PitchablePlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PitchablePlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PitchablePlayObject null() {return PitchablePlayObject((PitchablePlayObject_base*)0);}
	inline static PitchablePlayObject _from_base(PitchablePlayObject_base* b) {return PitchablePlayObject(b);}
	inline PitchablePlayObject& operator=(const PitchablePlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PitchablePlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline float speed();
	inline void speed(float _newValue);
};

class PlayObjectFactoryV2_base : virtual public Arts::PlayObjectFactory_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObjectFactoryV2_base *_create(const std::string& subClass = "Arts::PlayObjectFactoryV2");
	static PlayObjectFactoryV2_base *_fromString(const std::string& objectref);
	static PlayObjectFactoryV2_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlayObjectFactoryV2_base *_fromDynamicCast(const Arts::Object& object);
	inline PlayObjectFactoryV2_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::PlayObject createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS) = 0;
	virtual Arts::PlayObject createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS) = 0;
};

class PlayObjectFactoryV2_stub : virtual public PlayObjectFactoryV2_base, virtual public Arts::PlayObjectFactory_stub {
protected:
	PlayObjectFactoryV2_stub();

public:
	PlayObjectFactoryV2_stub(Arts::Connection *connection, long objectID);

	Arts::PlayObject createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS);
	Arts::PlayObject createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS);
};

class PlayObjectFactoryV2_skel : virtual public PlayObjectFactoryV2_base, virtual public Arts::PlayObjectFactory_skel {
public:
	PlayObjectFactoryV2_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObjectFactoryV2 : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObjectFactoryV2_base *_cache;
	inline PlayObjectFactoryV2_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObjectFactoryV2_base *)_pool->base->_cast(PlayObjectFactoryV2_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObjectFactoryV2(PlayObjectFactoryV2_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObjectFactoryV2_base _base_class;

	inline PlayObjectFactoryV2() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObjectFactoryV2(const Arts::SubClass& s) :
		Arts::Object(PlayObjectFactoryV2_base::_create(s.string())), _cache(0) {}
	inline PlayObjectFactoryV2(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObjectFactoryV2_base::_fromString(r.string())):(PlayObjectFactoryV2_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObjectFactoryV2(const Arts::DynamicCast& c) : Arts::Object(PlayObjectFactoryV2_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlayObjectFactoryV2(const PlayObjectFactoryV2& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObjectFactoryV2(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObjectFactoryV2 null() {return PlayObjectFactoryV2((PlayObjectFactoryV2_base*)0);}
	inline static PlayObjectFactoryV2 _from_base(PlayObjectFactoryV2_base* b) {return PlayObjectFactoryV2(b);}
	inline PlayObjectFactoryV2& operator=(const PlayObjectFactoryV2& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline PlayObjectFactoryV2_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::PlayObject createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS);
	inline Arts::PlayObject createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS);
};

};
// Forward wrapper calls to _base classes:

inline bool Arts::PlayObject_private::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline bool Arts::PlayObject::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline std::string Arts::PlayObject::description()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->description():static_cast<Arts::PlayObject_base*>(_method_call())->description();
}

inline Arts::poTime Arts::PlayObject::currentTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->currentTime():static_cast<Arts::PlayObject_base*>(_method_call())->currentTime();
}

inline Arts::poTime Arts::PlayObject::overallTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->overallTime():static_cast<Arts::PlayObject_base*>(_method_call())->overallTime();
}

inline Arts::poCapabilities Arts::PlayObject::capabilities()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->capabilities():static_cast<Arts::PlayObject_base*>(_method_call())->capabilities();
}

inline std::string Arts::PlayObject::mediaName()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->mediaName():static_cast<Arts::PlayObject_base*>(_method_call())->mediaName();
}

inline Arts::poState Arts::PlayObject::state()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->state():static_cast<Arts::PlayObject_base*>(_method_call())->state();
}

inline void Arts::PlayObject::play()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->play():static_cast<Arts::PlayObject_base*>(_method_call())->play();
}

inline void Arts::PlayObject::seek(const Arts::poTime& newTime)
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->seek(newTime):static_cast<Arts::PlayObject_base*>(_method_call())->seek(newTime);
}

inline void Arts::PlayObject::pause()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->pause():static_cast<Arts::PlayObject_base*>(_method_call())->pause();
}

inline void Arts::PlayObject::halt()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->halt():static_cast<Arts::PlayObject_base*>(_method_call())->halt();
}

inline Arts::PlayObject Arts::PlayObjectFactory::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::AutoSuspendState Arts::InputStream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::InputStream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::InputStream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::InputStream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::InputStream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::InputStream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline bool Arts::InputStream::eof()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->eof():static_cast<Arts::InputStream_base*>(_method_call())->eof();
}

inline long Arts::InputStream::size()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->size():static_cast<Arts::InputStream_base*>(_method_call())->size();
}

inline bool Arts::InputStream::seekOk()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->seekOk():static_cast<Arts::InputStream_base*>(_method_call())->seekOk();
}

inline long Arts::InputStream::seek(long position)
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->seek(position):static_cast<Arts::InputStream_base*>(_method_call())->seek(position);
}

inline bool Arts::FileInputStream::eof()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->eof():static_cast<Arts::InputStream_base*>(_method_call())->eof();
}

inline long Arts::FileInputStream::size()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->size():static_cast<Arts::InputStream_base*>(_method_call())->size();
}

inline bool Arts::FileInputStream::seekOk()
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->seekOk():static_cast<Arts::InputStream_base*>(_method_call())->seekOk();
}

inline long Arts::FileInputStream::seek(long position)
{
	return _cache?static_cast<Arts::InputStream_base*>(_cache)->seek(position):static_cast<Arts::InputStream_base*>(_method_call())->seek(position);
}

inline Arts::AutoSuspendState Arts::FileInputStream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::FileInputStream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::FileInputStream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::FileInputStream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::FileInputStream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::FileInputStream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::FileInputStream::filename()
{
	return _cache?static_cast<Arts::FileInputStream_base*>(_cache)->filename():static_cast<Arts::FileInputStream_base*>(_method_call())->filename();
}

inline void Arts::FileInputStream::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::FileInputStream_base*>(_cache)->filename(_newValue):static_cast<Arts::FileInputStream_base*>(_method_call())->filename(_newValue);
}

inline bool Arts::FileInputStream::open(const std::string& filename)
{
	return _cache?static_cast<Arts::FileInputStream_base*>(_cache)->open(filename):static_cast<Arts::FileInputStream_base*>(_method_call())->open(filename);
}

inline Arts::AutoSuspendState Arts::StdoutWriter::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StdoutWriter::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StdoutWriter::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StdoutWriter::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StdoutWriter::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StdoutWriter::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::StreamPlayObject::description()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->description():static_cast<Arts::PlayObject_base*>(_method_call())->description();
}

inline Arts::poTime Arts::StreamPlayObject::currentTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->currentTime():static_cast<Arts::PlayObject_base*>(_method_call())->currentTime();
}

inline Arts::poTime Arts::StreamPlayObject::overallTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->overallTime():static_cast<Arts::PlayObject_base*>(_method_call())->overallTime();
}

inline Arts::poCapabilities Arts::StreamPlayObject::capabilities()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->capabilities():static_cast<Arts::PlayObject_base*>(_method_call())->capabilities();
}

inline std::string Arts::StreamPlayObject::mediaName()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->mediaName():static_cast<Arts::PlayObject_base*>(_method_call())->mediaName();
}

inline Arts::poState Arts::StreamPlayObject::state()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->state():static_cast<Arts::PlayObject_base*>(_method_call())->state();
}

inline void Arts::StreamPlayObject::play()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->play():static_cast<Arts::PlayObject_base*>(_method_call())->play();
}

inline void Arts::StreamPlayObject::seek(const Arts::poTime& newTime)
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->seek(newTime):static_cast<Arts::PlayObject_base*>(_method_call())->seek(newTime);
}

inline void Arts::StreamPlayObject::pause()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->pause():static_cast<Arts::PlayObject_base*>(_method_call())->pause();
}

inline void Arts::StreamPlayObject::halt()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->halt():static_cast<Arts::PlayObject_base*>(_method_call())->halt();
}

inline bool Arts::StreamPlayObject::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline bool Arts::StreamPlayObject::streamMedia(Arts::InputStream instream)
{
	return _cache?static_cast<Arts::StreamPlayObject_base*>(_cache)->streamMedia(instream):static_cast<Arts::StreamPlayObject_base*>(_method_call())->streamMedia(instream);
}

inline Arts::InputStream Arts::StreamPlayObject::inputStream()
{
	return _cache?static_cast<Arts::StreamPlayObject_base*>(_cache)->inputStream():static_cast<Arts::StreamPlayObject_base*>(_method_call())->inputStream();
}

inline float Arts::PitchablePlayObject::speed()
{
	return _cache?static_cast<Arts::PitchablePlayObject_base*>(_cache)->speed():static_cast<Arts::PitchablePlayObject_base*>(_method_call())->speed();
}

inline void Arts::PitchablePlayObject::speed(float _newValue)
{
	 _cache?static_cast<Arts::PitchablePlayObject_base*>(_cache)->speed(_newValue):static_cast<Arts::PitchablePlayObject_base*>(_method_call())->speed(_newValue);
}

inline Arts::PlayObject Arts::PlayObjectFactoryV2::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::PlayObject Arts::PlayObjectFactoryV2::createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS)
{
	return _cache?static_cast<Arts::PlayObjectFactoryV2_base*>(_cache)->createPlayObjectForURL(url, mimetype, createBUS):static_cast<Arts::PlayObjectFactoryV2_base*>(_method_call())->createPlayObjectForURL(url, mimetype, createBUS);
}

inline Arts::PlayObject Arts::PlayObjectFactoryV2::createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS)
{
	return _cache?static_cast<Arts::PlayObjectFactoryV2_base*>(_cache)->createPlayObjectForStream(instream, mimetype, createBUS):static_cast<Arts::PlayObjectFactoryV2_base*>(_method_call())->createPlayObjectForStream(instream, mimetype, createBUS);
}

#endif /* KMEDIA2_H */
