;;; skk-setup.el --- Initial setup for SKK
;; This file was generated automatically by SKK-MK at Tue Aug  7 23:10:25 2001
;; Copyright (C) 2000 Mikio Nakajima <minakaji@osaka.email.ne.jp>

;; Author: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: $Id: skk-setup.el.in,v 1.14 2000/11/25 17:27:17 czkmt Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2000/11/25 17:27:17 $

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the Free
;; Software Foundation; either versions 2, or (at your option) any later
;; version.

;; Daredevil SKK is distributed in the hope that it will be useful but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;; more details.

;; You should have received a copy of the GNU General Public License along
;; with Daredevil SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;;; Code:

;;; `load-path' setting.
(if (or (featurep 'xemacs)
	(fboundp 'normal-top-level-add-subdirs-to-load-path))
    nil
  ;; Emacs 18, 19 and 20.2
  (condition-case nil
      (require 'path-util)
    (error
     (require 'path-util "apel/path-util")))
  (add-path "apel")
  (add-path "skk")
  (add-path "nicola-ddskk"))

;;; Autoloads.
(require 'skk-autoloads)

;;; Key bindings.
(global-set-key "\C-x\C-j" 'skk-mode)
(global-set-key "\C-xj" 'skk-auto-fill-mode)
(global-set-key "\C-xt" 'skk-tutorial)

;;; Dictionaries.
;;(defvar skk-large-jisyo "@DIC@")
(defvar skk-aux-large-jisyo "/usr/share/skk/SKK-JISYO.L")
(defvar skk-tut-file "/usr/share/skk/SKK.tut")

;;; Isearch setting.
(cond ((eq emacs-major-version 18)
       (define-key global-map "\C-s" 'skk-isearch-forward)
       (define-key global-map "\C-r" 'skk-isearch-backward)
       (define-key esc-map "\C-s" 'skk-isearch-forward-regexp)
       (define-key esc-map "\C-r" 'skk-isearch-backward-regexp))
      (t
       (add-hook 'isearch-mode-hook
		 (lambda () (and (boundp 'skk-mode) skk-mode
				 (skk-isearch-mode-setup))))
       (add-hook 'isearch-mode-end-hook
		 (lambda ()
		   (and (featurep 'skk-isearch) (skk-isearch-mode-cleanup))))))

(provide 'skk-setup)
;;; Local Variables:
;;; End:
;;; skk-setup.el ends here
