import HandlerAPI
from Mailman import Message, mm_cfg
import sys,re,base64,string

if mm_cfg.JAPANESE_CONVERTER == 'unicode':
    import japanese
    def toJis(s):
        x = unicode(s,'japanese.euc-jp','replace')
        return x.encode('japanese.iso-2022-jp','replace')

elif mm_cfg.JAPANESE_CONVERTER == 'kconv':
    import kconv
    _tojis = kconv.Kconv(kconv.JIS, kconv.EUC)
    def toJis(s):
        return(_tojis.convert(s))

isjis = re.compile('(\x1b\$B.*\x1b\(B)')
iseuc = re.compile('([\xa1-\xfe]{2})+')
word_sep  = re.compile('[\s\x1b]') 

#def toJis(s):
#    if japanese:
#        x = unicode(s,'japanese.euc-jp','replace')
#        return x.encode('japanese.iso-2022-jp','replace')
#    elif kconv:
#        return(_tojis.convert(s))
#    else:
#        return s

def mime_encode_header(line):
    # first cat the lines 
    line = re.sub('\n\s+',' ',line)
    newlines = ''
    bent = ''
    kanji = 0
    bp = 0
    lp = 0
    ls = 0
    while lp < len(line):
        if kanji:
          if line[lp] != '\x1b':
            lp = lp + 2
            bp = bp + 8./3 # 2*4/3
          else:
            lp = lp + 3   # must be tailing ESC-(-B
            #bp += 0      # addition already done
            kanji = 0
        else:
          if line[lp] != '\x1b':
            lp = lp + 1
            bp = bp + 1
          else:
            lp = lp + 3
            bp = bp + 26  # ESC-$-B/ESC-(-B -> 6*4/3 = 8 + =?iso.... = 26
            kanji = 1
        if bp > 70:   # RFC Max is 75
            if not kanji:
               sep = word_sep.search(line,lp)
               if sep:
                 lp = sep.start(0)
               else:
                 lp = len(line)
            if kanji and (line[lp-3:lp] == '\x1b$B'):
               lp = lp - 3 # we have just entered kanji. get back
               kanji = 0
            bent = bent + line[ls:lp]
            if kanji:
               bent = bent + '\x1b(B'
            # NOW! ENCODE
            newlines = newlines + _mime_encode_header(bent) + '\n '
            if kanji and line[lp:lp+3] == '\x1b(B':
               lp = lp + 3
               kanji = 0
            if kanji:
               bent = '\x1b$B'
               bp = 26
            else:
               bent = ''
               bp = 0
            ls = lp
#
    if ls != lp:
        bent = bent + line[ls:lp]
        newlines = newlines + _mime_encode_header(bent)
    #else:
    #    newlines = newlines[:-2]
    if re.compile('\n $').search(newlines):
        newlines = newlines[:-2]
    return newlines

def _mime_encode_header(line):
    line = string.lstrip(line)
    newline = ''
    match = ''
    pos = 0
    while 1:
        res = isjis.search(line, pos)
        if res is None:
            break
        match = res.group(1)
        match = base64.encodestring(match)
        match = re.sub('\n','',match)
		
        newline = newline + line[pos:res.start(0)]\
                + "=?iso-2022-jp?B?" + match + "?="
        pos = res.end(0)
    return newline + line[pos:]

def process(mlist,msg,msgdata):
    # convert list-id anyway
    headerline = msg.getheader('list-id')
    if headerline and iseuc.search(headerline):
        headerline = toJis(headerline)
        headerline = mime_encode_header(headerline)
        del msg['list-id']
        msg['List-id'] = headerline
    # check if Japanese and convert
    content_type = msg.getheader('content-type')
    if not content_type or re.compile('euc-jp',re.I).search(content_type)\
            or string.lower(content_type)=='text/plain':
# last line for internally crafted message ... need fix?
        content_type = 'text/plain; Charset=iso-2022-jp'
    if re.compile('iso-2022-jp',re.I).search(content_type):
        # These are the headers to convert
        for headername in ('subject','from'):
            headerline = msg.getheader(headername)
            if headerline and iseuc.search(headerline):
                headerline = toJis(headerline)
                headerline = mime_encode_header(headerline)
                del msg[headername]
                msg[string.capitalize(headername)] = headerline
# get original content-type header and check if it's multipart
        original_content_type = msg.getheader('x-mmoriginal-content-type')
        if original_content_type:
            del msg['x-mmoriginal-content-type']
            if re.search('multipart',original_content_type,re.I):
                content_type = original_content_type
# final munging of content-type
        del msg['content-type']
        msg['Content-Type'] = content_type
        msg.body = toJis(msg.body)
