# Copyright (C) 1998,1999,2000 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


"""Mixin class with list-digest handling methods and settings."""

from Mailman import mm_cfg
from Mailman import Utils
from Mailman import Errors



class Digester:
    def InitVars(self):
	# Configurable
	self.digestable = mm_cfg.DEFAULT_DIGESTABLE
	self.digest_is_default = mm_cfg.DEFAULT_DIGEST_IS_DEFAULT
	self.mime_is_default_digest = mm_cfg.DEFAULT_MIME_IS_DEFAULT_DIGEST
	self.digest_size_threshhold = mm_cfg.DEFAULT_DIGEST_SIZE_THRESHHOLD
	self.digest_send_periodic = mm_cfg.DEFAULT_DIGEST_SEND_PERIODIC
	self.next_post_number = 1
	self.digest_header = mm_cfg.DEFAULT_DIGEST_HEADER
	self.digest_footer = mm_cfg.DEFAULT_DIGEST_FOOTER
	# Non-configurable.
	self.digest_members = {}
	self.next_digest_number = 1

    def GetConfigInfo(self):
        WIDTH = mm_cfg.TEXTFIELDWIDTH

	return [
            "ޤȤɤ()",

	    ('digestable', mm_cfg.Toggle, ('No', 'Yes'), 1,
	     'ꥹȲϥȤǤޤȤɤߤ륪ץ'
	     'Ǥޤ?'),

	    ('digest_is_default', mm_cfg.Radio, 
	     ('̾', ''), 0,
	     'ɤ⡼ɤΥǥեȤǤ?'),

	    ('mime_is_default_digest', mm_cfg.Radio, 
	     ('ʿʸ', 'Mime'), 0,
	     'ȤȤɤηǥեȤǤ?'),

	    ('digest_size_threshhold', mm_cfg.Number, 3, 0,
	     'ȯޤǤ˲Kb ʾˤʤʤȤޤ?'),
            # Should offer a 'set to 0' for no size threshhold.

 	    ('digest_send_periodic', mm_cfg.Radio, ('No', 'Yes'), 1,
	     'ͤãǤȤȯԤޤ'
	     "?"),

            ('digest_header', mm_cfg.Text, (4, WIDTH), 0,
	     'Ȥκǽդʸ',
             "Ȥκǽդʸ"
             " (ܼκǽΥåȤʤ). "
             + Utils.maketext('headfoot.html', raw=1)),

	    ('digest_footer', mm_cfg.Text, (4, WIDTH), 0,
	     'Ȥθդʸ',
             "(ǸʸȤʤ). "
             + Utils.maketext('headfoot.html', raw=1)),
	    ]

    def SetUserDigest(self, sender, value, force=0):
	self.IsListInitialized()
	addr = self.FindUser(sender)
	if not addr:
	    raise Errors.MMNotAMemberError
        cpuser = self.GetUserSubscribedAddress(addr)
	if self.members.has_key(addr):
	    if value == 0:
		raise Errors.MMAlreadyUndigested
	    else:
		if not force and not self.digestable:
		    raise Errors.MMCantDigestError
		del self.members[addr]
		self.digest_members[addr] = cpuser
	else:
	    if value == 1:
		raise Errors.MMAlreadyDigested
	    else:
		if not force and not self.nondigestable:
		    raise Errors.MMMustDigestError
                try:
                    self.one_last_digest[addr] = self.digest_members[addr]
                except AttributeError:
                    self.one_last_digest = {addr: self.digest_members[addr]}
		del self.digest_members[addr]
		self.members[addr] = cpuser
	self.Save()
