# Copyright (C) 1998,1999,2000 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

"""MailList mixin class managing the autoresponder.
"""

from Mailman import mm_cfg



class Autoresponder:
    def InitVars(self):
        # configurable
        self.autorespond_postings = 0
        self.autorespond_admin = 0
        # this value can be
        #  0 - no autoresponse on the -request line
        #  1 - autorespond, but discard the original message
        #  2 - autorespond, and forward the message on to be processed
        self.autorespond_requests = 0
        self.autoresponse_postings_text = ''
        self.autoresponse_admin_text = ''
        self.autoresponse_request_text = ''
        self.autoresponse_graceperiod = 90 # days
        # non-configurable
        self.postings_responses = {}
        self.admin_responses = {}
        self.request_responses = {}

    def GetConfigInfo(self):
        WIDTH = mm_cfg.TEXTFIELDWIDTH

        return [
            """ư.<p>

ʲΥƥȥեɤǤϡPython  %(string)s ˤäưʲΥ
֤Ԥޤ:
<p><ul>
    <li><b>%(listname)s</b> - <em>᡼󥰥ꥹȤ̾ޤ</em>
    <li><b>%(listurl)s</b> - <em>ꥹȤ listinfo URL ޤ</em>
    <li><b>%(requestemail)s</b> - <em>ꥹȤ -request ᡼륢ɥ쥹ޤ</em>
    <li><b>%(adminemail)s</b> - <em>ꥹȤ -admin ɥ쥹ޤ</em>
    <li><b>%(owneremail)s</b> - <em>ꥹȤ -owner ɥ쥹ޤ</em>
</ul>

<p>줾ΥƥȥեɤˤĤơľܥƥȥܥå˽뤳Ȥ
ʤΥ륷ƥˤե򥢥åץɤ뤳ȤǤޤ""",

            ('autorespond_postings', mm_cfg.Toggle, ('No', 'Yes'), 0,
             '᡼󥰥ꥹȤؤƼԤ˼ưޤ?'),

            ('autoresponse_postings_text', mm_cfg.FileUpload,
             (6, WIDTH), 0,
             '᡼󥰥ꥹȤƼԤ뼫ưʸ'),

            ('autorespond_admin', mm_cfg.Toggle, ('No', 'Yes'), 0,
             '''-admin  -owner ɥ쥹إ᡼뤬줿ȯԤؼư
ޤ?'''),

            ('autoresponse_admin_text', mm_cfg.FileUpload,
             (6, WIDTH), 0,
             '-admin  -owner ɥ쥹褿᡼ؤμưʸ'),

            ('autorespond_requests', mm_cfg.Radio,
             ('No', 'Yes, ˴', 'Yes, ž'), 0,
             '''-request ɥ쥹褿᡼ФƼưޤ?
⤷Yes 硤Υ᡼˴뤫Ȥ̾Υ᡼륳ޥ
Ʊͤ˥ƥž뤫Ǥ
'''),

            ('autoresponse_request_text', mm_cfg.FileUpload,
             (6, WIDTH), 0,
             '-request ɥ쥹褿᡼ؤμưʸ'),

            ('autoresponse_graceperiod', mm_cfg.Number, 3, 0,
             '''ƱȯԤ褿 ꥹ ޤ -admin/-owner ᡼륢ɥ쥹
ФưԤֳ֤ޤˤȥ᡼뤬뤿Ӥ
뤳Ȥˤʤޤ'''),

            ]
