#include "util.h"
#include "l3side.h"
#include "fastmdct.h"

static double win[4][36];
static double cos_s[6][12], cos_l[18][18];
void mdct_short(double *, double *, int);
void mdct_long(double *, double *, int);
void mdct_init(void);

double ca[8], cs[8];

/*
  This is table B.9: coefficients for aliasing reduction
*/
static double c[8] = { -0.6,-0.535,-0.33,-0.185,-0.095,-0.041,-0.0142, -0.0037 };

void mdct_sub( L3SBS sb_sample, double (*mdct_freq)[2][576], int stereo, III_side_info_t *l3_side, int mode_gr )
{
    gr_info *cod_info;
    double mdct_in[36];
    int ch,gr,band,k,j;
    double bu,bd;
    static int init = 0;
    int	block_type;
    double (*mdct_enc)[2][32][18] = (double (*)[2][32][18]) mdct_freq;
    
    if ( init == 0 )
    {
      mdct_init();
	/* prepare the aliasing reduction butterflies */
	for ( k = 0; k < 8; k++ )
	{
	    double sq;
	    sq = sqrt( 1.0 + c[k] * c[k] );
	    ca[k] = c[k] / sq;
	    cs[k] = 1.0 / sq;
	}
	init++;
    }
    
    for ( gr = 0; gr < mode_gr; gr++ )
	for ( ch = 0; ch < stereo; ch++ )
	{
	    cod_info = (gr_info *) &(l3_side->gr[gr].ch[ch]) ;
	    block_type = cod_info->block_type;
	    
	    /*
	      Compensate for inversion in the analysis filter
	    */
	    for ( band = 1; band < 32; band+=2 )
		for ( k = 1; k < 18; k+=2 )
			sb_sample[ch][gr+1][k][band] *= -1.0;
	    
	    /*
	      Perform imdct of 18 previous subband samples
	      + 18 current subband samples
	    */
	    for ( band = 0; band < 32; band++ )
	    {
		for ( k = 0; k < 18; k++ )
		{
		    mdct_in[k]    = sb_sample[ch][ gr ][k][band];
		    mdct_in[k+18] = sb_sample[ch][gr+1][k][band];
		}
#ifdef ALLOW_MIXED
		if ( cod_info->mixed_block_flag && (band < 2) )
		    block_type = 0;
#endif
		if (block_type==2)
		  mdct_short(mdct_in, &mdct_enc[gr][ch][band][0], block_type );
		else 
		  mdct_long( mdct_in, &mdct_enc[gr][ch][band][0], block_type );
	    }
	    
	    /*
	      Perform aliasing reduction butterfly
	      on long blocks
	    */
	    if ( block_type != 2 )
		for ( band = 0; band < 31; band++ )
		    for ( k = 0; k < 8; k++ )
		    {
			bu = mdct_enc[gr][ch][band][17-k] * cs[k] + mdct_enc[gr][ch][band+1][k] * ca[k];
			bd = mdct_enc[gr][ch][band+1][k] * cs[k] - mdct_enc[gr][ch][band][17-k] * ca[k];
			mdct_enc[gr][ch][band][17-k] = bu;
			mdct_enc[gr][ch][band+1][k]  = bd;
		    }
	    
	}
    
    /*
      Save latest granule's subband samples to be used in
      the next mdct call
    */
    for ( ch = 0; ch < stereo; ch++ )
	for ( j = 0; j < 18; j++ )
	    for ( band = 0; band < 32; band++ )
		sb_sample[ch][0][j][band] = sb_sample[ch][mode_gr][j][band];
}

void mdct_init(void)
{
  int k,i,m,N;

    /* type 0 */
    for ( i = 0; i < 36; i++ )
      win[0][i] = sin( PI/36 * (i + 0.5) );
    /* type 1*/
    for ( i = 0; i < 18; i++ ) 
      win[1][i] = sin( PI/36 * (i + 0.5) );
    for ( i = 18; i < 24; i++ )
      win[1][i] = 1.0;
    for ( i = 24; i < 30; i++ )
      win[1][i] = sin( PI/12 * ( i + 0.5 - 18) );
    for ( i = 30; i < 36; i++ )
      win[1][i] = 0.0;
    /* type 3*/
    for ( i = 0; i < 6; i++ )
      win[3][i] = 0.0;
    for ( i = 6; i < 12; i++ ) 
      win[3][i] = sin( PI/12 * (i + 0.5 - 6) );
    for ( i = 12; i < 18; i++ )
      win[3][i] = 1.0;
    for ( i = 18; i < 36; i++ )
      win[3][i] = sin( PI/36 * (i + 0.5) );

    N = 12;
    for ( m = 0; m < N / 2; m++ )
      for ( k = 0; k < N; k++ )
        cos_s[m][k] = cos( (PI /(2 * N)) * (2 * k + 1 + N / 2) *
                     (2 * m + 1) ) / (N / 4) * sin( PI/12 * (k + 0.5) );

    N = 36;
    for ( m = 0; m < N / 2; m++ )
    {
      for ( k = 0; k < 9; k++ )
      {
        cos_l[m][k] = cos( (PI / (2 * N)) * (2 * k + 1 + N / 2) *
                     (2 * m + 1) ) / (N / 4);
        cos_l[m][9+k] = cos( (PI / (2 * N)) * (2 * (18 + k) + 1 + N / 2) *
                     (2 * m + 1) ) / (N / 4);
      }
    }
}

void mdct_short( double *in, double *out, int block_type)
{
  int l,m,k,N;
  double sum;
  N = 12;
  for ( l = 0; l < 3; l++ )
    {
      for ( m = 0; m < N / 2; m++ )
	{
	  for ( sum = 0.0, k = 0; k < N; k++ )
	    sum += in[k + 6 * l + 6] * cos_s[m][k];
	  out[ 3 * m + l] = sum;
	}
    }
}

void mdct_long (double *in, double *out, int block_type) {
  int k;
  double sum;
  static double fin[18];
  static double *cos_l0;
  double s0, s1, s2, s3, s4, s5;
  double *finp;

  int all[] = {0,2,3,5,6,8,9,11,12,14,15,17,-1};
  int i,j=0;
      for (k=0;k<9;k++)
      {
	 fin[k] = win[block_type][k] * in[k] - win[block_type][17-k] * in[17-k];
	 fin[9+k] = win[block_type][18+k] * in[18+k] + win[block_type][35-k] * in[35-k];
      }

      /* 0, 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 17 */  
      while ((i = all[j++])>=0) {
	cos_l0= &cos_l[i][0];
	finp = &fin[0];
	sum =  ( *finp++ ) * *cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0;
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	sum += ( *finp++ ) * *++cos_l0; 
	out[i]=sum; 
      }


    s0 = fin[0] + fin[ 5] + fin[15];
    s1 = fin[1] + fin[ 4] + fin[16];
    s2 = fin[2] + fin[ 3] + fin[17];
    s3 = fin[6] - fin[ 9] + fin[14];
    s4 = fin[7] - fin[10] + fin[13];
    s5 = fin[8] - fin[11] + fin[12];

      /* 1 */
      cos_l0 = & cos_l[1][0];
      sum =  s0 * *cos_l0;  /* mfc=3 2*/
      sum += s1 * *++cos_l0;  /* mfc=9 1*/
      sum += s2 * *++cos_l0;  /* mfc=15 0*/
      sum += s3 * *(cos_l0+=4); /* mfc=21 6*/
      sum += s4 * *++cos_l0; /* mfc=27 7*/
      sum += s5 * *++cos_l0;; /* mfc = 28 8*/
      out[1]=sum;

      /* 7 */
      cos_l0 = &cos_l[7][0];
      sum =  s0 * *cos_l0; 
      sum += s1 * *++cos_l0; 
      sum += s2 * *++cos_l0; 
      sum += s3 * *(cos_l0+=4); 
      sum += s4 * *++cos_l0; 
      sum += s5 * *++cos_l0; 
      out[7]=sum;

      /* 10 */
      cos_l0= &cos_l[10][0];
      sum =  s0 * *cos_l0; /* 33 */
      sum += s1 * *++cos_l0; /* 9 */
      sum += s2 * *++cos_l0; /* 21 */
      sum += s3 * *(cos_l0+=4); /* 3 */
      sum += s4 * *++cos_l0; /* 27 */
      sum += s5 * *++cos_l0; /* 15 */
      out[10]=sum;

      /* 16 */
      cos_l0 = &cos_l[16][0];
      sum =  s0 * *cos_l0; /* 21 */
      sum += s1 * *++cos_l0;  /* 27 */
      sum += s2 * *++cos_l0; /* 33 */
      sum += s3 * *(cos_l0+=4); /* 15 */
      sum += s4 * *++cos_l0; /* 9 */
      sum += s5 * *++cos_l0; /* 3 */
      out[16]=sum;

      s0 = s0 - s1 + s5;
      s2 = s2 - s3 - s4;

      /* 4 */
      sum = s0 * cos_l[4][0];
      sum += s2* cos_l[4][2];
      out[4]=sum;

      /* 13 */
      sum = s0 * cos_l[13][0];
      sum += s2 * cos_l[13][2]; 
      out[13]=sum;

}
