/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension
 *
 * $Id: encoder.h,v 1.1 1996/02/14 04:04:23 rowlands Exp $
 *
 * $Log: encoder.h,v $
 * Revision 1.1  1996/02/14 04:04:23  rowlands
 * Initial revision
 *
 * Received from Mike Coleman
 **********************************************************************/

#ifndef ENCODER_DOT_H
#define ENCODER_DOT_H
/***********************************************************************
*
*  Encoder Include Files
*
***********************************************************************/

/***********************************************************************
*
*  Encoder Definitions
*
***********************************************************************/

/* General Definitions */

/* Default Input Arguments (for command line control) */

#define DFLT_LAY        3      /* default encoding layer is III */
#define DFLT_MOD        'j'    /* default mode is stereo */
#define DFLT_PSY        2      /* default psych model is 2 */
#define DFLT_SFQ        44.1   /* default input sampling rate is 44.1 kHz */
#define DFLT_EMP        'n'    /* default de-emphasis is none */
#define DFLT_EXT        ".mp3" /* default output file extension */

#define FILETYPE_ENCODE 'TEXT'
#define CREATOR_ENCODE  'MpgD'

/* This is the smallest MNR a subband can have before it is counted
   as 'noisy' by the logic which chooses the number of JS subbands */

#define NOISY_MIN_MNR   0.0

/* Psychoacoustic Model 2 Definitions */

#define LOGBLKSIZE      10
#define BLKSIZE         1024
#define HBLKSIZE        513
#define CBANDS          63
#define LXMIN           32.0


/* The following functions are in the file "musicin.c" */
extern void   parse_args(int, char**, frame_params*, int*, unsigned long*,
                           char[MAX_NAME_SIZE], char[MAX_NAME_SIZE]);
extern void   print_config(frame_params*, int*,
                           char[MAX_NAME_SIZE], char[MAX_NAME_SIZE]);

/* The following functions are in the file "encode.c" */
extern void   window_subband(short**, double[HAN_SIZE], int);
extern void   filter_subband(double[HAN_SIZE], double[SBLIMIT]);


/* The following functions are in the file "psy.c" */
extern void        psycho_anal(short int*, short int[1056], int, int,
                           FLOAT[32], double);



#endif
