/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Yutaka Sato
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	wais.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950310	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "http.h" /* putHttpHeader */
extern char *malloc();
extern FILE *openHttpResponseFilter();

#define STRLEN(a)	strlen((char*)a)
#define STRCHR(a,b)	strchr((char*)a,b)
#define STRCAT(a,b)	strcat((char*)a,(char*)b)
#define STRCPY(a,b)	strcpy((char*)a,(char*)b)
#define STRNCPY(a,b,n)	strncpy((char*)a,(char*)b,n)

#define MAX_REC_DOC	100

/*
 *	PDU types
 */
#define P_InitAPDU		20
#define P_InitRespAPDU		21
#define P_SearchAPDU		22
#define P_SearchRespAPDU	23

typedef struct {
	int	t_tag;
	int	t_type;
	char   *t_name;
} Tags;

/*
 *	data types
 */
#define _BM	1
#define _IN	2
#define _TX	3
#define _Tx	4
#define _ST	5
#define _DI	6
#define _CC	7
#define _UN	8

#define PD_DatabaseNames	18
#define PD_AttributeList	44
#define PD_Term			45
#define PD_Operator		46
#define PD_DocumentHeaderGroup	150
#define PD_DocumentTextGroup	153
#define PD_DocumentText		127
#define PD_Date			122
#define PD_Headline		123

static Tags TagTab[] = {
	{   1,	_IN,	"PDU-Type"},
	{   2,	_IN,	"Reference-ID"},
	{   3,	_IN,	"Protocol-Version"},
	{   4,	_BM,	"Options"},
	{   5,	_IN,	"Prefered-Message-Size"},
	{   6,	_IN,	"Maximum-Record-Size"},
	{   7,	_TX,	"ID-Authentication"},
	{   8,	_TX,	"Implementation-ID"},
	{   9,	_TX,	"Implementation-Name"},
	{  10,	_TX,	"Implementation-Version"},
	{  17,	_TX,	"Result-Set-Name"},
	{  18,	_TX,	"Database-Names"},
	{  19,	_TX,	"Element-Set-Names"},
	{  20,	_TX,	"Query-Type"},
	{  27,	_IN,	"Present-Status"},
	{  28,	_TX,	"Database-Diagnostic-Records"},
	{  36,	_TX,	"Delete-MSG"},

	{  44,  _TX,	"Attribute-List"},
	{  45,  _DI,	"Term"},
	{  46,  _TX,	"Operator"},

	{  99,	_ST,	"User-Information-Length"},
	{ 100,	_CC,	"Chunk-Code"},
	{ 101,	_IN,	"Chunk-ID-Length"},
	{ 102,	_TX,	"Chunk-Marker"},
	{ 106,	_TX,	"Seed-Words"},
	{ 107,	_TX,	"Document-ID-Chunk"},
	{ 111,	_IN,	"Data-Factor"},
	{ 114,	_IN,	"Max-Documents-Retrieved"},
	{ 116,	_DI,	"Document-ID"},
	{ 117,	_IN,	"Version-Number"},
	{ 118,	_IN,	"Score"},
	{ 119,	_IN,	"Best-Match"},
	{ 120,	_IN,	"Document-Length"},
	{ 121,	_TX,	"Source"},
	{ 122,	_TX,	"Date"},
	{ 123,	_TX,	"Headline"},
	{ 127,	_Tx,	"Document-Text"},

	{ 131,	_IN,	"Lines"},
	{ 132,	_ST,	"Type-Block"},
	{ 133,	_TX,	"Type"},

	{ 150,	_ST,	"Document-Header-Group"},
	{ 151,	_ST,	"Document-Short-Header-Group"},
	{ 152,	_ST,	"Document-Long-Header-Group"},
	{ 153,	_ST,	"Document-Text-Group"},
	{ 154,	_ST,	"Document-Headline-Group"},
	{ 155,	_ST,	"Document-Code-Group"},
	0
};

#define scan_int(buf,idx,val) {\
	val = 0; \
	while( buf[idx] & 0x80 ) \
		val = (val << 7) | (buf[idx++] & 0x7F); \
	val = (val << 7) | buf[idx++]; \
}
static relay_taglen(src,dst,rem)
	FILE *src,*dst;
	int *rem;
{	int val,ch;

	val = 0;
	while( (ch = getc(src)) != EOF ){
		putc(ch,dst);
		*rem -= 1;
		val = (val << 7) | (ch & 0x7F);
		if( (ch & 0x80) == 0 )
			break;
	}
	return val;
}

static scan_decF(buf,len)
	unsigned char *buf;
{	int iv,ix;
	iv = 0;
	for( ix = 0; ix < len; ix++ )
		iv = (iv << 8) | buf[ix];
	return iv;
}
static unsigned char *dstrncpy(dst,src,len)
	unsigned char *dst,*src;
{	int l1,ch;

	for( l1 = 0; l1 < len; l1++ ){
		ch = *src++;
		if( ch<=0x20||0x7F<=ch || ch=='%'||ch==';'||ch=='"' ){
			sprintf((char*)dst,"%%%02x",ch & 0xFF);
			dst += 3;
		}else	*dst++ = ch;
	}
	*dst = 0;
	return dst;
}
static encode_did(pbuf,buf,len)
	unsigned char *pbuf,*buf;
{	int idx;
	unsigned char *pp;
	int tag,l1;

	pp = pbuf;
	for( idx = 0; idx < len; ){
		if( buf[idx] < 0x20 ){
			tag = buf[idx++];
			sprintf((char*)pp,"%d=",tag);
			pp += STRLEN(pp);
			scan_int(buf,idx,l1);
			pp = dstrncpy(pp,&buf[idx],l1);
			idx += l1;
			*pp++ = ';';
		}else	*pp++ = buf[idx++];
	}
	*pp = 0;
}

static decode_did(edid,ddid)
	unsigned char *edid,*ddid;
{	int tag,l1;
	unsigned char ch,*ep,*fp,*dp,*tp,*np,ebuf[0x4000],elem[0x1000];

	STRCPY(ebuf,edid);
	dp = ddid;
	for( ep = ebuf; *ep; ep = np ){
		if( np = (unsigned char*)STRCHR(ep,';') )
			*np++ = 0;
		if( sscanf((char*)ep,"%d=%s",&tag,elem) != 2 )
			break;

		dp[0] = tag;
		dp[1] = 0;
		tp = &dp[2]; 
		for( fp = elem; ch = *fp++; ){
			if( ch == '%' ){
				char xb[3];
				int xv;;
				xb[0] = *fp++;
				xb[1] = *fp++;
				xb[2] = 0;
				sscanf(xb,"%x",&xv);
				*tp++ = xv;
			}else	*tp++ = ch;
		}
		l1 = tp - &dp[2];
		dp[1] = l1;
		dp = tp;
		if( np == 0 )
			break;
	}
	return dp - ddid;
}
	
static print_data(pbuf,tag,len,buf)
	char *pbuf;
	unsigned char *buf;
{	int ti,iv,ttype;
	char *tname;
	Tags *ttab;

	ttype = 0;
	ttab = TagTab;
	for( ti = 0; tname = ttab[ti].t_name; ti++ )
		if( ttab[ti].t_tag == tag ){
			ttype = ttab[ti].t_type;
			break;
		}

	if( tname == 0 ){
		sprintf(pbuf,"????: [%d %d]",buf[0],buf[1]);
	}else{
		sprintf(pbuf,"%s: ",tname);
		pbuf += STRLEN(pbuf);
		switch( ttype ){
		    case _DI:
			encode_did(pbuf,buf,len);
			break;
		    case _ST:
			break;
		    case _TX:

if( tag == PD_DatabaseNames ){
	char tb[1024];
	STRNCPY(tb,buf,len);
	tb[len] = 0;
	sv1log("Database-Names: %s\n",tb);
}else
if( tag == PD_Headline ){
	STRNCPY(pbuf,buf,len);
	pbuf[len] = 0;
}else
			dstrncpy(pbuf,buf,len);
			break;
		    case _BM:
			iv = scan_decF(buf,len);
			sprintf(pbuf,"0x%x",iv);
			break;
		    case _IN:
			iv = scan_decF(buf,len);
			sprintf(pbuf,"%d",iv);
			break;
		    case _UN:
			sprintf(pbuf,"[%x %x]",buf[0],buf[1]);
			break;
		    case _CC:
			switch( buf[0] ){
				case 0: STRCPY(pbuf,"Document"); break;
				case 1: STRCPY(pbuf,"Byte"); break;
				case 2: STRCPY(pbuf,"Line"); break;
				case 3: STRCPY(pbuf,"Paragraph"); break;
			}
			break;
		}
	}
	return ttype;
}

static dump_record(buf,buflen,out)
	unsigned char *buf,*out;
{	unsigned char *bp;
	int tag,len,idx,idx0;
	char pbuf[1024];
	int ttype;

	idx = 0;
	while( idx < buflen ){
		idx0 = idx;
		scan_int(buf,idx,tag);
		scan_int(buf,idx,len);
		ttype = print_data(pbuf,tag,len,&buf[idx]);
		Verbose("%5d [tag=%3d;len=%3d]%d %s\n",
			idx0,tag,len,ttype,pbuf);

		if( ttype == _ST )
			dump_record(&buf[idx],len,out);
		else
		if( out != NULL ){
			STRCAT(out,pbuf);
			STRCAT(out,"\n");
		}
		idx += len;
	}
}

extern char *findFieldValue();
static char *curDB = 0;
static int byDID = 0;

static dhg2html(dst,dhg)
	char *dst,*dhg;
{	int score = 0;
	int lines = 0;
	int bytes = 0;
	char *date = "",	dateb[256];
	char *type = "TEXT",	typeb[256];
	char *did = "-",	didb[0x10000];
	char *subj = "",	subjb[0x1000],subjbe[0x1000];
	char *hfp;
	char *dp;

	dp = dst;

	if( hfp = findFieldValue(dhg,"Score") ) score = atoi(hfp);
	if( hfp = findFieldValue(dhg,"Lines") ) lines = atoi(hfp);
	if( hfp = findFieldValue(dhg,"Document-Length") ) bytes = atoi(hfp);
	if( hfp = findFieldValue(dhg,"Date")  )
		{ wordScan(hfp,dateb); date = dateb; }
	if( hfp = findFieldValue(dhg,"Type")  )
		{ wordScan(hfp,typeb); type = typeb; }
	if( hfp = findFieldValue(dhg,"Document-ID") )
		{ wordScan(hfp,didb); did = didb; }
	if( hfp = findFieldValue(dhg,"Headline") ){
		if( sscanf(hfp,"%[^\r\n]",subjb) ){
			encodeEntities(subjb,subjbe);
			subj = subjbe;
		}
	}
	sprintf(dst,
		"%5d %8s %5d <A HREF=\"/%s/%s/%d/%s\"><B>%s</B></A>\n",
		score,date,lines,
		curDB?curDB:"DB-DB-DB-DB",
		type,bytes,did,subj);
}

static relay_userinfo(up,src,dst,out,recleng,trace)
	FILE *src,*dst;
	char *out;
{	char *buf;
	int rem0,rem,tag,len,rcc;
	int cconv;
	char *what;

	what = up ? "C>S" : "S>C";
	rem = recleng;

	cconv = check_codeconv(0);
	if( codeconv_bufsize(cconv,10) > 10 )
		cconv = 0;

	while( 0 < rem ){
		rem0 = rem;
		tag = relay_taglen(src,dst,&rem);
		len = relay_taglen(src,dst,&rem);

		if( len == 0 ){
			Verbose(">>> [%d,%d] rem=%d\n",tag,len,rem);
			if(  tag == 28 )
				len = rem;
			else	continue;
		}
if( tag == PD_DocumentTextGroup ){
	Verbose("Document-Text-Group: %d\n",len);
	continue;
}

		if( rem < len ){
			ERRMSG("**** ERROR **** tag:%d len:%d > rem:%d\n",
				tag,len,rem);
			len = rem;
		}
		buf = malloc(len+1);
		rcc = fread(buf,1,len,src);
		buf[rcc] = 0;

{
int ttype;
char pbuf[2048];
ttype = print_data(pbuf,tag,len,buf);
Verbose("%5d[TAG=%3d;LEN=%3d]%d %s\n",recleng-rem0,tag,len,ttype,pbuf);
}
		if( tag == 106 ){
			char ebuf[1024];

TO_EUC(buf,ebuf,"text/plain");

			sv1log("%s: SeedWords=[%s]%d [%s]%d\n",what,
				buf,strlen(buf),ebuf,strlen(ebuf));
			strncpy(buf,ebuf,len);
		}else
		if( tag == PD_DocumentHeaderGroup ){
			if( out ){
				char tmp[4096];
				tmp[0] = 0;
				dump_record(buf,len,tmp);
				dhg2html(&out[strlen(out)],tmp);
			}else	dump_record(buf,len,NULL);
		}else
		if( tag == PD_DocumentText ){
			if( cconv ){
				check_codeconv(1);
				sv1log("%s: %d bytes\n",what,len);
				line_codeconv(buf,buf,"text/plain");
			}
			if( byDID )
			strcat(out,buf);
		}
else
if( tag == PD_Date )
	Verbose("Date: [%d] %s\n",len,buf);

		fwrite(buf,rcc,1,dst);
		free(buf);
		rem -= rcc;
	}
	Verbose("DONE\n");
}

#define int3(b,i)	( ((b[i])<<16) | ((b[i+1])<<8) | (b[i+2]) )
dump_searchPDU(ptype,buf)
	char *buf;
{
Verbose("Type: %d (Search); Upper=%d; Lower=%d; Present=%d Replace=%d\n",
	ptype, int3(buf,1), int3(buf,4), int3(buf,7), buf[10]);
}

static relay_record(up,fs,tc,head,body)
	FILE *fs,*tc;
	char *head,*body;
{	int ptype,tag,len;
	int rcc,wcc,rem;
	int bsize,hsize;
	unsigned char buf[0x10000];
	char *what;

	what = up ? "C>S" : "S>C";
	Verbose("%s:\n",what);

	rcc = fread(buf,1,25,fs);
	Verbose("%d read\n",rcc);
	if( rcc <= 0 )
		return 0;

	buf[25] = 0;
	bsize = atoi(buf);
	fwrite(buf,25,1,tc);
	Verbose("%s: %d [%s]\n",what,bsize,buf);

	if( bsize == 0 ){
		fflush(tc);
		return 0;
	}

	rem = bsize;
	fread(buf,1,2,fs);
	fwrite(buf,2,1,tc);
	rem -= 2;
	hsize = (buf[0] << 8) | buf[1];

	fread(buf,1,hsize,fs);
	fwrite(buf,hsize,1,tc);
	rem -= hsize;
	ptype = buf[0];
	Verbose("HeaderLength: %d / %d, rem=%d\n",hsize,bsize-2,rem);

	if( ptype == P_InitAPDU ){
		Verbose("Type: %d (Init);\n",ptype);
		dump_record(&buf[1],hsize-1,NULL);
	}
	if( ptype == P_InitRespAPDU ){
		Verbose("Type: %d (InitResp); Result=%d;\n",buf[1]);
		ptype,dump_record(&buf[2],hsize-2,NULL);
	}
	if( ptype == P_SearchAPDU ){
		dump_searchPDU(ptype,buf);
		dump_record(&buf[11],hsize-11,NULL);
	}
	if( ptype == P_SearchRespAPDU ){
Verbose("Type: %d (SearchResp); Status=%d; Result=%d; Returned=%d; Next=%d\n",
			ptype, buf[1], int3(buf,2), int3(buf,5), int3(buf,8));
		if( head ){
			sprintf(head,"Search-Returned: %d\n",int3(buf,5));
			head += strlen(head);
		}
		dump_record(&buf[11],hsize-11,NULL);
	}

	if( 0 < rem ){
		tag = relay_taglen(fs,tc,&rem);
		len = relay_taglen(fs,tc,&rem);
		Verbose("User-Information: [%d/%x %d] rem=%d\n",tag,tag,len,rem);
		relay_userinfo(up,fs,tc,body,rem,ptype!=P_SearchRespAPDU);
	}
	fflush(tc);
	return bsize;
}

static proxyWAIS(Conn)
	Connection *Conn;
{
	Verbose("proxy-WAIS\n");
}

service_wais(Conn)
	Connection *Conn;
{	int cc,sctotal,cstotal;
	FILE *ts,*fs,*tc,*fc;

	if( isMYSELF(DFLT_HOST) ){
		proxyWAIS(Conn);
		return -1;
	}

	ts = fdopen(ToS,"w");
	fs = fdopen(FromS,"r");
	tc = fdopen(ToC,"w");
	fc = fdopen(FromC,"r");

	if( ts == NULL || tc == NULL ){
		Verbose("Open failed: %x %x\n",ts,tc);
		return 0;
	}

	sctotal = 0;
	Verbose("WAIS START\n");
	while( cc = relay_record(1,fc,ts,NULL,NULL) ){
		if( (cc = relay_record(0,fs,tc,NULL,NULL)) == 0 )
			break;
		sctotal += cc;
	}
	Verbose("WAIS DONE: %d\n",sctotal);

	fclose(ts);
	fclose(fs);
	fclose(tc);
	fclose(fc);
	return sctotal;
}

WAIS_serverOpen(Conn,name,port)
	Connection *Conn;
	char *name;
{	int svsock;

	svsock = connect_to_serv(Conn,FromC,ToC,0);
}

alwais(ac,av)
	char *av[];
{	int svsock;
	char *host;
	int port;
	Connection *Conn;
	FILE *ts,*fs,*null;
	int len;
	char *pdu;

	fprintf(stderr,"ALWAIS\n");
	Conn = (Connection*)calloc(1,sizeof(Connection));
	scan_SERVER(Conn,"wais://etlport:8888/");

	svsock = connect_to_serv(Conn,0,1,0);

	fprintf(stderr,"ALWAIS [%d]\n",svsock);
	ts = fdopen(svsock,"w");
	fs = fdopen(svsock,"r");
	null = fopen("/dev/null","w");

/*
pdu = "\
\0\26\26\0\1\0\1\0\0\0\1\0\1\21\0\22\4jitr\24\0011\
\143\10\
\55\015cs=(A-BDenso)\162\1\1";
len = 41;

	fprintf(ts,"%010dz2wais        0",len);
	fwrite(pdu,1,len,ts);
	fflush(ts);
	relay_record(0,fs,null,NULL,NULL);
*/


pdu = "\
\0\26\26\0\1\0\1\0\0\0\1\0\1\21\0\22\4jitr\24\0013\
\143\10\
\152\003euc\162\1\1";
len = 34;

	fprintf(ts,"%010dz2wais        0",len);
	fwrite(pdu,1,len,ts);
	fflush(ts);
	relay_record(0,fs,null,NULL,NULL);

	fclose(ts);
	fclose(fs);
	fclose(null);
	free(Conn);
}

static wais_init(Conn,sv)
	Connection *Conn;
{	char ipdu[2048];
	int len,la;
	char *auth;

FILE *ts,*fs,*null;
ts = fdopen(sv,"w");
fs = fdopen(sv,"r");
null = fopen("/dev/null","w");

	len = 0;
	ipdu[len++] =  0; ipdu[len++] = 0;
	ipdu[len++] = 20;
	ipdu[len++] =  3; ipdu[len++] = 1; ipdu[len++] = 0x80;
	ipdu[len++] =  4; ipdu[len++] = 1; ipdu[len++] = 0x80;
	ipdu[len++] =  5; ipdu[len++] = 3; ipdu[len++] = 2; ipdu[len++] = 0; ipdu[len++] = 0;
	ipdu[len++] =  6; ipdu[len++] = 3; ipdu[len++] = 2; ipdu[len++] = 0; ipdu[len++] = 0;
	ipdu[1] = len - 2;

dump_record(&ipdu[3],len-3,NULL);

	fprintf(ts,"%010dz2wais        0",len);
	fwrite(ipdu,1,len,ts);
	fflush(ts);
	relay_record(0,fs,null,NULL,NULL);
}
static wais_search(Conn,sv,head,out,dbname,words,did,type,leng)
	Connection *Conn;
	char *dbname,*words,*did,*type;
	char *head,*out;
{
FILE *ts,*fs,*null;
	char qpdu[2048];
	int len,ulen,blen;
int vtop;
static int serno = 50;

ts = fdopen(sv,"w");
fs = fdopen(sv,"r");
null = fopen("/dev/null","w");

	len = 0;
	qpdu[len++] =  0; len++;
	qpdu[len++] = 22;

if( words ){
	qpdu[len++] =  0; qpdu[len++] = 0; qpdu[len++] = 50;
	qpdu[len++] =  0; qpdu[len++] = 10; qpdu[len++] = 0;
	qpdu[len++] =  0; qpdu[len++] = 0; qpdu[len++] = 50;
}else{
	qpdu[len++] =  0; qpdu[len++] = 0; qpdu[len++] = 10;
	qpdu[len++] =  0; qpdu[len++] = 0; qpdu[len++] = 16;
	qpdu[len++] =  0; qpdu[len++] = 0; qpdu[len++] = 15;
}
	qpdu[len++] =  1;
	vtop = len;

	if( words ){
		qpdu[len++] = 17; qpdu[len++] = 0;
	}else{
		qpdu[len++] = 17; qpdu[len++] = 3;
		strcpy(&qpdu[len],"FOO");
		len += 3;
	}
	qpdu[len++] = 18; qpdu[len++] = strlen(dbname);
		strcpy(&qpdu[len],dbname);
		len += strlen(dbname);

	if( words ){
		qpdu[len++] =  20; qpdu[len++] = 1; qpdu[len++] = '3';
	}else{
		qpdu[len++] =  20; qpdu[len++] = 1; qpdu[len++] = '1';
		qpdu[len++] =  19; qpdu[len++] = 15;
		strcpy(&qpdu[len]," \037Document Text");
		len += 15;
	}
	qpdu[len++] =   2; qpdu[len++] = 1; qpdu[len++] = ++serno;
	qpdu[1] = len - 2;

if( words ){
	qpdu[len++] = 99; ulen = len; qpdu[len++] = 0x80; qpdu[len++] = 0;
}else{
	qpdu[len++] = 21; ulen = len; qpdu[len++] = 0x80; qpdu[len++] = 0;
}

	if( words != NULL ){
		char ewords[1024];

TO_EUC(words,ewords,"text/plain");

		qpdu[len++] = 111;qpdu[len++] = 1; qpdu[len++] = 1;
		qpdu[len++] = 114;qpdu[len++] = 1; qpdu[len++] = MAX_REC_DOC;
		qpdu[len++] = 106;qpdu[len++] = strlen(ewords);
		strcpy(&qpdu[len],ewords);
		len += strlen(ewords);
	}
	if( did != NULL ){
		int dl;
		char tmp[128];

		qpdu[len++] = PD_AttributeList;
		qpdu[len++] = 17;
		strcpy(&qpdu[len],"un re ig ig ig ig");
		len += 17;
		dl = decode_did(did,&qpdu[len+3]);
		qpdu[len++] = PD_Term;
		qpdu[len++] = 0x80 | 0x7F & (dl>>7);
		qpdu[len++] = 0x7F & dl;
		len += dl;

		qpdu[len++] = PD_AttributeList;
		qpdu[len++] = 17;
		strcpy(&qpdu[len],"wt re ig ig ig ig");
		len += 17;
		qpdu[len++] = PD_Term;
		qpdu[len++] = strlen(type);
		strcpy(&qpdu[len],type);
		len += strlen(type);

		qpdu[len++] = PD_Operator;
		qpdu[len++] = 1;
		qpdu[len++] = 'a';

		qpdu[len++] = PD_AttributeList;
		qpdu[len++] = 17;
		strcpy(&qpdu[len],"wb ro ig ig ig ig");
		len += 17;
		qpdu[len++] = PD_Term;
		qpdu[len++] = 1;
		qpdu[len++] = '0';

		qpdu[len++] = PD_Operator;
		qpdu[len++] = 1;
		qpdu[len++] = 'a';

		qpdu[len++] = PD_AttributeList;
		qpdu[len++] = 17;
		strcpy(&qpdu[len],"wb rl ig ig ig ig");
		len += 17;
		sprintf(tmp,"%d",leng);
		qpdu[len++] = PD_Term;
		qpdu[len++] = strlen(tmp);
		strcpy(&qpdu[len],tmp);
		len += strlen(tmp);

		qpdu[len++] = PD_Operator;
		qpdu[len++] = 1;
		qpdu[len++] = 'a';
	}

	blen = len - (ulen+2);
	qpdu[ulen+0] = 0x80 | 0x7F & (blen>>7);
	qpdu[ulen+1] = 0x7F & blen;

/*
Verbose(">>>>>>>> %010dz2wais        0\n",len);
Verbose("HederLength: %d / %d\n",((qpdu[0]<<8)|qpdu[1]),len);
dump_searchPDU(22,qpdu+2);
dump_record(&qpdu[vtop],len-vtop,NULL);
*/

	fprintf(ts,"%010dz2wais        0",len);
	fwrite(qpdu,1,len,ts);
	fflush(ts);
	relay_record(0,fs,null,head,out);
}

/*
 *    WWW Address mapping convention:
 *
 *    /servername/database/type/length/document-id
 *    /servername/database?word+word+word
 */

static putIndex(Conn,tc,vno,dbname,words,head,body)
	Connection *Conn;
	FILE *tc;
	char *dbname,*words,*head,*body;
{	int totalc,returned;
	char *hfp;

	totalc = putHttpHeaderV(Conn,tc,vno,NULL,"text/html",NULL,0,0,0);
	fprintf(tc,"<TITLE> WAIS Search in %s database</TITLE>",dbname);
	fprintf(tc,"<H2> WAIS Search in `%s' database </H2>",dbname);
	fprintf(tc,"at the server <I>%s:%d</I><BR>",DST_HOST,DST_PORT);
	fprintf(tc,"<ISINDEX>");

	if( *words ){
		if( hfp = findFieldValue(head,"Search-Returned") )
			returned = atoi(hfp);
		else	returned = 0;

		fprintf(tc,"<B>`%s'</B> found in ",words);
		if( returned == MAX_REC_DOC )
			fprintf(tc,"more than ");
		fprintf(tc,"<B>%d</B> documents ",returned);
		fprintf(tc,"in <B>%s</B> database.\n",dbname);
		fprintf(tc,"<PRE>\n");
		fprintf(tc,"score   date   lines\n");
		fprintf(tc,"----- -------- -----\n");
		fprintf(tc,"%s",body);
		fprintf(tc,"</PRE><HR>");
		totalc += strlen(body);
	}
	totalc += putFrogForDeleGate(Conn,tc,"");
	return totalc;
}

HttpWais(Conn,vno,sv,server,iport,path)
	Connection *Conn;
	char *server,*path;
{	char xpath[0x10000],*dbname,*docid,*words;
	FILE *tc,*tcx;
	int totalc;
	char *dp,*type;
	int leng;
	int svsock;
	char head[0x2000],body[0x40000]; /* large enough to receive catalog... X-< */

	head[0] = body[0] = 0;
	strcpy(xpath,path);
	dbname = xpath;
	if( *dbname == '/' )
		dbname++;

	if( words = strchr(dbname,'?') ){
		*words++ = 0;
		nonxalpha_unescape(words,words,1);
		docid = NULL;
		type = NULL;
		leng = 0;
		goto search;
	}else
	if( type = strchr(dbname,'/') ){
		*type++ = 0;
		if( dp = strchr(type,'/') ){
			*dp++ = 0;
			leng = atoi(dp);
			if( docid = strchr(dp,'/') ){
				*docid++ = 0;
				words = NULL;
				goto search;
			}
		}
	}else
	if( *dbname ){
		docid = NULL;
		words = "";
		goto search;
	}
	return 0;

search:
	if( (svsock = sv) == -1 )
	if( (svsock = connect_to_serv(Conn,FromC,ToC,0)) < 0 )
		return 0;

	if( words && *words || docid ){
		curDB = dbname;
		byDID = docid != NULL;
		wais_search(Conn,svsock,head,body,dbname,words,docid,type,leng);
		byDID = 0;
		curDB = NULL;
	}

	tc = fdopen(ToC,"w");
	tcx = (FILE*)openHttpResponseFilter(Conn,tc);
	if( words ){
		totalc = putIndex(Conn,tcx,vno,dbname,words,head,body);
	}else
	if( docid ){
		/* code-conv. will not be done in MASTER, so sending to
		 * ResponseFilter is necessary also for code-conv.
		 */
		totalc = putHttpHeaderV(Conn,tcx,vno,NULL,"text/plain",NULL,0,0,0);
		fputs(body,tcx);
		totalc += strlen(body);
	}
	fclose(tcx);
	fflush(tc);
	return totalc;
}

/*=============== obsoleted ===============
#include <signal.h>
#include <setjmp.h>
static jmp_buf wais_env;

static SC(Conn,omask)
	Connection *Conn;
{	int cc,total;
	FILE *fs,*tc;

	fs = fdopen(FromS,"r");
	tc = fdopen(dup(ToC),"w");
	total = 0;
	if( setjmp(wais_env) == 0 ){
		sigsetmask(omask);
		while( cc = relay_record(0,fs,tc,NULL,NULL) )
			total += cc;
	}
	fclose(fs);
	fclose(tc);
	return total;
}
static CS(Conn,peer,omask)
	Connection *Conn;
{	char buf[0x4000];
	int gotsig;
	int cc,total;
	FILE *ts,*fc;

	total = 0;
	ts = fdopen(ToS,"w");
	fc = fdopen(dup(FromC),"r");
	if( (gotsig = setjmp(wais_env)) == 0 ){
		sigsetmask(omask);
		while( cc = relay_record(1,fc,ts,NULL,NULL) )
			total += cc;
	}
	fclose(ts);
	fclose(fc);
	if( gotsig == SIGPIPE ){
		sv1log("CS-SIGPIPE\n");
		sleep(1);
	}
	return total;
}
static void sigPIPE(sig){
	signal(SIGPIPE,SIG_IGN);
	longjmp(wais_env,SIGPIPE);
}
static void sigTERM(sig){
	signal(SIGTERM,SIG_IGN);
	longjmp(wais_env,SIGTERM);
}
service_wais(Conn)
	Connection *Conn;
{	register int ppid,cpid;
	int omask;
	int total;

	ppid = getpid();
	omask = sigblock(sigmask(SIGPIPE)|sigmask(SIGTERM));
	signal(SIGPIPE,sigPIPE);
	signal(SIGTERM,sigTERM);

	if( (cpid = Fork("service_wais")) == 0 ){
		total = SC(Conn,omask);
		signal(SIGPIPE,SIG_IGN);
		signal(SIGTERM,SIG_IGN);
		sv1log("SC-RELAY[%d<%d]: %dBytes\n",ToC,FromS,total);
		Kill(ppid,SIGTERM);
		Finish(0);
	}else{
		total = CS(Conn,cpid,omask);
		signal(SIGPIPE,SIG_IGN);
		signal(SIGTERM,SIG_IGN);
		sv1log("CS-RELAY[%d>%d]: %dBytes\n",FromC,ToS,total);
		Kill(cpid,SIGTERM);
		wait(0);
		sigsetmask(omask);
	}
	return total;
}
static dumpb(buf,rcc)
	char *buf;
{	int i,ch;

	for( i = 0; i < rcc; i++ ){
		ch = buf[i] & 0xFF;

if( ch == '\n' ){
	int j;
	for( j = i+1; j < rcc; j++ ){
		if( buf[j] == '\n' )
			break;

		if( (buf[j] & 0x80) && (buf[j+1] & 0x80) ){
			buf[j] &= 0x7F;
			buf[j+1] &= 0x7F;
			j++;
		}
	}
}
		if( ch == '\n' || ' ' <= ch && ch < 0x7F )
			putc(ch,stderr);
		else	fprintf(stderr,"\\%03o",ch);
	}
	fprintf(stderr,"\n");
}
*/
