/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	tcprelay.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950701	extracted from service.c and iotimeout.c and merged
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
extern int dump_tcprelay;

service_nbt(Conn)
	Connection *Conn;
{
	dump_tcprelay = 1;
	return relay_svcl(Conn,FromC,ToC,FromS,ToS);
}
service_tcprelay(Conn)
	Connection *Conn;
{
	if( ToS < 0 && FromS < 0  ){
		if( isMYSELF(DST_HOST) ){
			ToS = fileno(stdout);
			FromS = fileno(stdin);
		}else	return -1;
	}

	if( cur_codeconvCL(NULL) ){
		check_codeconv(1);
		return relay_lines(0,0,
			CCV_TOCL,FromS,ToC,
			CCV_TOSV,FromC,ToS,NULL);
	}else	return relay_svcl(Conn,FromC,ToC,FromS,ToS);
}
extern int IO_TIMEOUT;
relay_svcl(Conn,fromC,toC,fromS,toS)
	Connection *Conn;
{	int sdv[2][2];
	int cnt[2];

	sdv[0][0] = fromC; sdv[0][1] = toS;
	sdv[1][0] = fromS; sdv[1][1] = toC;
	relays(IO_TIMEOUT*1000,2,sdv,cnt);
	return cnt[1];
}
simple_relay(src,dst)
{
	return simple_relayTimeout(src,dst,IO_TIMEOUT*1000);
}
simple_relayf(src,dst)
	FILE *src,*dst;
{
	return simple_relayfTimeout(src,dst,IO_TIMEOUT*1000);
}

relay_lines(timeout,flush,C1,S1,D1,C2,S2,D2)
	char *C1,*C2;
{	FILE *rfv[2],*wfv[2];
	char *ccv[2],code;
	int wcv[2],rdv[2],nready;
	int fpc,fi;
	char iline[1024],xline[4096],*oline;

	ccv[0] = C1; rfv[0] = fdopen(S1,"r"); wfv[0] = fdopen(D1,"w");
	ccv[1] = C2; rfv[1] = fdopen(S2,"r"); wfv[1] = fdopen(D2,"w");
	wcv[0] = wcv[1] = 0;
	fpc = 2;

	for(;;){
		nready = 0;
		for( fi = 0; fi < fpc; fi++ )
			if( 0 < ready_cc(rfv[fi]) )
				nready++;
		if( nready == 0 )
			for( fi = 0; fi < fpc; fi++ ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}

		if( fPollIns(timeout,fpc,rfv,rdv) < 0 )
			break;

		for( fi = 0; fi < fpc; fi++ ){
		    if( 0 < rdv[fi] ){
			if( fgets(iline,sizeof(iline),rfv[fi]) == NULL )
				goto gotEOF;

			if( ccv[fi] == NULL )
				oline = iline;
			else{
				do_codeconv(ccv[fi],iline,xline,"text/plain");
				oline = xline;
			}

			if( fputs(oline,wfv[fi]) == EOF )
				goto gotEOF;

			wcv[fi] += strlen(oline);
			if( 0 < flush && flush < wcv[fi] ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}
		    }
		}
	}
gotEOF:
	for( fi = 0; fi < fpc; fi++ ){
		fclose(rfv[fi]);
		fclose(wfv[fi]);
	}
}
