/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	syslog.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>

extern int SYSLOG_EMERG;
extern int SYSLOG_ALERT;
extern int SYSLOG_CRIT;
extern int SYSLOG_ERR;
extern int SYSLOG_WARNING;
extern int SYSLOG_NOTICE;
extern int SYSLOG_INFO;
extern int SYSLOG_DEBUG;
static int SYSLOG_DAEMON  = (3<<3);
extern int SYSLOG_PRIMASK;

Syslog(priority,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	int level;

	level = priority & SYSLOG_PRIMASK;
	if( level <= SYSLOG_CRIT )
		sv1tlog(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	else
	if( level <= SYSLOG_INFO )
		sv1log(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	else	sv1vlog(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
syslog_ERROR(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{
	Syslog(SYSLOG_ERR,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
syslog_DEBUG(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{
	Syslog(SYSLOG_DEBUG,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}

static res_debug(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	char msg[4096];

	sprintf(msg,"{R} ");
	sprintf(msg+strlen(msg),fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	sv1log("%s",msg);
}

extern int sv1log();
extern int (*RES_debugprinter)();
int (*DEBUG_printf)() = syslog_DEBUG;

syslog_init(){
	RES_debugprinter = res_debug;
}


service_syslog()
{
}

int LOG_syslog = -1;
extern char *TIMEFORM_SYSLOG;
open_syslog(url)
	char *url;
{	char hostport[256],host[256];
	int port;

	if( sscanf(url,"syslog://%s",hostport) <= 0 )
		return -1;

	port = scan_hostport("syslog",hostport,host);
	LOG_syslog = UDP_client_open("syslog","syslog",host,port);
	return LOG_syslog;
}
send_syslog(log)
	char *log;
{	char msg[0x4000];
	int wcc;

	if( LOG_syslog < 0 )
		return;

	sprintf(msg,"<%d>%s",SYSLOG_DAEMON|SYSLOG_DEBUG,log);
	wcc = write(LOG_syslog,msg,strlen(msg));
}

