/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	loadstat.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991206	created
ToDo:
	- describe the total format of ps-title
	- display the server in keep-alive if exist
	- common symbol which indicates process status (Polling, *Running, ...)
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>
extern char *Sprintf();
extern char *TIMEFORM_HTTPD;

#define ST_ACC	0
#define ST_DONE	1

char *mainProcTitleFmt = "RPM=%L(%l)%?i[,IDLE=%is]%?c[,ACT=%c]";
char *loadaveFmt = "%l";

int NUM_CHILDREN;
int NUM_PEERS;
alive_peers(){ return NUM_PEERS; }
int TOTAL_SERVED;
int START_TIME1;
int START_TIME;
int DELEGATE_LastModified;

/*
 * long range counter by hour, day, week, ...
 * and possibly dumped into persistent file and reload on restart...
 */


static int TotalCount[2];
static int TotalLast[2];

#define LSWIN	15	/* 1/4 minute */
#define LSSIZE	60	/* 15 minutes */
typedef struct {
	int	s_time;
	int	s_qmin; /* 1/4 minute */
	int	s_done;
} LoadStat;
static LoadStat loadStats[2][LSSIZE];

putLoadStat(what,done)
{	int now,qmin,idx;
	LoadStat *lsp;

	now = time(NULL);
	qmin = now / LSWIN;
	idx = qmin % LSSIZE;
	lsp = &loadStats[what][idx];
	if( lsp->s_qmin != qmin ){
		lsp->s_time = now;
		lsp->s_qmin = qmin;
		lsp->s_done = 0;
	}
	lsp->s_done += done; 
	TotalCount[what] += done;
	TotalLast[what] = now;
}
double getLoadStat(what,now,mrange)
{	int qmin,qmin0,idx,cur;
	LoadStat *lsp;
	double cum,elp;

	qmin = now / LSWIN;
	qmin0 = qmin - mrange*(60/LSWIN);
	cum = 0;
	cur = 0;
	for( idx = 0; idx < LSSIZE; idx++ ){
		lsp = &loadStats[what][idx];
		if( lsp->s_qmin == qmin ){
			elp = now - lsp->s_time;
			if( elp <= 0 )
				elp = 1;
			cum += lsp->s_done * (LSWIN/elp);
		}else
		if( qmin0 < lsp->s_qmin && lsp->s_qmin < qmin )
			cum += lsp->s_done;
	}
	return cum;
}
char *strfLoadStat(str,size,fmt,now)
	char *str,*fmt;
{	char *fp,fc,*sp,*sx,*pp,*tp,subfmt[256];
	double load;
	int cond;
	int last,idle,elp,done;
	double loadv[4];

	sx = str + size - 1;
	sp = str;
	fp = fmt;
	while( fc = *fp++ ){
		if( sx <= sp )
			break;

		if( fc != '%' ){
			*sp++ = fc;
			*sp = 0;
			continue;
		}
		cond = 0;
		for(;;){
			switch( fc = *fp++ ){
				case 0: goto EXIT;
				case '?': cond = 1; continue;
			}
			break;
		}

		pp = sp;
		switch( fc ){
			case '%':
				*sp++ = fc;
				*sp = 0;
				break;
			case 'i':
				last = TotalLast[ST_ACC];
				if( last == 0 )
					last = START_TIME;
				idle = now - last;
				if( 0 < idle )
					sp = Sprintf(sp,"%d",idle);
				break;
			case 'c':
				if( 0 < NUM_CHILDREN )
					sp = Sprintf(sp,"%d",NUM_CHILDREN);
				break;
			case 'l':
				loadv[0] = getLoadStat(ST_ACC,now,1);
				loadv[1] = getLoadStat(ST_ACC,now,5) / 5;
				loadv[2] = getLoadStat(ST_ACC,now,15) / 15;
				sp = Sprintf(sp,"%3.1f %3.1f %3.1f",
					loadv[0],loadv[1],loadv[2]);
				break;
			case 'L':
				elp = now - START_TIME;
				done = TotalCount[ST_ACC];
				if( elp <= 0 )
					elp = 1;
				loadv[0] = done / (elp/60.0);
				sp = Sprintf(sp,"%4.2f",loadv[0]);
				break;
		}
		if( cond ){
			fc = *fp++;
			if( fc == 0 )
				break;
			if( fc = '[' ){
				if( tp = strchr(fp,']') ){
					bcopy(fp,subfmt,tp-fp);
					subfmt[tp-fp] = 0;
					fp = tp + 1;
				}else	break;
			}else{
				subfmt[0] = *fp++;
				subfmt[1] = 0;
			}
			if( pp < sp )
				sp = strfLoadStat(pp,size-(sp-str),subfmt,now);
		}
	}
EXIT:
	return sp;
}

char *start_time()
{	static char stime[64];

	if( stime[0] == 0 )
		StrftimeLocal(stime,sizeof(stime),TIMEFORM_HTTPD,START_TIME);
	return stime;
}
