/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	socks.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	SOCKS=host[:[port][/version][:dstHostList[:srcHostList]]]

History:
	991119	extracted from socks4.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
extern char *gethostaddr();

#define SOCKS_PORT	1080
#define SOCKS_CONNECT	1
#define SOCKS_BIND	2
#define SOCKS_ACCEPT	8	/* pseudo command */

/*
 *	SOCKS CLIENT
 */
static char username[64];

typedef struct {
	char	*s_host;
	int	 s_port;
	int	 s_ver;
	int	 s_acl;
} SocksServer;
SocksServer sockservs[8];

static socks_init(_,svhost,svportver,dsts,srcs)
	void *_;
	char *svhost,*svportver,*dsts,*srcs;
{	int sx;
	char *opts,*host1;
	char key[32],map[1024];
	int port;
	int ver = 5;

	if( svhost == 0 || svhost[0] == 0 )
		return;

	port = 0;
	opts = NULL;

	if( svportver ){
		port = atoi(svportver);
		if( opts = strchr(svportver,'/') )
			opts++;
	}
	if( port == 0 )
		port = SOCKS_PORT;
	if( opts != NULL ){
		if( strcmp(opts,"-4") == 0 )
			ver = 4;
	}

	for( sx = 0; host1 = sockservs[sx].s_host; sx++ ){
		if( host1[0] == 0 )
			break;
		if( sockservs[sx].s_port == port )
		if( hostcmp(sockservs[sx].s_host,svhost) == 0 )
			return;
	}

	sockservs[sx].s_host = strdup(svhost);
	sockservs[sx].s_port = port;
	sockservs[sx].s_ver = ver;

	sprintf(key,"SOCKS-%d",sx);
	sprintf(map,"{%s:%d/-%d}:*:%s:%s",
		svhost,port,ver,dsts?dsts:"!.localnet",srcs?srcs:"*");
	sockservs[sx].s_acl = scan_CMAP2(_,key,map);
}
static matchConn(Conn,sx)
	Connection *Conn;
{	char key[32],map[128];
	int found;

	sprintf(key,"SOCKS-%d",sx);
	found = find_CMAP(Conn,key,map);
	return 0 <= found;
}
static tobeViaSocks(Conn)
	Connection *Conn;
{	int sx;

	for( sx = 0; sockservs[sx].s_host; sx++ ){
		if( matchConn(Conn,sx) )
			return 1;
	}
	return 0;
}
GetViaSocks(Conn,host,port)
	Connection *Conn;
	char *host;
{
	return VSA_getViaSocks(Conn,host,port,NULL);
}
VSA_getViaSocks(Conn,host,port,vlocal)
	Connection *Conn;
	char *host;
	VSAddr *vlocal;
{	Connection toConn;
	int match,sx;

	if( hostcmp(host,"localhost") == 0 ){
		sv1log("##NOT ViaSocks-A(localhost)## %s:%d\n",host,port);
		return 0;
	}
	if( getViaSocks(host,port,vlocal) ){
		sv1log("##ViaSocks-A(by cache)## %s:%d\n",host,port);
		return 1;
	}
	toConn = *Conn;
	set_realserver(&toConn,DST_PROTO,host,port);
	if( tobeViaSocks(&toConn) ){
		sv1log("##ViaSocks-B(by rule)## %s:%d\n",host,port);
		if( vlocal ) bzero(vlocal,sizeof(VSAddr));
		return 1;
	}
	sv1log("##NOT ViaSocks-B## %s:%d\n",host,port);
	return 0;
}
scan_SOCKS(_,socks)
	void *_;
	char *socks;
{	char socksb[1024],*sv[4];

	strcpy(socksb,socks);
	sv[0] = sv[1] = sv[2] = sv[3] = 0;
	stoV(socksb,3,sv,':');
	socks_init(_,sv[0],sv[1],sv[2],sv[3]);
}
socks_addservers(){
	int sx;
	char *host;

	for( sx = 0; host = sockservs[sx].s_host; sx++ )
	if( *host )
		SOCKS_addserv("*",0,gethostaddr(host),sockservs[sx].s_port);
	return sx;
}

static socks_start(sock,ver,command,host,port,user,rhost,rport,xaddr)
	char *host,*user,*rhost;
	int *rport;
	char *xaddr;
{	unsigned char obuf[128],i,*ap;
	int pc,wcc,rep;

	if( ver == 5 ){

if( strchr(host,'%') ){
	char xhost[512],*addr;
	sv1log("## unescape host-name for SocksV5: %s\n",host);
	if( addr = gethostaddr(host) ){
		strcpy(xhost,addr);
		if( xaddr ) strcpy(xaddr,xhost);
	}else	nonxalpha_unescape(host,xhost,0);
	host = xhost;
}
		/* pass resolved address to SocksV5 client to know which of
		 * multiple IP addresses of the target host is used fot the
		 * connection and to pass it to setViaSocks().
		 */
		/* but this will cause problem when (especially non-FTP) user
		 * expects name resolusions to be done in SocksV5 server ...
		 */
		if( port == 21 ) /* should be switched using potocol name or
				  * explicit configuration ...
				  */
		if( command == SOCKS_CONNECT && xaddr != NULL )
		if( !isinetAddr(host) )
		{	char *addr;
			if( addr = gethostaddr(host) ){
				strcpy(xaddr,addr);
				host = addr;
			}
		}
		return SOCKS_startV5(sock,command,host,port,user,rhost,rport);
	}

	return
	SocksV4_clientStart(sock,command,host,port,user,rhost,rport,xaddr);
}

typedef struct {
	int	v_addr;
	int	v_port;
	VSAddr	v_local; /* source address for the destination */
} ViaSocks;

#define NVIAS 64
static ViaSocks viaSocks[NVIAS];

static setViaSocksX(addr,port,vlocal)
	unsigned int addr;
	VSAddr *vlocal;
{	ViaSocks *vs;
	int vsx;

	if( addr == -1 )
		return;

	for( vsx = 0; vsx < NVIAS; vsx++ ){
		vs = &viaSocks[vsx];
		if( vs->v_addr == 0 ){
			vs->v_addr = addr;
			vs->v_port = port;
			vs->v_local = *vlocal;
			break;
		}
		if( vs->v_addr == addr )
			break;
	}
}
static setViaSocks(host,port,vlocal)
	char *host;
	VSAddr *vlocal;
{
	setViaSocksX(gethostint_nboV4(host),port,vlocal);
	setViaSocksX(gethostintMin(host),port,vlocal);
	setViaSocksX(_inet_addrV4(host),port,vlocal);
}
static getViaSocksX(addr,port,vlocal)
	unsigned int addr;
	VSAddr *vlocal;
{	ViaSocks *vs;
	int vsx;

	if( addr == -1 )
		return 0;

	for( vsx = 0; vsx < NVIAS; vsx++ ){
		vs = &viaSocks[vsx];
		if( vs->v_addr == 0 )
			break;
		if( vs->v_addr == addr ){
			if( vlocal ) *vlocal = vs->v_local;
			return 1;
		}
	}
	return 0;
}
static getViaSocks(host,port,vlocal)
	char *host;
	VSAddr *vlocal;
{
	if( getViaSocksX(gethostint_nboV4(host),port,vlocal) ) return 1;
	if( getViaSocksX(gethostintMin(host),port,vlocal) ) return 1;
	if( getViaSocksX(_inet_addrV4(host),port,vlocal) ) return 1;
	return 0;
}

static socks_connect(sock,ver,host,port,user,rhost,rport)
	char *host,*user,*rhost;
	int *rport;
{	char addr[64];
	VSAddr vlocal;

	if( host == NULL || port == 0 )
		return -1;

	*addr = 0;
	if( socks_start(sock,ver,SOCKS_CONNECT,host,port,user,rhost,rport,addr))
		return -1;

	if( rhost && rport )
		VSA_atosa(&vlocal,*rport,rhost);
	else	bzero(&vlocal,sizeof(VSAddr));
	setViaSocks(host,port,&vlocal);
	if( *addr != 0 )
		setViaSocks(addr,port,&vlocal);
	return 0;
}

static int bind_ver;
static socks_bind(sock,ver,host,port,user,rhost,rport)
	char *host,*user,*rhost;
	int *rport;
{
	bind_ver = ver;
	return socks_start(sock,ver,SOCKS_BIND,host,port,user,rhost,rport,NULL);
}

bindViaSocks(Conn,dsthost,dstport,rhost,rport)
	void *Conn;
	char *dsthost,*rhost;
	int *rport;
{	int sx;
	char *shost;
	int sport;
	int ver;
	int sock;

	getUsernameCached(getuid(),username);
	sv1log("bindViaSocks(%s:%d)[%s]\n",dsthost,dstport,username);

	for( sx = 0; sockservs[sx].s_host; sx++ ){
		if( !matchConn(Conn,sx) )
			continue;

		shost = sockservs[sx].s_host;
		sport = sockservs[sx].s_port;
		ver = sockservs[sx].s_ver;
		if( shost[0] == 0 || sport == 0 )
			break;
		sock = OpenServer("BindViaSocks","socks",shost,sport);
		if( 0 <= sock )
		if( socks_bind(sock,ver,dsthost,dstport,username,rhost,rport) == 0 )
			return sock;
		close(sock);
	}
	return -1;
}
acceptViaSocks(sock,rhost,rport)
	char *rhost;
	int *rport;
{	int rep;

	if( bind_ver == 5 )
		return SOCKS_recvResponseV5(sock,SOCKS_ACCEPT,rhost,rport);
	else	return SocksV4_acceptViaSocks(sock,rhost,rport);
}
connectViaSocks(Conn,dsthost,dstport,rhost,rport)
	Connection *Conn;
	char *dsthost;
	char *rhost;
	int *rport;
{	int sx;
	char *host;
	int port;
	int ver;
	int sock;

	getUsernameCached(getuid(),username);
	for( sx = 0; sockservs[sx].s_host; sx++ ){
		if( !matchConn(Conn,sx) )
			continue;

		host = sockservs[sx].s_host;
		port = sockservs[sx].s_port;
		ver = sockservs[sx].s_ver;
		if( host[0] == 0 || port == 0 )
			break;

		sock = OpenServer("ConnectViaSocks","socks",host,port);
		if( 0 <= sock )
		if( socks_connect(sock,ver,dsthost,dstport,username,rhost,rport) == 0 )
			return sock;

		close(sock);
		continue;
	}
	return -1;
}
ConnectViaSocks(Conn,relay_input)
	Connection *Conn;
{	int sock;
	char rhost[128];
	int rport;

	if( Conn->co_mask & CONN_NOSOCKS )
		return -1;
	if( 0 <= (sock = connectViaSocks(Conn,DST_HOST,DST_PORT,rhost,&rport)) )
		initConnected(Conn,sock,relay_input);
	return sock;
}

/*
 *	SOCKS SERVER
 */
service_socks(Conn)
	Connection *Conn;
{	unsigned char ibuf[16];

	if( recvPeekTIMEOUT(FromC,ibuf,1) != 1 )
		return;

	if( !source_permitted(Conn) ){
		/* send appropriate error message */
		return;
	}

	if( ibuf[0] == 5 ){
		extern int IO_TIMEOUT;
		return SOCKS_serverV5(Conn,FromC,ToC,IO_TIMEOUT*1000);
	}
	SocksV4_server(Conn,ToS,FromS,FromC,ToC);
}
isSocksConnect(pack,leng,ver,addr,port,user)
	unsigned char *pack;
	int *ver;
	char *addr;
	int *port;
	unsigned char **user;
{
	return SocksV4_isConnectReuqest(pack,leng,ver,addr,port,user);
}
