/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	pop.c (POP proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "param.h"
#include "delegate.h"
#include "filter.h"
#include "ystring.h"
extern char *fgetsTIMEOUT();
extern char *getClientUserMbox();
extern char *CTX_mount_url_to();
extern FILE *TMPFILE();
#define LNSIZE 1024

static putget(xcode,ts,fs,resp,rsize,fmt,a,b,c,d)
	FILE *ts,*fs;
	char *resp;
	char *fmt,*a,*b,*c,*d;
{	char req[LNSIZE];

	if( fmt != NULL ){
		sprintf(req,fmt,a,b,c,d);
		strcat(req,"\r\n");
		if( strncasecmp(req,"PASS",4) == 0 )
			syslog_ERROR(">> PASS ****\n");
		else	syslog_ERROR(">> %s",req);
		fputs(req,ts);
		fflush(ts);
	}
	if( fgets(resp,rsize,fs) == NULL ){
		if( xcode < 0 )
			Finish(xcode);
		else	return xcode;
	}
	syslog_ERROR("<< %s",resp);
	if( resp[0] != '+' ){
		if( xcode < 0 )
			Finish(xcode);
		else	return xcode;
	}
	return 0;
}

typedef struct {
	char	*name;
	int	 resp;
} CommandSpec;

#define NULL_BODY	0
#define WITH_BODY	1
#define IN_RFC822	2
#define RESPFLAGS	(WITH_BODY|IN_RFC822)
#define NULL_BODY_IFARG	4

static CommandSpec pop_command[] = {
	/* MINIMAL POP3 COMMANDS */
	{ "USER"},
	{ "PASS"},
	{ "QUIT"},
	{ "STAT"},
	{ "LIST", WITH_BODY|NULL_BODY_IFARG },
	{ "RETR", WITH_BODY|IN_RFC822 },
	{ "DELE"},
	{ "NOOP"},
	{ "RSET"},

	/* OPTIONAL POP3 COMMANDS */
	{ "APOP"},
	{ "UIDL", WITH_BODY|NULL_BODY_IFARG },
	{ "TOP",  WITH_BODY|IN_RFC822 },

	/* private extension ? */
	{ "LAST"},
	{ "RPOP"},
	0
};

static openARTICLE(ts,fs,anum,resp)
	FILE *ts,*fs;
	char *resp;
{
	fprintf(ts,"ARTICLE %d\r\n",anum);
	fflush(ts);
	fgets(resp,LNSIZE,fs);
	if( atoi(resp) != 220 )
		return -1;
	else	return 0;
}
static skipmsg(fs)
	FILE *fs;
{	char line[LNSIZE];
	int size;

	size = 0;
	while( fgets(line,sizeof(line),fs) != NULL ){
		if( line[0] == '.' && line[1] == '\r' )
			break;
		size += strlen(line);
	}
	return size;
}
static msguid(fs,uid)
	FILE *fs;
	char *uid;
{
	msgMD5(fs,NULL,uid);
}
static top(fs,tc,lines)
	FILE *fs,*tc;
{	char line[LNSIZE];
	int size;
	int li;

	size = 0;
	for(;;){
		if( fgets(line,sizeof(line),fs) == NULL )
			return;
		if( line[0] == '.' && line[1] == '\r' )
			return;
		fputs(line,tc);
		size += strlen(line);
		if( line[0] == '\r' || line[0] == '\n' )
			break;
	}
	for( li = 0; li < lines; li++ ){
		if( fgets(line,sizeof(line),fs) == NULL )
			break;
		if( line[0] == '.' && line[1] == '\r' )
			return;
		fputs(line,tc);
		size += strlen(line);
	}
	skipmsg(fs);
	return size;
}
static putclient(tc,fmt,a,b,c,d,e,f,g)
	FILE *tc;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char xfmt[LNSIZE];

	fprintf(tc,fmt,a,b,c,d,e,f,g);
	strcpy(xfmt,"D-C ");
	strcat(xfmt,fmt);
	Verbose(xfmt,a,b,c,d,e,f,g);
}
nntp_via_pop(Conn,url,fc,tc)
	Connection *Conn;
	char *url;
	FILE *fc,*tc;
{	char proto[LNSIZE],host[LNSIZE],port[LNSIZE],group[LNSIZE];
	int ni,porti;
	FILE *ts,*fs,*tmp;
	char line[LNSIZE],com[LNSIZE],*ap,arg[LNSIZE];
	char resp[LNSIZE],*rp;
	int arts,min,max;
	int anum;
	int size,lines;
	char uid[LNSIZE];

	ni = scan_protositeport(url,proto,host,port);
	if( ni < 2 ){
		fprintf(tc,"-ERR\r\n");
		return;
	}
	porti = 119;
	if( ni == 3 ){
		porti = atoi(port);
		if( porti == 0 )
			porti = 119;
	}
	if( sscanf(url,"nntp://%*[^/]/%s",group) <= 0 ){
		fprintf(tc,"-ERR\r\n");
		return;
	}

	set_realserver(Conn,"nntp",host,porti);
	Conn->no_dstcheck_proto = serviceport("nntp");
	if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
		fprintf(tc,"-ERR\r\n");
		return;
	}
	fs = fdopen(FromS,"r");
	ts = fdopen(ToS,"w");

	rp = resp;
	if( fgets(rp,sizeof(resp),fs) == NULL ){
		fprintf(tc,"+ERR gatewaying to NNTP server: closed\r\n");
		return;
	}
	rp = strchr(rp,'\r');
	strcpy(rp," // ");
	rp += strlen(rp);

	fprintf(ts,"MODE READER\r\n");
	fflush(ts);
	fgets(rp,sizeof(resp),fs);

	fprintf(ts,"GROUP %s\r\n",group);
	fflush(ts);
	fgets(rp,sizeof(resp),fs);

	if( atoi(rp) != 211 ){
		putclient(tc,"+ERR gatewaying to NNTP serveri // %s",resp);
		return;
	}
	putclient(tc,"+OK gatewaying to NNTP server // %s",resp);
	sscanf(rp,"211 %d %d %d",&arts,&min,&max);
	sv1log("GROUP %d %d %d %s\n",arts,min,max,group);

	tmp = TMPFILE("NNTP/POP");

	for(;;){
		fflush(tc);
		if( fgets(line,sizeof(line),fc) == NULL ){
			Verbose("C-S EOF\n");
			break;
		}
		if( strncasecmp(line,"PASS ",5) == 0 )
			Verbose("C-S PASS ****\n");
		else	Verbose("C-S %s",line);

		ap = wordScan(line,com);
		lineScan(ap,arg);
		if( strcaseeq(com,"PASS") ){
			putclient(tc,"+OK %s has %d message(s)\r\n",group,arts);
		}else
		if( strcaseeq(com,"QUIT") ){
			putclient(tc,"+OK NNTP/POP gateway signing off.\r\n");
			break;
		}else
		if( strcaseeq(com,"STAT") ){
			putclient(tc,"+OK %d %d\r\n",arts,arts*10000);
		}else
		if( strcaseeq(com,"LIST") ){
			if( arg[0] ){
				anum = atoi(arg);
				if( openARTICLE(ts,fs,anum,resp) == 0 ){
					size = skipmsg(fs);
					putclient(tc,"+OK %d %d\r\n",anum,size);
				}else	putclient(tc,"+ERR %s",resp);
			}else{
				putclient(tc,"+OK %d messages (%d octet)\r\n",
					arts,arts*10000);

				for( anum = min; anum <= max; anum++ )
				if( openARTICLE(ts,fs,anum,resp) == 0 ){
					size = skipmsg(fs);
					putclient(tc,"%d %d\r\n",anum,size);
					if( anum % 10 == 0 )
						fflush(tc);
				}
				putclient(tc,".\r\n");
			}
		}else
		if( strcaseeq(com,"UIDL") ){
			if( arg[0] ){
				anum = atoi(arg);
				if( openARTICLE(ts,fs,anum,resp) == 0 ){
					msguid(fs,uid);
					putclient(tc,"+OK %d %s\r\n",anum,uid);
				}else	putclient(tc,"+ERR %s",resp);
			}else{
				putclient(tc,"+OK %d messages (%d octet)\r\n",
					arts,arts*10000);

				for( anum = min; anum <= max; anum++ )
				if( openARTICLE(ts,fs,anum,resp) == 0 ){
					msguid(fs,uid);
					putclient(tc,"%d %s\r\n",anum,uid);
					if( anum % 10 == 0 )
						fflush(tc);
				}
				putclient(tc,".\r\n");
			}
		}else
		if( strcaseeq(com,"RETR") ){
			anum = atoi(arg);
			if( openARTICLE(ts,fs,anum,resp) != 0 )
				putclient(tc,"-ERR %s",resp);
			else{
				fseek(tmp,0,0);
				PGPdecodeMIME(fs,tmp,NULL,0x7,1,0);
				fflush(tmp); Ftruncate(tmp,0,1);
				fseek(tmp,0,0);
				size = file_size(fileno(tmp));
				putclient(tc,"+OK %d octets\r\n",size);
				copyfile1(tmp,tc);
				putclient(tc,".\r\n");
			}
		}else
		if( strcaseeq(com,"DELE") ){
			putclient(tc,"-ERR forbidden\r\n");
		}else
		if( strcaseeq(com,"NOOP") ){
			putclient(tc,"+OK\r\n");
		}else
		if( strcaseeq(com,"RSET") ){
			putclient(tc,"+OK no effect\r\n");
		}else
		if( strcaseeq(com,"TOP") ){
			lines = 0;
			if( sscanf(arg,"%d %d",&anum,&lines) < 1 ){
				putclient(tc,"-ERR arg count.\r\n");
			}else
			if( openARTICLE(ts,fs,anum,resp) != 0 )
				putclient(tc,"-ERR %s",resp);
			else{
				fseek(tmp,0,0);
				top(fs,tmp,lines);
				fflush(tmp); Ftruncate(tmp,0,1);
				fseek(tmp,0,0);
				size = file_size(fileno(tmp));
				putclient(tc,"+OK %d octets\r\n",size);
				copyfile1(tmp,tc);
				putclient(tc,".\r\n");
			}
		}else{
			putclient(tc,"-ERR unknown command [%s]\r\n",com);
		}
	}
}

static checkPASS(Conn,opts,epass,seed,fc,tc,resp)
	Connection *Conn;
	char *opts,*epass,*seed;
	FILE *fc,*tc;
	char *resp;
{	char *pp,pass[LNSIZE],upass[LNSIZE];
	char xpass[LNSIZE],mpass[LNSIZE];
	char line[LNSIZE],com[LNSIZE],*vp;

	if( pp = strstr(opts,"apop=") ){
		if( *epass == 0 ){
			if( strstr(opts,"pass=") == NULL ){
				sprintf(resp,"-ERR APOP only\r\n");
				return -1;
			}
		}else{
			sscanf(pp+5,"%[^ \t\r\n,]",pass);
			sprintf(xpass,"%s%s",seed,pass);
			toMD5(xpass,mpass);
			if( strcmp(mpass,epass) != 0 ){
				sprintf(resp,"-ERR wrong password\r\n");
				return -2;
			}
			return 0;
		}
	}
	if( pp = strstr(opts,"pass=") ){
		sscanf(pp+5,"%[^ \t\r\n,]",pass);
		fprintf(tc,"+OK password required\r\n");
		fflush(tc);
		if( fgets(line,sizeof(line),fc) == NULL )
			return -1;
		vp = wordScan(line,com);
		lineScan(vp,upass);
		if( strcmp(pass,upass) != 0 ){
			sprintf(resp,"-ERR wrong password\r\n");
			return -3;
		}
	}
	return 0;
}
static mount1(with,src,proto,user,pass,hostn,iport,path,opts)
	char *with,*src,*proto,*user,*pass,*hostn,*iport,*path,*opts;
{
	if( strstr(opts,"apop=") ){
		*with = 1;
		return 1;
	}
	return 0;
}
static withAPOP(Conn)
	Connection *Conn;
{	int with;
	with = 0;

	CTX_scan_mtab(Conn,mount1,&with);
	return with;
}

static change_server(Conn,fc,tc,auser,epass,seed,nextUSER,resp)
	Connection *Conn;
	FILE *fc,*tc;
	char *auser,*epass,*seed;
	char *nextUSER;
	char *resp;
{	char *dp,userhost[LNSIZE],user[LNSIZE],hostport[LNSIZE],host[LNSIZE];
	char tmp[LNSIZE];
	char *opts;
	int port;

	strcpy(userhost,auser);

	if( strchr(userhost,'@') == NULL )
	if( dp = strrchr(userhost,'%') )
		*dp = '@'; /* from user%host1%host2 to user%host1@host2 */

	if( sscanf(userhost,"%[^@]@%s",user,hostport) == 2 ){
		if( dp = strrchr(user,'%') )
			*dp = '@';
		sprintf(userhost,"//%s/%s",hostport,user);
	}
	opts = CTX_mount_url_to(Conn,NULL,"GET",userhost);
	if( opts ){
		if( checkPASS(Conn,opts,epass,seed,fc,tc,resp) != 0 )
			return 0;
	}

	if( strncasecmp(userhost,"nntp:",5) == 0 ){
		Conn->no_dstcheck_proto = serviceport("nntp");
		nntp_via_pop(Conn,userhost,fc,tc);
		return 1;
	}
	if( strncasecmp(userhost,"pop:",4) == 0 ){
		strcpy(tmp,userhost+4);
		strcpy(userhost,tmp);
	}
	if( sscanf(userhost,"//%[^/]/%s",hostport,user) == 2 ){
		port = scan_hostportX("pop",hostport,host,sizeof(host));
		set_realserver(Conn,"pop",host,port);
		service_pop1(Conn,user,nextUSER);
		return 1;
	} 
	return 0;
}

static ProxyPOP(Conn)
	Connection *Conn;
{	char myhost[LNSIZE],banner[LNSIZE];
	FILE *tc,*fc;
	char req[LNSIZE],com[LNSIZE],*vp;
	char seed[LNSIZE],user[LNSIZE],pass[LNSIZE],resp[LNSIZE];

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");

	ClientIF_name(Conn,FromC,myhost);
	sprintf(banner,"+OK Proxy-POP server (%s) at %s starting.",
		DELEGATE_version(),myhost);
	if( withAPOP(Conn) ){
		sprintf(seed,"<%d.%d@%s>",time(0),getpid(),myhost);
		sprintf(banner+strlen(banner)," %s",seed);
	}
	strcat(banner,"\r\n");
	fputs(banner,tc);
	fflush(tc);

	while( fgetsTIMEOUT(req,sizeof(req),fc) != NULL ) GOT: {
		vp = wordScan(req,com);
		if( strcasecmp(com,"XECHO") == 0 ){
			lineScan(vp,resp);
			fprintf(tc,"%s\r\n",resp);
		}else
		if( strcaseeq(com,"USER") || strcaseeq(com,"APOP") ){
			sv1log("POP C-S: %s",req);
			req[0] = 0;
			if( strcaseeq(com,"USER") ){
				wordScan(vp,user);
				pass[0] = 0;
			}else{
				vp = wordScan(vp,user);
				wordScan(vp,pass);
			}
			resp[0] = 0;
			if( change_server(Conn,fc,tc,user,pass,seed,req,resp) ){
				if( req[0] )
					goto GOT;
				else	break;
			}
			if( resp[0] )
				fputs(resp,tc);
			else
			fprintf(tc,"-ERR %s username@hostname is expected.\r\n",
				com);
		}else
		if( strcaseeq(com,"QUIT") ){
			fprintf(tc,"+OK bye.\r\n");
			fflush(tc);
			break;
		}else{
			fprintf(tc,"-ERR Unknown command: \"%s\"\r\n",com);
		}
		fflush(tc);
	}
	fclose(tc);
	fclose(fc);
}
service_pop(Conn)
	Connection *Conn;
{
	if( isMYSELF(DST_HOST) )
		return ProxyPOP(Conn);
	else	return service_pop1(Conn,NULL,NULL);
}
static closePOPserver(ts,fs)
	FILE *ts,*fs;
{	char resp[LNSIZE];

	fputs("QUIT\r\n",ts);
	fflush(ts);
	if( fgets(resp,sizeof(resp),fs) != NULL )
		sv1log("%s",resp);
	else	sv1log("POP S-C EOF on closePOPserver\n");
	fclose(ts);
	fclose(fs);
}
getPOPcharange(banner,timestamp)
	char *banner,*timestamp;
{	char *sp,*dp,ch;

	dp = timestamp;
	if( sp = strchr(banner,'<') )
	for(; ch = *sp; sp++ ){
		*dp++ = ch;
		if( ch == '>' )
			break;
	}
	*dp = 0;
	if( strchr(timestamp,'@') != NULL && strtailchr(timestamp) == '>' )
		sv1log("#### BANNER TIMESTAMP for APOP: %s\n",timestamp);
	else	timestamp[0] = 0;
}
makeAPOPrequest(req,timestamp,user,pass,xpass)
	char *req,*timestamp,*user,*pass,*xpass;
{	char argb[LNSIZE],xpassb[LNSIZE];

	if( xpass == NULL )
		xpass = xpassb;

	sprintf(argb,"%s%s",timestamp,pass);
	toMD5(argb,xpass);
	sprintf(req,"APOP %s %s\r\n",user,xpass);
	sv1log("#### %s",req);
}
doPopAUTH(Conn,tsp,fsp,timestamp,user,pass,resp,size)
	Connection *Conn;
	FILE **tsp,**fsp;
	char *timestamp,*user,*pass,*resp;
{	FILE *ts,*fs;
	char req[LNSIZE],*dp;

	sv1log("AUTH start.\n");
	ts = *tsp;
	fs = *fsp;

	if( timestamp[0] ){
		makeAPOPrequest(req,timestamp,user,pass,NULL);
		if( dp = strpbrk(req,"\r\n") )
			*dp = 0;
		if( putget(1,ts,fs,resp,size,"%s",req) == 0 ){
			sv1log("APOP OK.\n");
			return 0;
		}
		sv1log("retry with USER+PASS\n");
		ToS = FromS = -1;
		if( connect_to_serv(Conn,FromC,ToC,0) < 0 )
			return -1;
		fclose(ts);
		fclose(fs);
		*tsp = ts = fdopen(ToS,"w");
		*fsp = fs = fdopen(FromS,"r");
		if( putget(2,ts,fs,resp,size,NULL) != 0 )
			return -2;
	}

	if( putget(3,ts,fs,resp,size,"USER %s",user) != 0 )
		return -3;

	if( pass != NULL )
	if( putget(4,ts,fs,resp,size,"PASS %s",pass) != 0 )
		return -4;

	sv1log("AUTH done.\n");
	return 0;
}
retryPOPopen(Conn,tsp,fsp,user,pass,resp,size)
	Connection *Conn;
	FILE **tsp,**fsp;
	char *user,*pass,*resp;
{
	sv1log("POP-AUTH: APOP for USER+PASS failed: %s",resp);
	sv1log("POP-AUTH: retrying with USER+PASS.\n");
	closePOPserver(*tsp,*fsp); *tsp = *fsp = NULL;

	if( connect_to_serv(Conn,FromC,ToC,0) < 0 )
		return -1;

	*tsp = fdopen(ToS,"w");
	*fsp = fdopen(FromS,"r");
	if( fgets(resp,size,*fsp) == NULL )
		return -1;

	fprintf(*tsp,"USER %s\r\n",user);
	fflush(*tsp);
	if( fgets(resp,size,*fsp) == NULL )
		return -1;
	fprintf(*tsp,"PASS %s\r\n",pass);
	fflush(*tsp);
	if( fgets(resp,size,*fsp) == NULL )
		return -1;

	if( *resp != '+' ){
		sv1log("POP-AUTH: USER+PASS failed: %s",resp);
		return -1;
	}
	return 0;
}

service_pop1(Conn,user,nextUSER)
	Connection *Conn;
	char *user;
	char *nextUSER;
{	FILE *fc,*tc,*ts,*fs;
	char req[LNSIZE],com[LNSIZE],arg[LNSIZE];
	char *acom,banner[LNSIZE],resp[LNSIZE];
	int ri,body;
	char timestamp[LNSIZE],ch,*sp,*dp;
	char userbuf[LNSIZE],pass[LNSIZE];
	int APOPforUSERPASS;

	if( connect_to_serv(Conn,FromC,ToC,0) < 0 )
	{
		sprintf(banner,"-ERR cannot connect to the server (%s)\r\n",
			"see LOGFILE to investigate the reason");
		write(ToC,banner,strlen(banner));
		set_linger(ToC,DELEGATE_LINGER);
		return;
	}

	fc = fdopen(dup(FromC),"r");
	tc = fdopen(dup(ToC),"w");
	ts = fdopen(ToS,"w");
	fs = fdopen(FromS,"r");

	if( fgets(resp,sizeof(resp),fs) == NULL )
		goto EXIT;
	sv1log("POP S-D: %s",resp);

	if( *resp != '+' ){
		fputs(resp,tc);
		fflush(tc);
		goto EXIT;
	}

	strcpy(banner,resp);
	getPOPcharange(banner,timestamp);

	if( user != NULL && timestamp[0] ){
		sprintf(resp,"+OK enter password for APOP/DeleGate: %s",
			banner);
	}else{
		if( *resp == '+' && user != NULL ){
			sprintf(req,"USER %s\r\n",user);
			sv1log("POP D-S: %s",req);
			if( fputs(req,ts) == EOF )
				goto EXIT;
			fflush(ts);
			if( fgets(resp,sizeof(resp),fs) == NULL )
				goto EXIT;
			sv1log("POP S-D: %s",resp);
		}
	}
	if( fputs(resp,tc) == EOF )
		goto EXIT;
	fflush(tc);
	if( *resp != '+' )
		goto EXIT;

	for(;;){
		/* relay unexpected signing off message
		 * and other ? notification messages ?
		 */
		/* should be implemented as PollIns([fs,ts]) ... */
		while( 0 < fPollIn(fs,1) ){
			if( fgets(resp,sizeof(resp),fs) == NULL ){
				sv1log("POP S-C EOF before client request\n");
				goto EXIT;
			}
			fputs(resp,tc);
		}
		if( fflush(tc) == EOF )
			goto EXIT;

		if( fgets(req,sizeof(req),fc) == NULL )
			goto EXIT;

		if( *req == '\r' || *req == '\n' )
			continue;

		dp = strpbrk(req,"\r\n");
		if( dp == NULL ){
			syslog_ERROR("POP request without CRLF: %s\n",req);
			goto EXIT;
		}
		if( strcmp(dp,"\n") == 0 ){
			syslog_ERROR("WARNING: inserted CR before LF\n");
			strcpy(dp,"\r\n");
		}

		sp = wordScan(req,com);
		if( *sp != 0 ){
			dp = arg;
			for( sp++; ch = *sp; sp++ ){
				if( ch == '\r' || ch == '\n' )
					break;
				*dp++ = ch;
			}
			*dp = 0;
		}else	arg[0] = 0;

		if( strcasecmp(com,"USER") == 0 )
			sv1log("POP C-S: %s",req);
		else
		if( strcasecmp(com,"PASS") == 0 )
			Verbose("POP C-S: PASS ******\r\n");
		else	Verbose("POP C-S: %s",req);

		if( strcasecmp(com,"XECHO") == 0 ){
			fprintf(tc,"%s\r\n",arg);
			continue;
		}

		if( strcasecmp(com,"USER") == 0 ){
			if( nextUSER != NULL ){
				closePOPserver(ts,fs); ts = fs = NULL;
				strcpy(nextUSER,req);
				goto EXIT;
			}
			if( user != NULL && timestamp[0] ){
				closePOPserver(ts,fs); ts = fs = NULL;
				goto EXIT;
			}
			strcpy(userbuf,arg);
			user = userbuf;
			if( timestamp[0] ){
				fprintf(tc,"+OK enter password for APOP/DeleGate.\r\n");
				fflush(tc);
				continue;
			}
		}

		APOPforUSERPASS = 0;
		if( strcasecmp(com,"PASS") == 0 )
		if( user != NULL && timestamp[0] ){
			strcpy(com,"APOP");
			strcpy(pass,arg);
			makeAPOPrequest(req,timestamp,user,pass,arg);
			APOPforUSERPASS = 1;
		}

		for( ri = 0; acom = pop_command[ri].name; ri++ ){
			if( strcaseeq(com,acom) )
				break;
		}
		fputs(req,ts);
		fflush(ts);

		if( fgets(resp,sizeof(resp),fs) == NULL )
		{
			syslog_ERROR("POP S-C EOF without response.\n");
			goto EXIT;
		}

		if( *resp == '-' && APOPforUSERPASS )
		if( retryPOPopen(Conn,&ts,&fs,user,pass,resp,sizeof(resp)) < 0 )
			goto EXIT;

		body = pop_command[ri].resp;
		if( body && arg[0] ){
			if( body & NULL_BODY_IFARG )
				body = NULL_BODY;
		}

		if( body && *resp == '+' )
		if( (body & RESPFLAGS) == (WITH_BODY|IN_RFC822) ) 
		if( filter_withCFI(Conn,XF_FTOCL) )
			putMESSAGEline(tc,"mime",com);

		if( fputs(resp,tc) == EOF )
			goto EXIT;

		if( strcasecmp(com,"PASS") == 0 )
			Verbose("POP S-C[%d:%d]: PASS ******\r\n",ri,body);
		else	Verbose("POP S-C[%d:%d]: %s",ri,body,resp);

		if( body && *resp == '+' ){
			switch( body & RESPFLAGS ){
				case WITH_BODY | IN_RFC822:
					PGPdecodeMIME(fs,tc,NULL,0xFF,1,0);
					break;
				case WITH_BODY:
					thruRESP(fs,tc);
					break;
			}
		}
		fflush(tc);
		if( strcaseeq(com,"QUIT") )
			goto EXIT;

		if( user != NULL )
		if( strcaseeq(com,"PASS") || strcaseeq(com,"APOP") ){
			char clnt[LNSIZE],serv[LNSIZE];
			char *cluser,clhost[LNSIZE];
			char *getClientUserC();
			int clport;

			clport = getClientHostPort(Conn,clhost);
			if( (cluser = getClientUserC(Conn)) == NULL )
				cluser = "-";
			sprintf(clnt,"%s@%s:%d",cluser,clhost,clport);

			sprintf(serv,"%s@%s",user,DST_HOST);
			sv1log("%cPOP-LOGIN FROM %s TO %s\n",
				resp[0],clnt,serv);
			fputLog(Conn,"Login","%cPOP-LOGIN; from=%s; to=%s\n",
				resp[0],clnt,serv);
			LOG_flushall();
		}
	}

EXIT:
	if( ts != NULL ) fclose(ts);
	if( fs != NULL ) fclose(fs);
	if( tc != NULL ) fclose(tc);
	if( fc != NULL ) fclose(fc);
	return;
}

getlineBlind(out,in,prompt,line,size)
	FILE *out,*in;
	char *prompt,*line;
{	char *dp;
	char *av[3];
	int pid;

	fprintf(out,"%s",prompt);
	fflush(out);

	line[0] = 0;
	av[0] = "stty";
	av[1] = "-echo";
	av[2] = 0;
	if( (pid = Spawnvp("getline","stty",av)) < 0 ){
		fprintf(stderr,"Cannot disable ECHO on your terminal\r\n");
		return -1;
	}
	wait(0);

	fgets(line,size,in);
	av[1] = "echo";
	Spawnvp("getline","stty",av);
	wait(0);

	if( dp = strpbrk(line,"\r\n") )
		*dp = 0;
	fprintf(out,"\r\n");
	return 0;
}
getPassword(proto,site,path,pass,size)
	char *proto,*site,*path,*pass;
{	char prompt[LNSIZE];

	pass[0] = 0;

	/* pop up window for password if any Window is available ...*/

	if( isatty(fileno(stdin)) ){
	sprintf(prompt,"Enter password for \"%s://%s/%s\": ",proto,site,path);
	getlineBlind(stderr,stdin,prompt,pass,size);
	}
}

POP_open(Conn,fromC,toC,tsp,fsp,user,pass,resp,rsize)
	Connection *Conn;
	FILE **tsp,**fsp;
	char *user,*pass,*resp;
{	int sock;
	char seed[LNSIZE];
	int rcode;

	sock = connect_to_serv(Conn,fromC,toC,0);
	if( sock < 0 ){
		sprintf(resp,"-ERR Could not connect to pop://%s:%d\r\n",
			DST_HOST,DST_PORT);
		return -1;
	}
	*fsp = fdopen(sock,"r");
	*tsp = fdopen(sock,"w");
	if( putget(1,*tsp,*fsp,resp,rsize,NULL) != 0 ){
		fclose(*fsp);
		fclose(*tsp);
		return -1;
	}
	getPOPcharange(resp,seed);
	resp[0] = 0;
	rcode = doPopAUTH(Conn,tsp,fsp,seed,user,pass,resp,rsize);
	return rcode;
}

poprelay_main(ac,av,xConn)
	char *av[];
	Connection *xConn;
{	Connection popConnBuf, *popConn = &popConnBuf;
	FILE *tsp,*fsp,*tss,*fss,*afp;
	char *spool;
	char dest[LNSIZE];
	char req[LNSIZE],resp[LNSIZE];
	int ai,mi;
	char *arg;
	int msize,wcc;
	char *error;
	int delete;
	char owner[LNSIZE],myhost[LNSIZE];
	char proto[LNSIZE],site[LNSIZE],upath[LNSIZE];
	char pophost[LNSIZE],user[LNSIZE],pass[LNSIZE];
	int maxmsg;
	char mailto[LNSIZE];

	ConnInit(popConn);
	popConn->from_myself = 1;
	spool = DELEGATE_getEnv(P_MAILSPOOL);
	if( spool == NULL ){
		fprintf(stderr,"Specify MAILSPOOL=pop://user@host\n");
		Finish(-1);
	}
	decomp_absurl(spool,proto,site,upath,sizeof(upath));
	if( strcmp(proto,"pop") != 0 ){
		fprintf(stderr,"Specify MAILSPOOL=pop://user@host\n");
		Finish(-2);
	}
	if( site[0] == 0 )
		strcpy(site,"localhost");
	decomp_site(proto,site,user,pass,pophost,NULL);

	getUsername(getuid(),owner);
	GetHostname(myhost,sizeof(myhost));

	if( user[0] == 0 )
		strcpy(user,owner);
	if( pass[0] == 0 )
		getPassword(proto,site,upath,pass,sizeof(pass));

	scan_SERVER(popConn,spool);

	dest[0] = 0;
	delete = 0;
	maxmsg = 10;
	strcpy(mailto,"");

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( streq(arg,"-DELE") )
			delete = 1;
		else
		if( strncasecmp(arg,"-To:",4) == 0 )
			strcpy(mailto,arg+4);
	}

	if( POP_open(popConn,-1,-1,&tsp,&fsp,user,pass,resp,sizeof(resp)) ){
		fprintf(stderr,"%s",resp);
		Finish(-3);
	}

/* connect to the SERVER if specified ... (smtp,ftp,nntp,...) */
/* else if XCMD is specified ... */

	afp = TMPFILE("POP2SMTP");
	for( mi = 1; mi <= maxmsg; mi++ ){
		if( putget(7,tsp,fsp,resp,sizeof(resp),"RETR %d",mi) != 0 )
			break;
		fseek(afp,0,0);
		relayRESPBODY(fsp,afp,resp,sizeof(resp));
		fflush(afp);
		Ftruncate(afp,0,1);
		fseek(afp,0,0);
		/* do filtering here ? */
		msize = file_size(fileno(afp));
		error = 0;
		if( mailto[0] ){
			if( sendmailSMTP(xConn,NULL,0,mailto,NULL,afp) != 0 )
				break;
		}else
		if( dest[0] == 0 ){
			wcc = copyfile1(afp,stderr);
			syslog_ERROR("wrote %d / %d\n",wcc,msize);
			error = "not forwarded (no destination)";
		}else{
			error = "not forwarded (bad destination)";
		}
		if( error ){
			syslog_ERROR("DON'T DELETE: %s\n",error);
			continue;
		}
		if( delete )
		if( putget(8,tsp,fsp,resp,sizeof(resp),"DELE %d",mi) != 0 )
			break;
	}
	fclose(afp);

	putget(-9,tsp,fsp,resp,sizeof(resp),"QUIT");
	Finish(0);
}
sendmailSMTP(Conn,smtphost,smtpport,mailto,mailfrom,afp)
	Connection *Conn;
	FILE *afp;
	char *smtphost,*mailto,*mailfrom;
{	FILE *fpv[2];
	char admin[LNSIZE],resp[LNSIZE];

	Conn->from_myself = 1;
	if( mailfrom == NULL ){
		sprintf(admin,"%s (POP-GW-DeleGate/%s)",getADMIN(),
			DELEGATE_ver());
		mailfrom = admin;
	}
	if( smtphost == NULL )
		smtphost = "localhost";
	if( smtpport == 0 )
		smtpport = 25;

	if( SMTP_open(Conn,fpv,smtphost,smtpport,mailto,mailfrom,1,stderr)<0 )
		return -1;

	fprintf(fpv[1],"X-Forwarded: by %s (POP-GW-DeleGate/%s)\r\n",
		mailfrom,DELEGATE_ver());
	copyfile1(afp,fpv[1]);
	fputs(".\r\n",fpv[1]);

	putget(0,fpv[1],fpv[0],resp,sizeof(resp),"QUIT");
	fclose(fpv[0]);
	fclose(fpv[1]);
	return 0;
}
