/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Yutaka Sato
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	param.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950205	created
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>
#include <stdio.h>

char P_ABORTLOG[] = "ABORTLOG";
char P_ACTDIR[]   = "ACTDIR";
char P_ADMDIR[]   = "ADMDIR";
char P_ADMIN[]    = "ADMIN";
char P_ADMINPASS[] = "ADMINPASS";
char P_AUTH[]     = "AUTH";
char P_AUTHORIZER[] = "AUTHORIZER";
char P_BASEURL[]  = "BASEURL";
char P_CACHE[]    = "CACHE";
char P_CACHEDIR[] = "CACHEDIR";
char P_CACHEFILE[]= "CACHEFILE";
char P_CGIENV[]   = "CGIENV";
char P_CHARCODE[] = "CHARCODE";
char P_CHARSET[]  = "CHARSET";
char P_CHROOT[]   = "CHROOT";
char P_CMAP[]     = "CMAP";
char P_CRON[]     = "CRON";
char P_CRONS[]    = "CRONS";
char P_CONNECT[]  = "CONNECT";
char P_COUNTER[]  = "COUNTER";
char P_DBFILE[]   = "DBFILE";
char P_DGOPTS[]   = "DGOPTS";
char P_DGPATH[]   = "DGPATH";
char P_DGROOT[]   = "DGROOT";
char P_DELAY[]    = "DELAY";
char P_DELEGATE[] = "DELEGATE";
char P_DNSCONF[]  = "DNSCONF";
char P_ERRORLOG[] = "ERRORLOG";
char P_ETCDIR[]   = "ETCDIR";
char P_EXPIRE[]   = "EXPIRE";
char P_EXPIRELOG[]= "EXPIRELOG";
char P_FCL[]      = "FCL";
char P_FMD[]      = "FMD";
char P_FSV[]      = "FSV";
char P_FFROMCL[]  = "FFROMCL";
char P_FFROMSV[]  = "FFROMSV";
char P_FFROMMD[]  = "FFROMMD";
char P_FILETYPE[] = "FILETYPE";
char P_FTOCL[]    = "FTOCL";
char P_FTOMD[]    = "FTOMD";
char P_FTOSV[]    = "FTOSV";
char P_FTPCONF[]  = "FTPCONF";
char P_FUNC[]     = "FUNC";
char P_HOSTS[]    = "HOSTS";
char P_HTMLCONV[] = "HTMLCONV";
char P_HTTPMAIL[] = "HTTPMAIL";
char P_HTTPCONF[] = "HTTPCONF";
char P_ICP[]      = "ICP";
char P_ICPCONF[]  = "ICPCONF";
char P_INETD[]    = "INETD";
char P_INPARAM[]  = "INPARAM";
char P_FORCEON[]  = "FORCEON";
char P_LIBDIR[]   = "LIBDIR";
char P_LIBPATH[]  = "LIBPATH";
char P_LOG[]      = "LOG";
char P_LOGDIR[]   = "LOGDIR";
char P_LOGFILE[]  = "LOGFILE";
char P_LOGCENTER[]= "LOGCENTER";
char P_MAILSPOOL[]= "MAILSPOOL";
char P_MANAGER[]  = "MANAGER";
char P_MASTER[]   = "MASTER";
char P_MASTERP[]  = "MASTERP";
char P_MAXIMA[]   = "MAXIMA";
char P_MIMECONV[] = "MIMECONV";
char P_MOUNT[]    = "MOUNT";
char P_NNTPCONF[] = "NNTPCONF";
char P_OWNER[]    = "OWNER";
char P_OVERRIDE[] = "OVERRIDE";
char P_PERMIT[]   = "PERMIT";
char P_REMITTABLE[] = "REMITTABLE";
char P_PGP[]      = "PGP";
char P_PIDFILE[]  = "PIDFILE";
char P_PORT[]     = "PORT";
char P_PROTOLOG[] = "PROTOLOG";
char P_PROXY[]    = "PROXY";
char P_PUBLIC[]   = "PUBLIC";
char P_QPORT[]    = "QPORT";
char P_RIDENT[]   = "RIDENT";
char P_RPORT[]    = "RPORT";
char P_REACHABLE[]= "REACHABLE";
char P_RELIABLE[] = "RELIABLE";
char P_RES_CONF[] = "RES_CONF";
char P_RES_DEBUG[]= "RES_DEBUG";
char P_RES_LOG[]  = "RES_LOG";
char P_RES_NS[]   = "RES_NS";
char P_RES_RR[]   = "RES_RR";
char P_RES_VRFY[] = "RES_VRFY";
char P_RESOLV[]   = "RESOLV";
char P_RELAY[]    = "RELAY";
char P_ROUTE[]    = "ROUTE";
char P_SERVER[]   = "SERVER";
char P_SHARE[]    = "SHARE";
char P_SMTPCONF[] = "SMTPCONF";
char P_SMTPGATE[] = "SMTPGATE";
char P_SMTPSERVER[] = "SMTPSERVER";
char P_SOCKS[]    = "SOCKS";
char P_SSLTUNNEL[] = "SSLTUNNEL";
char P_SYSLOG[]   = "SYSLOG";
char P_INVITE[]   = "INVITE";
char P_THRUWAY_ENTR[] = "THRUWAY_ENTR";
char P_THRUWAY_EXIT[] = "THRUWAY_EXIT";
char P_TMPDIR[]   = "TMPDIR";
char P_TUNNEL[]   = "TUNNEL";
char P_TIMEOUT[]  = "TIMEOUT";
char P_TRACELOG[] = "TRACELOG";
char P_UMASK[]    = "UMASK";
char P_URICONV[]  = "URICONV";
char P_VARDIR[]   = "VARDIR";
char P_VSAP[]     = "VSAP";
char P_WORKDIR[]  = "WORKDIR";
char P_XCOM[]     = "XCOM";
char P_XFIL[]     = "XFIL";

char P_EXEC_PATH[]   = "_execPath";
char P_EXEC_ENV[]    = "_execEnv";
char P_START_TIME[]  = "_startTime";
char P_ALIVE_PEERS[] = "_alivePeers";
char P_MASTERPMARK[] = "_masterp";
char P_INPUT[]       = "_input";


#define NOT	0	/* not yet supported */
#define EXP	1	/* experimental */
#define STD	2	/* current standard */
#define DIS	3	/* discurraged */
#define OBS	4	/* obsolete */
#define INT	5	/* internal use */

typedef struct {
	char	*p_name;
	int	 p_stat;
	char	*p_mssg;
	char	 p_mpass;	/* pass to private-MASTER */
	char	 p_fpass;	/* pass to external filter program */
	char	 p_spass;	/* pass to spawned self */
} ParamSpec;

#define M0	NULL
static char M1[] = "use PERMIT for it.";
static char M2[] = "use CHARCODE for it.";

static ParamSpec params[] = {
{ P_ABORTLOG,	STD,M0,1,1},
{ P_ACTDIR,	STD,M0,1,1},
{ P_ADMDIR,	STD,M0,1,1},
{ P_ADMIN,	STD,M0,1,1},
{ P_ADMINPASS,	STD,M0,1,1},
{ P_AUTH,	STD,M0,1,1},
{ P_AUTHORIZER,	STD,M0,0,1},
{ P_BASEURL,	STD,M0,0,1},
{ P_CACHE,	EXP,M0,1,1},
{ P_CACHEDIR,	STD,M0,1,1},
{ P_CACHEFILE,	STD,M0,1,1},
{ P_CGIENV,	STD,M0,1,1},
{ P_CHARCODE,	STD,M0,0,1},
{ P_CHARSET,	STD,M0,0,1},
{ P_CHROOT,	STD,M0,1,1},
{ P_CONNECT,	EXP,M0,1,1},
{ P_COUNTER,	NOT,M0,1,1},
{ P_CRON,	EXP,M0,0,0},
{ P_CRONS,	EXP,M0,0,0},
{ P_DBFILE,	EXP,M0,1,1},
{ P_DGOPTS,	STD,M0,1,1},
{ P_DGPATH,	STD,M0,1,1},
{ P_DGROOT,	STD,M0,1,1},
{ P_DELAY,	STD,M0,0,1},
{ P_DELEGATE,	STD,M0,0,1},
{ P_DNSCONF,	EXP,M0,1,1},
{ P_ERRORLOG,	STD,M0,1,1},
{ P_ETCDIR,	STD,M0,1,1},
{ P_EXPIRE,	STD,M0,1,1},
{ P_EXPIRELOG,	STD,M0,1,1},
{ P_FCL,	EXP,M0,0,0},
{ P_FMD,	EXP,M0,0,0},
{ P_FSV,	EXP,M0,0,0},
{ P_FFROMCL,	EXP,M0,0,0},
{ P_FFROMMD,	EXP,M0,0,0},
{ P_FFROMSV,	EXP,M0,0,0},
{ P_FILETYPE,	EXP,M0,0,0},
{ P_FTOCL,	EXP,M0,0,0},
{ P_FTOMD,	EXP,M0,0,0},
{ P_FTOSV,	EXP,M0,0,0},
{ P_FTPCONF,	EXP,M0,1,1},
{ P_FUNC,	EXP,M0,0,0},
{ P_FORCEON,	OBS,M0,0,0},
{ P_HOSTS,	STD,M0,1,1},
{ P_HTMLCONV,	STD,M0,0,1},
{ P_HTTPMAIL,	STD,M0,0,0},
{ P_HTTPCONF,	STD,M0,0,0},
{ P_ICP,	STD,M0,0,0},
{ P_ICPCONF,	STD,M0,0,0},
{ P_INETD,	EXP,M0,0,0},
{ P_INPARAM,	EXP,M0,0,0},
{ P_LIBDIR,	EXP,M0,1,1},
{ P_LIBPATH,	EXP,M0,1,1},
{ P_LOG,	EXP,M0,1,1},
{ P_LOGDIR,	STD,M0,1,1},
{ P_LOGFILE,	STD,M0,1,1},
{ P_LOGCENTER,	STD,M0,1,1},
{ P_MAILSPOOL,	STD,M0,1,1},
{ P_MANAGER,	OBS,M0,1,1},
{ P_CMAP,	STD,M0,0,0},
{ P_MASTER,	STD,M0,0,0},
{ P_MASTERP,	STD,M0,0,0},
{ P_MAXIMA,	EXP,M0,1,1},
{ P_MIMECONV,	STD,M0,0,1},
{ P_MOUNT,	STD,M0,0,0},
{ P_NNTPCONF,	EXP,M0,1,1},
{ P_OWNER,	STD,M0,1,1},
{ P_OVERRIDE,	EXP,M0,0,0},
{ P_PERMIT,	STD,M0,0,0},
{ P_PGP,	STD,M0,0,0},
{ P_PIDFILE,	STD,M0,1,1},
{ P_PORT,	EXP,M0,0,0},
{ P_PROTOLOG,	STD,M0,1,1},
{ P_PROXY,	STD,M0,0,0},
{ P_PUBLIC,	EXP,M0,0,0},
{ P_QPORT,	EXP,M0,1,1},
{ P_RIDENT,	EXP,M0,1,1},
{ P_RPORT,	EXP,M0,1,1},
{ P_REACHABLE,	DIS,M1,0,0},
{ P_RELIABLE,	DIS,M1,0,0},
{ P_REMITTABLE,	STD,M0,0,0},
{ P_RES_CONF,	STD,M0,1,1},
{ P_RES_DEBUG,	STD,M0,1,1},
{ P_RES_LOG,	STD,M0,1,1},
{ P_RES_NS,	STD,M0,1,1},
{ P_RES_RR,	STD,M0,1,1},
{ P_RES_VRFY,	STD,M0,1,1},
{ P_RESOLV,	STD,M0,1,1},
{ P_RELAY,	DIS,M1,0,0},
{ P_ROUTE,	STD,M0,1,1},
{ P_SERVER,	STD,M0,0,0},
{ P_SHARE,	EXP,M0,1,1},
{ P_SMTPCONF,	STD,M0,1,1},
{ P_SMTPGATE,	STD,M0,1,1},
{ P_SMTPSERVER,	STD,M0,0,0},
{ P_SOCKS,	STD,M0,1,1},
{ P_SSLTUNNEL,	EXP,M0,1,1},
{ P_SYSLOG,	EXP,M0,1,1},
{ P_INVITE,	EXP,M0,1,1},
{ P_THRUWAY_ENTR,EXP,M0,0,0},
{ P_THRUWAY_EXIT,EXP,M0,0,0},
{ P_TMPDIR,	STD,M0,1,1},
{ P_TUNNEL,	STD,M0,1,1},
{ P_TIMEOUT,	STD,M0,1,1},
{ P_TRACELOG,	EXP,M0,1,1},
{ P_UMASK,	STD,M0,1,1},
{ P_URICONV,	STD,M0,0,1},
{ P_VARDIR,	STD,M0,1,1},
{ P_VSAP,	EXP,M0,0,0},
{ P_WORKDIR,	STD,M0,1,1},
{ P_XCOM,	EXP,M0,0,0},
{ P_XFIL,	EXP,M0,0,0},

{ P_EXEC_PATH,  INT,M0,0,0},
{ P_EXEC_ENV,	INT,M0,0,0},
{ P_START_TIME, INT,M0,0,0},
{ P_ALIVE_PEERS,INT,M0,0,0},
{ P_MASTERPMARK,INT,M0,0,0},
{ P_INPUT,	INT,M0,0,0},
{ 0 }
};

script_asis(param)
	char *param;
{
	if( streq(param,P_CRON)  ) return 1;
	if( streq(param,P_INETD) ) return 1;
	return 0;
}

check_param(param,warn)
	char *param;
{	char *pn,*pm,*dp;
	int pi;
	char *name,nameb[128];

	if( dp = strchr(param,'=') ){
		strncpy(nameb,param,dp-param);
		nameb[dp-param] = 0;
		name = nameb;
	}else	name = param;

	for( pi = 0; pn = params[pi].p_name; pi++ ){
	    if( strcmp(pn,name) == 0  ){
		if( warn && params[pi].p_stat == OBS ){
			sv1log("Warning: Obsoleteparameter: %s\n",name);
			if( pm = params[pi].p_mssg )
				sv1log("Warning: %s\n",pm);
		}
		return pi;
	    }
	}
	if( warn )
		fprintf(stderr,"Warning: unknown parameter: %s\n",name);
	return -1;
}

copy_param(param,dav,sav)
	char *param;
	char *dav[],*sav[];
{	int dai,sai,pi;
	int valid_all;
	int option_also;
	int script_also;
	int for_filters;
	int len;
	char *name;

	valid_all = 0;
	option_also = 0;
	script_also = 0;
	for_filters = 0;
	if( param ){
		for(; *param; param++ ){
			if( param[0] == '*' ) valid_all = 1; else
			if( param[0] == '-' ) option_also = 1; else
			if( param[0] == '+' ) script_also = 1; else
			if( param[0] == 'f' ) for_filters = 1; else
				break;
		}
		if( *param == 0 )
			param = NULL;
	}
	dai = 0;

	if( param != NULL ){
	    len = strlen(param);
	    for( sai = 0; name = sav[sai]; sai++ ){
		if( name[len] == '=' )
		if( strncmp(name,param,len) == 0 )
		    dav[dai++] = sav[sai];
	    }
	}else{
	    for( sai = 0; name = sav[sai]; sai++ ){
		if( option_also && name[0] == '-' )
			dav[dai++] = sav[sai];
		else
		if( script_also && name[0] == '+' )
			dav[dai++] = sav[sai];
		else
		if( strchr(name,'=') )
		if( 0 <= (pi = check_param(name,0)) ){
		    if( valid_all
		    || !for_filters && params[pi].p_mpass
		    ||  for_filters && params[pi].p_fpass ){
			dav[dai++] = sav[sai];
		    }
		}
	    }
	}
	return dai;
}
