/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	notify.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

    category
	emergent
	infomational
	periodical report
	...

History:
	991207	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
extern char *TIMEFORM_RFC822;
extern char *DELEGATE_verdate();
extern FILE *TMPFILE();
extern int START_TIME;
extern char *getADMIN1();

notify_ADMIN(xConn,what)
	Connection *xConn;
	char *what;
{
	notify_ADMINX(xConn,getADMIN1(),what,"");
}
notify_ADMINX(xConn,admin,what,body)
	Connection *xConn;
	char *admin;
	char *what;
	char *body;
{	FILE *tmp;
	Connection ConnBuff,*Conn = &ConnBuff;
	char head[1024],me[128],date[128],load[128];
	char uname[128];
	int now;

	if( strncasecmp(what,"sig",3) != 0 )
	if( strncasecmp(what,"modified",8) != 0 )
	if( strncasecmp(what,"approved",8) != 0 )
	if( strncasecmp(what,"detected",8) != 0 )
		return;

	if( admin == NULL || *admin == 0 )
		admin = getADMIN1();

	now = time(NULL);
	if( xConn )
		*Conn = *xConn;
	else	bzero(Conn,sizeof(Connection));
	tmp = TMPFILE("NOTIFY");

	head[0] = 0;
	if( gethostname(me,sizeof(me)) != 0 )
		strcpy(me,"?");
	StrftimeLocal(date,sizeof(date),TIMEFORM_RFC822,now);
	sprintf(head+strlen(head),"Subject: DeleGate-Report: %s\r\n",what);
	sprintf(head+strlen(head),"From: [%d]@%s\r\n",getuid(),me);
	sprintf(head+strlen(head),"Date: %s\r\n",date);
	fprintf(tmp,"%s\r\n%s",head,head);
	fprintf(tmp,"Event: %s\r\n",what);
	Uname(uname);
	fprintf(tmp,"Version: %s (%s)\r\n",DELEGATE_verdate(),uname); 
	fprintf(tmp,"Host: %s\r\n",me);
	fprintf(tmp,"Owner: uid=%d/%d, gid=%d/%d\r\n",
		geteuid(),getuid(),getegid(),getgid());
	StrftimeLocal(date,sizeof(date),TIMEFORM_RFC822,START_TIME);
	fprintf(tmp,"Started: %s\r\n",date);
	fprintf(tmp,"Pid: %d\r\n",getpid());
	strfLoadStat(load,sizeof(load),"%L (%l)",now);
	fprintf(tmp,"Load: %s\r\n",load);
	fprintf(tmp,"\r\n");
	fprintf(tmp,"%s\r\n",body);

	fflush(tmp);
	fseek(tmp,0,0);
	Conn->co_mask = (CONN_NOPROXY | CONN_NOMASTER); 
	sendmail1(Conn,admin,admin,tmp,NULL);
	fclose(tmp);
}
