/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	msg.c (message I/O)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	Multiplex control and data messages on a communication channel.
History:
	941225	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
extern char *fgetsTimeout();
extern char *calloc();

#define MSG_SIZE	0x8000
#define MSG_TIMEOUT	((double)0.5)

static sv1Vlog(){}

putPreStatus(dstf,status)
	FILE *dstf;
	char *status;
{
	fprintf(dstf,"^%s",status);
	fflush(dstf);
}
putPostStatus(dstf,status)
	FILE *dstf;
	char *status;
{	char *sp,ch;

	fputs("$",dstf);
	for( sp = status; ch = *sp; sp++ ){
		if( ch == '\n' && sp[1] != 0 )
			fputs("\\n",dstf);
		else
		if( ch == '\\' )
			fputs("\\\\",dstf);
		else	putc(ch,dstf);
	}
	fflush(dstf);
}
static unescape_nl(str)
	char *str;
{	char *dp,*sp,ch;

	dp = sp = str;
	while( ch = *sp++ ){
		if( ch == '\\' ){
			if( *sp == 'n' )
				*dp++ = '\n';
			else	*dp++ = *sp;
			sp++;
		}else	*dp++ = ch;
	}
	*dp = 0;
}
putMessage1(dstf,ser,buff,size)
	FILE *dstf;
	char *buff;
{	int wc,wcc,nw;

	sv1Vlog("putMessage: got %d\n",size);
	fprintf(dstf,"@%d %d %s\r\n",ser,size,"");
	sv1Vlog("@%d %d %s\r\n",ser,size,"");

	if( buff != NULL ){
		nw = 0;
		for( wcc = 0; wcc < size; wcc += wc ){
			wc = fwrite(buff+wcc,1,size-wcc,dstf);
			if( wc == 0 )
				return -1;
			nw++;
		}
	}
	fflush(dstf);
	sv1Vlog("putMessage: put %d/%d\n",size,nw);
	return 0;
}

extern double Time();
static freadIntime(buff,s,n,fp,Timeout)
	char *buff;
	FILE *fp;
	double Timeout;
{	int rc,rc0,rc1;
	double start,end;
	int nread;

	if( s != 1 )
		return freadTIMEOUT(buff,s,n,fp);

	start = Time();
	end = 0;
	rc = 0;
	nread = 0;
	while( rc < n ){
		rc0 = n - rc;
		if( 512 < rc0 )
			rc0 = 512;

		rc1 = freadTIMEOUT(buff+rc,s,rc0,fp);
		end = Time();

		if( rc1 == 0 )
			break;

		nread++;
		rc += rc1;
		if( Timeout <= (end-start) )
			break;
	}
	daemonlog("D","freadIntime: %dbytes / %dread / %4.2fseconds\n",
		rc,nread,end-start);
	return rc;
}

putMessageF(srcf,dstf,cachefp)
	FILE *srcf,*dstf,*cachefp;
{	int ser,rcc,rcc_total;
	char buff[MSG_SIZE];

	rcc_total = 0;
	for( ser = 1; rcc = freadIntime(buff,1,sizeof(buff),srcf,MSG_TIMEOUT); ser++ ){
		rcc_total += rcc;
		if( cachefp )
			fwrite(buff,1,rcc,cachefp);
		if( putMessage1(dstf,ser,buff,rcc) < 0 )
			goto EXIT;
	}
	putMessage1(dstf,ser,NULL,0);
	fflush(dstf);
EXIT:
	return rcc_total;
}

getMessage(srcd,func,arg1,arg2)
	char *(*func)();
	char *arg1,*arg2;
{	FILE *src;

	src = fdopen(srcd,"r");
	return getMessageF(src,NULL,0,func,arg1,arg2);
}

#define MSG_BUFSIZE (MSG_SIZE *2) /* extra space for pending strings without NL */
static char *PendingBuff;
static char *PendingP;
static int Pending;
static int DoFill;

static pclear()
{
	PendingP = PendingBuff;
	Pending = 0;
	DoFill = 0;
}
static pfill(len,srcf)
	FILE *srcf;
{	int brc;

	if( PendingBuff == 0 )
		PendingBuff = calloc(MSG_BUFSIZE,1);
	if( Pending )
		bcopy(PendingP,PendingBuff,Pending);
	PendingP = PendingBuff;
	brc = freadTIMEOUT(PendingBuff+Pending,1,len,srcf);
	Pending += brc;
	sv1vlog("fillPending: +%d = %d bytes\n",brc,Pending);
	return brc;
}
static ppush(buff,len)
	char *buff;
{
	if( PendingBuff == 0 )
		PendingBuff = calloc(MSG_BUFSIZE,1);

	PendingP = PendingBuff;
	bcopy(buff,PendingBuff+Pending,len);
	Pending += len;
	sv1log("pushPending: +%d = %d bytes\n",len,Pending);
}
static pgets(buff,len,srcf)
	char *buff;
	FILE *srcf;
{	int pi;
	char *sp,*dp,ch;
	int rc,rrc,EOB = 0;

	if( Pending == 0 || DoFill )
	if( !feof(srcf) ){
		DoFill = 0;
		rrc = pfill(len,srcf);
		if( len == rrc )
			EOB = 1;
	}

	sp = PendingP;
	dp = buff;
	rc = 0;
	for( pi = 0; pi < Pending; pi++ ){
		rc++;
		ch = *dp++ = *sp++;
		if( ch == '\n' )
			goto GOTNL;
		if( ch == '\r' && rc < Pending && *sp != '\n' )
			goto GOTNL;
	}

	if( MSG_SIZE <= pi || EOB ){
		sv1log("Without CR/LF: %d/%d, %d\n",pi,MSG_SIZE,EOB);
		goto GOTNL;
	}

	if( !feof(srcf) ){
		DoFill = 1;
		return 0;
	}
GOTNL:
	buff[rc] = 0;
	Pending -= rc;
	PendingP = sp;
	return rc;
}

static flushPending(outEOF,ser,func,dstf,arg)
	char *(*func)();
	FILE *dstf;
	char *arg;
{	int pending;

	if( pending = Pending ){
		sv1log("flushPending: eof=%d %d\n",outEOF,Pending);
		if( !outEOF ){
			/* should be done line by line in "linemode" ... */
			(*func)(ser,PendingP,Pending,dstf,arg);
		}
		pclear();
	}
	return pending;
}

getMessageF(srcf,cachefp,timeout,func,dstf,arg)
	FILE *srcf,*cachefp;
	char *(*func)();
	FILE *dstf;
	char *arg;
{	char head[MSG_SIZE+1];
	int total,ser,rc,rcc1,rcc,pending,pen;
	char buff[MSG_SIZE+1];
	char *op;
	int linemode;
	char ext[128];
	int outEOF;

	total = 0;
	head[0] = 0;
	linemode = 0;
	pending = 0;
	outEOF = 0;

	op = "";
	for(;;){
		if( dstf != NULL && ready_cc(srcf) == 0 )
			if( fflushTIMEOUT(dstf) == EOF ){
				outEOF++;
				break;
			}

		head[0] = 0;
		if( fgetsTimeout(head,sizeof(head),srcf,timeout) == NULL ){
			sv1log("getMessageF: fgets timeout(%d)\n",timeout);
			break;
		}

		if( head[0] == '^' ){
			op = (*func)(-1,head+1,strlen(head)-1,dstf,arg);
			if( op && streq(op,"linemode") ){
				sv1log("getMessageF: linemode\n");
				linemode = 1;
			}
			continue;
		}
		if( head[0] == '$' ){
			total += flushPending(outEOF,ser,func,dstf,arg);
			unescape_nl(head);
			(*func)(0,head+1,strlen(head)-1,dstf,arg);
			sv1Vlog("getMessageF: End of Block\n");
			break;
		}

		ext[0] = 0;
		if( sscanf(head,"@%d %d %[^\r\n]\r\n",&ser,&rcc,ext) < 2 )
		if( sscanf(head,"@%d - %d\r\n",&ser,&rcc) != 2 ){
			sv1log("getMessageF: Bad block header(%d) %s\n",
				strlen(head),head);
			break;
		}

		sv1Vlog("getMessageF: @%d %d %s\n",ser,rcc,ext);

		if( 0 < rcc ){
		    pen = pending;
		    pending = 0;
		    for( ; 0 < pen+rcc; rcc -= rc ){

			if( dstf != NULL && ready_cc(srcf) == 0 )
				if( fflushTIMEOUT(dstf) == EOF ){
					outEOF++;
					break;
				}

			if( linemode ){
				rc = pgets(buff,rcc,srcf);
				if( rc == 0 ){
					pending = pen+rcc;
					break;
				}
				op = (*func)(ser,buff,rc,dstf,arg);
				if( cachefp )
					fwrite(buff,1,rc,cachefp);
			}else{
				if( rcc < MSG_SIZE )
					rcc1 = rcc;
				else	rcc1 = MSG_SIZE;

/*
951026
rc = freadIntime(buff,1,rcc1,srcf,(double)1);
timeouting often make the received packet collupted (in back-linemode only ?
*/
				rc = freadTIMEOUT(buff,1,rcc1,srcf);
				if( rc == 0 ){
					sv1log("getMessageF: premature EOF\n");
					break;
				}
				op = (*func)(ser,buff,rc,dstf,arg);
				if( cachefp )
					fwrite(buff,1,rc,cachefp);

				if( op && streq(op,"back-linemode") ){
					sv1log("getMessageF: back-linemode\n");
					ppush(buff,rcc1);
					linemode = 1;
					rc = 0;
				}
			}
			if( op && streq(op,"EOF") ){
				if( outEOF <= 1 )
					sv1log("getMessageF: EOF/output\n");
				outEOF++;
				break;
			}
			total += rc;
		    }
		}
	}
	if( dstf != NULL ) fflushTIMEOUT(dstf);
EXIT:
	sv1vlog("getMessageF: done(%d) + %d\n",total,Pending);
	total += flushPending(outEOF,ser,func,dstf,arg);
	return total;
}

static char *cpy1(ser,buff,leng,dst)
	char *buff;
	FILE *dst;
{	int wcc;

	if( ser <= 0 )
		return "";
	sv1Vlog("cpy1: @%d %d %s\r\n",ser,leng,"");
	fprintf(dst,"@%d %d %s\r\n",ser,leng,"");
	wcc = fwrite(buff,1,leng,dst);
	return "";
}
cpyMessageF(src,dst)
	FILE *src,*dst;
{
	return getMessageF(src,NULL,0,cpy1,dst);
}
