/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mailer.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951024	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>

#define STDSPLIT	50000
int MAX_MAILSPLIT = STDSPLIT;

char *X_PARTIAL ="X-Partial";
extern FILE *TMPFILE();
extern FILE *openMailPoster();
extern FILE *dirfopen();
extern char *cachedir();

static FILE *getMqueue(part,path)
	char *part,*path;
{	char *dir,*dp;
	FILE *pfp;

	if( dir = cachedir() ){
		strcpy(path,dir);
		if( dp = strrchr(path,'/') ){
			sprintf(dp+1,"mqueue/%s",part);
			if( pfp = dirfopen("partialMqueue",path,"w") )
				return pfp;
		}
	}
	sprintf(path,"/tmp/delegate/mqueue/%s",part);
	pfp = dirfopen("partialMqueue",path,"w");
	return pfp;
}

static putStdHeader(mfp,ver,to,from,subj)
	FILE *mfp;
	char *ver,*to,*from,*subj;
{
	fprintf(mfp,"To: %s\r\n",to);
	fprintf(mfp,"From: %s\r\n",from);
	fprintf(mfp,"Subject: %s\r\n",subj);
	if( ver[0] == 0 )
	fprintf(mfp,"MIME-Version: 1.0\r\n");
}
MAIL_send(msg,size,psize,ver,to,from,subj)
	FILE *msg;
	char *ver,*to,*from,*subj;
{	FILE *mfp;
	int number,total,sent;
	int leng;
	char line[1024],xsubj[1024];
	int seqno,pid;
	char partid[1024];

	if( psize == 0 )
		psize = MAX_MAILSPLIT;
	if( psize < 1000 )
		psize = 1000;
	if( 1000000 < psize )
		psize = 1000000;

	if( size < psize ){
		mfp = openMailPoster(to,from);
		putStdHeader(mfp,ver,to,from,subj);
		fprintf(mfp,"Content-Type: message/rfc822\r\n");
		fprintf(mfp,"X-Forwarded: by - (DeleGate/%s)\r\n",DELEGATE_ver());
		fprintf(mfp,"\r\n");
		putStdHeader(mfp,ver,to,from,subj);
		copyfile1(msg,mfp);
		fclose(mfp);
		return;
	}

	pid = getpid();
	seqno = time(0);
	sprintf(partid,"%d.%d@%s",seqno,pid,from);

	total = size / psize + 1;
	for( number = 1; number <= total; number++ ){
		sprintf(xsubj,"[%d/%d] %s",number,total,subj);
		mfp = openMailPoster(to,from);
		putStdHeader(mfp,ver,to,from,xsubj);
		fprintf(mfp,"Content-Type: message/rfc822\r\n");
		fprintf(mfp,"X-Forwarded: by - (DeleGate/%s)\r\n",DELEGATE_ver());
		fprintf(mfp,"\r\n");

		fprintf(mfp,"%s: %s/%d/%d\r\n",X_PARTIAL,partid,total,number);
		putStdHeader(mfp,ver,to,from,xsubj);
		fprintf(mfp,"Content-Type: message/partial;");
		fprintf(mfp," id=\"%s\";",partid);
		fprintf(mfp," number=%d; total=%d;\r\n",number,total);
		fprintf(mfp,"\r\n");

		if( number == 1 )
			putStdHeader(mfp,ver,to,from,subj);

		leng = 0;
		for(;;){
			if( fgets(line,sizeof(line),msg) == 0 )
				break;
			leng += fputs(line,mfp);
			if( number < total && psize < leng )
				break;
		}
		fclose(mfp);
	}
}
FILE *MAIL_assemblePartial(rfp,part)
	FILE *rfp;
	char *part;
{	char path[1024],*tp,*np;
	FILE *pfp,*afp;
	int cc,number,total,got;
	char ppath[1024];

	pfp = getMqueue(part,path);
	lock_exclusive(fileno(pfp));
	cc = copyfile1(rfp,pfp);
	fclose(pfp);
	sv1log("####[AS] GOT %s\n",path);

	tp = &path[strlen(path)];
	while( path < tp ){
		tp--;
		if( *tp == '/' ){
			np = tp;
			while( path < tp ){ tp--; if( *tp == '/' ) break; }
			break;
		}
	}
	if( sscanf(tp,"/%d/%d",&total,&number) == 2 ){
		got = 0;
		*np = 0;
		for( number = 1; number <= total; number++ ){
			sprintf(ppath,"%s/%d",path,number);
			if( 0 < File_size(ppath) )
				got++;
			else	break;
		}
		if( got != total )
			return NULL;

		sv1log("####[AS] ALL[%d] %s\n",total,ppath);
		afp = TMPFILE("assemblePartial");

		fprintf(afp,"MIME-Version: 1.0\r\n");
		fprintf(afp,"Content-Type: message/rfc822\r\n");
		fprintf(afp,"\r\n");

		for( number = 1; number <= total; number++ ){
			sprintf(ppath,"%s/%d",path,number);
			pfp = fopen(ppath,"r");
			lock_shared(fileno(pfp));
			copyfile1(pfp,afp);
			fclose(pfp);
			unlink(ppath);
		}
		fflush(afp);
		fseek(afp,0,0);

		rmdir(path);
		*tp = 0;
		rmdir(path);
		sv1log("####[AS] CLEAR %s\n ",path);
		return afp;
	}
	return NULL;
}
